/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.expectations;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.expectations.FractionallyOverExpected;

public class FractionallyUnbalancedWhenNoExpectations
extends FractionallyOverExpected {
    private Double iDisbalance = 0.1;
    private boolean iBalanceUnlimited = false;

    public FractionallyUnbalancedWhenNoExpectations(DataProperties config) {
        super(config);
        this.iDisbalance = config.getPropertyDouble("OverExpected.Disbalance", this.iDisbalance);
        this.iBalanceUnlimited = config.getPropertyBoolean("General.BalanceUnlimited", this.iBalanceUnlimited);
    }

    public FractionallyUnbalancedWhenNoExpectations(Double percentage, Double maximum, Double disbalance) {
        super(percentage, maximum);
        this.iDisbalance = disbalance;
    }

    public FractionallyUnbalancedWhenNoExpectations(Double percentage, Double maximum) {
        this(percentage, maximum, null);
    }

    public FractionallyUnbalancedWhenNoExpectations(Double percentage) {
        this(percentage, null, null);
    }

    public FractionallyUnbalancedWhenNoExpectations() {
        this(null, null, null);
    }

    public Double getDisbalance() {
        return this.iDisbalance;
    }

    public boolean isBalanceUnlimited() {
        return this.iBalanceUnlimited;
    }

    public double getMaximum(Section section, double defaultValue) {
        return this.getMaximum() == null || this.getMaximum() <= 0.0 ? defaultValue : this.getMaximum();
    }

    @Override
    public double getOverExpected(Assignment<Request, Enrollment> assignment, Section section, Request request) {
        double desired;
        Subpart subpart = section.getSubpart();
        if (this.hasExpectations(subpart) && section.getLimit() > 0) {
            return super.getOverExpected(assignment, section, request);
        }
        if (this.getDisbalance() == null || this.getDisbalance() < 0.0) {
            return 0.0;
        }
        double enrlConfig = request.getWeight() + this.getEnrollment(assignment, subpart.getConfig(), request);
        int subparts = section.getSubpart().getConfig().getSubparts().size();
        int limit = this.getLimit(section);
        double enrl = request.getWeight() + this.getEnrollment(assignment, section, request);
        if (limit > 0) {
            double desired2 = enrlConfig / (double)this.getLimit(subpart) * (double)limit;
            if (enrl - desired2 >= Math.max(1.0, this.getDisbalance() * (double)limit)) {
                double max = this.getMaximum(section, limit);
                return Math.min(max, enrl - desired2) / (max * (double)subparts);
            }
        } else if (this.isBalanceUnlimited() && enrl - (desired = enrlConfig / (double)subpart.getSections().size()) >= Math.max(1.0, this.getDisbalance() * desired)) {
            double max = this.getMaximum(section, desired);
            return Math.min(max, enrl - desired) / (max * (double)subparts);
        }
        return 0.0;
    }

    @Override
    public String toString() {
        return "fbal(" + this.getPercentage() + "," + this.getMaximum() + "," + this.getDisbalance() + ")";
    }
}

