/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLAttribute;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.HashMap;
import java.util.Map;

class ComputedAttributeInterpreter
implements XMLElement.Interpreter<String> {
    private final UiBinderWriter writer;
    private final Delegate delegate;

    public ComputedAttributeInterpreter(UiBinderWriter writer) {
        this.writer = writer;
        this.delegate = new DefaultDelegate();
    }

    public ComputedAttributeInterpreter(UiBinderWriter writer, Delegate delegate) {
        this.delegate = delegate;
        this.writer = writer;
    }

    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        HashMap<String, String> attNameToToken = new HashMap<String, String>();
        for (int i = elem.getAttributeCount() - 1; i >= 0; --i) {
            XMLAttribute att = elem.getAttribute(i);
            if (att.hasComputedValue()) {
                String attToken = this.delegate.getAttributeToken(att);
                attNameToToken.put(att.getName(), attToken);
                continue;
            }
            String n = att.getName();
            String v = att.consumeRawValue().replace("\\{", "{");
            elem.setAttribute(n, v);
        }
        for (Map.Entry attr : attNameToToken.entrySet()) {
            elem.setAttribute((String)attr.getKey(), (String)attr.getValue());
        }
        return null;
    }

    class DefaultDelegate
    implements Delegate {
        DefaultDelegate() {
        }

        @Override
        public String getAttributeToken(XMLAttribute attribute) throws UnableToCompleteException {
            return ComputedAttributeInterpreter.this.writer.tokenForStringExpression(attribute.getElement(), attribute.consumeStringValue());
        }
    }

    static interface Delegate {
        public String getAttributeToken(XMLAttribute var1) throws UnableToCompleteException;
    }
}

