/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Image;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.util.PdfEventHandler;
import org.unitime.timetable.util.PdfFont;

public class PdfWebTable
extends WebTable {
    private Hashtable iImages = new Hashtable();
    private float[] widths = null;

    public void addImage(String name, Image image) {
        this.iImages.put(name, image);
    }

    public PdfWebTable(int columns, String name, String[] headers, String[] align, boolean[] asc) {
        this(columns, name, null, headers, align, asc);
    }

    public PdfWebTable(int columns, String name, String ref, String[] headers, String[] align, boolean[] asc) {
        super(columns, name, ref, headers, align, asc);
    }

    private PdfPCell createCell() {
        PdfPCell cell = new PdfPCell();
        cell.setBorderColor(Color.BLACK);
        cell.setPadding(3.0f);
        cell.setBorderWidth(0.0f);
        cell.setVerticalAlignment(4);
        cell.setHorizontalAlignment(1);
        return cell;
    }

    private float addImage(PdfPCell cell, String name) {
        try {
            Image awtImage = (Image)this.iImages.get(name);
            if (awtImage == null) {
                return 0.0f;
            }
            com.lowagie.text.Image img = com.lowagie.text.Image.getInstance((Image)awtImage, (Color)Color.WHITE);
            Chunk ck = new Chunk(img, 0.0f, 0.0f);
            if (cell.getPhrase() == null) {
                cell.setPhrase((Phrase)new Paragraph(ck));
                cell.setVerticalAlignment(4);
                cell.setHorizontalAlignment(1);
            } else {
                cell.getPhrase().add((Object)ck);
            }
            return awtImage.getWidth(null);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public static float getWidth(String text, boolean bold, boolean italic) {
        Font font = PdfFont.getFont(bold, italic);
        float width = 0.0f;
        if (text.indexOf(10) >= 0) {
            StringTokenizer s = new StringTokenizer(text, "\n");
            while (s.hasMoreTokens()) {
                width = Math.max(width, font.getBaseFont().getWidthPoint(s.nextToken(), font.getSize()));
            }
        } else {
            width = Math.max(width, font.getBaseFont().getWidthPoint(text, font.getSize()));
        }
        return width;
    }

    public static float getWidthOfLastLine(String text, boolean bold, boolean italic) {
        Font font = PdfFont.getFont(bold, italic);
        float width = 0.0f;
        if (text.indexOf(10) >= 0) {
            StringTokenizer s = new StringTokenizer(text, "\n");
            while (s.hasMoreTokens()) {
                width = font.getBaseFont().getWidthPoint(s.nextToken(), font.getSize());
            }
        } else {
            width = Math.max(width, font.getBaseFont().getWidthPoint(text, font.getSize()));
        }
        return width;
    }

    private float addText(PdfPCell cell, String text, boolean bold, boolean italic, boolean underline, Color color, Color bgColor) {
        Font font = PdfFont.getFont(bold, italic, underline, color);
        Chunk chunk = new Chunk(text, font);
        if (bgColor != null) {
            chunk.setBackground(bgColor);
        }
        if (cell.getPhrase() == null) {
            cell.setPhrase((Phrase)new Paragraph(chunk));
            cell.setVerticalAlignment(4);
            cell.setHorizontalAlignment(1);
        } else {
            cell.getPhrase().add((Object)chunk);
        }
        float width = 0.0f;
        if (text.indexOf(10) >= 0) {
            StringTokenizer s = new StringTokenizer(text, "\n");
            while (s.hasMoreTokens()) {
                width = Math.max(width, font.getBaseFont().getWidthPoint(s.nextToken(), font.getSize()));
            }
        } else {
            width = Math.max(width, font.getBaseFont().getWidthPoint(text, font.getSize()));
        }
        return width;
    }

    private float addText(PdfPCell cell, String text, boolean bold, boolean italic, boolean underline, Color color, boolean borderTop, boolean borderBottom, boolean borderLeft, boolean borderRight, Color borderColor, Color bgColor) {
        cell.setBorderWidth(1.0f);
        if (borderTop) {
            cell.setBorder(1);
            if (borderColor == null) {
                cell.setBorderColorTop(Color.BLACK);
            } else {
                cell.setBorderColorTop(borderColor);
            }
        }
        if (borderBottom) {
            cell.setBorder(2);
            if (borderColor == null) {
                cell.setBorderColorBottom(Color.BLACK);
            } else {
                cell.setBorderColorBottom(borderColor);
            }
        }
        if (borderLeft) {
            cell.setBorder(4);
            if (borderColor == null) {
                cell.setBorderColorLeft(Color.BLACK);
            } else {
                cell.setBorderColorLeft(borderColor);
            }
        }
        if (borderRight) {
            cell.setBorder(8);
            if (borderColor == null) {
                cell.setBorderColorRight(Color.BLACK);
            } else {
                cell.setBorderColorRight(borderColor);
            }
        }
        return this.addText(cell, text, bold, italic, underline, color, bgColor);
    }

    private float addText(PdfPCell cell, String text, boolean bold, boolean italic, boolean underline, Color color, boolean border, Color borderColor, Color bgColor) {
        if (border) {
            cell.setBorderWidth(1.0f);
            cell.setBorder(15);
            if (borderColor == null) {
                cell.setBorderColor(Color.BLACK);
            } else {
                cell.setBorderColor(borderColor);
            }
        }
        return this.addText(cell, text, bold, italic, underline, color, bgColor);
    }

    private float addText(PdfPCell cell, String text, boolean bold) {
        if (text == null) {
            return this.addText(cell, "", bold, false, false, Color.BLACK, null);
        }
        if (text.indexOf("@@") < 0) {
            return this.addText(cell, text, bold, false, false, Color.BLACK, null);
        }
        Color color = Color.BLACK;
        Color bcolor = Color.BLACK;
        Color bgColor = null;
        boolean bd = bold;
        boolean it = false;
        boolean un = false;
        boolean ba = false;
        boolean bt = false;
        boolean bb = false;
        boolean bl = false;
        boolean br = false;
        float maxWidth = 0.0f;
        boolean first = true;
        StringTokenizer s = new StringTokenizer(text, "\n");
        while (s.hasMoreTokens()) {
            String line = s.nextToken();
            float width = 0.0f;
            int pos = 0;
            while (true) {
                String hex;
                int idx;
                if ((idx = line.indexOf("@@", pos)) < 0) {
                    if (ba) {
                        width += this.addText(cell, (!first && pos == 0 ? "\n" : "") + line.substring(pos), bd, it, un, color, true, bcolor, bgColor);
                        break;
                    }
                    if (bt || bb || bl || br) {
                        width += this.addText(cell, (!first && pos == 0 ? "\n" : "") + line.substring(pos), bd, it, un, color, bt, bb, bl, br, bcolor, bgColor);
                        break;
                    }
                    width += this.addText(cell, (!first && pos == 0 ? "\n" : "") + line.substring(pos), bd, it, un, color, bgColor);
                    break;
                }
                width = ba ? (width += this.addText(cell, (!first && pos == 0 ? "\n" : "") + line.substring(pos, idx), bd, it, un, color, true, bcolor, bgColor)) : (bt || bb || bl || br ? (width += this.addText(cell, (!first && pos == 0 ? "\n" : "") + line.substring(pos, idx), bd, it, un, color, bt, bb, bl, br, bcolor, bgColor)) : (width += this.addText(cell, (!first && pos == 0 ? "\n" : "") + line.substring(pos, idx), bd, it, un, color, bgColor)));
                pos = idx;
                String cmd = line.substring(pos += 2, line.indexOf(32, pos));
                pos += cmd.length() + 1;
                if ("BOLD".equals(cmd)) {
                    bd = true;
                }
                if ("END_BOLD".equals(cmd)) {
                    bd = false;
                }
                if ("ITALIC".equals(cmd)) {
                    it = true;
                }
                if ("END_ITALIC".equals(cmd)) {
                    it = false;
                }
                if ("UNDERLINE".equals(cmd)) {
                    un = true;
                }
                if ("END_UNDERLINE".equals(cmd)) {
                    un = false;
                }
                if ("COLOR".equals(cmd)) {
                    hex = line.substring(pos, line.indexOf(32, pos));
                    pos += hex.length() + 1;
                    if (hex.startsWith("#")) {
                        hex = hex.substring(1);
                    }
                    color = new Color(Integer.parseInt(hex, 16));
                }
                if ("END_COLOR".equals(cmd)) {
                    color = Color.BLACK;
                }
                if ("BGCOLOR".equals(cmd)) {
                    hex = line.substring(pos, line.indexOf(32, pos));
                    pos += hex.length() + 1;
                    bgColor = new Color(Integer.parseInt(hex, 16));
                }
                if ("END_BGCOLOR".equals(cmd)) {
                    bgColor = null;
                }
                if ("IMAGE".equals(cmd)) {
                    String name = line.substring(pos, line.indexOf(32, pos));
                    pos += name.length() + 1;
                    width += this.addImage(cell, name);
                }
                if ("BORDER_ALL".equals(cmd) || "BORDER_TOP".equals(cmd) || "BORDER_BOTTOM".equals(cmd) || "BORDER_LEFT".equals(cmd) || "BORDER_RIGHT".equals(cmd)) {
                    hex = line.substring(pos, line.indexOf(32, pos));
                    pos += hex.length() + 1;
                    bcolor = new Color(Integer.parseInt(hex, 16));
                    if ("BORDER_ALL".equals(cmd)) {
                        ba = true;
                    } else {
                        if ("BORDER_TOP".equals(cmd)) {
                            bt = true;
                        }
                        if ("BORDER_BOTTOM".equals(cmd)) {
                            bb = true;
                        }
                        if ("BORDER_LEFT".equals(cmd)) {
                            bl = true;
                        }
                        if ("BORDER_RIGHT".equals(cmd)) {
                            br = true;
                        }
                    }
                }
                if (!"NO_WRAP".equals(cmd)) continue;
                cell.setNoWrap(true);
            }
            maxWidth = Math.max(maxWidth, width);
            first = false;
        }
        return maxWidth;
    }

    public PdfPTable printPdfTable(int ordCol) {
        return this.printPdfTable(ordCol, false);
    }

    public PdfPTable printPdfTable(int ordCol, boolean keepTogether) {
        boolean asc;
        PdfPTable table = new PdfPTable(this.getNrColumns());
        table.setWidthPercentage(100.0f);
        table.getDefaultCell().setPadding(3.0f);
        table.getDefaultCell().setBorderWidth(0.0f);
        table.setSplitRows(false);
        table.setKeepTogether(keepTogether);
        boolean bl = asc = ordCol == 0 || this.iAsc == null || this.iAsc.length <= Math.abs(ordCol) - 1 ? true : this.iAsc[Math.abs(ordCol) - 1];
        if (ordCol < 0) {
            asc = !asc;
        }
        this.widths = new float[this.iColumns];
        for (int i = 0; i < this.iColumns; ++i) {
            this.widths[i] = 0.0f;
        }
        String[] lastLine = new String[Math.max(this.iColumns, this.iHeaders == null ? 0 : this.iHeaders.length)];
        if (this.iHeaders != null) {
            for (int i = 0; i < this.iColumns; ++i) {
                String align;
                if (this.isFiltered(i)) continue;
                PdfPCell c = this.createCell();
                c.setBorderWidthBottom(1.0f);
                float width = this.addText(c, this.iHeaders[i] == null ? "" : this.iHeaders[i], true);
                this.widths[i] = Math.max(this.widths[i], width);
                String string = align = this.iAlign != null ? this.iAlign[i] : "left";
                if ("left".equals(align)) {
                    c.setHorizontalAlignment(0);
                }
                if ("right".equals(align)) {
                    c.setHorizontalAlignment(2);
                }
                if ("center".equals(align)) {
                    c.setHorizontalAlignment(1);
                }
                table.addCell(c);
            }
            table.setHeaderRows(1);
        }
        if (ordCol != 0) {
            Collections.sort(this.iLines, new WebTable.WebTableComparator(Math.abs(ordCol) - 1, asc));
        }
        for (int el = 0; el < this.iLines.size(); ++el) {
            WebTable.WebTableLine wtline = (WebTable.WebTableLine)this.iLines.elementAt(el);
            String[] line = wtline.getLine();
            boolean blank = this.iBlankWhenSame;
            for (int i = 0; i < this.iColumns; ++i) {
                String align;
                if (this.isFiltered(i)) continue;
                if (blank && line[i] != null && !line[i].equals(lastLine[i])) {
                    blank = false;
                }
                PdfPCell c = this.createCell();
                float width = this.addText(c, blank || line[i] == null ? "" : line[i], false);
                this.widths[i] = Math.max(this.widths[i], width);
                String string = align = this.iAlign != null ? this.iAlign[i] : "left";
                if ("left".equals(align)) {
                    c.setHorizontalAlignment(0);
                }
                if ("right".equals(align)) {
                    c.setHorizontalAlignment(2);
                }
                if ("center".equals(align)) {
                    c.setHorizontalAlignment(1);
                }
                this.applyPdfStyle(c, wtline, el + 1 < this.iLines.size() ? (WebTable.WebTableLine)this.iLines.elementAt(el + 1) : null, ordCol);
                table.addCell(c);
                lastLine[i] = line[i];
            }
        }
        try {
            if (this.getNrFilteredColumns() < 0) {
                table.setWidths(this.widths);
            } else {
                float[] x = new float[this.getNrColumns()];
                int idx = 0;
                for (int i = 0; i < this.iColumns; ++i) {
                    if (this.isFiltered(i)) continue;
                    x[idx++] = this.widths[i];
                }
                table.setWidths(x);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return table;
    }

    public float getWidth() {
        float totalWidth = 0.0f;
        for (int i = 0; i < this.widths.length; ++i) {
            totalWidth += 25.0f + this.widths[i];
        }
        totalWidth = Math.max(PageSize.LETTER.getHeight(), totalWidth);
        return totalWidth;
    }

    public String getName() {
        return this.iName;
    }

    public void exportPdf(OutputStream out, int ordCol) throws Exception {
        PdfPTable table = this.printPdfTable(ordCol);
        float width = this.getWidth();
        Document doc = new Document(new Rectangle(60.0f + width, 60.0f + 0.75f * width), 30.0f, 30.0f, 30.0f, 30.0f);
        PdfWriter iWriter = PdfWriter.getInstance((Document)doc, (OutputStream)out);
        iWriter.setPageEvent((PdfPageEvent)new PdfEventHandler());
        doc.open();
        if (this.iName != null) {
            doc.add((Element)new Paragraph(this.iName, PdfFont.getBigFont(true)));
        }
        doc.add((Element)table);
        doc.close();
    }

    public void applyPdfStyle(PdfPCell cell, WebTable.WebTableLine currentLine, WebTable.WebTableLine nextLine, int order) {
        if (this.iWebTableTweakStyle == null || !(this.iWebTableTweakStyle instanceof PdfWebTableTweakStyle)) {
            return;
        }
        ((PdfWebTableTweakStyle)this.iWebTableTweakStyle).applyPdfStyle(cell, currentLine, nextLine, order);
    }

    public static interface PdfWebTableTweakStyle
    extends WebTable.WebTableTweakStyle {
        public void applyPdfStyle(PdfPCell var1, WebTable.WebTableLine var2, WebTable.WebTableLine var3, int var4);
    }
}

