/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.parameters.P;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.interfaces.ExternalCourseOfferingRemoveAction;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=subjectArea]")
public class SubjectAreas
implements AdminTable {
    private static Log sLog = LogFactory.getLog(SubjectAreas.class);
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageSubjectArea(), MESSAGES.pageSubjectAreas());
    }

    @Override
    @PreAuthorize(value="checkPermission('SubjectAreas')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        List<Department> deptList = DepartmentDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId());
        ArrayList<SimpleEditInterface.ListItem> depts = new ArrayList<SimpleEditInterface.ListItem>();
        ArrayList<SimpleEditInterface.ListItem> fundDepts = new ArrayList<SimpleEditInterface.ListItem>();
        for (Department dept : Department.getUserDepartments(context.getUser(), false)) {
            if (dept.isExternalManager() != null && dept.isExternalManager().booleanValue()) continue;
            depts.add(new SimpleEditInterface.ListItem(dept.getUniqueId().toString(), dept.getLabel()));
        }
        fundDepts.add(new SimpleEditInterface.ListItem("-1", MESSAGES.noFundingDepartment()));
        Collections.sort(deptList);
        for (Department dept : deptList) {
            if (dept.isExternalFundingDept() == null || !dept.isExternalFundingDept().booleanValue()) continue;
            fundDepts.add(new SimpleEditInterface.ListItem(dept.getUniqueId().toString(), dept.getLabel()));
        }
        boolean dispLastChange = CommonValues.Yes.eq(UserProperty.DisplayLastChanges.get(context.getUser()));
        HashMap<Object, Object> subjToChanges = new HashMap();
        SimpleEditInterface.Field lastChangeField = null;
        if (dispLastChange) {
            lastChangeField = new SimpleEditInterface.Field(MESSAGES.fieldLastChange(), SimpleEditInterface.FieldType.text, 50, SimpleEditInterface.Flag.READ_ONLY, SimpleEditInterface.Flag.NO_DETAIL);
            subjToChanges = this.lastChangeForAllSubjects(context, hibSession);
        } else {
            lastChangeField = new SimpleEditInterface.Field(MESSAGES.fieldLastChange(), SimpleEditInterface.FieldType.text, 50, SimpleEditInterface.Flag.READ_ONLY, SimpleEditInterface.Flag.HIDDEN);
        }
        HashMap<Long, String> deptToManagers = this.managersForAllDepts(context, hibSession);
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldAbbv(), SimpleEditInterface.FieldType.text, 100, 40, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldTitle(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.UNIQUE_IF_SET), new SimpleEditInterface.Field(MESSAGES.fieldDepartment(), SimpleEditInterface.FieldType.list, 300, depts, SimpleEditInterface.Flag.NOT_EMPTY), ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue() ? new SimpleEditInterface.Field(MESSAGES.fieldFundingDepartment(), SimpleEditInterface.FieldType.list, 300, fundDepts, new SimpleEditInterface.Flag[0]) : new SimpleEditInterface.Field(MESSAGES.fieldFundingDepartment(), SimpleEditInterface.FieldType.list, 300, fundDepts, SimpleEditInterface.Flag.HIDDEN), new SimpleEditInterface.Field(MESSAGES.fieldManagers(), SimpleEditInterface.FieldType.textarea, 100, SimpleEditInterface.Flag.READ_ONLY, SimpleEditInterface.Flag.NO_DETAIL), lastChangeField);
        data.setSortBy(1, 2);
        for (SubjectArea area : SubjectAreaDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            String changes;
            SimpleEditInterface.Record r = data.addRecord(area.getUniqueId());
            boolean canEdit = context.hasPermission(area, Right.SubjectAreaEdit);
            r.setField(0, area.getSubjectAreaAbbreviation(), canEdit);
            r.setField(1, area.getTitle(), canEdit);
            r.setField(2, area.getExternalUniqueId(), canEdit);
            r.setField(3, canEdit ? area.getDepartment().getUniqueId().toString() : area.getDepartment().getLabel(), canEdit && context.hasPermission(area, Right.SubjectAreaChangeDepartment));
            if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
                r.setField(4, area.getFundingDept() == null ? "-1" : area.getFundingDept().getUniqueId().toString(), canEdit);
            }
            r.setDeletable(context.hasPermission(area, Right.SubjectAreaDelete));
            String managers = deptToManagers.get(area.getDepartment().getUniqueId());
            if (managers == null) {
                managers = "";
            }
            r.setField(5, managers);
            if (!dispLastChange || (changes = (String)subjToChanges.get(area.getUniqueId())) == null || changes.isEmpty()) continue;
            r.setField(6, changes);
        }
        data.setAddable(context.hasPermission(Right.SubjectAreaAdd));
        data.setEditable(context.hasPermission(Right.SubjectAreaEdit) || context.hasPermission(Right.SubjectAreaAdd));
        if (CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.ConfirmationDialogs))) {
            data.setConfirmDelete(MESSAGES.confirmDeleteSubjectArea());
        }
        return data;
    }

    private HashMap<Long, String> managersForAllDepts(SessionContext context, org.hibernate.Session hibSession) {
        HashMap<Long, String> subjToManagers = new HashMap<Long, String>();
        String instrNameFormat = UserProperty.NameFormat.get(context.getUser());
        String query = "select d.uniqueId, tm from Department d inner join d.timetableManagers as tm where d.session.uniqueId = :sessionId";
        for (Object[] result : hibSession.createQuery(query, Object[].class).setParameter("sessionId", (Object)context.getUser().getCurrentAcademicSessionId()).list()) {
            long deptId = (Long)result[0];
            TimetableManager tm = (TimetableManager)result[1];
            Object tmName = subjToManagers.get(deptId);
            tmName = tmName == null ? tm.getName(instrNameFormat) : (String)tmName + "\n" + tm.getName(instrNameFormat);
            subjToManagers.put(deptId, (String)tmName);
        }
        return subjToManagers;
    }

    private HashMap<Long, String> lastChangeForAllSubjects(SessionContext context, org.hibernate.Session hibSession) {
        HashMap<Long, String> subjToChanges = new HashMap<Long, String>();
        String query = "select cl from ChangeLog cl where cl.uniqueId in (select max(cl2.uniqueId) from ChangeLog cl2 where cl2.session.uniqueId = :sessionId and cl2.subjectArea.session.uniqueId = :sessionId group by cl2.subjectArea.uniqueId)";
        for (ChangeLog cl : hibSession.createQuery(query, ChangeLog.class).setParameter("sessionId", (Object)context.getUser().getCurrentAcademicSessionId()).list()) {
            if (cl.getSubjectArea() == null) continue;
            Object changes = subjToChanges.get(cl.getSubjectArea().getUniqueId());
            if (changes == null) {
                changes = MESSAGES.lastChange(ChangeLog.sDFdate.format(cl.getTimeStamp()), cl.getManager().getShortName());
                subjToChanges.put(cl.getSubjectArea().getUniqueId(), (String)changes);
                continue;
            }
            changes = (String)changes + "\n" + MESSAGES.lastChange(ChangeLog.sDFdate.format(cl.getTimeStamp()), cl.getManager().getShortName());
        }
        return subjToChanges;
    }

    @Override
    @PreAuthorize(value="checkPermission('SubjectAreas')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (SubjectArea area : SubjectAreaDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(area.getUniqueId());
            if (r == null) {
                if (!context.hasPermission(area, Right.SubjectAreaDelete)) continue;
                this.delete(area, context, hibSession);
                continue;
            }
            if (!context.hasPermission(area, Right.SubjectAreaEdit)) continue;
            this.update(area, r, context, hibSession);
        }
        if (context.hasPermission(Right.SubjectAreaAdd)) {
            for (SimpleEditInterface.Record r : data.getNewRecords()) {
                this.save(r, context, hibSession);
            }
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('SubjectAreaAdd')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        Department dept = (Department)DepartmentDAO.getInstance().get(Long.valueOf(record.getField(3)), hibSession);
        Department fundDept = record.getField(4) == null || "-1".equals(record.getField(4)) ? null : (Department)DepartmentDAO.getInstance().get(Long.valueOf(record.getField(4)), hibSession);
        SubjectArea area = new SubjectArea();
        area.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        area.setSubjectAreaAbbreviation(record.getField(0));
        area.setTitle(record.getField(1));
        area.setExternalUniqueId(record.getField(2));
        area.setDepartment(dept);
        dept.getSubjectAreas().add(area);
        area.setFundingDept(fundDept);
        hibSession.persist((Object)area);
        record.setUniqueId(area.getUniqueId());
        if (fundDept == null) {
            record.setField(4, "-1");
        }
        String instrNameFormat = UserProperty.NameFormat.get(context.getUser());
        Object managers = "";
        for (TimetableManager mgr : area.getManagers()) {
            managers = (String)managers + (((String)managers).isEmpty() ? "" : "\n") + mgr.getName(instrNameFormat);
        }
        record.setField(5, (String)managers);
        record.setField(6, MESSAGES.lastChange(ChangeLog.sDFdate.format(new Date()), context.getUser().getName()));
        ChangeLog.addChange(hibSession, context, area, area.getSubjectAreaAbbreviation() + " " + area.getTitle(), ChangeLog.Source.SUBJECT_AREA_EDIT, ChangeLog.Operation.CREATE, area, area.getDepartment());
    }

    protected void update(SubjectArea area, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (area == null) {
            return;
        }
        boolean changed = false;
        boolean fundingEnabled = ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue();
        Department dept = (Department)DepartmentDAO.getInstance().get(Long.valueOf(record.getField(3)), hibSession);
        Department fundDept = record.getField(4) == null ? null : (Department)DepartmentDAO.getInstance().get(Long.valueOf(record.getField(4)), hibSession);
        changed = changed || !ToolBox.equals((Object)area.getSubjectAreaAbbreviation(), (Object)record.getField(0)) || !ToolBox.equals((Object)area.getTitle(), (Object)record.getField(1)) || !ToolBox.equals((Object)area.getExternalUniqueId(), (Object)record.getField(2)) || !ToolBox.equals((Object)dept, (Object)area.getDepartment()) || fundingEnabled && !ToolBox.equals((Object)fundDept, (Object)area.getFundingDept());
        HashSet<Class_> updatedClasses = new HashSet<Class_>();
        if (changed) {
            String className;
            area.setSubjectAreaAbbreviation(record.getField(0));
            area.setTitle(record.getField(1));
            area.setExternalUniqueId(record.getField(2));
            if (!dept.equals(area.getDepartment())) {
                HashSet<Location> availableRooms = new HashSet<Location>();
                HashSet<Building> availableBuildings = new HashSet<Building>();
                for (RoomDept roomDept : dept.getRoomDepts()) {
                    availableRooms.add(roomDept.getRoom());
                    if (!(roomDept.getRoom() instanceof Room)) continue;
                    availableBuildings.add(((Room)roomDept.getRoom()).getBuilding());
                }
                for (CourseOffering co : area.getCourseOfferings()) {
                    if (!co.getIsControl().booleanValue() || co.getInstructionalOffering() == null) continue;
                    for (InstrOfferingConfig ioc : co.getInstructionalOffering().getInstrOfferingConfigs()) {
                        for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                            if (!ss.getManagingDept().isExternalManager().booleanValue()) {
                                Iterator<Serializable> i = ss.getPreferences().iterator();
                                while (i.hasNext()) {
                                    RoomGroupPref rgp;
                                    Preference p = (Preference)i.next();
                                    if (p instanceof TimePref) continue;
                                    if (p instanceof RoomPref) {
                                        RoomPref rp = (RoomPref)p;
                                        if (availableRooms.contains(rp.getRoom())) continue;
                                        i.remove();
                                        continue;
                                    }
                                    if (p instanceof BuildingPref) {
                                        BuildingPref bp = (BuildingPref)p;
                                        if (availableBuildings.contains(bp.getBuilding())) continue;
                                        i.remove();
                                        continue;
                                    }
                                    if (p instanceof RoomFeaturePref) {
                                        RoomFeaturePref rfp = (RoomFeaturePref)p;
                                        if (!(rfp.getRoomFeature() instanceof DepartmentRoomFeature)) continue;
                                        i.remove();
                                        continue;
                                    }
                                    if (!(p instanceof RoomGroupPref) || (rgp = (RoomGroupPref)p).getRoomGroup().isGlobal().booleanValue()) continue;
                                    i.remove();
                                }
                                hibSession.merge((Object)ss);
                            }
                            for (Class_ c : ss.getClasses()) {
                                Iterator<Comparable> i;
                                if (!c.getManagingDept().isExternalManager().booleanValue()) {
                                    i = c.getPreferences().iterator();
                                    while (i.hasNext()) {
                                        RoomGroupPref rgp;
                                        Preference p = (Preference)i.next();
                                        if (p instanceof TimePref) continue;
                                        if (p instanceof RoomPref) {
                                            RoomPref rp = (RoomPref)p;
                                            if (availableRooms.contains(rp.getRoom())) continue;
                                            i.remove();
                                            continue;
                                        }
                                        if (p instanceof BuildingPref) {
                                            BuildingPref bp = (BuildingPref)p;
                                            if (availableBuildings.contains(bp.getBuilding())) continue;
                                            i.remove();
                                            continue;
                                        }
                                        if (p instanceof RoomFeaturePref) {
                                            RoomFeaturePref rfp = (RoomFeaturePref)p;
                                            if (!(rfp.getRoomFeature() instanceof DepartmentRoomFeature)) continue;
                                            i.remove();
                                            continue;
                                        }
                                        if (!(p instanceof RoomGroupPref) || (rgp = (RoomGroupPref)p).getRoomGroup().isGlobal().booleanValue()) continue;
                                        i.remove();
                                    }
                                    c.setManagingDept(dept, context.getUser(), hibSession);
                                }
                                i = c.getClassInstructors().iterator();
                                while (i.hasNext()) {
                                    ClassInstructor ci = (ClassInstructor)i.next();
                                    DepartmentalInstructor newInstructor = null;
                                    if (ci.getInstructor().getExternalUniqueId() != null) {
                                        newInstructor = DepartmentalInstructor.findByPuidDepartmentId(ci.getInstructor().getExternalUniqueId(), dept.getUniqueId());
                                    }
                                    ci.getInstructor().getClasses().remove(ci);
                                    hibSession.merge((Object)ci.getInstructor());
                                    if (newInstructor != null) {
                                        ci.setInstructor(newInstructor);
                                        newInstructor.getClasses().add(ci);
                                        hibSession.merge((Object)newInstructor);
                                        continue;
                                    }
                                    i.remove();
                                    hibSession.remove((Object)ci);
                                }
                                hibSession.merge((Object)c);
                                updatedClasses.add(c);
                            }
                        }
                    }
                }
                for (Preference p : area.getDepartment().getPreferences()) {
                    if (!(p instanceof DistributionPref)) continue;
                    DistributionPref dp = (DistributionPref)p;
                    boolean change = true;
                    for (DistributionObject dobj : dp.getOrderedSetOfDistributionObjects()) {
                        if (dobj.getPrefGroup() instanceof SchedulingSubpart) {
                            SchedulingSubpart ss = (SchedulingSubpart)dobj.getPrefGroup();
                            if (ss.getControllingCourseOffering().getSubjectArea().equals(area)) break;
                            change = false;
                            break;
                        }
                        if (!(dobj.getPrefGroup() instanceof Class_)) continue;
                        Class_ c = (Class_)dobj.getPrefGroup();
                        if (c.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea().equals(area)) break;
                        change = false;
                        break;
                    }
                    if (!change) continue;
                    dp.setOwner(dept);
                    hibSession.merge((Object)dp);
                }
                area.getDepartment().getSubjectAreas().remove(area);
                area.setDepartment(dept);
                dept.getSubjectAreas().add(area);
                String instrNameFormat = UserProperty.NameFormat.get(context.getUser());
                Object managers = "";
                for (TimetableManager mgr : area.getManagers()) {
                    managers = (String)managers + (((String)managers).isEmpty() ? "" : "\n") + mgr.getName(instrNameFormat);
                }
                record.setField(5, (String)managers);
            }
            if (fundingEnabled) {
                area.setFundingDept(fundDept);
            }
            hibSession.merge((Object)area);
            ChangeLog.addChange(hibSession, context, area, area.getSubjectAreaAbbreviation() + " " + area.getTitle(), ChangeLog.Source.SUBJECT_AREA_EDIT, ChangeLog.Operation.UPDATE, area, area.getDepartment());
            if (!updatedClasses.isEmpty() && (className = ApplicationProperty.ExternalActionClassEdit.value()) != null && !className.isEmpty()) {
                try {
                    ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    for (Class_ c : updatedClasses) {
                        editAction.performExternalClassEditAction(c, hibSession);
                    }
                }
                catch (Exception e) {
                    sLog.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            record.setField(6, MESSAGES.lastChange(ChangeLog.sDFdate.format(new Date()), context.getUser().getName()));
        }
    }

    @Override
    @PreAuthorize(value="checkPermission(#record.uniqueId, 'SubjectAreaEdit')")
    public void update(@P(value="record") SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((SubjectArea)SubjectAreaDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(SubjectArea area, SessionContext context, org.hibernate.Session hibSession) {
        if (area == null) {
            return;
        }
        String className = ApplicationProperty.ExternalActionCourseOfferingRemove.value();
        if (className != null && !className.isEmpty()) {
            try {
                ExternalCourseOfferingRemoveAction removeAction = (ExternalCourseOfferingRemoveAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (CourseOffering co : area.getCourseOfferings()) {
                    removeAction.performExternalCourseOfferingRemoveAction(co, hibSession);
                }
            }
            catch (Exception e) {
                sLog.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        for (CourseOffering co : new ArrayList<CourseOffering>(area.getCourseOfferings())) {
            if (!co.isIsControl().booleanValue()) continue;
            InstructionalOffering io = co.getInstructionalOffering();
            io.deleteAllDistributionPreferences(hibSession);
            io.deleteAllClasses(hibSession);
            io.deleteAllCourses(hibSession);
            hibSession.remove((Object)io);
        }
        for (CourseOffering co : area.getCourseOfferings()) {
            hibSession.remove((Object)co);
        }
        area.getDepartment().getSubjectAreas().remove(area);
        ChangeLog.addChange(hibSession, context, area, area.getSubjectAreaAbbreviation() + " " + area.getTitle(), ChangeLog.Source.SUBJECT_AREA_EDIT, ChangeLog.Operation.DELETE, null, area.getDepartment());
        hibSession.remove((Object)area);
    }

    @Override
    @PreAuthorize(value="checkPermission(#record.uniqueId, 'SubjectAreaDelete')")
    public void delete(@P(value="record") SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((SubjectArea)SubjectAreaDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

