/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.Preference;

@MappedSuperclass
public abstract class BaseInstructorCoursePref
extends Preference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CourseOffering iCourse;

    public BaseInstructorCoursePref() {
    }

    public BaseInstructorCoursePref(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="course_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public CourseOffering getCourse() {
        return this.iCourse;
    }

    public void setCourse(CourseOffering course) {
        this.iCourse = course;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof InstructorCoursePref)) {
            return false;
        }
        if (this.getUniqueId() == null || ((InstructorCoursePref)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((InstructorCoursePref)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "InstructorCoursePref[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "InstructorCoursePref[\n\tCourse: " + String.valueOf(this.getCourse()) + "\n\tNote: " + this.getNote() + "\n\tOwner: " + String.valueOf(this.getOwner()) + "\n\tPrefLevel: " + String.valueOf(this.getPrefLevel()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

