/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.page;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class SolverWarnings
extends P {
    protected static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    protected static final GwtMessages MSG = (GwtMessages)GWT.create(GwtMessages.class);

    public SolverWarnings(final RootPanel panel, Type type) {
        super(new String[0]);
        RPC.execute(new SolverWarningsRequest(type), new AsyncCallback<SolverWarningsResponse>(){

            public void onSuccess(final SolverWarningsResponse response) {
                if (response == null || !response.hasMessage()) {
                    return;
                }
                final P p = new P(response.isWarning() ? "unitime-PageWarn" : "unitime-PageMessage");
                if (response.hasUrl()) {
                    p.addMouseOverHandler(new MouseOverHandler(){

                        public void onMouseOver(MouseOverEvent e) {
                            p.getElement().getStyle().setBackgroundColor("#BBCDD0");
                        }
                    });
                    p.addMouseOutHandler(new MouseOutHandler(){

                        public void onMouseOut(MouseOutEvent e) {
                            p.getElement().getStyle().clearBackgroundColor();
                        }
                    });
                    p.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent c) {
                            ToolBox.open(GWT.getHostPageBaseURL() + response.getUrl());
                        }
                    });
                    p.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                }
                p.setHTML(response.getMessage());
                panel.add((Widget)p);
            }

            public void onFailure(Throwable e) {
                UniTimeNotifications.error(MSG.failedToLoadPage(e.getMessage()), e);
            }
        });
    }

    public static class SolverWarningsRequest
    implements GwtRpcRequest<SolverWarningsResponse> {
        private Type iType;

        public SolverWarningsRequest() {
        }

        public SolverWarningsRequest(Type type) {
            this.iType = type;
        }

        public Type getType() {
            return this.iType;
        }

        public void setType(Type type) {
            this.iType = type;
        }
    }

    public static enum Type implements IsSerializable
    {
        solver,
        assignments,
        exam;

    }

    public static class SolverWarningsResponse
    implements GwtRpcResponse {
        private String iMessage;
        private boolean iWarning = false;
        private String iUrl;

        public SolverWarningsResponse() {
        }

        public SolverWarningsResponse(String url, String message) {
            this.iUrl = url;
            this.iMessage = message;
        }

        public SolverWarningsResponse(String message) {
            this.iMessage = message;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public String getMessage() {
            return this.iMessage;
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public void setUrl(String url) {
            this.iUrl = url;
        }

        public String getUrl() {
            return this.iUrl;
        }

        public boolean hasUrl() {
            return this.iUrl != null && !this.iUrl.isEmpty();
        }

        public boolean isWarning() {
            return this.iWarning;
        }

        public SolverWarningsResponse setWarning(boolean warning) {
            this.iWarning = warning;
            return this;
        }
    }
}

