/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.dataexchange.StudentEnrollmentImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.AdvisorClassPref;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.AdvisorInstrMthPref;
import org.unitime.timetable.model.AdvisorSectioningPref;
import org.unitime.timetable.model.Campus;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Degree;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Program;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentClassPref;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentInstrMthPref;
import org.unitime.timetable.model.StudentSectioningPref;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.base.BaseAcademicArea;
import org.unitime.timetable.model.base.BaseAcademicClassification;
import org.unitime.timetable.model.base.BaseAdvisorCourseRequest;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.base.BaseFreeTime;
import org.unitime.timetable.model.base.BasePosMajor;
import org.unitime.timetable.model.base.BasePosMajorConcentration;
import org.unitime.timetable.model.base.BasePosMinor;
import org.unitime.timetable.model.base.BaseRefTableEntry;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.base.BaseStudentAccomodation;
import org.unitime.timetable.model.base.BaseStudentAreaClassificationMajor;
import org.unitime.timetable.model.base.BaseStudentAreaClassificationMinor;
import org.unitime.timetable.model.base.BaseStudentGroup;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;

public class StudentSectioningImport
extends BaseImport {
    protected static Formats.Format<Date> sDateFormat = Formats.getDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    @Override
    public void loadXml(Element rootElement) {
        try {
            this.beginTransaction();
            boolean trimLeadingZerosFromExternalId = ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue();
            String campus = rootElement.attributeValue("campus");
            String year = rootElement.attributeValue("year");
            String term = rootElement.attributeValue("term");
            EnrollmentMode mode = null;
            if (rootElement.attributeValue("enrollments") != null) {
                mode = EnrollmentMode.valueOf(rootElement.attributeValue("enrollments").toUpperCase());
            } else {
                mode = EnrollmentMode.UPDATE;
                if ("true".equals(rootElement.attributeValue("keepEnrollments", "false"))) {
                    mode = EnrollmentMode.NOCHANGE;
                }
                Iterator i = rootElement.elementIterator("student");
                block18: while (i.hasNext()) {
                    Element addCoursesElement;
                    Element studentElement = (Element)i.next();
                    Element reqCoursesElement = studentElement.element("updateCourseRequests");
                    if (reqCoursesElement != null && "true".equals(reqCoursesElement.attributeValue("commit", "true"))) {
                        Iterator j = reqCoursesElement.elementIterator("courseOffering");
                        while (j.hasNext()) {
                            Element requestElement = (Element)j.next();
                            if (requestElement.element("class") != null) {
                                mode = EnrollmentMode.IMPORT;
                                break block18;
                            }
                            Iterator k = requestElement.elementIterator("alternative");
                            while (k.hasNext()) {
                                Element altElement = (Element)k.next();
                                if (altElement.element("class") == null) continue;
                                mode = EnrollmentMode.IMPORT;
                                break block18;
                            }
                        }
                    }
                    if ((addCoursesElement = studentElement.element("addCourseRequests")) == null || !"true".equals(addCoursesElement.attributeValue("commit", "true"))) continue;
                    Iterator j = addCoursesElement.elementIterator("courseOffering");
                    while (j.hasNext()) {
                        Element requestElement = (Element)j.next();
                        if (requestElement.element("class") != null) {
                            mode = EnrollmentMode.IMPORT;
                            break block18;
                        }
                        Iterator k = requestElement.elementIterator("alternative");
                        while (k.hasNext()) {
                            Element altElement = (Element)k.next();
                            if (altElement.element("class") == null) continue;
                            mode = EnrollmentMode.IMPORT;
                            break block18;
                        }
                    }
                }
            }
            this.info("Enrollment mode set to " + mode.name() + ": " + mode.toString());
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            Hashtable<String, Student> students = new Hashtable<String, Student>();
            for (Object student : this.getHibSession().createQuery("from Student s where s.session.uniqueId=:sessionId and s.externalUniqueId is not null", Student.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                students.put(((BaseStudent)student).getExternalUniqueId(), (Student)student);
            }
            Hashtable<String, AcademicArea> abbv2area = new Hashtable<String, AcademicArea>();
            for (Object area : this.getHibSession().createQuery("from AcademicArea where session.uniqueId=:sessionId", AcademicArea.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                abbv2area.put(((BaseAcademicArea)area).getAcademicAreaAbbreviation(), (AcademicArea)area);
            }
            Hashtable<String, AcademicClassification> code2clasf = new Hashtable<String, AcademicClassification>();
            for (Object clasf : this.getHibSession().createQuery("from AcademicClassification where session.uniqueId=:sessionId", AcademicClassification.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                code2clasf.put(((BaseAcademicClassification)clasf).getCode(), (AcademicClassification)clasf);
            }
            Hashtable<CallSite, Object> code2major = new Hashtable<CallSite, Object>();
            for (Object major : this.getHibSession().createQuery("from PosMajor where session.uniqueId=:sessionId", PosMajor.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                for (AcademicArea academicArea : ((BasePosMajor)major).getAcademicAreas()) {
                    code2major.put((CallSite)((Object)(academicArea.getAcademicAreaAbbreviation() + ":" + ((BasePosMajor)major).getCode())), major);
                }
            }
            Hashtable<CallSite, Object> code2concentration = new Hashtable<CallSite, Object>();
            for (Object conc : this.getHibSession().createQuery("from PosMajorConcentration where major.session.uniqueId=:sessionId", PosMajorConcentration.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                for (AcademicArea area : ((BasePosMajorConcentration)conc).getMajor().getAcademicAreas()) {
                    code2concentration.put((CallSite)((Object)(area.getAcademicAreaAbbreviation() + ":" + ((BasePosMajorConcentration)conc).getMajor().getCode() + ":" + ((BasePosMajorConcentration)conc).getCode())), conc);
                }
            }
            Hashtable<String, Degree> code2degree = new Hashtable<String, Degree>();
            for (Degree degree : this.getHibSession().createQuery("from Degree where session.uniqueId=:sessionId", Degree.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                code2degree.put(degree.getReference(), degree);
            }
            Hashtable<String, Program> code2program = new Hashtable<String, Program>();
            for (Object prog : this.getHibSession().createQuery("from Program where session.uniqueId=:sessionId", Program.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                code2program.put(((BaseRefTableEntry)prog).getReference(), (Program)prog);
            }
            Hashtable<String, Campus> hashtable = new Hashtable<String, Campus>();
            for (Object camp : this.getHibSession().createQuery("from Campus where session.uniqueId=:sessionId", Campus.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                hashtable.put(((BaseRefTableEntry)camp).getReference(), (Campus)camp);
            }
            Hashtable<CallSite, Object> code2minor = new Hashtable<CallSite, Object>();
            for (Object minor : this.getHibSession().createQuery("from PosMinor where session.uniqueId=:sessionId", PosMinor.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                for (AcademicArea area : ((BasePosMinor)minor).getAcademicAreas()) {
                    code2minor.put((CallSite)((Object)(area.getAcademicAreaAbbreviation() + ":" + ((BasePosMinor)minor).getCode())), minor);
                }
            }
            Hashtable<String, StudentGroup> code2group = new Hashtable<String, StudentGroup>();
            for (Object group : this.getHibSession().createQuery("from StudentGroup where session.uniqueId=:sessionId", StudentGroup.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                code2group.put(((BaseStudentGroup)group).getGroupAbbreviation(), (StudentGroup)group);
            }
            Hashtable<String, StudentAccomodation> code2accomodation = new Hashtable<String, StudentAccomodation>();
            for (Object accomodation : this.getHibSession().createQuery("from StudentAccomodation where session.uniqueId=:sessionId", StudentAccomodation.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                code2accomodation.put(((BaseStudentAccomodation)accomodation).getAbbreviation(), (StudentAccomodation)accomodation);
            }
            Hashtable<String, CourseOffering> name2course = new Hashtable<String, CourseOffering>();
            for (CourseOffering course : this.getHibSession().createQuery("from CourseOffering where subjectArea.session.uniqueId=:sessionId", CourseOffering.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                name2course.put(course.getCourseName(), course);
            }
            HashMap course2extId2class = new HashMap();
            HashMap course2name2class = new HashMap();
            this.info("Loading classes...");
            for (Object[] o : this.getHibSession().createQuery("select c, co from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId", Object[].class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                String name;
                HashSet<Object> sameNameClasses;
                String extId;
                HashMap<CallSite, HashSet<Object>> name2class;
                Class_ clazz = (Class_)o[0];
                CourseOffering course = (CourseOffering)o[1];
                HashMap<String, HashSet<Object>> extId2class = (HashMap<String, HashSet<Object>>)course2extId2class.get(course.getUniqueId());
                if (extId2class == null) {
                    extId2class = new HashMap<String, HashSet<Object>>();
                    course2extId2class.put(course.getUniqueId(), extId2class);
                }
                if ((name2class = (HashMap<CallSite, HashSet<Object>>)course2name2class.get(course.getUniqueId())) == null) {
                    name2class = new HashMap<CallSite, HashSet<Object>>();
                    course2name2class.put(course.getUniqueId(), name2class);
                }
                if ((extId = clazz.getExternalId(course)) != null && !extId.isEmpty()) {
                    HashSet<Object> sameExtIdClasses = (HashSet<Object>)extId2class.get(extId);
                    if (sameExtIdClasses == null) {
                        sameExtIdClasses = new HashSet<Object>();
                        extId2class.put(extId, sameExtIdClasses);
                    }
                    sameExtIdClasses.add(clazz);
                }
                if ((sameNameClasses = (HashSet<Object>)name2class.get(name = clazz.getSchedulingSubpart().getItypeDesc().trim() + " " + this.getClassSuffix(clazz))) == null) {
                    sameNameClasses = new HashSet<Object>();
                    name2class.put((CallSite)((Object)name), sameNameClasses);
                }
                sameNameClasses.add(clazz);
            }
            HashMap<String, InstructionalMethod> ref2im = new HashMap<String, InstructionalMethod>();
            HashMap<String, InstructionalMethod> name2im = new HashMap<String, InstructionalMethod>();
            for (Object meth : InstructionalMethodDAO.getInstance().findAll(this.getHibSession())) {
                ref2im.put(((BaseRefTableEntry)meth).getReference(), (InstructionalMethod)meth);
                name2im.put(((BaseRefTableEntry)meth).getLabel(), (InstructionalMethod)meth);
            }
            HashMap<String, StudentSectioningStatus> ref2status = new HashMap<String, StudentSectioningStatus>();
            for (StudentSectioningStatus status : StudentSectioningStatus.findAll(this.getHibSession(), session.getUniqueId())) {
                ref2status.put(status.getReference(), status);
            }
            HashSet<Long> updatedStudents = new HashSet<Long>();
            ArrayList<Student> createdStudents = new ArrayList<Student>();
            Iterator i1 = rootElement.elementIterator("student");
            while (i1.hasNext()) {
                Element recommendationsEl;
                Object free;
                Iterator j;
                CourseOffering course;
                String critical;
                boolean bl;
                String status;
                Object email;
                Element studentElement = (Element)i1.next();
                String externalId = studentElement.attributeValue("key");
                if (externalId == null) continue;
                while (trimLeadingZerosFromExternalId && externalId.startsWith("0")) {
                    externalId = externalId.substring(1);
                }
                Element cancelElement = studentElement.element("cancelStudent");
                if (cancelElement != null) {
                    Student student = (Student)students.remove(externalId);
                    if (student == null) continue;
                    Iterator<Serializable> i = student.getCourseDemands().iterator();
                    while (i.hasNext()) {
                        CourseDemand cd = i.next();
                        if (cd.getFreeTime() != null) {
                            this.getHibSession().remove((Object)cd.getFreeTime());
                        }
                        for (CourseRequest cr : cd.getCourseRequests()) {
                            this.getHibSession().remove((Object)cr);
                        }
                        i.remove();
                        this.getHibSession().remove((Object)cd);
                        updatedStudents.add(student.getUniqueId());
                    }
                    i = student.getClassEnrollments().iterator();
                    while (i.hasNext()) {
                        StudentClassEnrollment enrollment = (StudentClassEnrollment)i.next();
                        this.getHibSession().remove((Object)enrollment);
                        i.remove();
                        updatedStudents.add(student.getUniqueId());
                    }
                    boolean delete = "true".equals(cancelElement.attributeValue("delete", "false"));
                    if (delete) {
                        updatedStudents.add(student.getUniqueId());
                        this.getHibSession().remove((Object)student);
                        continue;
                    }
                }
                Element demographicsElement = studentElement.element("updateDemographics");
                Student student = (Student)students.remove(externalId);
                if (student == null) {
                    Element pin;
                    if (demographicsElement == null) {
                        this.error("Student " + externalId + " not found, but no demographics information provided.");
                        continue;
                    }
                    student = new Student();
                    student.setSession(session);
                    student.setExternalUniqueId(externalId);
                    student.setFreeTimeCategory(0);
                    student.setSchedulePreference(0);
                    student.setClassEnrollments(new HashSet<StudentClassEnrollment>());
                    student.setCourseDemands(new HashSet<CourseDemand>());
                    student.setAdvisorCourseRequests(new HashSet<AdvisorCourseRequest>());
                    name = demographicsElement.element("name");
                    if (name != null) {
                        student.setFirstName(name.attributeValue("first"));
                        student.setMiddleName(name.attributeValue("middle"));
                        student.setLastName(name.attributeValue("last"));
                    } else {
                        student.setFirstName("Name");
                        student.setLastName("Unknown");
                    }
                    email = demographicsElement.element("email");
                    if (email != null) {
                        student.setEmail(email.attributeValue("value"));
                    }
                    if ((pin = demographicsElement.element("pin")) != null) {
                        student.setPin(pin.attributeValue("value"));
                        String string = pin.attributeValue("released");
                        if ("true".equalsIgnoreCase(string)) {
                            student.setPinReleased(true);
                        } else if ("false".equalsIgnoreCase(string)) {
                            student.setPinReleased(false);
                        }
                    }
                    student.setAreaClasfMajors(new HashSet<StudentAreaClassificationMajor>());
                    student.setAreaClasfMinors(new HashSet<StudentAreaClassificationMinor>());
                    student.setGroups(new HashSet<StudentGroup>());
                    student.setAccomodations(new HashSet<StudentAccomodation>());
                    String string = demographicsElement.attributeValue("minCredit");
                    student.setMinCredit(string == null ? null : Float.valueOf(string));
                    String maxCred = demographicsElement.attributeValue("maxCredit");
                    student.setMaxCredit(maxCred == null ? null : Float.valueOf(maxCred));
                    this.getHibSession().persist((Object)student);
                } else if (demographicsElement != null) {
                    Element pin;
                    String string;
                    String minCred;
                    name = demographicsElement.element("name");
                    if (name != null) {
                        String fName = name.attributeValue("first");
                        String mName = name.attributeValue("middle");
                        String string2 = name.attributeValue("last");
                        if (!this.eq(fName, student.getFirstName())) {
                            student.setFirstName(name.attributeValue("first"));
                            updatedStudents.add(student.getUniqueId());
                        }
                        if (!this.eq(mName, student.getMiddleName())) {
                            student.setMiddleName(mName);
                            updatedStudents.add(student.getUniqueId());
                        }
                        if (!this.eq(string2, student.getLastName())) {
                            student.setLastName(string2);
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    if ((email = demographicsElement.element("email")) != null && !this.eq(email.attributeValue("value"), student.getEmail())) {
                        student.setEmail(email.attributeValue("value"));
                        updatedStudents.add(student.getUniqueId());
                    }
                    if (!this.eq((minCred = demographicsElement.attributeValue("minCredit")) == null ? null : Float.valueOf(minCred), student.getMinCredit())) {
                        student.setMinCredit(minCred == null ? null : Float.valueOf(minCred));
                        updatedStudents.add(student.getUniqueId());
                    }
                    if (!this.eq((string = demographicsElement.attributeValue("maxCredit")) == null ? null : Float.valueOf(string), student.getMaxCredit())) {
                        student.setMaxCredit(string == null ? null : Float.valueOf(string));
                        updatedStudents.add(student.getUniqueId());
                    }
                    if ((pin = demographicsElement.element("pin")) != null) {
                        String pinReleased;
                        if (!this.eq(pin.attributeValue("value"), student.getPin())) {
                            student.setPin(pin.attributeValue("value"));
                            updatedStudents.add(student.getUniqueId());
                        }
                        if (!this.eq(pinReleased = pin.attributeValue("released"), student.getPinReleased() == null ? null : (Boolean.TRUE.equals(student.getPinReleased()) ? "true" : "false"))) {
                            if ("true".equalsIgnoreCase(pinReleased)) {
                                student.setPinReleased(true);
                            } else if ("false".equalsIgnoreCase(pinReleased)) {
                                student.setPinReleased(false);
                            } else {
                                student.setPinReleased(null);
                            }
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                }
                if (demographicsElement != null) {
                    Object group2;
                    String clasf;
                    AcademicClassification f;
                    AcademicArea a;
                    Serializable m;
                    String area;
                    Element g;
                    Iterator i3;
                    String code;
                    Comparable<StudentAreaClassificationMajor> acm;
                    Hashtable<CallSite, Object> sMajors = new Hashtable<CallSite, Object>();
                    email = student.getAreaClasfMajors().iterator();
                    while (email.hasNext()) {
                        StudentAreaClassificationMajor major = (StudentAreaClassificationMajor)email.next();
                        sMajors.put((CallSite)((Object)(major.getAcademicArea().getAcademicAreaAbbreviation() + ":" + major.getAcademicClassification().getCode() + ":" + major.getMajor().getCode() + (String)(major.getConcentration() == null ? "" : ":" + major.getConcentration().getCode()))), major);
                    }
                    Hashtable<CallSite, StudentAreaClassificationMinor> sMinors = new Hashtable<CallSite, StudentAreaClassificationMinor>();
                    for (StudentAreaClassificationMinor studentAreaClassificationMinor : student.getAreaClasfMinors()) {
                        sMinors.put((CallSite)((Object)(studentAreaClassificationMinor.getAcademicArea().getAcademicAreaAbbreviation() + ":" + studentAreaClassificationMinor.getAcademicClassification().getCode() + ":" + studentAreaClassificationMinor.getMinor().getCode())), studentAreaClassificationMinor);
                    }
                    Iterator i2 = demographicsElement.elementIterator("acadArea");
                    while (i2.hasNext()) {
                        String code2;
                        Element element = (Element)i2.next();
                        String area2 = element.attributeValue("abbv");
                        AcademicArea a2 = (AcademicArea)abbv2area.get(area2);
                        if (a2 == null) {
                            this.warn("Academic area " + area2 + " not known.");
                            continue;
                        }
                        String clasf2 = element.attributeValue("classification");
                        AcademicClassification f2 = (AcademicClassification)code2clasf.get(clasf2);
                        if (f2 == null) {
                            this.warn("Academic classification " + clasf2 + " not known.");
                            continue;
                        }
                        Iterator i32 = element.elementIterator("major");
                        while (i32.hasNext()) {
                            Element g2 = (Element)i32.next();
                            String code22 = g2.attributeValue("code");
                            String concentration = g2.attributeValue("concentration");
                            String degree = g2.attributeValue("degree");
                            String program = g2.attributeValue("program");
                            String camp = g2.attributeValue("campus");
                            Double weight = Double.valueOf(g2.attributeValue("weight", "1.0"));
                            StudentAreaClassificationMajor acm2 = (StudentAreaClassificationMajor)sMajors.remove(area2 + ":" + clasf2 + ":" + code22 + (String)(concentration == null ? "" : ":" + concentration));
                            if (acm2 != null) {
                                acm2.setConcentration(concentration == null ? null : (PosMajorConcentration)code2concentration.get(area2 + ":" + code22 + ":" + concentration));
                                acm2.setDegree(degree == null ? null : (Degree)code2degree.get(degree));
                                acm2.setProgram(program == null ? null : (Program)code2program.get(program));
                                acm2.setCampus(camp == null ? null : (Campus)hashtable.get(camp));
                                acm2.setWeight(weight);
                                if (student.getUniqueId() == null) continue;
                                updatedStudents.add(student.getUniqueId());
                                continue;
                            }
                            PosMajor m2 = (PosMajor)code2major.get(area2 + ":" + code22);
                            if (m2 == null) {
                                this.warn("Major " + area2 + " " + code22 + " not known.");
                                continue;
                            }
                            acm2 = new StudentAreaClassificationMajor();
                            acm2.setAcademicArea(a2);
                            acm2.setAcademicClassification(f2);
                            acm2.setMajor(m2);
                            acm2.setStudent(student);
                            acm2.setConcentration(concentration == null ? null : (PosMajorConcentration)code2concentration.get(area2 + ":" + code22 + ":" + concentration));
                            acm2.setDegree(degree == null ? null : (Degree)code2degree.get(degree));
                            acm2.setProgram(program == null ? null : (Program)code2program.get(program));
                            acm2.setCampus(camp == null ? null : (Campus)hashtable.get(camp));
                            acm2.setWeight(weight);
                            student.getAreaClasfMajors().add(acm2);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                        if (element.element("major") == null && element.element("minor") == null) {
                            String code3;
                            boolean noMajor = true;
                            Iterator i33 = demographicsElement.elementIterator("major");
                            while (i33.hasNext()) {
                                code2 = ((Element)i33.next()).attributeValue("code");
                                if (code2major.get(area2 + ":" + code2) == null) continue;
                                noMajor = false;
                                break;
                            }
                            if (noMajor && sMajors.remove(area2 + ":" + clasf2 + ":" + (code3 = "-")) == null) {
                                PosMajor m3 = (PosMajor)code2major.get(area2 + ":" + code3);
                                if (m3 == null) {
                                    m3 = new PosMajor();
                                    m3.addToAcademicAreas(a2);
                                    m3.setExternalUniqueId("-");
                                    m3.setCode("-");
                                    m3.setName("No Major");
                                    m3.setSession(a2.getSession());
                                    a2.addToPosMajors(m3);
                                    this.getHibSession().persist((Object)m3);
                                    code2major.put((CallSite)((Object)(area2 + ":" + code3)), m3);
                                }
                                StudentAreaClassificationMajor acm3 = new StudentAreaClassificationMajor();
                                acm3.setAcademicArea(a2);
                                acm3.setAcademicClassification(f2);
                                acm3.setMajor(m3);
                                acm3.setStudent(student);
                                acm3.setWeight(1.0);
                                student.getAreaClasfMajors().add(acm3);
                                if (student.getUniqueId() != null) {
                                    updatedStudents.add(student.getUniqueId());
                                }
                            }
                        }
                        Iterator i33 = element.elementIterator("minor");
                        while (i33.hasNext()) {
                            Element g2 = (Element)i33.next();
                            code2 = g2.attributeValue("code");
                            if (sMinors.remove(area2 + ":" + clasf2 + ":" + code2) != null) continue;
                            PosMinor m4 = (PosMinor)code2minor.get(area2 + ":" + code2);
                            if (m4 == null) {
                                this.warn("Minor " + area2 + " " + code2 + " not known.");
                                continue;
                            }
                            acm = new StudentAreaClassificationMinor();
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setAcademicArea(a2);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setAcademicClassification(f2);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setMinor(m4);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setStudent(student);
                            student.getAreaClasfMinors().add((StudentAreaClassificationMinor)acm);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    i2 = demographicsElement.elementIterator("major");
                    while (i2.hasNext()) {
                        Element element = (Element)i2.next();
                        code = element.attributeValue("code");
                        i3 = demographicsElement.elementIterator("acadArea");
                        while (i3.hasNext()) {
                            g = (Element)i3.next();
                            area = g.attributeValue("abbv");
                            m = (PosMajor)code2major.get(area + ":" + code);
                            if (m == null || (a = (AcademicArea)abbv2area.get(area)) == null || (f = (AcademicClassification)code2clasf.get(clasf = g.attributeValue("classification"))) == null || sMajors.remove(area + ":" + clasf + ":" + code) != null) continue;
                            acm = new StudentAreaClassificationMajor();
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setAcademicArea(a);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setAcademicClassification(f);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setMajor((PosMajor)m);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setStudent(student);
                            ((BaseStudentAreaClassificationMajor)((Object)acm)).setWeight(1.0);
                            student.getAreaClasfMajors().add((StudentAreaClassificationMajor)acm);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    i2 = demographicsElement.elementIterator("minor");
                    while (i2.hasNext()) {
                        Element element = (Element)i2.next();
                        code = element.attributeValue("code");
                        i3 = demographicsElement.elementIterator("acadArea");
                        while (i3.hasNext()) {
                            g = (Element)i3.next();
                            area = g.attributeValue("abbv");
                            m = (PosMinor)code2minor.get(area + ":" + code);
                            if (m == null || (a = (AcademicArea)abbv2area.get(area)) == null || (f = (AcademicClassification)code2clasf.get(clasf = g.attributeValue("classification"))) == null || sMinors.remove(area + ":" + clasf + ":" + code) != null) continue;
                            acm = new StudentAreaClassificationMinor();
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setAcademicArea(a);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setAcademicClassification(f);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setMinor((PosMinor)m);
                            ((BaseStudentAreaClassificationMinor)((Object)acm)).setStudent(student);
                            student.getAreaClasfMinors().add((StudentAreaClassificationMinor)acm);
                            if (student.getUniqueId() == null) continue;
                            updatedStudents.add(student.getUniqueId());
                        }
                    }
                    for (StudentAreaClassificationMajor studentAreaClassificationMajor : sMajors.values()) {
                        student.getAreaClasfMajors().remove(studentAreaClassificationMajor);
                        this.getHibSession().remove((Object)studentAreaClassificationMajor);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    for (StudentAreaClassificationMinor studentAreaClassificationMinor : sMinors.values()) {
                        student.getAreaClasfMinors().remove(studentAreaClassificationMinor);
                        this.getHibSession().remove((Object)studentAreaClassificationMinor);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    Hashtable<String, StudentGroup> sGroups = new Hashtable<String, StudentGroup>();
                    for (StudentGroup group3 : student.getGroups()) {
                        sGroups.put(group3.getGroupAbbreviation(), group3);
                    }
                    Iterator iterator = demographicsElement.elementIterator("groupAffiliation");
                    while (iterator.hasNext()) {
                        Element e2 = (Element)iterator.next();
                        String code4 = e2.attributeValue("code");
                        if (sGroups.remove(code4) != null) continue;
                        StudentGroup group2 = (StudentGroup)code2group.get(code4);
                        if (group2 == null) {
                            this.warn("Student group " + code4 + " not known.");
                            continue;
                        }
                        student.getGroups().add(group2);
                        group2.getStudents().add(student);
                        this.getHibSession().merge((Object)group2);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    for (Object group2 : sGroups.values()) {
                        if (((BaseStudentGroup)group2).getExternalUniqueId() == null) continue;
                        student.getGroups().remove(group2);
                        ((BaseStudentGroup)group2).getStudents().remove(student);
                        this.getHibSession().merge(group2);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    Hashtable<String, StudentAccomodation> hashtable2 = new Hashtable<String, StudentAccomodation>();
                    group2 = student.getAccomodations().iterator();
                    while (group2.hasNext()) {
                        StudentAccomodation accomodation = (StudentAccomodation)group2.next();
                        hashtable2.put(accomodation.getAbbreviation(), accomodation);
                    }
                    Iterator i23 = demographicsElement.elementIterator("disability");
                    while (i23.hasNext()) {
                        Element e3 = (Element)i23.next();
                        String code5 = e3.attributeValue("code");
                        if (hashtable2.remove(code5) != null) continue;
                        StudentAccomodation accomodation2 = (StudentAccomodation)code2accomodation.get(code5);
                        if (accomodation2 == null) {
                            this.warn("Student accomodation " + code5 + " not known.");
                            continue;
                        }
                        student.getAccomodations().add(accomodation2);
                        accomodation2.getStudents().add(student);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                    for (Object accomodation3 : hashtable2.values()) {
                        student.getAccomodations().remove(accomodation3);
                        ((BaseStudentAccomodation)accomodation3).getStudents().remove(student);
                        if (student.getUniqueId() == null) continue;
                        updatedStudents.add(student.getUniqueId());
                    }
                }
                if ((status = studentElement.attributeValue("status")) != null) {
                    if (status.isEmpty()) {
                        student.setSectioningStatus(null);
                    } else {
                        StudentSectioningStatus s = (StudentSectioningStatus)ref2status.get(status);
                        if (s != null) {
                            student.setSectioningStatus(s);
                        } else {
                            this.warn("Student sectioning status " + status + " not found.");
                        }
                    }
                }
                if (student.getUniqueId() == null) {
                    createdStudents.add(student);
                    this.getHibSession().persist((Object)student);
                } else {
                    this.getHibSession().merge((Object)student);
                }
                Element reqCoursesElement = studentElement.element("updateCourseRequests");
                Element delCoursesElement = null;
                boolean bl2 = bl = reqCoursesElement != null;
                if (!bl) {
                    reqCoursesElement = studentElement.element("addCourseRequests");
                    delCoursesElement = studentElement.element("dropCourseRequests");
                }
                if (reqCoursesElement != null && "true".equals(reqCoursesElement.attributeValue("commit", "true")) || delCoursesElement != null) {
                    Element requestElement;
                    Iterator<Object> i;
                    Object accomodation3;
                    Hashtable<StudentEnrollmentImport.Pair, StudentClassEnrollment> enrollments = new Hashtable<StudentEnrollmentImport.Pair, StudentClassEnrollment>();
                    accomodation3 = student.getClassEnrollments().iterator();
                    while (accomodation3.hasNext()) {
                        StudentClassEnrollment enrollment = accomodation3.next();
                        enrollments.put(new StudentEnrollmentImport.Pair(enrollment.getCourseOffering().getUniqueId(), enrollment.getClazz().getUniqueId()), enrollment);
                    }
                    TreeSet<CourseDemand> remaining = new TreeSet<CourseDemand>(student.getCourseDemands());
                    int priority = bl ? 0 : remaining.size();
                    Date ts = new Date();
                    HashMap<Long, CourseRequest> course2request = new HashMap<Long, CourseRequest>();
                    ArrayList<CourseRequest> unusedRequests = new ArrayList<CourseRequest>();
                    if (reqCoursesElement != null) {
                        i = reqCoursesElement.elementIterator();
                        while (i.hasNext()) {
                            requestElement = (Element)i.next();
                            String waitList = requestElement.attributeValue("waitlist");
                            String noSub = requestElement.attributeValue("nosub");
                            String alternative = requestElement.attributeValue("alternative");
                            critical = requestElement.attributeValue("critical");
                            String criticalOverride = requestElement.attributeValue("criticalOverride");
                            if (requestElement.getName().equals("courseOffering")) {
                                ArrayList<CourseOffering> courses = new ArrayList<CourseOffering>();
                                ArrayList<Integer> credits = new ArrayList<Integer>();
                                ArrayList<Element> elements = new ArrayList<Element>();
                                course = (CourseOffering)name2course.get(requestElement.attributeValue("subjectArea") + " " + requestElement.attributeValue("courseNumber"));
                                if (course == null) {
                                    this.warn("Course " + requestElement.attributeValue("subjectArea") + " " + requestElement.attributeValue("courseNumber") + " not found.");
                                } else {
                                    courses.add(course);
                                    credits.add(Integer.valueOf(requestElement.attributeValue("credit", "0")));
                                    elements.add(requestElement);
                                }
                                LinkedList<Element> queue = new LinkedList<Element>();
                                queue.add(requestElement);
                                Element requestOrAlternativeElement = null;
                                while ((requestOrAlternativeElement = (Element)queue.poll()) != null) {
                                    j = requestOrAlternativeElement.elementIterator("alternative");
                                    while (j.hasNext()) {
                                        Element altElement = (Element)j.next();
                                        CourseOffering altCourse = (CourseOffering)name2course.get(altElement.attributeValue("subjectArea") + " " + altElement.attributeValue("courseNumber"));
                                        if (altCourse == null) {
                                            this.warn("Course " + altElement.attributeValue("subjectArea") + " " + altElement.attributeValue("courseNumber") + " not found.");
                                        } else {
                                            courses.add(altCourse);
                                            credits.add(Integer.valueOf(altElement.attributeValue("credit", "0")));
                                            elements.add(altElement);
                                        }
                                        queue.add(altElement);
                                    }
                                }
                                if (!courses.isEmpty()) {
                                    CourseDemand cd = null;
                                    Iterator j2 = remaining.iterator();
                                    block68: while (j2.hasNext()) {
                                        CourseDemand adept = (CourseDemand)j2.next();
                                        if (adept.getFreeTime() != null) continue;
                                        for (CourseRequest cr : adept.getCourseRequests()) {
                                            if (!cr.getCourseOffering().getUniqueId().equals(((CourseOffering)courses.get(0)).getUniqueId())) continue;
                                            cd = adept;
                                            j2.remove();
                                            break block68;
                                        }
                                    }
                                    if (cd == null) {
                                        cd = new CourseDemand();
                                        String requested = requestElement.attributeValue("requested");
                                        if (requested != null) {
                                            try {
                                                cd.setTimestamp(sDateFormat.parse(requested));
                                            }
                                            catch (ParseException e) {
                                                cd.setTimestamp(ts);
                                            }
                                        } else {
                                            cd.setTimestamp(ts);
                                        }
                                        cd.setCourseRequests(new HashSet<CourseRequest>());
                                        cd.setEnrollmentMessages(new HashSet<StudentEnrollmentMessage>());
                                        cd.setStudent(student);
                                        student.getCourseDemands().add(cd);
                                    }
                                    cd.setAlternative("true".equals(alternative));
                                    cd.setPriority(priority);
                                    if ("true".equals(waitList) && !Boolean.TRUE.equals(cd.getWaitlist())) {
                                        CourseDemand.Critical[] waitlisted = requestElement.attributeValue("waitlisted");
                                        if (waitlisted != null) {
                                            try {
                                                cd.setWaitlistedTimeStamp(sDateFormat.parse((String)waitlisted));
                                            }
                                            catch (ParseException e) {
                                                cd.setWaitlistedTimeStamp(ts);
                                            }
                                        } else {
                                            cd.setWaitlistedTimeStamp(ts);
                                        }
                                    }
                                    cd.setWaitlist("true".equals(waitList));
                                    cd.setNoSub("true".equals(noSub));
                                    if (critical == null) {
                                        cd.setCritical(null);
                                    } else if ("true".equals(critical)) {
                                        cd.setCritical(CourseDemand.Critical.CRITICAL.ordinal());
                                    } else if ("false".equals(critical)) {
                                        cd.setCritical(CourseDemand.Critical.NORMAL.ordinal());
                                    } else {
                                        for (CourseDemand.Critical c : CourseDemand.Critical.values()) {
                                            if (!c.name().equalsIgnoreCase(critical) && !String.valueOf(c.ordinal()).equals(critical)) continue;
                                            cd.setCritical(c.ordinal());
                                            break;
                                        }
                                    }
                                    if (criticalOverride == null) {
                                        cd.setCriticalOverride(null);
                                    } else if ("true".equals(criticalOverride)) {
                                        cd.setCriticalOverride(CourseDemand.Critical.CRITICAL.ordinal());
                                    } else if ("false".equals(criticalOverride)) {
                                        cd.setCriticalOverride(CourseDemand.Critical.NORMAL.ordinal());
                                    } else {
                                        for (CourseDemand.Critical c : CourseDemand.Critical.values()) {
                                            if (!c.name().equalsIgnoreCase(criticalOverride) && !String.valueOf(c.ordinal()).equals(criticalOverride)) continue;
                                            cd.setCriticalOverride(c.ordinal());
                                            break;
                                        }
                                    }
                                    Iterator<CourseRequest> requests = new TreeSet<CourseRequest>(cd.getCourseRequests()).iterator();
                                    int order = 0;
                                    for (CourseOffering co : courses) {
                                        CourseRequest cr = null;
                                        if (requests.hasNext()) {
                                            cr = requests.next();
                                            if (cr.getCourseRequestOptions() != null) {
                                                Iterator<CourseRequestOption> j3 = cr.getCourseRequestOptions().iterator();
                                                while (j3.hasNext()) {
                                                    this.getHibSession().remove((Object)j3.next());
                                                }
                                                cr.getCourseRequestOptions().clear();
                                            }
                                        } else {
                                            cr = new CourseRequest();
                                            cd.getCourseRequests().add(cr);
                                            cr.setCourseDemand(cd);
                                            cr.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                                        }
                                        cr.setAllowOverlap(false);
                                        cr.setCredit((Integer)credits.get(order));
                                        cr.setCourseOffering(co);
                                        this.importPreferences(cr, (Element)elements.get(order), co, (Map<String, Set<Class_>>)((Map)course2extId2class.get(co.getUniqueId())), (Map<String, Set<Class_>>)((Map)course2name2class.get(co.getUniqueId())), ref2im, name2im);
                                        cr.setOrder(order++);
                                        course2request.put(co.getUniqueId(), cr);
                                    }
                                    while (requests.hasNext()) {
                                        unusedRequests.add(requests.next());
                                        requests.remove();
                                    }
                                    if (cd.getUniqueId() == null) {
                                        this.getHibSession().persist((Object)cd);
                                    } else {
                                        this.getHibSession().merge((Object)cd);
                                    }
                                    if (mode == EnrollmentMode.IMPORT) {
                                        for (int j4 = 0; j4 < courses.size(); ++j4) {
                                            CourseOffering co;
                                            co = (CourseOffering)courses.get(j4);
                                            Element reqEl = (Element)elements.get(j4);
                                            Map extId2class = (Map)course2extId2class.get(co.getUniqueId());
                                            Map name2class = (Map)course2name2class.get(co.getUniqueId());
                                            HashSet<Long> imported = new HashSet<Long>();
                                            Iterator k = reqEl.elementIterator("class");
                                            while (k.hasNext()) {
                                                Element classElement = (Element)k.next();
                                                Set classes = null;
                                                String classExternalId = classElement.attributeValue("externalId");
                                                if (classExternalId != null && extId2class != null && (classes = (Set)extId2class.get(classExternalId)) == null) {
                                                    classes = (Set)name2class.get(classExternalId);
                                                }
                                                if (classes == null && name2class != null) {
                                                    String type = classElement.attributeValue("type");
                                                    String suffix = classElement.attributeValue("suffix");
                                                    if (type != null && suffix != null) {
                                                        classes = (Set)name2class.get(type.trim() + " " + suffix);
                                                    }
                                                }
                                                if (classes == null && co != null) {
                                                    this.warn(co.getCourseName() + ": Class " + (String)(classExternalId != null ? classExternalId : classElement.attributeValue("type") + " " + classElement.attributeValue("suffix")) + " not found.");
                                                    continue;
                                                }
                                                CourseRequest request = (CourseRequest)course2request.get(co.getUniqueId());
                                                if (request != null) {
                                                    Iterator<StudentEnrollmentMessage> l = request.getCourseDemand().getEnrollmentMessages().iterator();
                                                    while (l.hasNext()) {
                                                        StudentEnrollmentMessage message = l.next();
                                                        this.getHibSession().remove((Object)message);
                                                        l.remove();
                                                    }
                                                }
                                                for (Class_ clazz : classes) {
                                                    StudentClassEnrollment enrollment;
                                                    if (!imported.add(clazz.getUniqueId()) || (enrollment = (StudentClassEnrollment)enrollments.remove(new StudentEnrollmentImport.Pair(co.getUniqueId(), clazz.getUniqueId()))) != null) continue;
                                                    enrollment = new StudentClassEnrollment();
                                                    enrollment.setStudent(student);
                                                    enrollment.setClazz(clazz);
                                                    enrollment.setCourseOffering(co);
                                                    String enrolled = classElement.attributeValue("enrolled");
                                                    if (enrolled != null) {
                                                        try {
                                                            enrollment.setTimestamp(sDateFormat.parse(enrolled));
                                                        }
                                                        catch (ParseException e) {
                                                            enrollment.setTimestamp(ts);
                                                        }
                                                    } else {
                                                        enrollment.setTimestamp(ts);
                                                    }
                                                    enrollment.setChangedBy(StudentClassEnrollment.SystemChange.IMPORT.toString());
                                                    enrollment.setCourseRequest(request);
                                                    student.getClassEnrollments().add(enrollment);
                                                }
                                            }
                                        }
                                    }
                                }
                            } else if (requestElement.getName().equals("freeTime")) {
                                String days = requestElement.attributeValue("days");
                                String startTime = requestElement.attributeValue("startTime");
                                String length = requestElement.attributeValue("length");
                                String endTime = requestElement.attributeValue("endTime");
                                TimeLocation time = this.makeTime(student.getSession().getDefaultDatePattern(), days, startTime, endTime, length);
                                CourseDemand cd = null;
                                j = remaining.iterator();
                                while (j.hasNext()) {
                                    TimeLocation free2;
                                    CourseDemand adept = (CourseDemand)j.next();
                                    if (adept.getFreeTime() == null || !bl && !(free2 = new TimeLocation(adept.getFreeTime().getDayCode().intValue(), adept.getFreeTime().getStartSlot().intValue(), adept.getFreeTime().getLength().intValue(), 0, 0.0, 0, null, null, student.getSession().getDefaultDatePattern().getPatternBitSet(), 0)).hasIntersection(time)) continue;
                                    cd = adept;
                                    j.remove();
                                    break;
                                }
                                if (cd == null) {
                                    cd = new CourseDemand();
                                    String requested = requestElement.attributeValue("requested");
                                    if (requested != null) {
                                        try {
                                            cd.setTimestamp(sDateFormat.parse(requested));
                                        }
                                        catch (ParseException e) {
                                            cd.setTimestamp(ts);
                                        }
                                    } else {
                                        cd.setTimestamp(ts);
                                    }
                                    student.getCourseDemands().add(cd);
                                    cd.setStudent(student);
                                }
                                cd.setAlternative("true".equals(alternative));
                                cd.setPriority(priority);
                                if ("true".equals(waitList) && !Boolean.TRUE.equals(cd.getWaitlist())) {
                                    String waitlisted = requestElement.attributeValue("waitlisted");
                                    if (waitlisted != null) {
                                        try {
                                            cd.setWaitlistedTimeStamp(sDateFormat.parse(waitlisted));
                                        }
                                        catch (ParseException e) {
                                            cd.setWaitlistedTimeStamp(ts);
                                        }
                                    } else {
                                        cd.setWaitlistedTimeStamp(ts);
                                    }
                                }
                                cd.setWaitlist("true".equals(waitList));
                                cd.setNoSub("true".equals(noSub));
                                FreeTime free3 = cd.getFreeTime();
                                if (free3 == null) {
                                    free3 = new FreeTime();
                                    cd.setFreeTime(free3);
                                }
                                free3.setCategory(time.getBreakTime());
                                free3.setDayCode(time.getDayCode());
                                free3.setStartSlot(time.getStartSlot());
                                free3.setLength(time.getLength());
                                free3.setSession(student.getSession());
                                free3.setName(time.getLongName(true));
                                if (free3.getUniqueId() == null) {
                                    this.getHibSession().persist((Object)free3);
                                } else {
                                    this.getHibSession().merge((Object)free3);
                                }
                                if (cd.getUniqueId() == null) {
                                    this.getHibSession().persist((Object)cd);
                                } else {
                                    this.getHibSession().merge((Object)cd);
                                }
                            } else {
                                this.warn("Request element " + requestElement.getName() + " not recognized.");
                            }
                            ++priority;
                        }
                    }
                    if (delCoursesElement != null) {
                        i = delCoursesElement.elementIterator();
                        while (i.hasNext()) {
                            requestElement = (Element)i.next();
                            if (requestElement.getName().equals("courseOffering")) {
                                CourseOffering course2 = (CourseOffering)name2course.get(requestElement.attributeValue("subjectArea") + " " + requestElement.attributeValue("courseNumber"));
                                if (course2 == null) {
                                    this.warn("Course " + requestElement.attributeValue("subjectArea") + " " + requestElement.attributeValue("courseNumber") + " not found.");
                                } else {
                                    BaseCourseDemand cd = null;
                                    Iterator<Object> j5 = remaining.iterator();
                                    block81: while (j5.hasNext()) {
                                        CourseDemand adept = (CourseDemand)j5.next();
                                        if (adept.getFreeTime() != null) continue;
                                        for (CourseRequest cr : adept.getCourseRequests()) {
                                            if (!cr.getCourseOffering().getUniqueId().equals(course2.getUniqueId())) continue;
                                            cd = adept;
                                            j5.remove();
                                            break block81;
                                        }
                                    }
                                    if (cd != null) {
                                        for (CourseRequest cr : cd.getCourseRequests()) {
                                            unusedRequests.add(cr);
                                        }
                                    }
                                }
                            } else if (requestElement.getName().equals("freeTime")) {
                                String days = requestElement.attributeValue("days");
                                String startTime = requestElement.attributeValue("startTime");
                                String length = requestElement.attributeValue("length");
                                String endTime = requestElement.attributeValue("endTime");
                                TimeLocation time = this.makeTime(student.getSession().getDefaultDatePattern(), days, startTime, endTime, length);
                                BaseCourseDemand cd = null;
                                j = remaining.iterator();
                                while (j.hasNext()) {
                                    CourseDemand adept = (CourseDemand)j.next();
                                    if (adept.getFreeTime() == null || !bl && !(free = new TimeLocation(adept.getFreeTime().getDayCode().intValue(), adept.getFreeTime().getStartSlot().intValue(), adept.getFreeTime().getLength().intValue(), 0, 0.0, 0, null, null, student.getSession().getDefaultDatePattern().getPatternBitSet(), 0)).hasIntersection(time)) continue;
                                    cd = adept;
                                    j.remove();
                                    break;
                                }
                                if (cd != null) {
                                    this.getHibSession().remove((Object)cd.getFreeTime());
                                    student.getCourseDemands().remove(cd);
                                    this.getHibSession().remove((Object)cd);
                                }
                            } else {
                                this.warn("Request element " + requestElement.getName() + " not recognized.");
                            }
                            ++priority;
                        }
                    }
                    if (!bl) {
                        for (CourseDemand cd : remaining) {
                            for (CourseRequest cr : cd.getCourseRequests()) {
                                if (course2request.containsKey(cr.getCourseOffering().getUniqueId())) {
                                    unusedRequests.add(cr);
                                    continue;
                                }
                                course2request.put(cr.getCourseOffering().getUniqueId(), cr);
                                if (mode != EnrollmentMode.IMPORT) continue;
                                for (StudentClassEnrollment e : student.getClassEnrollments()) {
                                    if (!e.getCourseOffering().equals(cr.getCourseOffering())) continue;
                                    enrollments.remove(new StudentEnrollmentImport.Pair(e.getCourseOffering().getUniqueId(), e.getClazz().getUniqueId()));
                                }
                            }
                        }
                        remaining.clear();
                    }
                    if (mode == EnrollmentMode.DELETE || mode == EnrollmentMode.IMPORT) {
                        for (StudentClassEnrollment enrl : enrollments.values()) {
                            student.getClassEnrollments().remove(enrl);
                            enrl.getClazz().getStudentEnrollments().remove(enrl);
                            this.getHibSession().remove((Object)enrl);
                        }
                    } else {
                        i = student.getClassEnrollments().iterator();
                        while (i.hasNext()) {
                            StudentClassEnrollment enrl;
                            enrl = (StudentClassEnrollment)i.next();
                            CourseRequest cr = (CourseRequest)course2request.get(enrl.getCourseOffering().getUniqueId());
                            if (cr == null) {
                                if (mode == EnrollmentMode.NOCHANGE) {
                                    enrl.setCourseRequest(null);
                                    this.getHibSession().merge((Object)enrl);
                                    continue;
                                }
                                enrl.getClazz().getStudentEnrollments().remove(enrl);
                                this.getHibSession().remove((Object)enrl);
                                i.remove();
                                continue;
                            }
                            enrl.setCourseRequest(cr);
                            this.getHibSession().merge((Object)enrl);
                        }
                    }
                    for (CourseRequest cr : unusedRequests) {
                        CourseDemand cd = cr.getCourseDemand();
                        cd.getCourseRequests().remove(cr);
                        this.getHibSession().remove((Object)cr);
                        if (!cd.getCourseRequests().isEmpty()) continue;
                        student.getCourseDemands().remove(cd);
                        this.getHibSession().remove((Object)cd);
                    }
                    for (CourseDemand cd : remaining) {
                        if (cd.getFreeTime() != null) {
                            this.getHibSession().remove((Object)cd.getFreeTime());
                        }
                        for (CourseRequest cr : cd.getCourseRequests()) {
                            this.getHibSession().remove((Object)cr);
                        }
                        student.getCourseDemands().remove(cd);
                        this.getHibSession().remove((Object)cd);
                    }
                    if (!bl) {
                        priority = 0;
                        for (CourseDemand cd : new TreeSet<CourseDemand>(student.getCourseDemands())) {
                            cd.setPriority(priority++);
                            this.getHibSession().merge((Object)cd);
                        }
                    }
                    updatedStudents.add(student.getUniqueId());
                    if (student.getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList) {
                        student.resetWaitLists(WaitList.WaitListType.XML_IMPORT, StudentClassEnrollment.SystemChange.IMPORT.toString(), ts, this.getHibSession());
                    }
                }
                if ((recommendationsEl = studentElement.element("updateAdvisorRecommendations")) != null) {
                    Iterator i;
                    Date ts = new Date();
                    TreeSet<AdvisorCourseRequest> remaining = new TreeSet<AdvisorCourseRequest>(student.getAdvisorCourseRequests());
                    String notes = recommendationsEl.attributeValue("notes");
                    if (notes != null) {
                        BaseAdvisorCourseRequest acr = null;
                        i = remaining.iterator();
                        while (i.hasNext()) {
                            AdvisorCourseRequest adept = (AdvisorCourseRequest)i.next();
                            if (adept.getPriority() != -1) continue;
                            acr = adept;
                            i.remove();
                        }
                        if (acr == null) {
                            acr = new AdvisorCourseRequest();
                            acr.setStudent(student);
                            acr.setPriority(-1);
                            acr.setAlternative(0);
                            acr.setSubstitute(false);
                            String recommended = recommendationsEl.attributeValue("recommended");
                            if (recommended != null) {
                                try {
                                    acr.setTimestamp(sDateFormat.parse(recommended));
                                }
                                catch (ParseException e) {
                                    acr.setTimestamp(ts);
                                }
                            } else {
                                acr.setTimestamp(ts);
                            }
                            acr.setCredit(null);
                            acr.setCritical(0);
                            acr.setChangedBy(StudentClassEnrollment.SystemChange.IMPORT.toString());
                            student.getAdvisorCourseRequests().add((AdvisorCourseRequest)acr);
                        }
                        acr.setNotes(notes);
                        if (acr.getUniqueId() == null) {
                            this.getHibSession().persist((Object)acr);
                        } else {
                            this.getHibSession().merge((Object)acr);
                        }
                    }
                    int priority = 0;
                    i = recommendationsEl.elementIterator("recommendation");
                    while (i.hasNext()) {
                        Element recEl = (Element)i.next();
                        AdvisorCourseRequest acr = null;
                        Iterator j6 = remaining.iterator();
                        while (j6.hasNext()) {
                            AdvisorCourseRequest adept = (AdvisorCourseRequest)j6.next();
                            if (adept.getPriority() != priority || adept.getAlternative() != 0) continue;
                            acr = adept;
                            j6.remove();
                        }
                        if (acr == null) {
                            acr = new AdvisorCourseRequest();
                            acr.setStudent(student);
                            acr.setChangedBy(StudentClassEnrollment.SystemChange.IMPORT.toString());
                            String recommended = recEl.attributeValue("recommended");
                            if (recommended != null) {
                                try {
                                    acr.setTimestamp(sDateFormat.parse(recommended));
                                }
                                catch (ParseException e) {
                                    acr.setTimestamp(ts);
                                }
                            } else {
                                acr.setTimestamp(ts);
                            }
                            acr.setPriority(priority);
                            acr.setAlternative(0);
                            student.getAdvisorCourseRequests().add(acr);
                        }
                        acr.setSubstitute("true".equalsIgnoreCase(recEl.attributeValue("substitute", "false")));
                        acr.setCredit(recEl.attributeValue("credit"));
                        String wl = recEl.attributeValue("waitlist");
                        if (wl == null) {
                            acr.setWaitlist(null);
                        } else {
                            acr.setWaitlist("true".equalsIgnoreCase(wl));
                        }
                        String ns = recEl.attributeValue("nosub");
                        if (ns == null) {
                            acr.setNoSub(null);
                        } else {
                            acr.setNoSub("true".equalsIgnoreCase(ns));
                        }
                        acr.setNotes(recEl.attributeValue("notes"));
                        acr.setCourse(recEl.attributeValue("course"));
                        if (recEl.attributeValue("subjectArea") != null) {
                            CourseOffering course3 = (CourseOffering)name2course.get(recEl.attributeValue("subjectArea") + " " + recEl.attributeValue("courseNumber"));
                            if (course3 == null) {
                                this.warn("Course " + recEl.attributeValue("subjectArea") + " " + recEl.attributeValue("courseNumber") + " not found.");
                            } else {
                                acr.setCourseOffering(course3);
                                this.importPreferences(acr, recEl, course3, (Map<String, Set<Class_>>)((Map)course2extId2class.get(course3.getUniqueId())), (Map<String, Set<Class_>>)((Map)course2name2class.get(course3.getUniqueId())), ref2im, name2im);
                            }
                        } else {
                            acr.setCourseOffering(null);
                            if (acr.getPreferences() != null && !acr.getPreferences().isEmpty()) {
                                acr.getPreferences().clear();
                            }
                        }
                        Element ftEl = recEl.element("freeTime");
                        if (ftEl != null) {
                            String days = ftEl.attributeValue("days");
                            String startTime = ftEl.attributeValue("startTime");
                            String length = ftEl.attributeValue("length");
                            String endTime = ftEl.attributeValue("endTime");
                            TimeLocation time = this.makeTime(student.getSession().getDefaultDatePattern(), days, startTime, endTime, length);
                            free = acr.getFreeTime();
                            if (free == null) {
                                free = new FreeTime();
                                acr.setFreeTime((FreeTime)free);
                            }
                            ((BaseFreeTime)free).setCategory(time.getBreakTime());
                            ((BaseFreeTime)free).setDayCode(time.getDayCode());
                            ((BaseFreeTime)free).setStartSlot(time.getStartSlot());
                            ((BaseFreeTime)free).setLength(time.getLength());
                            ((BaseFreeTime)free).setSession(student.getSession());
                            ((BaseFreeTime)free).setName(time.getLongName(true));
                            if (((BaseFreeTime)free).getUniqueId() == null) {
                                this.getHibSession().persist(free);
                            } else {
                                this.getHibSession().merge(free);
                            }
                        } else if (acr.getFreeTime() != null) {
                            this.getHibSession().remove((Object)acr.getFreeTime());
                            acr.setFreeTime(null);
                        }
                        critical = recEl.attributeValue("critical");
                        if (critical == null) {
                            acr.setCritical(null);
                        } else if ("true".equals(critical)) {
                            acr.setCritical(CourseDemand.Critical.CRITICAL.ordinal());
                        } else if ("false".equals(critical)) {
                            acr.setCritical(CourseDemand.Critical.NORMAL.ordinal());
                        } else {
                            for (CourseDemand.Critical c : CourseDemand.Critical.values()) {
                                if (!c.name().equalsIgnoreCase(critical) && !String.valueOf(c.ordinal()).equals(critical)) continue;
                                acr.setCritical(c.ordinal());
                                break;
                            }
                        }
                        if (acr.getUniqueId() == null) {
                            this.getHibSession().persist((Object)acr);
                        } else {
                            this.getHibSession().merge((Object)acr);
                        }
                        int alterantive = 1;
                        AdvisorCourseRequest parent = acr;
                        j = recEl.elementIterator("alternative");
                        while (j.hasNext()) {
                            Element acrEl = (Element)j.next();
                            acr = null;
                            Iterator k = remaining.iterator();
                            while (k.hasNext()) {
                                AdvisorCourseRequest adept = (AdvisorCourseRequest)k.next();
                                if (adept.getPriority() != priority || adept.getAlternative() != alterantive) continue;
                                acr = adept;
                                k.remove();
                            }
                            if (acr == null) {
                                acr = new AdvisorCourseRequest();
                                acr.setStudent(student);
                                acr.setChangedBy(StudentClassEnrollment.SystemChange.IMPORT.toString());
                                String recommended = acrEl.attributeValue("recommended");
                                if (recommended != null) {
                                    try {
                                        acr.setTimestamp(sDateFormat.parse(recommended));
                                    }
                                    catch (ParseException e) {
                                        acr.setTimestamp(ts);
                                    }
                                } else {
                                    acr.setTimestamp(ts);
                                }
                                acr.setPriority(priority);
                                acr.setAlternative(alterantive);
                                student.getAdvisorCourseRequests().add(acr);
                            }
                            acr.setSubstitute(parent.isSubstitute());
                            acr.setCredit(null);
                            acr.setNotes(null);
                            acr.setWaitlist(null);
                            acr.setCourse(acrEl.attributeValue("course"));
                            if (acrEl.attributeValue("subjectArea") != null) {
                                course = (CourseOffering)name2course.get(acrEl.attributeValue("subjectArea") + " " + acrEl.attributeValue("courseNumber"));
                                if (course == null) {
                                    this.warn("Course " + acrEl.attributeValue("subjectArea") + " " + acrEl.attributeValue("courseNumber") + " not found.");
                                } else {
                                    acr.setCourseOffering(course);
                                    this.importPreferences(acr, acrEl, course, (Map<String, Set<Class_>>)((Map)course2extId2class.get(course.getUniqueId())), (Map<String, Set<Class_>>)((Map)course2name2class.get(course.getUniqueId())), ref2im, name2im);
                                }
                            } else {
                                acr.setCourseOffering(null);
                                if (acr.getPreferences() != null && !acr.getPreferences().isEmpty()) {
                                    acr.getPreferences().clear();
                                }
                            }
                            ftEl = acrEl.element("freeTime");
                            if (ftEl != null) {
                                String days = ftEl.attributeValue("days");
                                String startTime = ftEl.attributeValue("startTime");
                                String length = ftEl.attributeValue("length");
                                String endTime = ftEl.attributeValue("endTime");
                                TimeLocation time = this.makeTime(student.getSession().getDefaultDatePattern(), days, startTime, endTime, length);
                                FreeTime free4 = acr.getFreeTime();
                                if (free4 == null) {
                                    free4 = new FreeTime();
                                    acr.setFreeTime(free4);
                                }
                                free4.setCategory(time.getBreakTime());
                                free4.setDayCode(time.getDayCode());
                                free4.setStartSlot(time.getStartSlot());
                                free4.setLength(time.getLength());
                                free4.setSession(student.getSession());
                                free4.setName(time.getLongName(true));
                                if (free4.getUniqueId() == null) {
                                    this.getHibSession().persist((Object)free4);
                                } else {
                                    this.getHibSession().merge((Object)free4);
                                }
                            } else if (acr.getFreeTime() != null) {
                                this.getHibSession().remove((Object)acr.getFreeTime());
                                acr.setFreeTime(null);
                            }
                            critical = acrEl.attributeValue("critical");
                            if (critical == null) {
                                acr.setCritical(null);
                            } else if ("true".equals(critical)) {
                                acr.setCritical(CourseDemand.Critical.CRITICAL.ordinal());
                            } else if ("false".equals(critical)) {
                                acr.setCritical(CourseDemand.Critical.NORMAL.ordinal());
                            } else {
                                for (CourseDemand.Critical c : CourseDemand.Critical.values()) {
                                    if (!c.name().equalsIgnoreCase(critical) && !String.valueOf(c.ordinal()).equals(critical)) continue;
                                    acr.setCritical(c.ordinal());
                                    break;
                                }
                            }
                            ++alterantive;
                            if (acr.getUniqueId() == null) {
                                this.getHibSession().persist((Object)acr);
                                continue;
                            }
                            this.getHibSession().merge((Object)acr);
                        }
                        ++priority;
                    }
                    for (AdvisorCourseRequest acr : remaining) {
                        if (acr.getFreeTime() != null) {
                            this.getHibSession().remove((Object)acr.getFreeTime());
                        }
                        student.getAdvisorCourseRequests().remove(acr);
                        this.getHibSession().remove((Object)acr);
                    }
                }
                this.getHibSession().merge((Object)student);
            }
            this.getHibSession().flush();
            if (!createdStudents.isEmpty()) {
                for (Student s : createdStudents) {
                    updatedStudents.add(s.getUniqueId());
                }
            }
            this.info(updatedStudents.size() + " students changed");
            if (!updatedStudents.isEmpty()) {
                StudentSectioningQueue.studentChanged(this.getHibSession(), null, session.getUniqueId(), updatedStudents);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    private TimeLocation makeTime(DatePattern dp, String days, String startTime, String endTime, String length) {
        int dayCode = 0;
        if (days.contains("Th")) {
            dayCode += Constants.DAY_CODES[3];
            days = days.replace("Th", "..");
        }
        if (days.contains("R")) {
            dayCode += Constants.DAY_CODES[3];
            days = days.replace("R", ".");
        }
        if (days.contains("Su")) {
            dayCode += Constants.DAY_CODES[6];
            days = days.replace("Su", "..");
        }
        if (days.contains("U")) {
            dayCode += Constants.DAY_CODES[6];
            days = days.replace("U", ".");
        }
        if (days.contains("M")) {
            dayCode += Constants.DAY_CODES[0];
            days = days.replace("M", ".");
        }
        if (days.contains("T")) {
            dayCode += Constants.DAY_CODES[1];
            days = days.replace("T", ".");
        }
        if (days.contains("W")) {
            dayCode += Constants.DAY_CODES[2];
            days = days.replace("W", ".");
        }
        if (days.contains("F")) {
            dayCode += Constants.DAY_CODES[4];
            days = days.replace("F", ".");
        }
        if (days.contains("S")) {
            dayCode += Constants.DAY_CODES[5];
            days = days.replace("S", ".");
        }
        int startSlot = (Integer.parseInt(startTime) / 100 * 60 + Integer.parseInt(startTime) % 100 - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
        int nrSlots = 0;
        nrSlots = length != null ? Integer.parseInt(length) / Constants.SLOT_LENGTH_MIN : (Integer.parseInt(endTime) / 100 * 60 + Integer.parseInt(endTime) % 100 - (Integer.parseInt(startTime) / 100 * 60 + Integer.parseInt(startTime) % 100)) / Constants.SLOT_LENGTH_MIN;
        return new TimeLocation(dayCode, startSlot, nrSlots, 0, 0.0, dp.getUniqueId(), dp.getName(), dp.getPatternBitSet(), 0);
    }

    private boolean eq(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    private boolean eq(Float a, Float b) {
        return a == null ? b == null : a.equals(b);
    }

    protected void importPreferences(CourseRequest cr, Element requestEl, CourseOffering course, Map<String, Set<Class_>> extId2class, Map<String, Set<Class_>> name2class, Map<String, InstructionalMethod> ref2im, Map<String, InstructionalMethod> name2im) {
        StudentInstrMthPref imp;
        StudentClassPref scp;
        Element prefEl = requestEl.element("preferences");
        if (cr.getPreferences() == null) {
            cr.setPreferences(new HashSet<StudentSectioningPref>());
        } else {
            Iterator<StudentSectioningPref> i = cr.getPreferences().iterator();
            while (i.hasNext()) {
                this.iHibSession.remove((Object)i.next());
                i.remove();
            }
        }
        if (prefEl == null) {
            return;
        }
        HashSet<Class_> preferredClasses = new HashSet<Class_>();
        HashSet<Class_> requiredClasses = new HashSet<Class_>();
        Iterator i = prefEl.elementIterator("class");
        while (i.hasNext()) {
            Element classElement = (Element)i.next();
            Set<Class_> classes = null;
            String classExternalId = classElement.attributeValue("externalId");
            if (classExternalId != null && extId2class != null && (classes = extId2class.get(classExternalId)) == null) {
                classes = name2class.get(classExternalId);
            }
            if (classes == null && name2class != null) {
                String type = classElement.attributeValue("type");
                String suffix = classElement.attributeValue("suffix");
                if (type != null && suffix != null) {
                    classes = name2class.get(type.trim() + " " + suffix);
                }
            }
            if (classes == null && course != null) {
                this.warn(course.getCourseName() + ": Class " + (String)(classExternalId != null ? classExternalId : classElement.attributeValue("type") + " " + classElement.attributeValue("suffix")) + " not found.");
                continue;
            }
            if ("true".equalsIgnoreCase(classElement.attributeValue("required", "false"))) {
                requiredClasses.addAll(classes);
                continue;
            }
            preferredClasses.addAll(classes);
        }
        for (Class_ clazz : preferredClasses) {
            scp = new StudentClassPref();
            scp.setCourseRequest(cr);
            scp.setClazz(clazz);
            scp.setLabel(clazz.getClassPrefLabel(cr.getCourseOffering()));
            scp.setRequired(false);
            cr.getPreferences().add(scp);
        }
        for (Class_ clazz : requiredClasses) {
            scp = new StudentClassPref();
            scp.setCourseRequest(cr);
            scp.setClazz(clazz);
            scp.setLabel(clazz.getClassPrefLabel(cr.getCourseOffering()));
            scp.setRequired(true);
            cr.getPreferences().add(scp);
        }
        HashSet<InstructionalMethod> preferredIMs = new HashSet<InstructionalMethod>();
        HashSet<InstructionalMethod> requiredIMs = new HashSet<InstructionalMethod>();
        Iterator i2 = prefEl.elementIterator("instructional-method");
        while (i2.hasNext()) {
            String imName;
            Element imElement = (Element)i2.next();
            InstructionalMethod meth = null;
            String imExternalId = imElement.attributeValue("externalId", imElement.attributeValue("id"));
            if (imExternalId != null) {
                meth = ref2im.get(imExternalId);
            }
            if (meth == null && (imName = imElement.attributeValue("name")) != null) {
                meth = name2im.get(imName);
            }
            if (meth == null) {
                this.warn(course.getCourseName() + ": Instructional Method " + (imExternalId != null ? imExternalId : imElement.attributeValue("name")) + " not found.");
                continue;
            }
            if ("true".equalsIgnoreCase(imElement.attributeValue("required", "false"))) {
                requiredIMs.add(meth);
                continue;
            }
            preferredIMs.add(meth);
        }
        for (InstructionalMethod meth : preferredIMs) {
            imp = new StudentInstrMthPref();
            imp.setCourseRequest(cr);
            imp.setRequired(false);
            imp.setInstructionalMethod(meth);
            imp.setLabel(meth.getLabel());
            cr.getPreferences().add(imp);
        }
        for (InstructionalMethod meth : requiredIMs) {
            imp = new StudentInstrMthPref();
            imp.setCourseRequest(cr);
            imp.setRequired(true);
            imp.setInstructionalMethod(meth);
            imp.setLabel(meth.getLabel());
            cr.getPreferences().add(imp);
        }
    }

    protected void importPreferences(AdvisorCourseRequest cr, Element requestEl, CourseOffering course, Map<String, Set<Class_>> extId2class, Map<String, Set<Class_>> name2class, Map<String, InstructionalMethod> ref2im, Map<String, InstructionalMethod> name2im) {
        AdvisorInstrMthPref imp;
        AdvisorClassPref scp;
        Element prefEl = requestEl.element("preferences");
        if (cr.getPreferences() == null) {
            cr.setPreferences(new HashSet<AdvisorSectioningPref>());
        } else {
            Iterator<AdvisorSectioningPref> i = cr.getPreferences().iterator();
            while (i.hasNext()) {
                this.iHibSession.remove((Object)i.next());
                i.remove();
            }
        }
        if (prefEl == null) {
            return;
        }
        HashSet<Class_> preferredClasses = new HashSet<Class_>();
        HashSet<Class_> requiredClasses = new HashSet<Class_>();
        Iterator i = prefEl.elementIterator("class");
        while (i.hasNext()) {
            Element classElement = (Element)i.next();
            Set<Class_> classes = null;
            String classExternalId = classElement.attributeValue("externalId");
            if (classExternalId != null && extId2class != null && (classes = extId2class.get(classExternalId)) == null) {
                classes = name2class.get(classExternalId);
            }
            if (classes == null && name2class != null) {
                String type = classElement.attributeValue("type");
                String suffix = classElement.attributeValue("suffix");
                if (type != null && suffix != null) {
                    classes = name2class.get(type.trim() + " " + suffix);
                }
            }
            if (classes == null && course != null) {
                this.warn(course.getCourseName() + ": Class " + (String)(classExternalId != null ? classExternalId : classElement.attributeValue("type") + " " + classElement.attributeValue("suffix")) + " not found.");
                continue;
            }
            if ("true".equalsIgnoreCase(classElement.attributeValue("required", "false"))) {
                requiredClasses.addAll(classes);
                continue;
            }
            preferredClasses.addAll(classes);
        }
        for (Class_ clazz : preferredClasses) {
            scp = new AdvisorClassPref();
            scp.setCourseRequest(cr);
            scp.setClazz(clazz);
            scp.setLabel(clazz.getClassPrefLabel(cr.getCourseOffering()));
            scp.setRequired(false);
            cr.getPreferences().add(scp);
        }
        for (Class_ clazz : requiredClasses) {
            scp = new AdvisorClassPref();
            scp.setCourseRequest(cr);
            scp.setClazz(clazz);
            scp.setLabel(clazz.getClassPrefLabel(cr.getCourseOffering()));
            scp.setRequired(true);
            cr.getPreferences().add(scp);
        }
        HashSet<InstructionalMethod> preferredIMs = new HashSet<InstructionalMethod>();
        HashSet<InstructionalMethod> requiredIMs = new HashSet<InstructionalMethod>();
        Iterator i2 = prefEl.elementIterator("instructional-method");
        while (i2.hasNext()) {
            String imName;
            Element imElement = (Element)i2.next();
            InstructionalMethod meth = null;
            String imExternalId = imElement.attributeValue("externalId", imElement.attributeValue("id"));
            if (imExternalId != null) {
                meth = ref2im.get(imExternalId);
            }
            if (meth == null && (imName = imElement.attributeValue("name")) != null) {
                meth = name2im.get(imName);
            }
            if (meth == null) {
                this.warn(course.getCourseName() + ": Instructional Method " + (imExternalId != null ? imExternalId : imElement.attributeValue("name")) + " not found.");
                continue;
            }
            if ("true".equalsIgnoreCase(imElement.attributeValue("required", "false"))) {
                requiredIMs.add(meth);
                continue;
            }
            preferredIMs.add(meth);
        }
        for (InstructionalMethod meth : preferredIMs) {
            imp = new AdvisorInstrMthPref();
            imp.setCourseRequest(cr);
            imp.setRequired(false);
            imp.setInstructionalMethod(meth);
            imp.setLabel(meth.getLabel());
            cr.getPreferences().add(imp);
        }
        for (InstructionalMethod meth : requiredIMs) {
            imp = new AdvisorInstrMthPref();
            imp.setCourseRequest(cr);
            imp.setRequired(true);
            imp.setInstructionalMethod(meth);
            imp.setLabel(meth.getLabel());
            cr.getPreferences().add(imp);
        }
    }

    public static enum EnrollmentMode {
        DELETE("Student enrollments will be deleted."),
        IMPORT("Student enrollments will be imported."),
        NOCHANGE("Student enrollments will be left unchanged"),
        UPDATE("Student enrollments will be updated (only enrollments that are no longer requested will be deleted)");

        private String iText;

        private EnrollmentMode(String text) {
            this.iText = text;
        }

        public String toString() {
            return this.iText;
        }
    }
}

