/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;

@Service(value="/api/enrollments")
public class EnrollmentsConnector
extends ApiConnector {
    @Override
    public void doGet(ApiHelper helper) throws IOException {
        String configurationId;
        String offeringId;
        String courseId;
        String examId;
        String classId;
        String eventId = helper.getParameter("eventId");
        if (eventId != null) {
            if (Long.valueOf(eventId) < 0L) {
                Class_ clazz = (Class_)Class_DAO.getInstance().get(-Long.valueOf(eventId).longValue(), helper.getHibSession());
                if (clazz == null) {
                    throw new IllegalArgumentException("Class with the given ID does not exist.");
                }
                helper.getSessionContext().checkPermissionAnyAuthority((Object)clazz.getManagingDept().getSession(), Right.ApiRetrieveEnrollments, new Qualifiable[0]);
                helper.setResponse(this.convert(clazz.getStudentEnrollments()));
            } else {
                Event event = (Event)EventDAO.getInstance().get(Long.parseLong(eventId), helper.getHibSession());
                if (event == null) {
                    throw new IllegalArgumentException("Event with the given ID does not exist.");
                }
                helper.getSessionContext().checkPermissionAnyAuthority((Object)event.getSession(), Right.ApiRetrieveEnrollments, new Qualifiable[0]);
                helper.setResponse(this.convert(event.getStudentClassEnrollments()));
            }
        }
        if ((classId = helper.getParameter("classId")) != null) {
            Class_ clazz = (Class_)Class_DAO.getInstance().get(Long.parseLong(classId), helper.getHibSession());
            if (clazz == null) {
                throw new IllegalArgumentException("Class with the given ID does not exist.");
            }
            helper.getSessionContext().checkPermissionAnyAuthority((Object)clazz.getManagingDept().getSession(), Right.ApiRetrieveEnrollments, new Qualifiable[0]);
            helper.setResponse(this.convert(clazz.getStudentEnrollments()));
        }
        if ((examId = helper.getParameter("examId")) != null) {
            Exam exam = (Exam)ExamDAO.getInstance().get(Long.parseLong(examId), helper.getHibSession());
            if (exam == null) {
                throw new IllegalArgumentException("Examination with the given ID does not exist.");
            }
            helper.getSessionContext().checkPermissionAnyAuthority((Object)exam.getSession(), Right.ApiRetrieveEnrollments, new Qualifiable[0]);
            helper.setResponse(this.convert(exam.getStudentClassEnrollments()));
        }
        if ((courseId = helper.getParameter("courseId")) != null) {
            CourseOffering course = (CourseOffering)CourseOfferingDAO.getInstance().get(Long.parseLong(courseId), helper.getHibSession());
            if (course == null) {
                throw new IllegalArgumentException("Course with the given ID does not exist.");
            }
            helper.getSessionContext().checkPermissionAnyAuthority((Object)course.getInstructionalOffering().getSession(), Right.ApiRetrieveEnrollments, new Qualifiable[0]);
            helper.setResponse(this.convert(CourseOfferingDAO.getInstance().getSession().createQuery("from StudentClassEnrollment e where e.courseOffering.uniqueId = :courseId", StudentClassEnrollment.class).setParameter("courseId", (Object)course.getUniqueId()).list()));
        }
        if ((offeringId = helper.getParameter("offeringId")) != null) {
            InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(Long.parseLong(offeringId), helper.getHibSession());
            if (offering == null) {
                throw new IllegalArgumentException("Offering with the given ID does not exist.");
            }
            helper.getSessionContext().checkPermissionAnyAuthority((Object)offering.getSession(), Right.ApiRetrieveEnrollments, new Qualifiable[0]);
            helper.setResponse(this.convert(CourseOfferingDAO.getInstance().getSession().createQuery("from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId", StudentClassEnrollment.class).setParameter("offeringId", (Object)offering.getUniqueId()).list()));
        }
        if ((configurationId = helper.getParameter("configurationId")) != null) {
            InstrOfferingConfig config = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(Long.parseLong(configurationId), helper.getHibSession());
            if (config == null) {
                throw new IllegalArgumentException("Configuration with the given ID does not exist.");
            }
            helper.getSessionContext().checkPermissionAnyAuthority((Object)config.getInstructionalOffering().getSession(), Right.ApiRetrieveEnrollments, new Qualifiable[0]);
            helper.setResponse(this.convert(CourseOfferingDAO.getInstance().getSession().createQuery("from StudentClassEnrollment e where e.clazz.schedulingSubpart.instrOfferingConfig.uniqueId = :configId", StudentClassEnrollment.class).setParameter("configId", (Object)config.getUniqueId()).list()));
        }
    }

    protected List<ClassEnrollmentInfo> convert(Collection<StudentClassEnrollment> enrollments) {
        ArrayList<ClassEnrollmentInfo> converted = new ArrayList<ClassEnrollmentInfo>();
        if (enrollments != null) {
            for (StudentClassEnrollment enrollment : enrollments) {
                converted.add(new ClassEnrollmentInfo(enrollment));
            }
        }
        return converted;
    }

    @Override
    protected String getName() {
        return "enrollments";
    }

    static class ClassEnrollmentInfo {
        Long iStudentId;
        String iExternalId;
        String iFirstName;
        String iMiddleName;
        String iLastName;
        String iTitle;
        String iEmail;
        String iSectioningStatus;
        List<String> iArea;
        List<String> iClassification;
        List<String> iMajor;
        List<String> iMinor;
        List<String> iGroup;
        List<String> iAccomodation;
        List<CurriculumInfo> iCurriculum;
        Long iCourseId;
        String iSubjectArea;
        String iCourseNumber;
        String iCourseTitle;
        Long iClassId;
        String iSubpart;
        String iSectionNumber;
        String iClassSuffix;
        String iClassExternalId;
        Date iRequestDate;
        Date iEnrollmentDate;

        ClassEnrollmentInfo(StudentClassEnrollment enrollment) {
            this.iStudentId = enrollment.getStudent().getUniqueId();
            this.iExternalId = enrollment.getStudent().getExternalUniqueId();
            this.iFirstName = enrollment.getStudent().getFirstName();
            this.iMiddleName = enrollment.getStudent().getMiddleName();
            this.iLastName = enrollment.getStudent().getLastName();
            this.iTitle = enrollment.getStudent().getAcademicTitle();
            this.iEmail = enrollment.getStudent().getEmail();
            if (enrollment.getStudent().getSectioningStatus() != null) {
                this.iSectioningStatus = enrollment.getStudent().getSectioningStatus().getReference();
            }
            for (StudentAreaClassificationMajor aac : enrollment.getStudent().getAreaClasfMajors()) {
                if (this.iArea == null) {
                    this.iArea = new ArrayList<String>();
                    this.iClassification = new ArrayList<String>();
                }
                if (this.iMajor == null) {
                    this.iMajor = new ArrayList<String>();
                }
                this.iArea.add(aac.getAcademicArea().getAcademicAreaAbbreviation());
                this.iClassification.add(aac.getAcademicClassification().getCode());
                this.iMajor.add(aac.getMajor().getCode());
                if (this.iCurriculum == null) {
                    this.iCurriculum = new ArrayList<CurriculumInfo>();
                }
                this.iCurriculum.add(new CurriculumInfo(aac));
            }
            for (StudentAreaClassificationMinor minor : enrollment.getStudent().getAreaClasfMinors()) {
                if (this.iMinor == null) {
                    this.iMinor = new ArrayList<String>();
                }
                this.iMinor.add(minor.getMinor().getCode());
                if (this.iCurriculum == null) {
                    this.iCurriculum = new ArrayList<CurriculumInfo>();
                }
                this.iCurriculum.add(new CurriculumInfo(minor));
            }
            for (StudentGroup group : enrollment.getStudent().getGroups()) {
                if (this.iGroup == null) {
                    this.iGroup = new ArrayList<String>();
                }
                this.iGroup.add(group.getGroupAbbreviation());
            }
            for (StudentAccomodation accomodation : enrollment.getStudent().getAccomodations()) {
                if (this.iAccomodation == null) {
                    this.iAccomodation = new ArrayList<String>();
                }
                this.iAccomodation.add(accomodation.getAbbreviation());
            }
            this.iCourseId = enrollment.getCourseOffering().getUniqueId();
            this.iSubjectArea = enrollment.getCourseOffering().getSubjectAreaAbbv();
            this.iCourseNumber = enrollment.getCourseOffering().getCourseNbr();
            this.iCourseTitle = enrollment.getCourseOffering().getTitle();
            this.iClassId = enrollment.getClazz().getUniqueId();
            this.iSectionNumber = enrollment.getClazz().getSectionNumberString();
            this.iSubpart = enrollment.getClazz().getSchedulingSubpart().getItypeDesc().trim();
            this.iClassSuffix = enrollment.getClazz().getClassSuffix(enrollment.getCourseOffering());
            this.iClassExternalId = enrollment.getClazz().getExternalId(enrollment.getCourseOffering());
            this.iEnrollmentDate = enrollment.getTimestamp();
            if (enrollment.getCourseRequest() != null && enrollment.getCourseRequest().getCourseDemand() != null) {
                this.iRequestDate = enrollment.getCourseRequest().getCourseDemand().getTimestamp();
            }
        }
    }

    static class CurriculumInfo {
        String iArea;
        String iClassification;
        String iMajor;
        String iMinor;

        CurriculumInfo(StudentAreaClassificationMajor acm) {
            this.iArea = acm.getAcademicArea().getAcademicAreaAbbreviation();
            this.iClassification = acm.getAcademicClassification().getCode();
            this.iMajor = acm.getMajor().getCode();
        }

        CurriculumInfo(StudentAreaClassificationMinor acm) {
            this.iArea = acm.getAcademicArea().getAcademicAreaAbbreviation();
            this.iClassification = acm.getAcademicClassification().getCode();
            this.iMinor = acm.getMinor().getCode();
        }
    }
}

