/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.selection;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.online.OnlineSectioningModel;
import org.cpsolver.studentsct.online.selection.MultiCriteriaBranchAndBoundSelection;

public class BestPenaltyCriterion
implements MultiCriteriaBranchAndBoundSelection.SelectionCriterion {
    private Student iStudent;
    private OnlineSectioningModel iModel;

    public BestPenaltyCriterion(Student student, OnlineSectioningModel model) {
        this.iStudent = student;
        this.iModel = model;
    }

    private Request getRequest(int index) {
        return index < 0 || index >= this.iStudent.getRequests().size() ? null : this.iStudent.getRequests().get(index);
    }

    private boolean isFreeTime(int index) {
        Request r = this.getRequest(index);
        return r != null && r instanceof FreeTimeRequest;
    }

    @Override
    public int compare(Assignment<Request, Enrollment> assignment, Enrollment[] current, Enrollment[] best) {
        if (best == null) {
            return -1;
        }
        for (int idx = 0; idx < current.length; ++idx) {
            if (this.isFreeTime(idx)) continue;
            if (best[idx] != null && best[idx].getAssignments() != null) {
                if (current[idx] == null || current[idx].getSections() == null) {
                    return 1;
                }
                if (best[idx].getTruePriority() < current[idx].getTruePriority()) {
                    return 1;
                }
                if (best[idx].getTruePriority() <= current[idx].getTruePriority()) continue;
                return -1;
            }
            if (current[idx] == null || current[idx].getAssignments() == null) continue;
            return -1;
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] == null || best[idx].getAssignments() == null || !best[idx].isCourseRequest()) continue;
            for (Section section : best[idx].getSections()) {
                bestPenalties += this.iModel.getOverExpected(assignment, best, idx, section, best[idx].getRequest());
            }
            for (Section section : current[idx].getSections()) {
                currentPenalties += this.iModel.getOverExpected(assignment, current, idx, section, current[idx].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return -1;
        }
        if (bestPenalties < currentPenalties) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canImprove(Assignment<Request, Enrollment> assignment, int maxIdx, Enrollment[] current, Enrollment[] best) {
        int alt = 0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (this.isFreeTime(idx)) continue;
            Request request = this.getRequest(idx);
            if (idx < maxIdx) {
                if (best[idx] != null) {
                    if (current[idx] == null) {
                        return false;
                    }
                    if (best[idx].getTruePriority() < current[idx].getTruePriority()) {
                        return false;
                    }
                    if (best[idx].getTruePriority() > current[idx].getTruePriority()) {
                        return true;
                    }
                    if (!request.isAlternative()) continue;
                    --alt;
                    continue;
                }
                if (current[idx] != null) {
                    return true;
                }
                if (request.isAlternative()) continue;
                ++alt;
                continue;
            }
            if (!(best[idx] != null ? best[idx].getTruePriority() > 0 : !request.isAlternative() || alt > 0)) continue;
            return true;
        }
        double bestPenalties = 0.0;
        double currentPenalties = 0.0;
        for (int idx = 0; idx < current.length; ++idx) {
            if (best[idx] != null) {
                for (Section section : best[idx].getSections()) {
                    bestPenalties += this.iModel.getOverExpected(assignment, best, idx, section, best[idx].getRequest());
                }
            }
            if (current[idx] == null || idx >= maxIdx) continue;
            for (Section section : current[idx].getSections()) {
                currentPenalties += this.iModel.getOverExpected(assignment, current, idx, section, current[idx].getRequest());
            }
        }
        if (currentPenalties < bestPenalties) {
            return true;
        }
        if (bestPenalties < currentPenalties) {
            return false;
        }
        return false;
    }

    @Override
    public double getTotalWeight(Assignment<Request, Enrollment> assignment, Enrollment[] enrollments) {
        return 0.0;
    }

    @Override
    public int compare(Assignment<Request, Enrollment> assignment, Enrollment e1, Enrollment e2) {
        if (e1.getTruePriority() < e2.getTruePriority()) {
            return -1;
        }
        if (e1.getTruePriority() > e2.getTruePriority()) {
            return 1;
        }
        double p1 = 0.0;
        double p2 = 0.0;
        for (Section section : e1.getSections()) {
            p1 += this.iModel.getOverExpected(assignment, section, e1.getRequest());
        }
        for (Section section : e2.getSections()) {
            p2 += this.iModel.getOverExpected(assignment, section, e2.getRequest());
        }
        if (p1 < p2) {
            return -1;
        }
        if (p2 < p1) {
            return 1;
        }
        return 0;
    }
}

