/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.dao.StudentDAO;

public class CriticalCoursesReport
extends AbstractStudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public CriticalCoursesReport(StudentSectioningModel model) {
        super(model);
    }

    protected String curriculum(Student student) {
        Object curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = (String)curriculum + (((String)curriculum).isEmpty() ? "" : ", ") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        Object group = "";
        TreeSet<String> groups = new TreeSet<String>();
        for (StudentGroup studentGroup : student.getGroups()) {
            groups.add(studentGroup.getReference());
        }
        for (String string : groups) {
            group = (String)group + (((String)group).isEmpty() ? "" : ", ") + string;
        }
        return group;
    }

    protected String advisor(Student student) {
        Object advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = (String)advisors + (((String)advisors).isEmpty() ? "" : ", ") + instructor.getName();
        }
        return advisors;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportPriority()), new CSVFile.CSVField((Object)MSG.reportCourseRequestPriority()), new CSVFile.CSVField((Object)MSG.reportCourse()), new CSVFile.CSVField((Object)MSG.report1stAlt()), new CSVFile.CSVField((Object)MSG.report2ndAlt()), new CSVFile.CSVField((Object)MSG.reportEnrolledCourse()), new CSVFile.CSVField((Object)MSG.reportEnrolledChoice())});
        for (Student student : this.getModel().getStudents()) {
            if (student.isDummy()) continue;
            int priority = 0;
            for (Request r : student.getRequests()) {
                Enrollment e;
                if (!(r instanceof CourseRequest)) continue;
                CourseRequest cr = (CourseRequest)r;
                ++priority;
                if (!cr.isCritical() || cr.isAlternative() || !this.matches((Request)cr, e = (Enrollment)cr.getAssignment(assignment))) continue;
                Course course = (Course)cr.getCourses().get(0);
                Course alt1 = cr.getCourses().size() < 2 ? null : (Course)cr.getCourses().get(1);
                Course alt2 = cr.getCourses().size() < 3 ? null : (Course)cr.getCourses().get(2);
                Course enrolled = e == null ? null : e.getCourse();
                org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(student.getId()), new CSVFile.CSVField((Object)student.getExternalId()), new CSVFile.CSVField((Object)student.getName()), new CSVFile.CSVField((Object)(dbStudent == null ? null : dbStudent.getEmail())), new CSVFile.CSVField((Object)(student.getPriority() == null ? "" : student.getPriority().name())), new CSVFile.CSVField((Object)this.curriculum(student)), new CSVFile.CSVField((Object)this.group(student)), new CSVFile.CSVField((Object)this.advisor(student)), new CSVFile.CSVField(priority), new CSVFile.CSVField((Object)(cr.getRequestPriority() == null ? "" : cr.getRequestPriority().name())), new CSVFile.CSVField((Object)course.getName()), new CSVFile.CSVField((Object)(alt1 == null ? "" : alt1.getName())), new CSVFile.CSVField((Object)(alt2 == null ? "" : alt2.getName())), new CSVFile.CSVField((Object)(enrolled == null ? "" : enrolled.getName())), new CSVFile.CSVField((Object)(enrolled == null ? "" : String.valueOf(cr.getCourses().indexOf(enrolled) + 1)))});
            }
        }
        return csv;
    }
}

