/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.updates;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.hibernate.CacheMode;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.ClassWaitList;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.StudentEnrollmentMessage;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.WaitList;
import org.unitime.timetable.model.base.BaseCourseDemand;
import org.unitime.timetable.model.base.BaseCourseRequest;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.onlinesectioning.HasCacheMode;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetAssignment;
import org.unitime.timetable.onlinesectioning.custom.CriticalCoursesProvider;
import org.unitime.timetable.onlinesectioning.custom.CustomCriticalCoursesHolder;
import org.unitime.timetable.onlinesectioning.custom.CustomStudentEnrollmentHolder;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.onlinesectioning.custom.StudentEnrollmentProvider;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.CheckAssignmentAction;
import org.unitime.timetable.onlinesectioning.solver.FindAssignmentAction;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.specreg.WaitListCheckValidation;
import org.unitime.timetable.onlinesectioning.specreg.WaitListSubmitOverrides;
import org.unitime.timetable.onlinesectioning.updates.CheckOfferingAction;
import org.unitime.timetable.onlinesectioning.updates.NotifyStudentAction;

public class EnrollStudent
implements OnlineSectioningAction<ClassAssignmentInterface>,
HasCacheMode {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private Long iStudentId;
    private CourseRequestInterface iRequest;
    private List<ClassAssignmentInterface.ClassAssignment> iAssignment;
    private boolean iCheckWaitLists = false;

    public EnrollStudent forStudent(Long studentId) {
        this.iStudentId = studentId;
        return this;
    }

    public EnrollStudent withRequest(CourseRequestInterface request) {
        this.iRequest = request;
        return this;
    }

    public EnrollStudent withAssignment(List<ClassAssignmentInterface.ClassAssignment> assignment) {
        this.iAssignment = assignment;
        return this;
    }

    public EnrollStudent withWaitListCheck(boolean checkWaitLists) {
        this.iCheckWaitLists = checkWaitLists;
        return this;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public CourseRequestInterface getRequest() {
        return this.iRequest;
    }

    public List<ClassAssignmentInterface.ClassAssignment> getAssignment() {
        return this.iAssignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    @Override
    public ClassAssignmentInterface execute(OnlineSectioningServer server, final OnlineSectioningHelper helper) {
        ClassAssignmentInterface ret;
        if (!server.getAcademicSession().isSectioningEnabled()) {
            throw new SectioningException(MSG.exceptionNotSupportedFeature());
        }
        HashSet<Long> offeringIds = new HashSet<Long>();
        HashSet<Long> lockedCourses = new HashSet<Long>();
        List<StudentEnrollmentProvider.EnrollmentFailure> failures = null;
        boolean includeRequestInTheReturnMessage = false;
        boolean rescheduling = server.getConfig().getPropertyBoolean("Enrollment.ReSchedulingEnabled", false) && server.getConfig().getPropertyBoolean("Enrollment.WaitListLockedCourse", true);
        this.getRequest().removeDuplicates();
        for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
            if (ca == null || ca.isFreeTime() || ca.isDummy() || ca.isTeachingAssignment()) continue;
            XCourse course = server.getCourse(ca.getCourseId());
            if (course == null) {
                throw new SectioningException(MSG.exceptionEnrollNotAvailable(MSG.clazz(ca.getSubject(), ca.getCourseNbr(), ca.getSubpart(), ca.getSection())));
            }
            if (server.isOfferingLocked(course.getOfferingId())) {
                XOffering offering;
                lockedCourses.add(course.getCourseId());
                if (!rescheduling || (offering = server.getOffering(course.getOfferingId())) == null || !offering.isWaitList()) continue;
                for (CourseRequestInterface.Request r : this.getRequest().getCourses()) {
                    if (r.isWaitList() || !r.hasRequestedCourse()) continue;
                    for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                        if (rc.hasCourseId()) {
                            if (!rc.getCourseId().equals(course.getCourseId())) continue;
                            r.setWaitList(true);
                            continue;
                        }
                        if (!rc.hasCourseName() || !course.matchCourse(rc.getCourseName())) continue;
                        r.setWaitList(true);
                    }
                }
                continue;
            }
            offeringIds.add(course.getOfferingId());
        }
        OnlineSectioningServer.ServerCallback<Boolean> offeringChecked = new OnlineSectioningServer.ServerCallback<Boolean>(){

            @Override
            public void onFailure(Throwable exception) {
                helper.error("Offering check failed: " + exception.getMessage(), exception);
            }

            @Override
            public void onSuccess(Boolean result) {
            }
        };
        CriticalCoursesProvider.CriticalCourses cc = null;
        boolean checkCritical = ApplicationProperty.EnrollmentCheckCritical.isTrue();
        try {
            if (CustomCriticalCoursesHolder.hasProvider() && checkCritical) {
                cc = CustomCriticalCoursesHolder.getProvider().getCriticalCourses(server, helper, server.getStudent(this.getStudentId()));
            }
        }
        catch (Exception e) {
            helper.warn("Failed to lookup critical courses: " + e.getMessage(), e);
        }
        OnlineSectioningInterface.WaitListMode wlMode = OnlineSectioningInterface.WaitListMode.None;
        boolean hasWaitList = false;
        boolean enrollmentChanged = false;
        TreeSet<ClassAssignmentInterface.ErrorMessage> checkErrors = this.getRequest().areTimeConflictsAllowed() || this.getRequest().areSpaceConflictsAllowed() || this.getRequest().areLinkedConflictsAllowed() ? new TreeSet<ClassAssignmentInterface.ErrorMessage>() : null;
        OnlineSectioningServer.Lock lock = server.lockStudent(this.getStudentId(), offeringIds, this.name());
        OnlineSectioningInterface.GradeModes gradeModes = new OnlineSectioningInterface.GradeModes();
        try {
            helper.beginTransaction();
            try {
                Iterator<Object> i;
                Object cd;
                FreeTime free;
                CourseDemand adept;
                Iterator i2;
                CourseDemand cd2;
                ArrayList<XCourseId> courses;
                OnlineSectioningLog.Action.Builder action = helper.getAction();
                if (this.getRequest().getStudentId() != null) {
                    action.setStudent(OnlineSectioningLog.Entity.newBuilder().setUniqueId(this.getStudentId()));
                }
                OnlineSectioningLog.Enrollment.Builder requested = OnlineSectioningLog.Enrollment.newBuilder();
                requested.setType(OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED);
                Hashtable<Long, OnlineSectioningLog.CourseRequestOption.Builder> options = new Hashtable<Long, OnlineSectioningLog.CourseRequestOption.Builder>();
                for (ClassAssignmentInterface.ClassAssignment assignment : this.getAssignment()) {
                    if (assignment == null) continue;
                    OnlineSectioningLog.Section s = OnlineSectioningHelper.toProto(assignment);
                    requested.addSection(s);
                    if (assignment.isFreeTime() || assignment.isDummy() || assignment.isTeachingAssignment()) continue;
                    OnlineSectioningLog.CourseRequestOption.Builder option = (OnlineSectioningLog.CourseRequestOption.Builder)options.get(assignment.getCourseId());
                    if (option == null) {
                        option = OnlineSectioningLog.CourseRequestOption.newBuilder().setType(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT);
                        options.put(assignment.getCourseId(), option);
                    }
                    option.addSection(s);
                }
                action.addEnrollment(requested);
                for (OnlineSectioningLog.Request r : OnlineSectioningHelper.toProto(this.getRequest())) {
                    action.addRequest(r);
                }
                List<StudentEnrollmentProvider.EnrollmentRequest> enrlCheck = server.createAction(CheckAssignmentAction.class).forStudent(this.getStudentId()).withAssignment(this.getAssignment()).check(server, helper, checkErrors);
                Student student = (Student)helper.getHibSession().createQuery("select s from Student s left join fetch s.courseDemands as cd left join fetch cd.courseRequests as cr left join fetch cd.freeTime as ft left join fetch cr.courseOffering as co left join fetch cr.courseRequestOptions as cro left join fetch cr.classWaitLists as cwl left join fetch s.classEnrollments as e left join fetch e.clazz as c left join fetch c.managingDept as cmd left join fetch c.schedulingSubpart as ss where s.uniqueId = :studentId", Student.class).setParameter("studentId", (Object)this.getStudentId()).uniqueResult();
                if (student == null) {
                    throw new SectioningException(MSG.exceptionBadStudentId());
                }
                wlMode = student.getWaitListMode();
                XStudent oldStudent = server.getStudent(this.getStudentId());
                action.getStudentBuilder().setUniqueId(student.getUniqueId()).setExternalId(oldStudent.getExternalId()).setName(oldStudent.getName());
                boolean hasWaitListedCourses = false;
                if (wlMode == OnlineSectioningInterface.WaitListMode.WaitList) {
                    block12: for (Serializable r : this.getRequest().getCourses()) {
                        if (((CourseRequestInterface.Request)r).isWaitList()) {
                            hasWaitListedCourses = true;
                            break;
                        }
                        if (!((CourseRequestInterface.Request)r).hasRequestedCourse()) continue;
                        for (CourseRequestInterface.RequestedCourse rc : ((CourseRequestInterface.Request)r).getRequestedCourse()) {
                            if (!rc.isCanWaitList()) continue;
                            hasWaitListedCourses = true;
                            break block12;
                        }
                    }
                    if (!hasWaitListedCourses) {
                        for (Serializable r : oldStudent.getRequests()) {
                            if (((XRequest)r).isAlternative() || !(r instanceof XCourseRequest) || !((XCourseRequest)r).isWaitlist()) continue;
                            hasWaitListedCourses = true;
                            break;
                        }
                    }
                    if (student.getOverrideExternalId() != null && student.getMaxCreditOverrideIntent() == CourseRequest.CourseRequestOverrideIntent.WAITLIST && student.getMaxCreditOverrideStatus() == CourseRequest.CourseRequestOverrideStatus.PENDING) {
                        hasWaitList = true;
                    }
                }
                if (CustomStudentEnrollmentHolder.hasProvider()) {
                    failures = CustomStudentEnrollmentHolder.getProvider().enroll(server, helper, oldStudent, enrlCheck, lockedCourses, gradeModes, hasWaitListedCourses);
                    Iterator<Serializable> i3 = this.getAssignment().iterator();
                    block15: while (i3.hasNext()) {
                        ClassAssignmentInterface.ClassAssignment ca = i3.next();
                        if (ca == null || ca.isFreeTime() || ca.getClassId() == null || ca.isDummy() || ca.isTeachingAssignment()) continue;
                        for (StudentEnrollmentProvider.EnrollmentFailure f : failures) {
                            if (f.isEnrolled() || !f.getSection().getSectionId().equals(ca.getClassId())) continue;
                            i3.remove();
                            continue block15;
                        }
                    }
                    block17: for (Object f : failures) {
                        if (!((StudentEnrollmentProvider.EnrollmentFailure)f).isEnrolled()) continue;
                        for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
                            if (ca == null || !((StudentEnrollmentProvider.EnrollmentFailure)f).getSection().getSectionId().equals(ca.getClassId())) continue;
                            continue block17;
                        }
                        Object ca = new ClassAssignmentInterface.ClassAssignment();
                        ((ClassAssignmentInterface.ClassAssignment)ca).setClassId(((StudentEnrollmentProvider.EnrollmentFailure)f).getSection().getSectionId());
                        ((ClassAssignmentInterface.ClassAssignment)ca).setCourseId(((StudentEnrollmentProvider.EnrollmentFailure)f).getCourse().getCourseId());
                        this.getAssignment().add((ClassAssignmentInterface.ClassAssignment)ca);
                    }
                }
                HashSet<Long> assignedCourses = new HashSet<Long>();
                for (Object ca : this.getAssignment()) {
                    if (ca == null || ((ClassAssignmentInterface.ClassAssignment)ca).isFreeTime() || ((ClassAssignmentInterface.ClassAssignment)ca).isDummy() || ((ClassAssignmentInterface.ClassAssignment)ca).isTeachingAssignment() || ((ClassAssignmentInterface.ClassAssignment)ca).getClassId() == null) continue;
                    assignedCourses.add(((ClassAssignmentInterface.ClassAssignment)ca).getCourseId());
                }
                int sub = 0;
                for (CourseRequestInterface.Request request : this.getRequest().getCourses()) {
                    if (!request.hasCourseId() || request.isWaitList() || request.isAssigned(assignedCourses)) continue;
                    ++sub;
                }
                for (CourseRequestInterface.Request request : this.getRequest().getAlternatives()) {
                    if (!request.hasCourseId() || !request.isAssigned(assignedCourses)) continue;
                    --sub;
                }
                Iterator<CourseRequestInterface.Request> i4 = this.getRequest().getAlternatives().iterator();
                while (i4.hasNext() && sub < 0) {
                    CourseRequestInterface.Request request;
                    request = i4.next();
                    this.getRequest().getCourses().add(request);
                    i4.remove();
                    includeRequestInTheReturnMessage = true;
                    ++sub;
                }
                HashMap<FindAssignmentAction.IdPair, StudentClassEnrollment> oldEnrollments = new HashMap<FindAssignmentAction.IdPair, StudentClassEnrollment>();
                HashMap<Long, Object[]> oldApprovals = new HashMap<Long, Object[]>();
                for (StudentClassEnrollment e : student.getClassEnrollments()) {
                    oldEnrollments.put(new FindAssignmentAction.IdPair(e.getCourseOffering().getUniqueId(), e.getClazz().getUniqueId()), e);
                    if (e.getApprovedBy() == null || oldApprovals.containsKey(e.getCourseOffering().getUniqueId())) continue;
                    oldApprovals.put(e.getCourseOffering().getUniqueId(), new Object[]{e.getApprovedBy(), e.getApprovedDate()});
                }
                HashMap<Long, Class_> classes = new HashMap<Long, Class_>();
                Object classIds = null;
                for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
                    if (ca == null || ca.isFreeTime() || ca.getClassId() == null || ca.isDummy() || ca.isTeachingAssignment() || oldEnrollments.containsKey(new FindAssignmentAction.IdPair(ca.getCourseId(), ca.getClassId()))) continue;
                    if (classIds == null) {
                        classIds = ca.getClassId().toString();
                        continue;
                    }
                    classIds = (String)classIds + "," + ca.getClassId();
                }
                if (classIds != null) {
                    for (Class_ clazz : helper.getHibSession().createQuery("select c from Class_ c left join fetch c.studentEnrollments as e left join fetch c.schedulingSubpart as s where c.uniqueId in (" + classIds + ")", Class_.class).list()) {
                        classes.put(clazz.getUniqueId(), clazz);
                    }
                }
                HashMap<Long, Long> courseDemandId2courseId = new HashMap<Long, Long>();
                TreeSet<CourseDemand> remaining = new TreeSet<CourseDemand>(student.getCourseDemands());
                int priority = 0;
                Date ts = new Date();
                HashMap<Long, Object> course2request = new HashMap<Long, Object>();
                HashMap<Long, Object> alt2demand = new HashMap<Long, Object>();
                for (CourseRequestInterface.Request r : this.getRequest().getCourses()) {
                    CourseOffering alt;
                    Object cr;
                    courses = new ArrayList<XCourseId>();
                    if (r.hasRequestedCourse()) {
                        for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                            if (rc.isFreeTime()) {
                                for (Object ft : rc.getFreeTime()) {
                                    cd2 = null;
                                    i2 = remaining.iterator();
                                    while (i2.hasNext()) {
                                        adept = (CourseDemand)i2.next();
                                        if (adept.getFreeTime() == null) continue;
                                        cd2 = adept;
                                        i2.remove();
                                        break;
                                    }
                                    if (cd2 == null) {
                                        cd2 = new CourseDemand();
                                        cd2.setTimestamp(ts);
                                        cd2.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                                        student.getCourseDemands().add(cd2);
                                        cd2.setStudent(student);
                                    }
                                    cd2.setAlternative(false);
                                    cd2.setPriority(priority);
                                    cd2.setWaitlist(false);
                                    cd2.setNoSub(false);
                                    cd2.setCritical(0);
                                    free = cd2.getFreeTime();
                                    if (free == null) {
                                        free = new FreeTime();
                                        cd2.setFreeTime(free);
                                    }
                                    free.setCategory(0);
                                    free.setDayCode(DayCode.toInt(DayCode.toDayCodes(((CourseRequestInterface.FreeTime)ft).getDays())));
                                    free.setStartSlot(((CourseRequestInterface.FreeTime)ft).getStart());
                                    free.setLength(((CourseRequestInterface.FreeTime)ft).getLength());
                                    free.setSession(student.getSession());
                                    free.setName(((CourseRequestInterface.FreeTime)ft).toString());
                                    if (free.getUniqueId() == null) {
                                        helper.getHibSession().persist((Object)free);
                                    } else {
                                        helper.getHibSession().merge((Object)free);
                                    }
                                    if (cd2.getUniqueId() == null) {
                                        helper.getHibSession().persist((Object)cd2);
                                        continue;
                                    }
                                    helper.getHibSession().merge((Object)cd2);
                                }
                                ++priority;
                                continue;
                            }
                            XCourseId c = server.getCourse(rc.getCourseId(), rc.getCourseName());
                            if (c == null) continue;
                            courses.add(c);
                        }
                    }
                    if (courses.isEmpty()) continue;
                    cd = null;
                    i = remaining.iterator();
                    block30: while (i.hasNext()) {
                        Object ft;
                        CourseDemand adept2 = (CourseDemand)i.next();
                        if (adept2.getFreeTime() != null) continue;
                        ft = adept2.getCourseRequests().iterator();
                        while (ft.hasNext()) {
                            cr = (org.unitime.timetable.model.CourseRequest)ft.next();
                            if (!((BaseCourseRequest)cr).getCourseOffering().getUniqueId().equals(((XCourseId)courses.get(0)).getCourseId())) continue;
                            cd = adept2;
                            i.remove();
                            break block30;
                        }
                    }
                    if (cd == null) {
                        cd = new CourseDemand();
                        ((BaseCourseDemand)cd).setTimestamp(ts);
                        ((BaseCourseDemand)cd).setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                        ((BaseCourseDemand)cd).setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                        ((BaseCourseDemand)cd).setStudent(student);
                        ((BaseCourseDemand)cd).setEnrollmentMessages(new HashSet<StudentEnrollmentMessage>());
                        student.getCourseDemands().add((CourseDemand)cd);
                    } else {
                        i = ((BaseCourseDemand)cd).getEnrollmentMessages().iterator();
                        while (i.hasNext()) {
                            StudentEnrollmentMessage message = (StudentEnrollmentMessage)i.next();
                            helper.getHibSession().remove((Object)message);
                            i.remove();
                        }
                    }
                    ((BaseCourseDemand)cd).setAlternative(false);
                    ((BaseCourseDemand)cd).setPriority(priority);
                    Boolean oldWaitList = ((BaseCourseDemand)cd).isWaitlist();
                    if (Boolean.TRUE.equals(((BaseCourseDemand)cd).isWaitlist()) || r.isWaitList()) {
                        hasWaitList = true;
                    }
                    if (r.isWaitList() && !Boolean.TRUE.equals(((BaseCourseDemand)cd).getWaitlist())) {
                        ((BaseCourseDemand)cd).setWaitlistedTimeStamp(ts);
                    }
                    if (r.isWaitList()) {
                        ((BaseCourseDemand)cd).setWaitListSwapWithCourseOffering(r.getWaitListSwapWithCourseOfferingId() == null ? null : (CourseOffering)CourseOfferingDAO.getInstance().get(r.getWaitListSwapWithCourseOfferingId(), helper.getHibSession()));
                    } else {
                        ((BaseCourseDemand)cd).setWaitListSwapWithCourseOffering(null);
                    }
                    ((BaseCourseDemand)cd).setWaitlist(r.isWaitList());
                    ((BaseCourseDemand)cd).setNoSub(r.isNoSub());
                    if (checkCritical) {
                        ((BaseCourseDemand)cd).setCritical(EnrollStudent.isCritical(courses, cc));
                    }
                    Iterator<org.unitime.timetable.model.CourseRequest> requests = new TreeSet<org.unitime.timetable.model.CourseRequest>(((BaseCourseDemand)cd).getCourseRequests()).iterator();
                    int order = 0;
                    for (XCourseId co : courses) {
                        org.unitime.timetable.model.CourseRequest cr2 = null;
                        if (requests.hasNext()) {
                            cr2 = requests.next();
                            if (cr2.getClassWaitLists() != null) {
                                Iterator<ClassWaitList> i5 = cr2.getClassWaitLists().iterator();
                                while (i5.hasNext()) {
                                    helper.getHibSession().remove((Object)i5.next());
                                    i5.remove();
                                }
                            }
                        } else {
                            cr2 = new org.unitime.timetable.model.CourseRequest();
                            ((BaseCourseDemand)cd).getCourseRequests().add(cr2);
                            cr2.setCourseDemand((CourseDemand)cd);
                            cr2.setCourseRequestOptions(new HashSet<CourseRequestOption>());
                        }
                        cr2.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT, (OnlineSectioningLog.CourseRequestOption.Builder)options.get(co.getCourseId()));
                        cr2.setAllowOverlap(false);
                        cr2.setCredit(0);
                        cr2.setOrder(order++);
                        if (cr2.getCourseOffering() == null || !cr2.getCourseOffering().getUniqueId().equals(co.getCourseId())) {
                            cr2.setCourseOffering((CourseOffering)CourseOfferingDAO.getInstance().get(co.getCourseId(), helper.getHibSession()));
                            if (r.isWaitList() && Customization.WaitListValidationProvider.hasProvider()) {
                                cr2.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.NOT_CHECKED);
                                cr2.setCourseRequestOverrideIntent(CourseRequest.CourseRequestOverrideIntent.WAITLIST);
                                cr2.setOverrideExternalId("TBD");
                                cr2.setOverrideTimeStamp(ts);
                            }
                        }
                        if (Boolean.TRUE.equals(((BaseCourseDemand)cd).getWaitlist()) && !Boolean.TRUE.equals(oldWaitList) && Customization.WaitListValidationProvider.hasProvider()) {
                            cr2.setCourseRequestOverrideStatus(CourseRequest.CourseRequestOverrideStatus.NOT_CHECKED);
                            cr2.setCourseRequestOverrideIntent(CourseRequest.CourseRequestOverrideIntent.WAITLIST);
                            cr2.setOverrideExternalId("TBD");
                            cr2.setOverrideTimeStamp(ts);
                        }
                        if (!Boolean.TRUE.equals(((BaseCourseDemand)cd).getWaitlist()) && cr2.getCourseRequestOverrideIntent() == CourseRequest.CourseRequestOverrideIntent.WAITLIST) {
                            cr2.setOverrideStatus(null);
                            cr2.setOverrideExternalId(null);
                            cr2.setOverrideTimeStamp(null);
                            cr2.setOverrideIntent(null);
                        }
                        cr2.updatePreferences(r.getRequestedCourse(co.getCourseId()), helper.getHibSession());
                        if (failures == null) continue;
                        Object message = null;
                        for (StudentEnrollmentProvider.EnrollmentFailure f : failures) {
                            if (!co.getCourseId().equals(f.getCourse().getCourseId())) continue;
                            if (message == null) {
                                message = f.getMessage();
                                continue;
                            }
                            if (((String)message).contains(f.getMessage())) continue;
                            message = (String)message + "\n" + f.getMessage();
                        }
                        if (message == null || ((String)message).isEmpty()) continue;
                        StudentEnrollmentMessage m = new StudentEnrollmentMessage();
                        m.setCourseDemand((CourseDemand)cd);
                        m.setLevel(0);
                        m.setType(0);
                        m.setTimestamp(ts);
                        m.setMessage((String)(((String)message).length() > 255 ? ((String)message).substring(0, 252) + "..." : message));
                        m.setOrder(0);
                        ((BaseCourseDemand)cd).getEnrollmentMessages().add(m);
                    }
                    while (requests.hasNext()) {
                        cr = requests.next();
                        ((BaseCourseDemand)cd).getCourseRequests().remove(cr);
                        helper.getHibSession().remove(cr);
                    }
                    if (((BaseCourseDemand)cd).getUniqueId() == null) {
                        helper.getHibSession().persist(cd);
                    } else {
                        helper.getHibSession().merge(cd);
                    }
                    for (org.unitime.timetable.model.CourseRequest cr3 : ((BaseCourseDemand)cd).getCourseRequests()) {
                        course2request.put(cr3.getCourseOffering().getUniqueId(), cr3);
                    }
                    if (helper.isAlternativeCourseEnabled() && ((BaseCourseDemand)cd).getCourseRequests().size() == 1 && (alt = ((BaseCourseDemand)cd).getCourseRequests().iterator().next().getCourseOffering().getAlternativeOffering()) != null) {
                        alt2demand.put(alt.getUniqueId(), cd);
                    }
                    ++priority;
                }
                for (CourseRequestInterface.Request r : this.getRequest().getAlternatives()) {
                    Iterator ft2;
                    courses = new ArrayList();
                    if (r.hasRequestedCourse()) {
                        for (CourseRequestInterface.RequestedCourse rc : r.getRequestedCourse()) {
                            XCourseId c;
                            if (rc.isFreeTime()) {
                                for (Iterator ft2 : rc.getFreeTime()) {
                                    cd2 = null;
                                    i2 = remaining.iterator();
                                    while (i2.hasNext()) {
                                        adept = (CourseDemand)i2.next();
                                        if (adept.getFreeTime() == null) continue;
                                        cd2 = adept;
                                        i2.remove();
                                        break;
                                    }
                                    if (cd2 == null) {
                                        cd2 = new CourseDemand();
                                        cd2.setTimestamp(ts);
                                        cd2.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                                        student.getCourseDemands().add(cd2);
                                        cd2.setStudent(student);
                                    }
                                    cd2.setAlternative(true);
                                    cd2.setPriority(priority);
                                    cd2.setWaitlist(false);
                                    cd2.setNoSub(false);
                                    cd2.setCritical(0);
                                    free = cd2.getFreeTime();
                                    if (free == null) {
                                        free = new FreeTime();
                                        cd2.setFreeTime(free);
                                    }
                                    free.setCategory(0);
                                    free.setDayCode(DayCode.toInt(DayCode.toDayCodes(((CourseRequestInterface.FreeTime)((Object)ft2)).getDays())));
                                    free.setStartSlot(((CourseRequestInterface.FreeTime)((Object)ft2)).getStart());
                                    free.setLength(((CourseRequestInterface.FreeTime)((Object)ft2)).getLength());
                                    free.setSession(student.getSession());
                                    free.setName(((CourseRequestInterface.FreeTime)((Object)ft2)).toString());
                                    if (free.getUniqueId() == null) {
                                        helper.getHibSession().persist((Object)free);
                                    } else {
                                        helper.getHibSession().merge((Object)free);
                                    }
                                    if (cd2.getUniqueId() == null) {
                                        helper.getHibSession().persist((Object)cd2);
                                        continue;
                                    }
                                    helper.getHibSession().merge((Object)cd2);
                                }
                                ++priority;
                                continue;
                            }
                            if (!rc.isCourse() || (c = server.getCourse(rc.getCourseId(), rc.getCourseName())) == null) continue;
                            courses.add(c);
                        }
                    }
                    if (courses.isEmpty()) continue;
                    cd = null;
                    i = remaining.iterator();
                    block42: while (i.hasNext()) {
                        CourseDemand adept3 = (CourseDemand)i.next();
                        if (adept3.getFreeTime() != null) continue;
                        for (Object cr : adept3.getCourseRequests()) {
                            if (!((BaseCourseRequest)cr).getCourseOffering().getUniqueId().equals(((XCourseId)courses.get(0)).getCourseId())) continue;
                            cd = adept3;
                            i.remove();
                            break block42;
                        }
                    }
                    if (cd == null) {
                        cd = new CourseDemand();
                        ((BaseCourseDemand)cd).setTimestamp(ts);
                        ((BaseCourseDemand)cd).setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                        ((BaseCourseDemand)cd).setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                        ((BaseCourseDemand)cd).setStudent(student);
                        student.getCourseDemands().add((CourseDemand)cd);
                    } else {
                        i = ((BaseCourseDemand)cd).getEnrollmentMessages().iterator();
                        while (i.hasNext()) {
                            StudentEnrollmentMessage message = (StudentEnrollmentMessage)i.next();
                            helper.getHibSession().remove((Object)message);
                            i.remove();
                        }
                    }
                    ((BaseCourseDemand)cd).setAlternative(true);
                    ((BaseCourseDemand)cd).setPriority(priority);
                    if (Boolean.TRUE.equals(((BaseCourseDemand)cd).isWaitlist()) || r.isWaitList()) {
                        hasWaitList = true;
                    }
                    if (r.isWaitList() && !Boolean.TRUE.equals(((BaseCourseDemand)cd).getWaitlist())) {
                        ((BaseCourseDemand)cd).setWaitlistedTimeStamp(ts);
                    }
                    if (r.isWaitList()) {
                        ((BaseCourseDemand)cd).setWaitListSwapWithCourseOffering(r.getWaitListSwapWithCourseOfferingId() == null ? null : (CourseOffering)CourseOfferingDAO.getInstance().get(r.getWaitListSwapWithCourseOfferingId(), helper.getHibSession()));
                    } else {
                        ((BaseCourseDemand)cd).setWaitListSwapWithCourseOffering(null);
                    }
                    ((BaseCourseDemand)cd).setWaitlist(r.isWaitList());
                    ((BaseCourseDemand)cd).setNoSub(r.isNoSub());
                    ((BaseCourseDemand)cd).setCritical(0);
                    Iterator<org.unitime.timetable.model.CourseRequest> requests = new TreeSet<org.unitime.timetable.model.CourseRequest>(((BaseCourseDemand)cd).getCourseRequests()).iterator();
                    int order = 0;
                    ft2 = courses.iterator();
                    while (ft2.hasNext()) {
                        org.unitime.timetable.model.CourseRequest cr3;
                        XCourseId co = (XCourseId)ft2.next();
                        cr3 = null;
                        if (requests.hasNext()) {
                            cr3 = requests.next();
                            if (cr3.getClassWaitLists() != null) {
                                Iterator<ClassWaitList> i6 = cr3.getClassWaitLists().iterator();
                                while (i6.hasNext()) {
                                    helper.getHibSession().remove((Object)i6.next());
                                    i6.remove();
                                }
                            }
                        } else {
                            cr3 = new org.unitime.timetable.model.CourseRequest();
                            ((BaseCourseDemand)cd).getCourseRequests().add(cr3);
                            cr3.setCourseDemand((CourseDemand)cd);
                        }
                        cr3.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT, (OnlineSectioningLog.CourseRequestOption.Builder)options.get(co.getCourseId()));
                        cr3.setAllowOverlap(false);
                        cr3.setCredit(0);
                        cr3.setOrder(order++);
                        if (cr3.getCourseOffering() == null || !cr3.getCourseOffering().getUniqueId().equals(co.getCourseId())) {
                            cr3.setCourseOffering((CourseOffering)CourseOfferingDAO.getInstance().get(co.getCourseId(), helper.getHibSession()));
                            cr3.setOverrideStatus(null);
                            cr3.setOverrideIntent(null);
                            cr3.setOverrideExternalId(null);
                            cr3.setOverrideTimeStamp(null);
                        }
                        cr3.updatePreferences(r.getRequestedCourse(co.getCourseId()), helper.getHibSession());
                    }
                    while (requests.hasNext()) {
                        org.unitime.timetable.model.CourseRequest cr = requests.next();
                        ((BaseCourseDemand)cd).getCourseRequests().remove(cr);
                        helper.getHibSession().remove((Object)cr);
                    }
                    if (((BaseCourseDemand)cd).getUniqueId() == null) {
                        helper.getHibSession().persist(cd);
                    } else {
                        helper.getHibSession().merge(cd);
                    }
                    for (Object cr : ((BaseCourseDemand)cd).getCourseRequests()) {
                        course2request.put(((BaseCourseRequest)cr).getCourseOffering().getUniqueId(), cr);
                    }
                    ++priority;
                }
                if (cc != null && student.getAdvisorCourseRequests() != null) {
                    for (AdvisorCourseRequest acr : student.getAdvisorCourseRequests()) {
                        int crit = acr.isCritical(cc);
                        if (acr.getCritical() != null && acr.getCritical() == crit) continue;
                        acr.setCritical(crit);
                        helper.getHibSession().merge((Object)acr);
                    }
                }
                for (ClassAssignmentInterface.ClassAssignment ca : this.getAssignment()) {
                    if (ca == null || ca.isFreeTime() || ca.getClassId() == null || ca.isDummy() || ca.isTeachingAssignment()) continue;
                    org.unitime.timetable.model.CourseRequest cr = (org.unitime.timetable.model.CourseRequest)course2request.get(ca.getCourseId());
                    if (cr == null) {
                        cd = (CourseDemand)alt2demand.get(ca.getCourseId());
                        if (cd == null) {
                            i = remaining.iterator();
                            block51: while (i.hasNext()) {
                                CourseDemand adept4 = (CourseDemand)i.next();
                                if (adept4.getFreeTime() != null) continue;
                                for (Object r : adept4.getCourseRequests()) {
                                    if (!((BaseCourseRequest)r).getCourseOffering().getUniqueId().equals(ca.getCourseId())) continue;
                                    cd = adept4;
                                    cr = r;
                                    i.remove();
                                    break block51;
                                }
                            }
                            if (cd == null) {
                                cd = new CourseDemand();
                                ((BaseCourseDemand)cd).setTimestamp(ts);
                                ((BaseCourseDemand)cd).setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                                ((BaseCourseDemand)cd).setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                                ((BaseCourseDemand)cd).setStudent(student);
                                student.getCourseDemands().add((CourseDemand)cd);
                            }
                            ((BaseCourseDemand)cd).setAlternative(false);
                            ((BaseCourseDemand)cd).setPriority(priority++);
                            if (Boolean.TRUE.equals(((BaseCourseDemand)cd).isWaitlist())) {
                                hasWaitList = true;
                            }
                            ((BaseCourseDemand)cd).setWaitlist(false);
                            ((BaseCourseDemand)cd).setNoSub(false);
                            if (checkCritical) {
                                ((BaseCourseDemand)cd).setCritical(EnrollStudent.isCritical(ca, cc));
                            }
                        }
                        if (cr == null) {
                            cr = new org.unitime.timetable.model.CourseRequest();
                            ((BaseCourseDemand)cd).getCourseRequests().add(cr);
                            cr.setCourseDemand((CourseDemand)cd);
                            cr.updateCourseRequestOption(OnlineSectioningLog.CourseRequestOption.OptionType.ORIGINAL_ENROLLMENT, (OnlineSectioningLog.CourseRequestOption.Builder)options.get(ca.getCourseId()));
                            cr.setAllowOverlap(false);
                            cr.setCredit(0);
                            cr.setOrder(((BaseCourseDemand)cd).getCourseRequests().size());
                            cr.setCourseOffering((CourseOffering)CourseOfferingDAO.getInstance().get(ca.getCourseId(), helper.getHibSession()));
                        }
                        if (((BaseCourseDemand)cd).getUniqueId() == null) {
                            helper.getHibSession().persist(cd);
                        } else {
                            helper.getHibSession().merge(cd);
                        }
                        course2request.put(ca.getCourseId(), cr);
                        courseDemandId2courseId.put(((BaseCourseDemand)cd).getUniqueId(), ca.getCourseId());
                        includeRequestInTheReturnMessage = true;
                    } else {
                        Long courseId = (Long)courseDemandId2courseId.get(cr.getCourseDemand().getUniqueId());
                        if (courseId == null) {
                            courseDemandId2courseId.put(cr.getCourseDemand().getUniqueId(), ca.getCourseId());
                        } else if (!courseId.equals(ca.getCourseId())) {
                            cr.getCourseDemand().getCourseRequests().remove(cr);
                            CourseDemand cd3 = new CourseDemand();
                            cd3.setTimestamp(ts);
                            cd3.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                            cd3.setCourseRequests(new HashSet<org.unitime.timetable.model.CourseRequest>());
                            cd3.setStudent(student);
                            student.getCourseDemands().add(cd3);
                            cd3.setAlternative(false);
                            cd3.setPriority(priority++);
                            cd3.setWaitlist(false);
                            cd3.setNoSub(false);
                            if (checkCritical) {
                                cd3.setCritical(EnrollStudent.isCritical(ca, cc));
                            }
                            cr.setCourseDemand(cd3);
                            cd3.getCourseRequests().add(cr);
                            if (cd3.getUniqueId() == null) {
                                helper.getHibSession().persist((Object)cd3);
                            } else {
                                helper.getHibSession().merge((Object)cd3);
                            }
                            courseDemandId2courseId.put(cd3.getUniqueId(), ca.getCourseId());
                            includeRequestInTheReturnMessage = true;
                        }
                    }
                    StudentClassEnrollment enrl = (StudentClassEnrollment)oldEnrollments.remove(new FindAssignmentAction.IdPair(ca.getCourseId(), ca.getClassId()));
                    if (enrl != null) {
                        if (cr.equals(enrl.getCourseRequest())) continue;
                        enrl.setCourseRequest(cr);
                        helper.getHibSession().merge((Object)enrl);
                        continue;
                    }
                    Class_ clazz = (Class_)classes.get(ca.getClassId());
                    if (clazz == null) continue;
                    if (lockedCourses.contains(ca.getCourseId())) {
                        ClassWaitList cwl = new ClassWaitList();
                        cwl.setClazz(clazz);
                        cwl.setCourseRequest(cr);
                        cwl.setStudent(student);
                        cwl.setType(ClassWaitList.Type.LOCKED.ordinal());
                        cwl.setTimestamp(ts);
                        if (cr.getClassWaitLists() == null) {
                            cr.setClassWaitLists(new HashSet<ClassWaitList>());
                        }
                        cr.getClassWaitLists().add(cwl);
                        helper.getHibSession().persist((Object)cwl);
                        continue;
                    }
                    enrl = new StudentClassEnrollment();
                    enrl.setClazz(clazz);
                    enrl.setStudent(student);
                    enrl.setCourseOffering(cr.getCourseOffering());
                    clazz.getStudentEnrollments().add(enrl);
                    student.getClassEnrollments().add(enrl);
                    enrl.setTimestamp(ts);
                    enrl.setChangedBy(helper.getUser() == null ? null : helper.getUser().getExternalId());
                    Object[] approval = (Object[])oldApprovals.get(ca.getCourseId());
                    if (approval != null) {
                        enrl.setApprovedBy((String)approval[0]);
                        enrl.setApprovedDate((Date)approval[1]);
                    }
                    enrl.setCourseRequest(cr);
                    helper.getHibSession().persist((Object)enrl);
                    enrollmentChanged = true;
                }
                for (CourseDemand cd4 : remaining) {
                    if (cd4.getFreeTime() != null) {
                        helper.getHibSession().remove((Object)cd4.getFreeTime());
                    }
                    for (org.unitime.timetable.model.CourseRequest cr : cd4.getCourseRequests()) {
                        helper.getHibSession().remove((Object)cr);
                    }
                    if (Boolean.TRUE.equals(cd4.isWaitlist())) {
                        hasWaitList = true;
                    }
                    student.getCourseDemands().remove(cd4);
                    helper.getHibSession().remove((Object)cd4);
                }
                for (StudentClassEnrollment enrl : oldEnrollments.values()) {
                    enrl.getClazz().getStudentEnrollments().remove(enrl);
                    student.getClassEnrollments().remove(enrl);
                    helper.getHibSession().remove((Object)enrl);
                    enrollmentChanged = true;
                }
                helper.getHibSession().merge((Object)student);
                if (wlMode == OnlineSectioningInterface.WaitListMode.WaitList) {
                    helper.getHibSession().flush();
                    student.resetWaitLists(WaitList.WaitListType.SCHEDULING_ASSISTANT, helper.getUser().getExternalId(), ts, helper.getHibSession());
                }
                XStudent newStudent = new XStudent(oldStudent, student.getCourseDemands(), helper, server.getAcademicSession().getFreeTimePattern());
                Iterator<XRequest> i7 = newStudent.getRequests().iterator();
                while (i7.hasNext()) {
                    XOffering offering;
                    XRequest request = i7.next();
                    if (!(request instanceof XCourseRequest)) continue;
                    XCourseRequest courseRequest = (XCourseRequest)request;
                    Iterator<XCourseId> j = courseRequest.getCourseIds().iterator();
                    while (j.hasNext()) {
                        XCourseId course = j.next();
                        XOffering offering2 = server.getOffering(course.getOfferingId());
                        if (offering2 != null) continue;
                        helper.warn("Student " + helper.getStudentNameFormat().format(student) + " (" + student.getExternalUniqueId() + ") requests course " + course.getCourseName() + " that is not loaded.");
                        j.remove();
                    }
                    if (courseRequest.getCourseIds().isEmpty()) {
                        i7.remove();
                        continue;
                    }
                    XEnrollment enrollment = courseRequest.getEnrollment();
                    if (enrollment == null || enrollment.getReservation() != null || (offering = server.getOffering(enrollment.getOfferingId())) == null || offering.getReservations().isEmpty()) continue;
                    enrollment.setReservation(offering.guessReservation(server.getRequests(enrollment.getOfferingId()), newStudent, enrollment));
                }
                server.update(newStudent, true);
                for (XRequest oldRequest : oldStudent.getRequests()) {
                    Set<Long> oldSections;
                    XEnrollment oldEnrollment;
                    XEnrollment xEnrollment = oldEnrollment = oldRequest instanceof XCourseRequest ? ((XCourseRequest)oldRequest).getEnrollment() : null;
                    if (oldEnrollment == null) continue;
                    XRequest newRequest = null;
                    XEnrollment newEnrollment = null;
                    if (newStudent != null) {
                        for (Object r : newStudent.getRequests()) {
                            XEnrollment e = r instanceof XCourseRequest ? ((XCourseRequest)r).getEnrollment() : null;
                            if (e == null || !e.getOfferingId().equals(oldEnrollment.getOfferingId())) continue;
                            newRequest = (XCourseRequest)r;
                            newEnrollment = e;
                            break;
                        }
                    }
                    if (newEnrollment == null) {
                        oldSections = oldEnrollment.getSectionIds();
                    } else {
                        Object r;
                        oldSections = new HashSet<Long>();
                        r = oldEnrollment.getSectionIds().iterator();
                        while (r.hasNext()) {
                            Long sectionId = (Long)r.next();
                            if (newEnrollment.getSectionIds().contains(sectionId)) continue;
                            oldSections.add(sectionId);
                        }
                    }
                    if (oldSections.isEmpty()) continue;
                    XOffering offering = server.getOffering(oldEnrollment.getOfferingId());
                    if (CheckOfferingAction.isCheckNeeded(server, helper, oldEnrollment, newEnrollment)) {
                        server.execute(server.createAction(CheckOfferingAction.class).forOfferings(oldEnrollment.getOfferingId()).skipStudents(this.getStudentId()), helper.getUser(), offeringChecked);
                    }
                    EnrollStudent.updateSpace(server, newEnrollment == null ? null : SectioningRequest.convert(newStudent, (XCourseRequest)newRequest, server, offering, newEnrollment, wlMode, helper), oldEnrollment == null ? null : SectioningRequest.convert(oldStudent, (XCourseRequest)oldRequest, server, offering, oldEnrollment, wlMode, helper), offering);
                    server.persistExpectedSpaces(oldEnrollment.getOfferingId());
                }
                OnlineSectioningLog.Enrollment.Builder previous = OnlineSectioningLog.Enrollment.newBuilder();
                previous.setType(OnlineSectioningLog.Enrollment.EnrollmentType.PREVIOUS);
                for (XRequest oldRequest : oldStudent.getRequests()) {
                    XEnrollment oldEnrollment = oldRequest instanceof XCourseRequest ? ((XCourseRequest)oldRequest).getEnrollment() : null;
                    if (oldEnrollment == null) continue;
                    for (XSection section : server.getOffering(oldEnrollment.getOfferingId()).getSections(oldEnrollment)) {
                        previous.addSection(OnlineSectioningHelper.toProto(section, oldEnrollment));
                    }
                }
                action.addEnrollment(previous);
                block63: for (XRequest newRequest : newStudent.getRequests()) {
                    XEnrollment newEnrollment = newRequest instanceof XCourseRequest ? ((XCourseRequest)newRequest).getEnrollment() : null;
                    if (newEnrollment == null) continue;
                    if (oldStudent != null) {
                        for (XRequest oldRequest : oldStudent.getRequests()) {
                            XEnrollment oldEnrollment = oldRequest instanceof XCourseRequest ? ((XCourseRequest)oldRequest).getEnrollment() : null;
                            if (oldEnrollment == null || !oldEnrollment.getOfferingId().equals(newEnrollment.getOfferingId())) continue;
                            continue block63;
                        }
                    }
                    XOffering offering = server.getOffering(newEnrollment.getOfferingId());
                    EnrollStudent.updateSpace(server, SectioningRequest.convert(newStudent, (XCourseRequest)newRequest, server, offering, newEnrollment, wlMode, helper), null, offering);
                    server.persistExpectedSpaces(newEnrollment.getOfferingId());
                }
                OnlineSectioningLog.Enrollment.Builder stored = OnlineSectioningLog.Enrollment.newBuilder();
                stored.setType(OnlineSectioningLog.Enrollment.EnrollmentType.STORED);
                for (XRequest newRequest : newStudent.getRequests()) {
                    XEnrollment newEnrollment = newRequest instanceof XCourseRequest ? ((XCourseRequest)newRequest).getEnrollment() : null;
                    if (newEnrollment == null) continue;
                    for (XSection section : server.getOffering(newEnrollment.getOfferingId()).getSections(newEnrollment)) {
                        stored.addSection(OnlineSectioningHelper.toProto(section, newEnrollment));
                    }
                }
                action.addEnrollment(stored);
                if (enrollmentChanged) {
                    server.execute(server.createAction(NotifyStudentAction.class).forStudent(newStudent).fromAction(this.name()).withType(helper.isAdmin() ? StudentSectioningStatus.NotificationType.AdminChangeEnrollment : StudentSectioningStatus.NotificationType.StudentChangeEnrollment).skipWhenNoChange(true).oldStudent(oldStudent), helper.getUser());
                }
                helper.commitTransaction();
            }
            catch (Exception e) {
                helper.rollbackTransaction();
                if (e instanceof SectioningException) {
                    SectioningException se = (SectioningException)e;
                    if (checkErrors != null && !checkErrors.isEmpty()) {
                        for (ClassAssignmentInterface.ErrorMessage em : checkErrors) {
                            se.addError(em);
                        }
                    }
                    throw se;
                }
                helper.error("Failed to enroll student " + this.getStudentId() + ": " + e.getMessage(), e);
                throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
            }
        }
        finally {
            lock.release();
        }
        if (!includeRequestInTheReturnMessage) {
            if (ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnly.isTrue()) {
                includeRequestInTheReturnMessage = true;
            } else if (helper.getUser() != null && helper.getUser().getType() == OnlineSectioningLog.Entity.EntityType.MANAGER && ApplicationProperty.OnlineSchedulingMakeAssignedRequestReadOnlyIfAdmin.isTrue()) {
                includeRequestInTheReturnMessage = true;
            } else if (ApplicationProperty.StudentSchedulingAlternativeCourse.isTrue()) {
                includeRequestInTheReturnMessage = true;
            } else if (wlMode == OnlineSectioningInterface.WaitListMode.WaitList && hasWaitList) {
                includeRequestInTheReturnMessage = true;
            }
        }
        if ((ret = server.execute(server.createAction(GetAssignment.class).forStudent(this.getStudentId()).withMessages(failures).withErrors(checkErrors).withRequest(includeRequestInTheReturnMessage).withWaitListMode(wlMode), helper.getUser())) != null && gradeModes.hasGradeModes()) {
            for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                    OnlineSectioningInterface.GradeMode m = gradeModes.getGradeMode(a);
                    if (m == null) continue;
                    a.setGradeMode(m);
                }
            }
        }
        if (ret != null && gradeModes.hasCreditHours()) {
            for (ClassAssignmentInterface.CourseAssignment ca : ret.getCourseAssignments()) {
                for (ClassAssignmentInterface.ClassAssignment a : ca.getClassAssignments()) {
                    Float credit = gradeModes.getCreditHour(a);
                    a.setCreditHour(credit);
                    if (credit == null) continue;
                    a.setCredit(FixedCreditUnitConfig.formatCredit(credit.floatValue()));
                }
            }
        }
        if (ret != null && gradeModes.hasCurrentCredit()) {
            ret.setCurrentCredit(gradeModes.getCurrentCredit());
        }
        if (this.iCheckWaitLists && hasWaitList && ret != null && ret.getRequest() != null && wlMode == OnlineSectioningInterface.WaitListMode.WaitList && Customization.WaitListValidationProvider.hasProvider()) {
            ret.getRequest().setWaitListChecks(server.execute(server.createAction(WaitListCheckValidation.class).withRequest(ret.getRequest()), helper.getUser()));
            if (ret.getRequest().hasWaitListChecks() && !ret.getRequest().getWaitListChecks().isConfirm() && !ret.getRequest().getWaitListChecks().isError()) {
                ret.setRequest(server.execute(server.createAction(WaitListSubmitOverrides.class).withRequest(ret.getRequest()).withCredit(ret.getRequest().getWaitListChecks().getMaxCreditNeeded()), helper.getUser()));
            }
        }
        return ret;
    }

    public static int getLimit(Enrollment enrollment, Map<Long, XSection> sections) {
        Integer limit = null;
        for (Section s : enrollment.getSections()) {
            XSection section = sections.get(s.getId());
            if (section == null || section.getLimit() < 0) continue;
            if (limit == null) {
                limit = section.getLimit();
                continue;
            }
            limit = Math.min(limit, section.getLimit());
        }
        return limit == null ? -1 : limit;
    }

    public static void updateSpace(OnlineSectioningServer server, Enrollment newEnrollment, Enrollment oldEnrollment, XOffering offering) {
        EnrollStudent.updateSpace(server, newEnrollment, oldEnrollment, offering, offering);
    }

    public static void updateSpace(OnlineSectioningServer server, Enrollment newEnrollment, Enrollment oldEnrollment, XOffering newOffering, XOffering oldOffering) {
        Enrollment otherErollment;
        Object feasibleEnrollments;
        HashMap<Long, XSection> sections;
        if (newEnrollment == null && oldEnrollment == null) {
            return;
        }
        XExpectations expectations = server.getExpectations((newEnrollment == null ? oldEnrollment : newEnrollment).getOffering().getId());
        DefaultSingleAssignment assignment = new DefaultSingleAssignment();
        if (oldEnrollment != null) {
            sections = new HashMap<Long, XSection>();
            if (oldOffering != null) {
                for (XConfig config : oldOffering.getConfigs()) {
                    for (XSubpart subpart : config.getSubparts()) {
                        for (XSection section : subpart.getSections()) {
                            sections.put(section.getSectionId(), section);
                        }
                    }
                }
            }
            feasibleEnrollments = new ArrayList();
            int totalLimit = 0;
            for (Enrollment enrl : oldEnrollment.getRequest().values((Assignment)assignment)) {
                if (!enrl.getCourse().equals((Object)oldEnrollment.getCourse())) continue;
                boolean overlaps = false;
                for (Request otherRequest : oldEnrollment.getRequest().getStudent().getRequests()) {
                    if (otherRequest.equals((Object)oldEnrollment.getRequest()) || !(otherRequest instanceof CourseRequest) || (otherErollment = (Enrollment)otherRequest.getInitialAssignment()) == null || !enrl.isOverlapping(otherErollment)) continue;
                    overlaps = true;
                    break;
                }
                if (overlaps) continue;
                feasibleEnrollments.add(enrl);
                if (totalLimit < 0) continue;
                int limit = EnrollStudent.getLimit(enrl, sections);
                if (limit < 0) {
                    totalLimit = -1;
                    continue;
                }
                totalLimit += limit;
            }
            double increment = 1.0 / (double)(totalLimit > 0 ? totalLimit : feasibleEnrollments.size());
            Iterator<Object> overlaps = feasibleEnrollments.iterator();
            while (overlaps.hasNext()) {
                Enrollment feasibleEnrollment = (Enrollment)overlaps.next();
                for (Section section : feasibleEnrollment.getSections()) {
                    if (totalLimit > 0) {
                        expectations.incExpectedSpace(section.getId(), increment * (double)EnrollStudent.getLimit(feasibleEnrollment, sections));
                        continue;
                    }
                    expectations.incExpectedSpace(section.getId(), increment);
                }
            }
        }
        if (newEnrollment != null) {
            sections = new HashMap();
            if (newOffering != null) {
                for (XConfig config : newOffering.getConfigs()) {
                    for (XSubpart subpart : config.getSubparts()) {
                        for (XSection section : subpart.getSections()) {
                            sections.put(section.getSectionId(), section);
                        }
                    }
                }
            }
            for (Section section : newEnrollment.getSections()) {
                section.setSpaceHeld(section.getSpaceHeld() - 1.0);
            }
            feasibleEnrollments = new ArrayList();
            int totalLimit = 0;
            for (Enrollment enrl : newEnrollment.getRequest().values((Assignment)assignment)) {
                if (!enrl.getCourse().equals((Object)newEnrollment.getCourse())) continue;
                boolean overlaps = false;
                for (Request otherRequest : newEnrollment.getRequest().getStudent().getRequests()) {
                    if (otherRequest.equals((Object)newEnrollment.getRequest()) || !(otherRequest instanceof CourseRequest) || (otherErollment = (Enrollment)assignment.getValue((Variable)otherRequest)) == null || !enrl.isOverlapping(otherErollment)) continue;
                    overlaps = true;
                    break;
                }
                if (overlaps) continue;
                feasibleEnrollments.add(enrl);
                if (totalLimit < 0) continue;
                int limit = EnrollStudent.getLimit(enrl, sections);
                if (limit < 0) {
                    totalLimit = -1;
                    continue;
                }
                totalLimit += limit;
            }
            double decrement = 1.0 / (double)(totalLimit > 0 ? totalLimit : feasibleEnrollments.size());
            Iterator iterator = feasibleEnrollments.iterator();
            while (iterator.hasNext()) {
                Enrollment feasibleEnrollment = (Enrollment)iterator.next();
                for (Section section : feasibleEnrollment.getSections()) {
                    if (totalLimit > 0) {
                        expectations.incExpectedSpace(section.getId(), -decrement * (double)EnrollStudent.getLimit(feasibleEnrollment, sections));
                        continue;
                    }
                    expectations.incExpectedSpace(section.getId(), -decrement);
                }
            }
        }
        server.update(expectations);
    }

    protected static int isCritical(List<XCourseId> courses, CriticalCoursesProvider.CriticalCourses critical) {
        if (critical == null) {
            return 0;
        }
        Iterator<XCourseId> iterator = courses.iterator();
        if (iterator.hasNext()) {
            XCourseId co = iterator.next();
            return critical.isCritical(co);
        }
        return 0;
    }

    protected static int isCritical(ClassAssignmentInterface.ClassAssignment course, CriticalCoursesProvider.CriticalCourses critical) {
        if (critical == null) {
            return 0;
        }
        if (course == null || course.getCourseId() == null) {
            return 0;
        }
        return critical.isCritical(new XCourseId(null, course.getCourseId(), course.getSubject(), course.getCourseNbr()));
    }

    @Override
    public String name() {
        return "enroll";
    }

    @Override
    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }
}

