/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.List;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.model.base.BaseSessionConfig;
import org.unitime.timetable.model.dao.SessionConfigDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="session_config")
public class SessionConfig
extends BaseSessionConfig {
    private static final long serialVersionUID = 1L;

    public static SessionConfig getConfig(String key, Long sessionId) {
        if (sessionId == null) {
            return null;
        }
        return (SessionConfig)SessionConfigDAO.getInstance().getSession().createQuery("from SessionConfig where key = :key and session.uniqueId = :sessionId", SessionConfig.class).setParameter("key", (Object)key).setParameter("sessionId", (Object)sessionId).setCacheable(true).uniqueResult();
    }

    public static List<SessionConfig> findAll(Long sessionId) {
        return SessionConfigDAO.getInstance().getSession().createQuery("from SessionConfig where session.uniqueId = :sessionId order by key", SessionConfig.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    public static String getConfigValue(String key, Long sessionId, String defaultValue) {
        if (!HibernateUtil.isConfigured() || sessionId == null) {
            return defaultValue;
        }
        String value = (String)SessionConfigDAO.getInstance().getSession().createQuery("select value from SessionConfig where key = :key and session.uniqueId = :sessionId", String.class).setParameter("key", (Object)key).setParameter("sessionId", (Object)sessionId).setCacheable(true).uniqueResult();
        return value == null ? defaultValue : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties toProperties(Long sessionId) {
        if (!HibernateUtil.isConfigured() || sessionId == null) {
            return null;
        }
        Session hibSession = SessionConfigDAO.getInstance().createNewSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            Properties properties = new Properties();
            for (SessionConfig config : hibSession.createQuery("from SessionConfig where session.uniqueId = :sessionId", SessionConfig.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
                properties.setProperty(config.getKey(), config.getValue() == null ? "" : config.getValue());
            }
            tx.commit();
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            hibSession.close();
        }
        return null;
    }
}

