/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.base.BaseExamType;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.SimpleExaminationPermission;

@Entity
@Table(name="exam_type")
public class ExamType
extends BaseExamType
implements Comparable<ExamType> {
    private static final long serialVersionUID = 1L;
    protected static ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    public static final int sExamTypeFinal = 0;
    public static final int sExamTypeMidterm = 1;

    @Override
    public int compareTo(ExamType o) {
        return this.getType().equals(o.getType()) ? this.getLabel().compareToIgnoreCase(o.getLabel()) : this.getType().compareTo(o.getType());
    }

    public static ExamType findByReference(String ref) {
        return (ExamType)ExamTypeDAO.getInstance().getSession().createQuery("from ExamType where reference = :ref", ExamType.class).setParameter("ref", (Object)ref).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public static List<ExamType> findAllOfType(int type) {
        return ExamTypeDAO.getInstance().getSession().createQuery("from ExamType where type = :type order by type, label", ExamType.class).setParameter("type", (Object)type).setCacheable(true).list();
    }

    public static TreeSet<ExamType> findAllUsed(Long sessionId) {
        return new TreeSet<ExamType>(ExamTypeDAO.getInstance().getSession().createQuery("select distinct p.examType from ExamPeriod p where p.session.uniqueId = :sessionId", ExamType.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list());
    }

    public static List<ExamType> findAllApplicable(UserContext user, DepartmentStatusType.Status ... status) {
        UserAuthority authority;
        ArrayList<ExamType> types = new ArrayList<ExamType>();
        UserAuthority userAuthority = authority = user == null ? null : user.getCurrentAuthority();
        if (authority == null) {
            return types;
        }
        SimpleExaminationPermission p = new SimpleExaminationPermission();
        for (ExamType type : ExamType.findAll()) {
            ExamStatus examStatus = ExamStatus.findStatus(user.getCurrentAcademicSessionId(), type.getUniqueId());
            if (examStatus != null) {
                if (!p.checkManager(authority, examStatus, status) || !p.checkStatus(authority, examStatus.effectiveStatus(), status)) continue;
                types.add(type);
                continue;
            }
            types.add(type);
        }
        return types;
    }

    public static List<ExamType> findAllUsedApplicable(UserContext user, DepartmentStatusType.Status ... status) {
        UserAuthority authority;
        ArrayList<ExamType> types = new ArrayList<ExamType>();
        UserAuthority userAuthority = authority = user == null ? null : user.getCurrentAuthority();
        if (authority == null) {
            return types;
        }
        SimpleExaminationPermission p = new SimpleExaminationPermission();
        for (ExamType type : ExamType.findAllUsed(user.getCurrentAcademicSessionId())) {
            ExamStatus examStatus = ExamStatus.findStatus(user.getCurrentAcademicSessionId(), type.getUniqueId());
            if (examStatus != null) {
                if (!p.checkManager(authority, examStatus, status) || !p.checkStatus(authority, examStatus.effectiveStatus(), status)) continue;
                types.add(type);
                continue;
            }
            types.add(type);
        }
        return types;
    }

    public static List<ExamType> findAll() {
        return ExamType.findAll(null);
    }

    public static List<ExamType> findAll(Session hibSession) {
        return (hibSession != null ? hibSession : ExamTypeDAO.getInstance().getSession()).createQuery("from ExamType order by type, label", ExamType.class).setCacheable(true).list();
    }

    public boolean isUsed(Long sessionId) {
        if (sessionId == null) {
            return ((Number)ExamTypeDAO.getInstance().getSession().createQuery("select count(p) from ExamPeriod p where p.examType.uniqueId = :typeId", Number.class).setParameter("typeId", (Object)this.getUniqueId()).setCacheable(true).uniqueResult()).longValue() > 0L;
        }
        return ((Number)ExamTypeDAO.getInstance().getSession().createQuery("select count(p) from ExamPeriod p where p.examType.uniqueId = :typeId and p.session.uniqueId = :sessionId", Number.class).setParameter("typeId", (Object)this.getUniqueId()).setParameter("sessionId", (Object)sessionId).setCacheable(true).uniqueResult()).longValue() > 0L;
    }

    public static void refreshSolution(Long sessionId, Long examTypeId) {
        Session hibSession = ExamTypeDAO.getInstance().getSession();
        SessionFactory hibSessionFactory = hibSession.getSessionFactory();
        for (Long examId : hibSession.createQuery("select x.uniqueId from Exam x where x.session.uniqueId = :sessionId and x.examType.uniqueId = :examTypeId", Long.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list()) {
            hibSessionFactory.getCache().evictEntityData(Exam.class, (Object)examId);
            hibSessionFactory.getCache().evictCollectionData(Exam.class.getName() + ".assignedRooms", (Object)examId);
            hibSessionFactory.getCache().evictCollectionData(Exam.class.getName() + ".conflicts", (Object)examId);
        }
        for (Long eventId : hibSession.createQuery("select e.uniqueId from ExamEvent e inner join e.exam x where x.session.uniqueId = :sessionId and x.examType.uniqueId = :examTypeId", Long.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list()) {
            hibSessionFactory.getCache().evictEntityData(Event.class, (Object)eventId);
            hibSessionFactory.getCache().evictCollectionData(Event.class.getName() + ".meetings", (Object)eventId);
        }
        hibSessionFactory.getCache().evictDefaultQueryRegion();
    }
}

