/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class ObjectivesCell
extends P
implements TakesValue<Map<String, Double>> {
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static NumberFormat sTeachingLoadFormat = NumberFormat.getFormat((String)CONSTANTS.teachingLoadFormat());
    protected InstructorInterface.TeachingRequestsPagePropertiesResponse iProperties;
    private Map<String, Double> iValue = null;

    public ObjectivesCell(InstructorInterface.TeachingRequestsPagePropertiesResponse properties) {
        super("objectives");
        this.iProperties = properties;
    }

    public ObjectivesCell(InstructorInterface.TeachingRequestsPagePropertiesResponse properties, Map<String, Double> values) {
        this(properties);
        this.setValue(values);
    }

    public ObjectivesCell(InstructorInterface.TeachingRequestsPagePropertiesResponse properties, Map<String, Double> initial, Map<String, Double> current) {
        this(properties);
        this.setValue(initial, current);
    }

    public static Map<String, Double> diff(Map<String, Double> initial, Map<String, Double> current) {
        HashMap<String, Double> ret;
        HashMap<String, Double> hashMap = ret = current == null ? new HashMap<String, Double>() : new HashMap<String, Double>(current);
        if (initial != null) {
            for (Map.Entry<String, Double> e : initial.entrySet()) {
                Double value;
                String key = e.getKey();
                Double base = e.getValue();
                Double d = value = current == null ? null : current.get(key);
                if (value == null) {
                    ret.put(key, -base.doubleValue());
                    continue;
                }
                ret.put(key, value - base);
            }
        }
        return ret;
    }

    public void setValue(Map<String, Double> values) {
        this.iValue = values;
        this.clear();
        if (values != null) {
            for (String key : new TreeSet<String>(values.keySet())) {
                Double value = values.get(key);
                if (value == null || Math.abs(value) < 0.001) continue;
                P obj = new P("objective");
                obj.setText(key + ": " + (value > 0.0 ? "+" : "") + sTeachingLoadFormat.format((Number)value));
                if (key.endsWith(" Preferences")) {
                    if (value <= -50.0) {
                        obj.getElement().getStyle().setColor(this.iProperties.getPreference("R").getColor());
                    } else if (value <= -2.0) {
                        obj.getElement().getStyle().setColor(this.iProperties.getPreference("-2").getColor());
                    } else if (value < 0.0) {
                        obj.getElement().getStyle().setColor(this.iProperties.getPreference("-1").getColor());
                    } else if (value >= 50.0) {
                        obj.getElement().getStyle().setColor(this.iProperties.getPreference("P").getColor());
                    } else if (value >= 2.0) {
                        obj.getElement().getStyle().setColor(this.iProperties.getPreference("2").getColor());
                    } else if (value > 0.0) {
                        obj.getElement().getStyle().setColor(this.iProperties.getPreference("1").getColor());
                    }
                } else if (value < 0.0) {
                    obj.getElement().getStyle().setColor("green");
                } else if (value > 0.0) {
                    obj.getElement().getStyle().setColor("red");
                }
                this.add((Widget)obj);
            }
        }
    }

    public void setValue(Map<String, Double> initial, Map<String, Double> current) {
        this.setValue(ObjectivesCell.diff(initial, current));
    }

    public Map<String, Double> getValue() {
        return this.iValue;
    }
}

