/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.admin.TaskDetail;
import org.unitime.timetable.gwt.client.admin.TaskEditor;
import org.unitime.timetable.gwt.client.admin.TasksTable;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.TaskInterface;

public class TasksPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    public static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iForm = new SimpleForm(2);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private TasksTable iTasksTable;
    private TaskInterface.TaskOptionsInterface iOptions = null;
    private TaskDetail iTaskDetail;
    private SimplePanel iPanel;

    public TasksPage() {
        this.iForm.removeStyleName("unitime-NotPrintableBottomLine");
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectScheduledTasks("..."));
        this.iHeader.addButton("add", MESSAGES.buttonAddNewTask(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                new TaskEditor(null, TasksPage.this.iOptions){

                    @Override
                    protected void doSave(final TaskInterface task) {
                        LoadingWidget.getInstance().show(task.getId() == null ? MESSAGES.waitCreate(task.getName()) : MESSAGES.waitUpdate(task.getName()));
                        TasksPage.this.RPC.execute(new TaskInterface.SaveTaskDetailsRpcRequest(task), new AsyncCallback<TaskInterface>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                if (task.getId() == null) {
                                    this.setErrorMessage(MESSAGES.failedCreate(task.getName(), caught.getMessage()));
                                    UniTimeNotifications.error(MESSAGES.failedCreate(task.getName(), caught.getMessage()), caught);
                                } else {
                                    this.setErrorMessage(MESSAGES.failedUpdate(task.getName(), caught.getMessage()));
                                    UniTimeNotifications.error(MESSAGES.failedUpdate(task.getName(), caught.getMessage()), caught);
                                }
                                this.center();
                            }

                            public void onSuccess(TaskInterface result) {
                                LoadingWidget.getInstance().hide();
                                TasksPage.this.loadTasks(result == null ? null : result.getId());
                            }
                        });
                    }
                }.center();
            }
        });
        this.iHeader.setEnabled("add", false);
        this.iHeader.addButton("refresh", MESSAGES.buttonRefresh(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                TasksPage.this.loadTasks(null);
            }
        });
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iTasksTable = new TasksTable();
        this.iForm.addRow((Widget)this.iTasksTable);
        this.iFooter = this.iHeader.clonePanel("");
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.iPanel = new SimplePanel((Widget)this.iForm);
        this.initWidget((Widget)this.iPanel);
        this.iHeader.showLoading();
        this.RPC.execute(new TaskInterface.GetTaskOptionsRpcRequest(), new AsyncCallback<TaskInterface.TaskOptionsInterface>(){

            public void onFailure(Throwable caught) {
                TasksPage.this.iHeader.setErrorMessage(MESSAGES.failedLoadData(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedLoadData(caught.getMessage()), caught);
            }

            public void onSuccess(TaskInterface.TaskOptionsInterface result) {
                TasksPage.this.iOptions = result;
                TasksPage.this.iTasksTable.setOptions(result);
                TasksPage.this.iHeader.setEnabled("add", TasksPage.this.iOptions.canAdd());
                TasksPage.this.iHeader.setHeaderTitle(MESSAGES.sectScheduledTasks(TasksPage.this.iOptions.getSession().getName()));
                TasksPage.this.loadTasks(null);
            }
        });
        this.iTasksTable.addMouseClickListener(new UniTimeTable.MouseClickListener<TaskInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<TaskInterface> event) {
                if (event.getData() != null && event.getData().canView()) {
                    TasksPage.this.iTaskDetail.setValue(event.getData());
                    UniTimePageLabel.getInstance().setPageName(MESSAGES.pageTaskDetails());
                    TasksPage.this.iPanel.setWidget((Widget)TasksPage.this.iTaskDetail);
                    Window.scrollTo((int)0, (int)0);
                    GwtHint.hideHint();
                }
            }
        });
        this.iTaskDetail = new TaskDetail(){

            @Override
            protected void doBack() {
                TasksPage.this.iPanel.setWidget((Widget)TasksPage.this.iForm);
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageTasks());
                TasksPage.this.loadTasks(this.getValue() == null ? null : this.getValue().getId());
            }

            @Override
            protected void doEdit() {
                new TaskEditor(this.getValue(), TasksPage.this.iOptions){

                    @Override
                    protected void doSave(final TaskInterface task) {
                        LoadingWidget.getInstance().show(task.getId() == null ? MESSAGES.waitCreate(task.getName()) : MESSAGES.waitUpdate(task.getName()));
                        TasksPage.this.RPC.execute(new TaskInterface.SaveTaskDetailsRpcRequest(task), new AsyncCallback<TaskInterface>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                if (task.getId() == null) {
                                    this.setErrorMessage(MESSAGES.failedCreate(task.getName(), caught.getMessage()));
                                    UniTimeNotifications.error(MESSAGES.failedCreate(task.getName(), caught.getMessage()), caught);
                                } else {
                                    this.setErrorMessage(MESSAGES.failedUpdate(task.getName(), caught.getMessage()));
                                    UniTimeNotifications.error(MESSAGES.failedUpdate(task.getName(), caught.getMessage()), caught);
                                }
                                this.center();
                            }

                            public void onSuccess(TaskInterface result) {
                                LoadingWidget.getInstance().hide();
                                if (result != null) {
                                    this.setValue(result);
                                } else {
                                    this.doBack();
                                }
                            }
                        });
                    }
                }.center();
            }
        };
    }

    protected void loadTasks(final Long taskId) {
        this.iHeader.showLoading();
        this.RPC.execute(new TaskInterface.GetTasksRpcRequest(), new AsyncCallback<GwtRpcResponseList<TaskInterface>>(){

            public void onFailure(Throwable caught) {
                TasksPage.this.iHeader.setErrorMessage(MESSAGES.failedLoadData(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedLoadData(caught.getMessage()), caught);
            }

            public void onSuccess(GwtRpcResponseList<TaskInterface> result) {
                TasksPage.this.iHeader.clearMessage();
                TasksPage.this.populateTasks(result, taskId);
            }
        });
    }

    protected void populateTasks(List<TaskInterface> tasks, Long taskId) {
        this.iTasksTable.clearTable(1);
        this.iTasksTable.setValue(tasks);
        if (taskId != null) {
            this.iTasksTable.scrollToTask(taskId);
        }
    }
}

