/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.form.ExamReportForm;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.ComboBoxLookup;

public class ExamChangesForm
extends ExamReportForm {
    private static final long serialVersionUID = 4093360180461644275L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private String iChage = ExamChange.Initial.name();
    private boolean iReverse = false;
    private boolean iNoSolver = false;

    public String getChangeName() {
        try {
            return this.getChangeName(ExamChange.valueOf(this.iChage));
        }
        catch (Exception e) {
            return this.iChage;
        }
    }

    public String getChangeName(ExamChange ch) {
        switch (ch) {
            case Best: {
                return MSG.changeBest();
            }
            case Initial: {
                return MSG.changeInitial();
            }
            case Saved: {
                return MSG.changeSaved();
            }
        }
        return ch.name();
    }

    public boolean getReverse() {
        return this.iReverse;
    }

    public void setReverse(boolean reverse) {
        this.iReverse = reverse;
    }

    public String getChangeType() {
        return this.iChage;
    }

    public void setChangeType(String changeType) {
        this.iChage = changeType;
    }

    public List<ComboBoxLookup> getChangeTypes() {
        ArrayList<ComboBoxLookup> ret = new ArrayList<ComboBoxLookup>();
        for (ExamChange ch : ExamChange.values()) {
            ret.add(new ComboBoxLookup(this.getChangeName(ch), ch.name()));
        }
        return ret;
    }

    @Override
    public void reset() {
        super.reset();
        this.iChage = ExamChange.Initial.name();
        this.iReverse = false;
    }

    @Override
    public void load(SessionContext session) {
        super.load(session);
        this.setReverse("1".equals(session.getUser().getProperty("ExamChanges.reverse", "0")));
        this.setChangeType(session.getUser().getProperty("ExamChanges.changeType", ExamChange.Initial.name()));
    }

    @Override
    public void save(SessionContext session) {
        super.save(session);
        session.getUser().setProperty("ExamChanges.reverse", this.getReverse() ? "1" : "0");
        session.getUser().setProperty("ExamChanges.changeType", this.getChangeType());
    }

    public boolean getNoSolver() {
        return this.iNoSolver;
    }

    public void setNoSolver(boolean noSolver) {
        this.iNoSolver = noSolver;
    }

    public static enum ExamChange {
        Initial,
        Best,
        Saved;

    }
}

