/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import jakarta.servlet.http.HttpSession;
import java.util.Collection;
import java.util.Set;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.solver.course.ui.ClassInfoModel;

public class ClassInfoForm
implements UniTimeForm {
    private static final long serialVersionUID = -9085986972061220089L;
    protected static CourseMessages MSG = Localization.create(CourseMessages.class);
    private String iOp;
    private ClassInfoModel iModel;
    private String iMessage;
    private String iMinRoomSize = null;
    private String iMaxRoomSize = null;
    private String iRoomFilter = null;
    private boolean iAllowRoomConflict = false;
    private String iRoomOrder = null;
    private RoomBase iRoomBase = RoomBase.Departmental;
    private boolean iKeepConflictingAssignments = false;
    private Long[] iRoomFeatures = null;
    private Long[] iRoomTypes = null;
    private Long[] iRoomGroups = null;
    private Long iSessionId = null;
    private String iFilter = null;

    public ClassInfoForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
    }

    @Override
    public void reset() {
        this.iOp = null;
        this.iModel = null;
        this.iMessage = null;
        this.iMinRoomSize = null;
        this.iMaxRoomSize = null;
        this.iRoomFilter = null;
        this.iAllowRoomConflict = false;
        this.iRoomBase = RoomBase.Departmental;
        this.iRoomOrder = MSG.sortRoomNameAsc();
        this.iFilter = null;
        this.iKeepConflictingAssignments = false;
        this.iRoomTypes = null;
        this.iRoomFeatures = null;
        this.iRoomGroups = null;
    }

    public void load(HttpSession session) {
        this.iRoomOrder = (String)session.getAttribute("ClassInfo.RoomOrd");
        this.iMinRoomSize = (String)session.getAttribute("ClassInfo.MinRoomSize");
        this.iMaxRoomSize = (String)session.getAttribute("ClassInfo.MaxRoomSize");
        this.iRoomFilter = (String)session.getAttribute("ClassInfo.RoomFilter");
        this.iAllowRoomConflict = "true".equals(session.getAttribute("ClassInfo.AllowRoomConflict"));
        String base = (String)session.getAttribute("ClassInfo.RoomBase");
        this.iRoomBase = base == null || base.isEmpty() ? RoomBase.Departmental : RoomBase.valueOf(base);
        this.iFilter = (String)session.getAttribute("ClassInfo.Filter");
        this.iKeepConflictingAssignments = "true".equals(session.getAttribute("ClassInfo.KeepConflictingAssignments"));
        this.iRoomTypes = (Long[])session.getAttribute("ClassInfo.RoomTypes");
        this.iRoomGroups = (Long[])session.getAttribute("ClassInfo.RoomGroups");
        this.iRoomFeatures = (Long[])session.getAttribute("ClassInfo.RoomFeatures");
    }

    public void save(HttpSession session) {
        if (this.iRoomOrder == null) {
            session.removeAttribute("ClassInfo.RoomOrd");
        } else {
            session.setAttribute("ClassInfo.RoomOrd", (Object)this.iRoomOrder);
        }
        if (this.iMinRoomSize == null) {
            session.removeAttribute("ClassInfo.MinRoomSize");
        } else {
            session.setAttribute("ClassInfo.MinRoomSize", (Object)this.iMinRoomSize);
        }
        if (this.iMaxRoomSize == null) {
            session.removeAttribute("ClassInfo.MaxRoomSize");
        } else {
            session.setAttribute("ClassInfo.MaxRoomSize", (Object)this.iMaxRoomSize);
        }
        if (this.iRoomFilter == null) {
            session.removeAttribute("ClassInfo.RoomFilter");
        } else {
            session.setAttribute("ClassInfo.RoomFilter", (Object)this.iRoomFilter);
        }
        session.setAttribute("ClassInfo.AllowRoomConflict", (Object)(this.iAllowRoomConflict ? "true" : "false"));
        session.setAttribute("ClassInfo.RoomBase", (Object)(this.iRoomBase == null ? RoomBase.Departmental.name() : this.iRoomBase.name()));
        if (!this.iKeepConflictingAssignments) {
            session.removeAttribute("ClassInfo.KeepConflictingAssignments");
        } else {
            session.setAttribute("ClassInfo.KeepConflictingAssignments", (Object)(this.iKeepConflictingAssignments ? "true" : "false"));
        }
        if (this.iFilter == null) {
            session.removeAttribute("ClassInfo.Filter");
        } else {
            session.setAttribute("ClassInfo.Filter", (Object)this.iFilter);
        }
        if (this.iRoomTypes == null) {
            session.removeAttribute("ClassInfo.RoomTypes");
        } else {
            session.setAttribute("ClassInfo.RoomTypes", (Object)this.iRoomTypes);
        }
        if (this.iRoomGroups == null) {
            session.removeAttribute("ClassInfo.RoomGroups");
        } else {
            session.setAttribute("ClassInfo.RoomGroups", (Object)this.iRoomGroups);
        }
        if (this.iRoomFeatures == null) {
            session.removeAttribute("ClassInfo.RoomFeatures");
        } else {
            session.setAttribute("ClassInfo.RoomFeatures", (Object)this.iRoomFeatures);
        }
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public ClassInfoModel getModel() {
        return this.iModel;
    }

    public void setModel(ClassInfoModel model) {
        this.iModel = model;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getMinRoomSize() {
        return this.iMinRoomSize;
    }

    public void setMinRoomSize(String minRoomSize) {
        this.iMinRoomSize = minRoomSize;
    }

    public String getMaxRoomSize() {
        return this.iMaxRoomSize;
    }

    public void setMaxRoomSize(String maxRoomSize) {
        this.iMaxRoomSize = maxRoomSize;
    }

    public String getRoomFilter() {
        return this.iRoomFilter;
    }

    public void setRoomFilter(String roomFilter) {
        this.iRoomFilter = roomFilter;
    }

    public boolean getAllowRoomConflict() {
        return this.iAllowRoomConflict;
    }

    public void setAllowRoomConflict(boolean allowRoomConflict) {
        this.iAllowRoomConflict = allowRoomConflict;
    }

    public String getRoomBase() {
        return this.iRoomBase == null ? RoomBase.Departmental.name() : this.iRoomBase.name();
    }

    public RoomBase getRoomBaseEnum() {
        return this.iRoomBase == null ? RoomBase.Departmental : this.iRoomBase;
    }

    public RoomBase[] getRoomBases() {
        return RoomBase.values();
    }

    public void setRoomBase(String base) {
        this.iRoomBase = base == null || base.isEmpty() ? RoomBase.Departmental : RoomBase.valueOf(base);
    }

    public String getRoomOrder() {
        return this.iRoomOrder;
    }

    public void setRoomOrder(String ord) {
        this.iRoomOrder = ord;
    }

    public String[] getRoomOrders() {
        return new String[]{MSG.sortRoomNameAsc(), MSG.sortRoomNameDesc(), MSG.sortRoomSizeAsc(), MSG.sortRoomSizeDesc()};
    }

    public String getFilter() {
        return this.iFilter;
    }

    public void setFilter(String filter) {
        this.iFilter = filter;
    }

    public boolean getKeepConflictingAssignments() {
        return this.iKeepConflictingAssignments;
    }

    public void setKeepConflictingAssignments(boolean unassignConflictingAssignments) {
        this.iKeepConflictingAssignments = unassignConflictingAssignments;
    }

    public Long[] getRoomTypes() {
        return this.iRoomTypes;
    }

    public void setRoomTypes(Long[] rts) {
        this.iRoomTypes = rts;
    }

    public Long[] getRoomGroups() {
        return this.iRoomGroups;
    }

    public void setRoomGroups(Long[] rgs) {
        this.iRoomGroups = rgs;
    }

    public Long[] getRoomFeatures() {
        return this.iRoomFeatures;
    }

    public void setRoomFeatures(Long[] rfs) {
        this.iRoomFeatures = rfs;
    }

    public Collection<RoomFeatureType> getRoomFeatureTypes() {
        Set<RoomFeatureType> types = RoomFeatureType.getRoomFeatureTypes(this.iSessionId, false);
        if (RoomFeatureType.hasRoomFeatureWithNoType(this.iSessionId, false)) {
            RoomFeatureType f = new RoomFeatureType();
            f.setUniqueId(-1L);
            f.setReference("Features");
            f.setLabel(MSG.labelRoomfeatures());
            types.add(f);
        }
        return types;
    }

    public Collection<GlobalRoomFeature> getAllRoomFeatures(String featureType) {
        return RoomFeature.getAllGlobalRoomFeatures(this.iSessionId, featureType == null || featureType.isEmpty() ? null : Long.valueOf(featureType));
    }

    public Collection<RoomGroup> getAllRoomGroups() {
        return RoomGroup.getAllGlobalRoomGroups(this.iSessionId);
    }

    public Collection<RoomType> getAllRoomTypes() {
        return RoomType.findAll(this.iSessionId);
    }

    public void setSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public static enum RoomBase {
        Departmental,
        Timetabling,
        All;


        public String getValue() {
            return this.name();
        }

        public String getLabel() {
            switch (this) {
                case Departmental: {
                    return MSG.roomTypeDepartmental();
                }
                case Timetabling: {
                    return MSG.roomTypeTimetabling();
                }
                case All: {
                    return MSG.roomTypeAll();
                }
            }
            return this.name();
        }
    }
}

