/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DistributionSampler {
    protected final Bucket[] buckets;
    protected long min_value = Integer.MAX_VALUE;
    protected long max_value;
    protected boolean exception_on_missing_bucket = true;

    public DistributionSampler(long ... buckets) {
        int i;
        if (buckets.length < 2) {
            throw new IllegalArgumentException("at least 2 numbers are required to create one bucket");
        }
        DistributionSampler.sanityCheck(buckets);
        long prev_value = -1L;
        ArrayList<Bucket> list = new ArrayList<Bucket>(buckets.length);
        for (i = 0; i < buckets.length; ++i) {
            if (prev_value < 0L) {
                prev_value = buckets[i];
                continue;
            }
            long min = prev_value;
            long max = buckets[i];
            Bucket b = new Bucket(min, max);
            list.add(b);
            prev_value = max + 1L;
            this.min_value = Math.min(min, this.min_value);
            this.max_value = Math.max(max, this.max_value);
        }
        this.buckets = new Bucket[list.size()];
        for (i = 0; i < list.size(); ++i) {
            this.buckets[i] = (Bucket)list.get(i);
        }
    }

    public DistributionSampler(List<Long> buckets) {
        this(DistributionSampler.listToArray(buckets));
    }

    public long minValue() {
        return this.min_value;
    }

    public long maxValue() {
        return this.max_value;
    }

    public Bucket[] buckets() {
        return this.buckets;
    }

    public boolean exceptionOnMissingBucket() {
        return this.exception_on_missing_bucket;
    }

    public DistributionSampler exceptionOnMissingBucket(boolean b) {
        this.exception_on_missing_bucket = b;
        return this;
    }

    public DistributionSampler add(long value) {
        Bucket b = this.getBucket(value);
        if (b != null) {
            b.increment();
        }
        return this;
    }

    public DistributionSampler reset() {
        Stream.of(this.buckets).forEach(Bucket::reset);
        return this;
    }

    public long total() {
        long ret = 0L;
        for (Bucket b : this.buckets) {
            ret += b.count();
        }
        return ret;
    }

    public int size() {
        return this.buckets.length;
    }

    public String toString() {
        return Stream.of(this.buckets).map(Bucket::toString).collect(Collectors.joining("\n"));
    }

    protected Bucket getBucket(long value) {
        if (value < this.min_value || value > this.max_value) {
            if (this.exception_on_missing_bucket) {
                throw new IllegalArgumentException(String.format("value %,d out of range (min: %,d max: %,d)", value, this.min_value, this.max_value));
            }
            return null;
        }
        return this.binarySearch(0, this.buckets.length, value);
    }

    protected Bucket binarySearch(int from, int to, long value) {
        int index = (from + to) / 2;
        Bucket b = this.buckets[index];
        if (value >= b.min && value <= b.max) {
            return b;
        }
        if (value > b.max) {
            return this.binarySearch(index + 1, to, value);
        }
        return this.binarySearch(from, index - 1, value);
    }

    protected static long[] listToArray(List<Long> buckets) {
        long[] tmp = new long[buckets.size()];
        for (int i = 0; i < buckets.size(); ++i) {
            tmp[i] = buckets.get(i);
        }
        return tmp;
    }

    protected static void sanityCheck(long ... buckets) {
        long prev_value = -1L;
        for (long i : buckets) {
            if (prev_value >= 0L && i <= prev_value) {
                throw new IllegalArgumentException("values must be in increasing order");
            }
            prev_value = i;
        }
    }

    public static class Bucket {
        protected long min;
        protected long max;
        protected final LongAdder count = new LongAdder();

        public Bucket(long min, long max) {
            this.min = min;
            this.max = max;
        }

        public long count() {
            return this.count.sum();
        }

        public void increment() {
            this.count.increment();
        }

        public void reset() {
            this.count.reset();
        }

        public String toString() {
            return String.format("[%,d .. %,d]: %,d", this.min, this.max, this.count.sum());
        }
    }
}

