/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics;

import java.util.ArrayList;
import java.util.List;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.heuristics.StudentSctNeighbourSelection;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class TwoPhaseStudentSctNeighbourSelection
extends StudentSctNeighbourSelection {
    private int iNrRounds = 7;
    List<Student> iDummyStudents = null;

    public TwoPhaseStudentSctNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
        this.iNrRounds = properties.getPropertyInt("TwoPhaseSectioning.NrRoundsFirstPhase", this.iNrRounds);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        super.init(solver);
        if (this.removeDummyStudents(solver.currentSolution())) {
            this.registerSelection(new RestoreDummyStudents());
        }
    }

    private boolean removeDummyStudents(Solution<Request, Enrollment> solution) {
        StudentSectioningModel model = (StudentSectioningModel)solution.getModel();
        if (model.getNrLastLikeStudents(false) == 0 || model.getNrRealStudents(false) == 0) {
            return false;
        }
        this.iDummyStudents = new ArrayList<Student>();
        for (Student student : new ArrayList<Student>(model.getStudents())) {
            if (!student.isDummy()) continue;
            this.iDummyStudents.add(student);
            model.removeStudent(student);
        }
        return true;
    }

    private boolean addDummyStudents(Solution<Request, Enrollment> solution) {
        if (this.iDummyStudents == null || this.iDummyStudents.isEmpty()) {
            return false;
        }
        --this.iNrRounds;
        if (this.iNrRounds > 0) {
            return false;
        }
        solution.restoreBest();
        StudentSectioningModel model = (StudentSectioningModel)solution.getModel();
        for (Student student : this.iDummyStudents) {
            model.addStudent(student);
        }
        this.iDummyStudents = null;
        solution.saveBest();
        return true;
    }

    protected class RestoreDummyStudents
    implements NeighbourSelection<Request, Enrollment> {
        @Override
        public void init(Solver<Request, Enrollment> solver) {
        }

        @Override
        public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
            TwoPhaseStudentSctNeighbourSelection.this.addDummyStudents(solution);
            return null;
        }
    }
}

