/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.util.ArrayList;
import java.util.TreeSet;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;

public class DependentCourseIssues
extends AbstractStudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public DependentCourseIssues(StudentSectioningModel model) {
        super(model);
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportCourse()), new CSVFile.CSVField((Object)MSG.colSubpart()), new CSVFile.CSVField((Object)MSG.reportClass()), new CSVFile.CSVField((Object)MSG.reportMeetingTime()), new CSVFile.CSVField((Object)MSG.reportDatePattern()), new CSVFile.CSVField((Object)MSG.colRoom()), new CSVFile.CSVField((Object)MSG.reportNotAssigned())});
        for (Student student : this.getModel().getStudents()) {
            for (Request request : student.getRequests()) {
                Enrollment enrollment = (Enrollment)assignment.getValue((Variable)request);
                if (enrollment == null || !enrollment.isCourseRequest() || !enrollment.getCourse().hasParent() || !this.matches(request, enrollment)) continue;
                Course parent = enrollment.getCourse().getParent();
                for (Request otherRequest : student.getRequests()) {
                    Enrollment e;
                    if (!otherRequest.hasCourse(parent) || (e = (Enrollment)assignment.getValue((Variable)otherRequest)) != null && e.getCourse() != null && parent.equals((Object)e.getCourse())) continue;
                    ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                    line.add(new CSVFile.CSVField(student.getId()));
                    line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                    line.add(new CSVFile.CSVField((Object)student.getName()));
                    line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                    line.add(new CSVFile.CSVField((Object)this.group(student)));
                    line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                    line.add(new CSVFile.CSVField((Object)enrollment.getCourse().getName()));
                    Object type = "";
                    Object section = "";
                    Object time = "";
                    Object room = "";
                    Object date = "";
                    for (Section s : enrollment.getSections()) {
                        type = (String)type + (((String)type).isEmpty() ? "" : "\n") + (s.getSubpart().getName() == null ? s.getSubpart().getInstructionalType() : s.getSubpart().getName());
                        section = (String)section + (((String)section).isEmpty() ? "" : "\n") + s.getName(enrollment.getCourse().getId());
                        time = (String)time + (((String)time).isEmpty() ? "" : "\n") + (String)(s.getTime() == null || s.getTime().getDayCode() == 0 ? "" : s.getTime().getDayHeader() + " " + s.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + s.getTime().getEndTimeHeader(this.isUseAmPm()));
                        date = (String)date + (((String)date).isEmpty() ? "" : "\n") + (s.getTime() == null || s.getTime().getDatePatternName() == null ? "" : s.getTime().getDatePatternName());
                        room = (String)room + (((String)room).isEmpty() ? "" : "\n") + this.rooms((SctAssignment)s);
                    }
                    line.add(new CSVFile.CSVField(type));
                    line.add(new CSVFile.CSVField(section));
                    line.add(new CSVFile.CSVField(time));
                    line.add(new CSVFile.CSVField(date));
                    line.add(new CSVFile.CSVField(room));
                    line.add(new CSVFile.CSVField((Object)parent.getName()));
                    csv.addLine(line);
                }
            }
        }
        return csv;
    }

    protected String rooms(SctAssignment section) {
        if (section.getNrRooms() == 0) {
            return "";
        }
        Object ret = "";
        for (RoomLocation r : section.getRooms()) {
            ret = (String)ret + (((String)ret).isEmpty() ? "" : ",\n") + r.getName();
        }
        return ret;
    }

    protected String curriculum(Student student) {
        Object curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = (String)curriculum + (((String)curriculum).isEmpty() ? "" : ",\n") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        Object group = "";
        TreeSet<String> groups = new TreeSet<String>();
        for (StudentGroup studentGroup : student.getGroups()) {
            groups.add(studentGroup.getReference());
        }
        for (String string : groups) {
            group = (String)group + (((String)group).isEmpty() ? "" : ",\n") + string;
        }
        return group;
    }

    protected String advisor(Student student) {
        Object advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = (String)advisors + (((String)advisors).isEmpty() ? "" : ",\n") + instructor.getName();
        }
        return advisors;
    }
}

