/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.comparators;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.solver.ClassAssignmentProxy;

public class DivSecAssignmentComparator
implements Comparator {
    private boolean iConsiderParentChildRelation = false;
    private boolean iMixConfigs = false;
    private ClassAssignmentProxy iProxy = null;

    public DivSecAssignmentComparator(ClassAssignmentProxy proxy, boolean considerParentChildRelation, boolean mixConfigs) {
        this.iProxy = proxy;
        this.iConsiderParentChildRelation = considerParentChildRelation;
        this.iMixConfigs = mixConfigs;
    }

    public int compare(Object o1, Object o2) {
        Assignment a2;
        Class_ c2;
        Class_ c1 = o1 instanceof Assignment ? ((Assignment)o1).getClazz() : (Class_)o1;
        int cmp = this.compareClasses(c1, c2 = o2 instanceof Assignment ? ((Assignment)o2).getClazz() : (Class_)o2);
        if (cmp != 0) {
            return cmp;
        }
        Assignment a1 = o1 instanceof Assignment ? (Assignment)o1 : null;
        Assignment assignment = a2 = o2 instanceof Assignment ? (Assignment)o2 : null;
        if (a1 == null) {
            return a2 == null ? c1.getSectionNumber().compareTo(c2.getSectionNumber()) : 1;
        }
        if (a2 == null) {
            return -1;
        }
        return this.compareAssignments(a1, a2);
    }

    public int compareAssignments(Assignment a1, Assignment a2) {
        int cmp = this.comparePlacements(a1.getClazz(), a2.getClazz(), a1.getPlacement(), a2.getPlacement());
        if (cmp != 0) {
            return cmp;
        }
        cmp = a1.getClazz().getSectionNumber().compareTo(a2.getClazz().getSectionNumber());
        if (cmp != 0) {
            return cmp;
        }
        return a1.getUniqueId().compareTo(a2.getUniqueId());
    }

    public int comparePlacements(Class_ c1, Class_ c2, Placement p1, Placement p2) {
        int cmp = this.compareTimeLocations(c1, c2, p1.getTimeLocation(), p2.getTimeLocation());
        if (cmp != 0) {
            return cmp;
        }
        if (this.iMixConfigs) {
            cmp = this.compareInstrOfferingConfigs(c1.getSchedulingSubpart().getInstrOfferingConfig(), c2.getSchedulingSubpart().getInstrOfferingConfig());
            if (cmp != 0) {
                return cmp;
            }
            return cmp;
        }
        return 0;
    }

    public int compareRoomLocations(Vector rv1, Vector rv2) {
        if (rv1.isEmpty()) {
            return rv2.isEmpty() ? 0 : -1;
        }
        if (rv2.isEmpty()) {
            return 1;
        }
        if (rv1.size() > 1) {
            Collections.sort(rv1);
        }
        if (rv2.size() > 1) {
            Collections.sort(rv2);
        }
        int min = Math.min(rv1.size(), rv2.size());
        for (int i = 0; i < min; ++i) {
            int cmp = this.compareRoomLocations((RoomLocation)rv1.elementAt(i), (RoomLocation)rv2.elementAt(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Double.compare(rv1.size(), rv2.size());
    }

    public int compareRoomLocations(RoomLocation r1, RoomLocation r2) {
        int cmp = r1.getName().compareTo(r2.getName());
        if (cmp != 0) {
            return cmp;
        }
        return r1.getId().compareTo(r2.getId());
    }

    public int compareTimeLocations(Class_ c1, Class_ c2, TimeLocation t1, TimeLocation t2) {
        int cmp = ((Integer)t1.getStartSlots().nextElement()).compareTo((Integer)t2.getStartSlots().nextElement());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Double.compare(t1.getDayCode(), t2.getDayCode());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Double.compare(t1.getLength(), t2.getLength());
        if (cmp != 0) {
            return cmp;
        }
        cmp = ((TimePattern)TimePatternDAO.getInstance().get(t1.getTimePatternId())).compareTo((TimePattern)TimePatternDAO.getInstance().get(t2.getTimePatternId()));
        if (cmp != 0) {
            return cmp;
        }
        cmp = ((DatePattern)DatePatternDAO.getInstance().get(t1.getDatePatternId())).compareTo((DatePattern)DatePatternDAO.getInstance().get(t2.getDatePatternId()));
        if (cmp != 0) {
            return cmp;
        }
        cmp = t1.getLongName(false).compareTo(t2.getLongName(false));
        if (cmp != 0) {
            return cmp;
        }
        if (c1.getSchedulingSubpart().equals(c2.getSchedulingSubpart()) && c1.getChildClasses().size() == 1 && c2.getChildClasses().size() == 1) {
            Class_ cc1 = c1.getChildClasses().iterator().next();
            Class_ cc2 = c2.getChildClasses().iterator().next();
            if (this.iConsiderParentChildRelation || cc1.getSchedulingSubpart().getItype().equals(c1.getSchedulingSubpart().getItype())) {
                ClassAssignmentProxy.AssignmentInfo a1 = null;
                try {
                    a1 = this.iProxy.getAssignment(cc1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ClassAssignmentProxy.AssignmentInfo a2 = null;
                try {
                    a2 = this.iProxy.getAssignment(cc2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (a1 == null || a2 == null) {
                    if (cc1.getSchedulingSubpart().getItype().equals(c1.getSchedulingSubpart().getItype())) {
                        return c1.getUniqueId().compareTo(c2.getUniqueId());
                    }
                } else {
                    return this.compareTimeLocations(cc1, cc2, a1.getTimeLocation(), a2.getTimeLocation());
                }
            }
        }
        return 0;
    }

    public int compareClasses(Class_ c1, Class_ c2) {
        int cmp;
        if (this.iConsiderParentChildRelation && c1.getSchedulingSubpart().equals(c2.getSchedulingSubpart()) && (cmp = this.compareParentClasses(c1.getParentClass(), c2.getParentClass())) != 0) {
            return cmp;
        }
        return this.compareSchedulingSubparts(c1.getSchedulingSubpart(), c2.getSchedulingSubpart());
    }

    public int compareParentClasses(Class_ c1, Class_ c2) {
        if (c1 == null || c2 == null) {
            return 0;
        }
        int cmp = this.compareParentClasses(c1.getParentClass(), c2.getParentClass());
        if (cmp != 0) {
            return cmp;
        }
        if (c1.getDivSecNumber() != null && c2.getDivSecNumber() != null && (cmp = c1.getDivSecNumber().compareTo(c2.getDivSecNumber())) != 0) {
            return cmp;
        }
        ClassAssignmentProxy.AssignmentInfo a1 = null;
        try {
            a1 = this.iProxy.getAssignment(c1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ClassAssignmentProxy.AssignmentInfo a2 = null;
        try {
            a2 = this.iProxy.getAssignment(c2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (a1 != null && a2 != null && (cmp = this.comparePlacements(c1, c2, a1.getPlacement(), a2.getPlacement())) != 0) {
            return cmp;
        }
        return c1.getUniqueId().compareTo(c2.getUniqueId());
    }

    public boolean isParent(SchedulingSubpart s1, SchedulingSubpart s2) {
        SchedulingSubpart p2 = s2.getParentSubpart();
        if (p2 == null) {
            return false;
        }
        if (p2.equals(s1)) {
            return true;
        }
        return this.isParent(s1, p2);
    }

    public int compareSchedulingSubparts(SchedulingSubpart s1, SchedulingSubpart s2) {
        if (s1.equals(s2)) {
            return 0;
        }
        if (this.iMixConfigs) {
            int cmp = this.compareInstructionalOfferings(s1.getInstrOfferingConfig().getInstructionalOffering(), s2.getInstrOfferingConfig().getInstructionalOffering());
            if (cmp != 0) {
                return cmp;
            }
            if (this.isParent(s1, s2)) {
                return -1;
            }
            if (this.isParent(s2, s1)) {
                return 1;
            }
            cmp = s1.getItype().getItype().compareTo(s2.getItype().getItype());
            if (cmp != 0) {
                return cmp;
            }
            return 0;
        }
        int cmp = this.compareInstrOfferingConfigs(s1.getInstrOfferingConfig(), s2.getInstrOfferingConfig());
        if (cmp != 0) {
            return cmp;
        }
        if (this.isParent(s1, s2)) {
            return -1;
        }
        if (this.isParent(s2, s1)) {
            return 1;
        }
        cmp = s1.getItype().getItype().compareTo(s2.getItype().getItype());
        if (cmp != 0) {
            return cmp;
        }
        return s1.getUniqueId().compareTo(s2.getUniqueId());
    }

    public int compareInstrOfferingConfigs(InstrOfferingConfig c1, InstrOfferingConfig c2) {
        if (c1.equals(c2)) {
            return 0;
        }
        int cmp = this.compareInstructionalOfferings(c1.getInstructionalOffering(), c2.getInstructionalOffering());
        if (cmp != 0) {
            return cmp;
        }
        return c1.getUniqueId().compareTo(c2.getUniqueId());
    }

    public int compareInstructionalOfferings(InstructionalOffering o1, InstructionalOffering o2) {
        int cmp = o1.getCourseName().compareTo(o2.getCourseName());
        if (cmp != 0) {
            return cmp;
        }
        return o1.getUniqueId().compareTo(o2.getUniqueId());
    }
}

