/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeatureType;

@MappedSuperclass
public abstract class BaseRoomFeature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iLabel;
    private String iAbbv;
    private String iDescription;
    private RoomFeatureType iFeatureType;
    private Set<Location> iRooms;

    public BaseRoomFeature() {
    }

    public BaseRoomFeature(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="room_feature_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="label", nullable=false, length=60)
    public String getLabel() {
        return this.iLabel;
    }

    public void setLabel(String label) {
        this.iLabel = label;
    }

    @Column(name="abbv", nullable=true, length=60)
    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    @Column(name="description", nullable=true, length=1000)
    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="feature_type_id", nullable=true)
    public RoomFeatureType getFeatureType() {
        return this.iFeatureType;
    }

    public void setFeatureType(RoomFeatureType featureType) {
        this.iFeatureType = featureType;
    }

    @ManyToMany(mappedBy="features")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Location> getRooms() {
        return this.iRooms;
    }

    public void setRooms(Set<Location> rooms) {
        this.iRooms = rooms;
    }

    public void addToRooms(Location location) {
        if (this.iRooms == null) {
            this.iRooms = new HashSet<Location>();
        }
        this.iRooms.add(location);
    }

    @Deprecated
    public void addTorooms(Location location) {
        this.addToRooms(location);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RoomFeature)) {
            return false;
        }
        if (this.getUniqueId() == null || ((RoomFeature)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((RoomFeature)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "RoomFeature[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    public String toDebugString() {
        return "RoomFeature[\n\tAbbv: " + this.getAbbv() + "\n\tDescription: " + this.getDescription() + "\n\tFeatureType: " + String.valueOf(this.getFeatureType()) + "\n\tLabel: " + this.getLabel() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

