/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import java.util.Date;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.model.base.BaseOverrideReservation;

@Entity
@DiscriminatorValue(value="4")
public class OverrideReservation
extends BaseOverrideReservation {
    private static final long serialVersionUID = 1L;

    @Transient
    public ReservationInterface.OverrideType getOverrideType() {
        return this.getType() == null ? null : ReservationInterface.OverrideType.values()[this.getType()];
    }

    public void setOverrideType(ReservationInterface.OverrideType type) {
        this.setType(type == null ? null : Integer.valueOf(type.ordinal()));
    }

    @Override
    @Transient
    public boolean isExpired() {
        ReservationInterface.OverrideType type = this.getOverrideType();
        return type == null || type.isCanHaveExpirationDate() ? super.isExpired() : type.isExpired().booleanValue();
    }

    @Override
    @Transient
    public Date getStartDate() {
        ReservationInterface.OverrideType type = this.getOverrideType();
        return type == null || type.isCanHaveExpirationDate() ? super.getStartDate() : null;
    }

    @Override
    @Transient
    public Date getExpirationDate() {
        ReservationInterface.OverrideType type = this.getOverrideType();
        return type == null || type.isCanHaveExpirationDate() ? super.getExpirationDate() : null;
    }

    @Override
    @Transient
    public int getPriority() {
        return ApplicationProperty.ReservationPriorityOverride.intValue();
    }

    @Override
    @Transient
    public boolean isCanAssignOverLimit() {
        ReservationInterface.OverrideType type = this.getOverrideType();
        return type != null && type.isAllowOverLimit();
    }

    @Override
    @Transient
    public boolean isMustBeUsed() {
        ReservationInterface.OverrideType type = this.getOverrideType();
        return type != null && type.isMustBeUsed();
    }

    @Override
    @Transient
    public boolean isAllowOverlap() {
        ReservationInterface.OverrideType type = this.getOverrideType();
        return type != null && type.isAllowTimeConflict();
    }

    @Override
    @Transient
    public boolean isAlwaysExpired() {
        ReservationInterface.OverrideType type = this.getOverrideType();
        return type != null && !type.isCanHaveExpirationDate();
    }
}

