/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor.survey;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyCourseTable;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyInterface;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.rooms.RoomSharingWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class InstructorSurveyPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    protected static DateTimeFormat sTimeStampFormat = DateTimeFormat.getFormat((String)CONSTANTS.timeStampFormat());
    private SimpleForm iPanel = new SimpleForm(3);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private UniTimeTextBox iEmail;
    private InstructorTimePreferences iTimePrefs;
    private List<PreferencesTable> iRoomPrefs;
    private PreferencesTable iDistPrefs;
    private Note iPrefsNote;
    private InstructorSurveyCourseTable iCourses;
    private InstructorSurveyInterface.InstructorSurveyData iSurvey;
    private InstructorSurveyInterface.InstructorSurveyData iOriginal;
    private ListBox iSessionSelection;

    public InstructorSurveyPage() {
        this.iPanel.addStyleName("unitime-InstructorSurveyPage");
        this.load(Window.Location.getParameter((String)"id"), Window.Location.getParameter((String)"session"));
        this.initWidget((Widget)this.iPanel);
        Window.addWindowClosingHandler((Window.ClosingHandler)new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                if (InstructorSurveyPage.this.isChanged()) {
                    if (LoadingWidget.getInstance().isShowing()) {
                        LoadingWidget.getInstance().hide();
                    }
                    event.setMessage(MESSAGES.queryLeaveChangesOnYourInstructorSurvey());
                }
            }
        });
    }

    protected void load(String externalId, String session) {
        LoadingWidget.showLoading(MESSAGES.waitLoadingPage());
        RPC.execute(new InstructorSurveyInterface.InstructorSurveyRequest(externalId, session), new AsyncCallback<InstructorSurveyInterface.InstructorSurveyData>(){

            public void onFailure(Throwable t) {
                LoadingWidget.hideLoading();
                UniTimeNotifications.error(MESSAGES.failedToLoadPage(t.getMessage()), t);
                ToolBox.checkAccess(t);
                InstructorSurveyPage.this.iPanel.clear();
                InstructorSurveyPage.this.iHeader = new UniTimeHeaderPanel("");
                InstructorSurveyPage.this.iHeader.setErrorMessage(t.getMessage());
                InstructorSurveyPage.this.iPanel.addRow((Widget)InstructorSurveyPage.this.iHeader);
            }

            public void onSuccess(InstructorSurveyInterface.InstructorSurveyData survey) {
                InstructorSurveyPage.this.setValue(survey);
                LoadingWidget.hideLoading();
            }
        });
    }

    public boolean isChanged() {
        return this.iOriginal != null && this.iOriginal.isEditable() && this.iOriginal.isChanged(this.getValue());
    }

    public void setValue(InstructorSurveyInterface.InstructorSurveyData survey) {
        this.iSurvey = survey;
        this.iOriginal = new InstructorSurveyInterface.InstructorSurveyData(survey);
        this.iPanel.clear();
        this.iHeader = new UniTimeHeaderPanel(survey.getFormattedName());
        this.iHeader.addButton("copy", MESSAGES.buttonCopyInstructorSurvey(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                MenuItem item;
                MenuBar submenu;
                final PopupPanel popup = new PopupPanel(true);
                UniTimeTableHeader.MenuBarWithAccessKeys menu = new UniTimeTableHeader.MenuBarWithAccessKeys();
                if (InstructorSurveyPage.this.iSurvey.hasSessionsWithPreferences()) {
                    submenu = new MenuBar(true);
                    for (final AcademicSessionProvider.AcademicSessionInfo s : InstructorSurveyPage.this.iSurvey.getSessionsWithPreferences()) {
                        submenu.addItem(new MenuItem(s.getName(), new Scheduler.ScheduledCommand(){

                            public void execute() {
                                popup.hide();
                                InstructorSurveyPage.this.iHeader.clearMessage();
                                final InstructorSurveyInterface.InstructorSurveyData original = InstructorSurveyPage.this.iOriginal;
                                LoadingWidget.showLoading(MESSAGES.waitUpdatingInstructorSurvey());
                                RPC.execute(new InstructorSurveyInterface.InstructorSurveyCopyRequest(InstructorSurveyPage.this.getValue(), s.getSessionId(), null), new AsyncCallback<InstructorSurveyInterface.InstructorSurveyData>(){

                                    public void onFailure(Throwable caught) {
                                        LoadingWidget.hideLoading();
                                        UniTimeNotifications.error(caught.getMessage());
                                        InstructorSurveyPage.this.iHeader.setErrorMessage(caught.getMessage());
                                    }

                                    public void onSuccess(InstructorSurveyInterface.InstructorSurveyData result) {
                                        LoadingWidget.hideLoading();
                                        InstructorSurveyPage.this.setValue(result);
                                        InstructorSurveyPage.this.iOriginal = original;
                                    }
                                });
                            }
                        }));
                    }
                    item = new MenuItem(MESSAGES.opCopyPreferencesRequirements(), true, submenu);
                    item.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    menu.addItem(item);
                }
                if (InstructorSurveyPage.this.iSurvey.hasSessionsWithCourses()) {
                    submenu = new MenuBar(true);
                    for (final AcademicSessionProvider.AcademicSessionInfo s : InstructorSurveyPage.this.iSurvey.getSessionsWithCourses()) {
                        submenu.addItem(new MenuItem(s.getName(), new Scheduler.ScheduledCommand(){

                            public void execute() {
                                popup.hide();
                                InstructorSurveyPage.this.iHeader.clearMessage();
                                final InstructorSurveyInterface.InstructorSurveyData original = InstructorSurveyPage.this.iOriginal;
                                LoadingWidget.showLoading(MESSAGES.waitUpdatingInstructorSurvey());
                                RPC.execute(new InstructorSurveyInterface.InstructorSurveyCopyRequest(InstructorSurveyPage.this.getValue(), null, s.getSessionId()), new AsyncCallback<InstructorSurveyInterface.InstructorSurveyData>(){

                                    public void onFailure(Throwable caught) {
                                        LoadingWidget.hideLoading();
                                        UniTimeNotifications.error(caught.getMessage());
                                        InstructorSurveyPage.this.iHeader.setErrorMessage(caught.getMessage());
                                    }

                                    public void onSuccess(InstructorSurveyInterface.InstructorSurveyData result) {
                                        LoadingWidget.hideLoading();
                                        InstructorSurveyPage.this.setValue(result);
                                        InstructorSurveyPage.this.iOriginal = original;
                                    }
                                });
                            }
                        }));
                    }
                    item = new MenuItem(MESSAGES.opCopyCourseRequirements(), true, submenu);
                    item.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    menu.addItem(item);
                }
                menu.setVisible(true);
                popup.add((Widget)menu);
                popup.showRelativeTo((UIObject)event.getSource());
                menu.focus();
            }
        });
        this.iHeader.addButton("save", MESSAGES.buttonSaveInstructorSurvey(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                InstructorSurveyPage.this.iHeader.clearMessage();
                LoadingWidget.showLoading(MESSAGES.waitSavingInstructorSurvey());
                RPC.execute(new InstructorSurveyInterface.InstructorSurveySaveRequest(InstructorSurveyPage.this.getValue(), false), new AsyncCallback<InstructorSurveyInterface.InstructorSurveyData>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.hideLoading();
                        UniTimeNotifications.error(caught.getMessage());
                        InstructorSurveyPage.this.iHeader.setErrorMessage(caught.getMessage());
                    }

                    public void onSuccess(InstructorSurveyInterface.InstructorSurveyData result) {
                        LoadingWidget.hideLoading();
                        UniTimeNotifications.info(MESSAGES.infoInstructorSurveyUpdated());
                        InstructorSurveyPage.this.setValue(result);
                        if (ToolBox.hasParent()) {
                            ToolBox.closeWindow();
                        }
                        if (result.hasPopupMessage()) {
                            if (result.isPopupWarning()) {
                                UniTimeNotifications.warn(result.getPopupMessage());
                            } else {
                                UniTimeNotifications.info(result.getPopupMessage());
                            }
                        }
                    }
                });
            }
        });
        this.iHeader.addButton("submit", MESSAGES.buttonSubmitInstructorSurvey(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                InstructorSurveyPage.this.iHeader.clearMessage();
                UniTimeConfirmationDialog.confirm(MESSAGES.questionSubmitInstructorSurvey(), new Command(){

                    public void execute() {
                        LoadingWidget.showLoading(MESSAGES.waitSubmittingInstructorSurvey());
                        RPC.execute(new InstructorSurveyInterface.InstructorSurveySaveRequest(InstructorSurveyPage.this.getValue(), true), new AsyncCallback<InstructorSurveyInterface.InstructorSurveyData>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.hideLoading();
                                UniTimeNotifications.error(caught.getMessage());
                                InstructorSurveyPage.this.iHeader.setErrorMessage(caught.getMessage());
                            }

                            public void onSuccess(InstructorSurveyInterface.InstructorSurveyData result) {
                                LoadingWidget.hideLoading();
                                UniTimeNotifications.info(MESSAGES.infoInstructorSurveyUpdated());
                                InstructorSurveyPage.this.setValue(result);
                                if (ToolBox.hasParent()) {
                                    ToolBox.closeWindow();
                                }
                                if (result.hasPopupMessage()) {
                                    if (result.isPopupWarning()) {
                                        UniTimeNotifications.warn(result.getPopupMessage());
                                    } else {
                                        UniTimeNotifications.info(result.getPopupMessage());
                                    }
                                }
                                if (result.hasPopupMessage()) {
                                    if (result.isPopupWarning()) {
                                        UniTimeNotifications.warn(result.getPopupMessage());
                                    } else {
                                        UniTimeNotifications.info(result.getPopupMessage());
                                    }
                                }
                            }
                        });
                    }
                });
            }
        });
        this.iHeader.addButton("unsubmit", MESSAGES.buttonUnsubmitInstructorSurvey(), new ClickHandler(){

            public void onClick(ClickEvent e) {
                InstructorSurveyPage.this.iHeader.clearMessage();
                UniTimeConfirmationDialog.confirm(MESSAGES.questionUnsubmitInstructorSurvey(), new Command(){

                    public void execute() {
                        LoadingWidget.showLoading(MESSAGES.waitUpdatingInstructorSurvey());
                        InstructorSurveyInterface.InstructorSurveySaveRequest req = new InstructorSurveyInterface.InstructorSurveySaveRequest(InstructorSurveyPage.this.getValue(), false);
                        req.setUnsubmit(true);
                        RPC.execute(req, new AsyncCallback<InstructorSurveyInterface.InstructorSurveyData>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.hideLoading();
                                UniTimeNotifications.error(caught.getMessage());
                                InstructorSurveyPage.this.iHeader.setErrorMessage(caught.getMessage());
                            }

                            public void onSuccess(InstructorSurveyInterface.InstructorSurveyData result) {
                                LoadingWidget.hideLoading();
                                UniTimeNotifications.info(MESSAGES.infoInstructorSurveyUpdated());
                                InstructorSurveyPage.this.setValue(result);
                                if (ToolBox.hasParent()) {
                                    ToolBox.closeWindow();
                                }
                                if (result.hasPopupMessage()) {
                                    if (result.isPopupWarning()) {
                                        UniTimeNotifications.warn(result.getPopupMessage());
                                    } else {
                                        UniTimeNotifications.info(result.getPopupMessage());
                                    }
                                }
                                if (result.hasPopupMessage()) {
                                    if (result.isPopupWarning()) {
                                        UniTimeNotifications.warn(result.getPopupMessage());
                                    } else {
                                        UniTimeNotifications.info(result.getPopupMessage());
                                    }
                                }
                            }
                        });
                    }
                });
            }
        });
        this.iHeader.setEnabled("unsubmit", false);
        if (ToolBox.hasParent() || "hide".equals(Window.Location.getParameter((String)"menu"))) {
            this.iHeader.addButton("close", MESSAGES.buttonCloseInstructorSurvey(), new ClickHandler(){

                public void onClick(ClickEvent e) {
                    if (InstructorSurveyPage.this.isChanged()) {
                        if (LoadingWidget.getInstance().isShowing()) {
                            LoadingWidget.getInstance().hide();
                        }
                        UniTimeConfirmationDialog.confirm(MESSAGES.queryLeaveChangesOnInstructorSurvey(), new Command(){

                            public void execute() {
                                ToolBox.closeWindow();
                            }
                        });
                    } else {
                        ToolBox.closeWindow();
                    }
                }
            });
        }
        this.iHeader.setEnabled("save", this.iSurvey.isEditable());
        this.iHeader.setEnabled("submit", this.iSurvey.isEditable());
        this.iHeader.setEnabled("unsubmit", survey.isEditable() && survey.isAdmin() && survey.getSubmitted() != null);
        this.iHeader.setEnabled("copy", this.iSurvey.isEditable() && (this.iSurvey.hasSessionsWithPreferences() || this.iSurvey.hasSessionsWithCourses()));
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        this.iPanel.addRow(MESSAGES.propExternalId(), (Widget)new Label(survey.getExternalId()));
        if (survey.hasSessions()) {
            this.iSessionSelection = new ListBox();
            for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : survey.getSessions()) {
                this.iSessionSelection.addItem(academicSessionInfo.getName(), academicSessionInfo.getSessionId().toString());
                if (!survey.getSessionId().equals(academicSessionInfo.getSessionId())) continue;
                this.iSessionSelection.setSelectedIndex(this.iSessionSelection.getItemCount() - 1);
                UniTimePageHeader.getInstance().getRight().setText(academicSessionInfo.getName());
                UniTimePageHeader.getInstance().getRight().setInfo(null);
            }
            if (this.iSessionSelection.getItemCount() <= 1) {
                this.iSessionSelection.setEnabled(false);
            }
            this.iSessionSelection.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    final String newSessionId = InstructorSurveyPage.this.iSessionSelection.getSelectedValue();
                    if (!newSessionId.equals(InstructorSurveyPage.this.iSurvey.getSessionId().toString())) {
                        if (InstructorSurveyPage.this.isChanged()) {
                            UniTimeConfirmationDialog d = new UniTimeConfirmationDialog(UniTimeConfirmationDialog.Type.CONFIRM, MESSAGES.queryLeaveChangesOnInstructorSurvey(), null, null, new Command(){

                                public void execute() {
                                    InstructorSurveyPage.this.load(InstructorSurveyPage.this.iSurvey.getExternalId(), newSessionId);
                                }
                            });
                            d.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                                public void onClose(CloseEvent<PopupPanel> event) {
                                    for (int i = 0; i < InstructorSurveyPage.this.iSessionSelection.getItemCount(); ++i) {
                                        if (!InstructorSurveyPage.this.iOriginal.getSessionId().toString().equals(InstructorSurveyPage.this.iSessionSelection.getValue(i))) continue;
                                        InstructorSurveyPage.this.iSessionSelection.setSelectedIndex(i);
                                        break;
                                    }
                                }
                            });
                            d.center();
                        } else {
                            InstructorSurveyPage.this.load(InstructorSurveyPage.this.iSurvey.getExternalId(), newSessionId);
                        }
                    }
                }
            });
            this.iPanel.addRow(MESSAGES.propAcademicSession(), (Widget)this.iSessionSelection);
        }
        if (survey.isEditable()) {
            this.iEmail = new UniTimeTextBox();
            this.iEmail.addStyleName("email");
            if (survey.hasEmail()) {
                this.iEmail.setText(survey.getEmail());
            }
            this.iPanel.addRow(MESSAGES.propEmail(), (Widget)this.iEmail);
        } else if (survey.hasEmail()) {
            this.iPanel.addRow(MESSAGES.propEmail(), (Widget)new Label(survey.getEmail()));
        }
        if (survey.getSubmitted() != null) {
            this.iPanel.addRow(MESSAGES.propSubmitted(), (Widget)new Label(sTimeStampFormat.format(survey.getSubmitted())));
        }
        if (survey.hasDepartments()) {
            P depts = new P("departments");
            for (InstructorSurveyInterface.InstructorDepartment dept : survey.getDepartments()) {
                String label = dept.getLabel() + (String)(dept.hasPosition() ? " (" + dept.getPosition().getLabel() + ")" : "");
                depts.add((Widget)new Label(label, false));
            }
            this.iPanel.addRow(MESSAGES.propDepartment(), (Widget)depts);
        }
        this.iPanel.addHeaderRow((Widget)new UniTimeHeaderPanel(MESSAGES.sectGeneralPreferences()));
        if (survey.getTimePrefs() != null) {
            this.iTimePrefs = new InstructorTimePreferences(survey.isEditable());
            this.iTimePrefs.setSplit(17);
            this.iTimePrefs.setModel(survey.getTimePrefs());
            this.iTimePrefs.setMode(survey.getTimePrefs().getModes().get(0), true);
            this.iTimePrefs.getReason().setEnabled(this.iSurvey.isEditable());
            this.iPanel.addRow((Widget)this.iTimePrefs.getPanel());
            if (this.iSurvey.isEditable()) {
                this.iPanel.addRow("", (Widget)this.iTimePrefs.getReason());
                this.iTimePrefs.getReason().resizeNotes();
            } else if (!this.iTimePrefs.getReason().getText().isEmpty() && survey.getTimePrefs().hasHard()) {
                this.iPanel.addRow("", (Widget)new ReadOnlyNote(this.iTimePrefs.getReason().getText()));
            }
        }
        this.iRoomPrefs = new ArrayList<PreferencesTable>();
        if (survey.hasRoomPreferences()) {
            for (InstructorSurveyInterface.Preferences preferences : survey.getRoomPreferences()) {
                if (this.iSurvey.isEditable()) {
                    PreferencesTable tab = new PreferencesTable(preferences, survey);
                    this.iRoomPrefs.add(tab);
                    this.iPanel.addRow(preferences.getType(), (Widget)tab);
                    tab.resizeNotes();
                    continue;
                }
                if (!preferences.hasSelections()) continue;
                this.iPanel.addRow(preferences.getType(), (Widget)new PreferencesReadOnlyTable(preferences, survey.getPrefLevels()));
            }
        }
        this.iDistPrefs = null;
        if (survey.hasDistributionPreferences()) {
            if (this.iSurvey.isEditable()) {
                this.iDistPrefs = new PreferencesTable(survey.getDistributionPreferences(), survey);
                this.iPanel.addRow(survey.getDistributionPreferences().getType(), (Widget)this.iDistPrefs);
                this.iDistPrefs.resizeNotes();
            } else if (survey.getDistributionPreferences().hasSelections()) {
                this.iPanel.addRow(survey.getDistributionPreferences().getType(), (Widget)new PreferencesReadOnlyTable(survey.getDistributionPreferences(), survey.getPrefLevels()));
            }
        }
        if (survey.isEditable()) {
            this.iPrefsNote = new Note();
            this.iPrefsNote.setText(survey.getNote());
            this.iPanel.addRow(MESSAGES.propOtherPreferences(), (Widget)this.iPrefsNote);
            this.iPrefsNote.resizeNotes();
        } else if (survey.hasNote()) {
            this.iPanel.addRow(MESSAGES.propOtherPreferences(), (Widget)new ReadOnlyNote(survey.getNote()));
        }
        this.iPanel.addHeaderRow((Widget)new UniTimeHeaderPanel(MESSAGES.sectCoursePreferences()));
        this.iCourses = new InstructorSurveyCourseTable(survey.getSessionId(), survey.getCustomFields(), survey.isEditable());
        if (survey.hasCourses()) {
            for (InstructorSurveyInterface.Course course : survey.getCourses()) {
                if (!survey.isEditable() && !course.hasCustomFields()) continue;
                this.iCourses.addRow(course);
            }
        }
        if (survey.isEditable()) {
            for (int i = 0; i < 2; ++i) {
                this.iCourses.addRow(new InstructorSurveyInterface.Course());
            }
        }
        int row = this.iPanel.addRow((Widget)this.iCourses);
        this.iPanel.getCellFormatter().getElement(row, 0).getStyle().setPadding(0.0, Style.Unit.PX);
        this.iFooter = this.iHeader.clonePanel("");
        this.iPanel.addBottomRow((Widget)this.iFooter);
        if (!this.iSurvey.isEditable()) {
            if (this.iSurvey.getSubmitted() != null) {
                this.iHeader.setMessage(MESSAGES.infoInstructorSurveySubmitted(sTimeStampFormat.format(this.iSurvey.getSubmitted())));
            } else {
                this.iHeader.setMessage(MESSAGES.infoInstructorSurveyNotEditable());
            }
        }
    }

    public InstructorSurveyInterface.InstructorSurveyData getValue() {
        this.iSurvey.setEmail(this.iEmail.getValue());
        if (this.iSurvey.getTimePrefs() != null) {
            this.iSurvey.getTimePrefs().setNote(this.iTimePrefs.getReason().getText());
        }
        for (PreferencesTable pt : this.iRoomPrefs) {
            pt.update();
        }
        if (this.iDistPrefs != null) {
            this.iDistPrefs.update();
        }
        this.iSurvey.setNote(this.iPrefsNote.getText());
        this.iSurvey.clearCourses();
        for (InstructorSurveyInterface.Course c : this.iCourses.getData()) {
            if (!c.hasCourseName() && !c.hasCustomFields()) continue;
            this.iSurvey.addCourse(c);
        }
        return this.iSurvey;
    }

    public static class InstructorTimePreferences
    extends RoomSharingWidget {
        Note iReason = new Note();

        public InstructorTimePreferences(boolean editable) {
            super(editable, false);
            this.iReason.addStyleName("prohibited-times-reason");
            this.iReason.setVisible(false);
            this.iReason.setHint(MESSAGES.hintProvideReasonForProhibitedTimes());
            this.addValueChangeHandler(new ValueChangeHandler<RoomInterface.RoomSharingModel>(){

                public void onValueChange(ValueChangeEvent<RoomInterface.RoomSharingModel> event) {
                    iReason.setVisible(event.getValue() != null && ((RoomInterface.RoomSharingModel)event.getValue()).countOptions(-7L) > 0);
                }
            });
        }

        public Note getReason() {
            return this.iReason;
        }

        public void setModel(InstructorSurveyInterface.InstructorTimePreferencesModel model) {
            super.setModel(model);
            this.iReason.setText(model.getNote());
            this.iReason.resizeNotes();
            this.iReason.setVisible(model.countOptions(-7L) > 0);
        }
    }

    public static class Note
    extends TextArea {
        Timer iTimer;
        private String iHint = "";

        public Note() {
            this.setStyleName("unitime-TextArea");
            this.setHeight("45px");
            this.setCharacterWidth(95);
            this.getElement().setAttribute("maxlength", "2048");
            this.iTimer = new Timer(){

                public void run() {
                    this.resizeNotes();
                }
            };
            this.addKeyPressHandler(new KeyPressHandler(){

                public void onKeyPress(KeyPressEvent event) {
                    iTimer.schedule(10);
                }
            });
            this.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    iTimer.schedule(10);
                }
            });
            this.addBlurHandler(new BlurHandler(){

                public void onBlur(BlurEvent event) {
                    if (Note.super.getText().isEmpty() && !iHint.isEmpty()) {
                        Note.super.setText(iHint);
                        this.addStyleName("notes-hint");
                    }
                }
            });
            this.addFocusHandler(new FocusHandler(){

                public void onFocus(FocusEvent event) {
                    if (!iHint.isEmpty() && Note.super.getText().equals(iHint)) {
                        Note.super.setText("");
                        this.removeStyleName("notes-hint");
                    }
                }
            });
        }

        public String getText() {
            if (super.getText().equals(this.iHint)) {
                return "";
            }
            return super.getText();
        }

        public void setText(String text) {
            if (text == null || text.isEmpty()) {
                super.setText(this.iHint);
                if (!this.iHint.isEmpty()) {
                    this.addStyleName("notes-hint");
                } else {
                    this.removeStyleName("notes-hint");
                }
            } else {
                super.setText(text);
                this.removeStyleName("notes-hint");
            }
        }

        public void resizeNotes() {
            if (!this.getText().isEmpty()) {
                this.setHeight(Math.max(45, this.getElement().getScrollHeight()) + "px");
            } else {
                this.setHeight("45px");
            }
        }

        public void setHint(String hint) {
            if (super.getText().equals(this.iHint)) {
                super.setText(hint);
                if (!hint.isEmpty()) {
                    this.addStyleName("notes-hint");
                } else {
                    this.removeStyleName("notes-hint");
                }
            }
            this.iHint = hint;
        }

        public String getHint() {
            return this.iHint;
        }

        protected void checkHint() {
            if (this.getValue().isEmpty()) {
                // empty if block
            }
        }
    }

    public static class ReadOnlyNote
    extends Label {
        public ReadOnlyNote(String text) {
            this.addStyleName("read-only-note");
            this.setText(text);
        }
    }

    static class PreferencesTable
    extends P {
        static int lastId = 0;
        ChangeHandler iChangeHandler;
        HandlerRegistration iHandlerRegistration;
        InstructorSurveyInterface.Preferences iPreferences;

        PreferencesTable(InstructorSurveyInterface.Preferences preferences, final InstructorSurveyInterface.InstructorSurveyData survey) {
            super("preference-table");
            this.iPreferences = preferences;
            if (preferences.hasSelections()) {
                for (InstructorSurveyInterface.Selection selection : preferences.getSelections()) {
                    PreferenceLine p = new PreferenceLine(this.iPreferences.getItems(), survey);
                    InstructorSurveyInterface.IdLabel item = preferences.getItem(selection.getItem());
                    InstructorSurveyInterface.PrefLevel level = survey.getPrefLevel(selection.getLevel());
                    if (item != null && level != null && !item.isAllowedPref(level.getId())) {
                        if ("P".equals(level.getCode())) {
                            selection.setLevel(survey.getPrefLevel("2").getId());
                        }
                        if ("R".equals(level.getCode())) {
                            selection.setLevel(survey.getPrefLevel("-2").getId());
                        }
                    }
                    p.setValue(selection);
                    this.add((Widget)p);
                }
            }
            this.add((Widget)new PreferenceLine(this.iPreferences.getItems(), survey));
            this.iChangeHandler = new ChangeHandler(){

                public void onChange(ChangeEvent e) {
                    if (((PreferenceLine)this.getWidget(this.getWidgetCount() - 1)).getId() != null) {
                        PreferenceLine p = new PreferenceLine(iPreferences.getItems(), survey);
                        this.add((Widget)p);
                        iHandlerRegistration.removeHandler();
                        iHandlerRegistration = p.addChangeHandler(iChangeHandler);
                        this.fixButtons();
                    }
                }
            };
            this.fixButtons();
        }

        protected void update() {
            this.iPreferences.clearSelections();
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                PreferenceLine p = (PreferenceLine)this.getWidget(i);
                InstructorSurveyInterface.Selection selection = p.getValue();
                if (selection == null) continue;
                this.iPreferences.addSelection(selection);
            }
        }

        protected void fixButtons() {
            if (this.iHandlerRegistration != null) {
                this.iHandlerRegistration.removeHandler();
            }
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                PreferenceLine p = (PreferenceLine)this.getWidget(i);
                if (i < this.getWidgetCount() - 1) {
                    p.setButtonAdd(false);
                    continue;
                }
                p.setButtonAdd(true);
                this.iHandlerRegistration = p.addChangeHandler(this.iChangeHandler);
            }
        }

        protected void resizeNotes() {
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                PreferenceLine p = (PreferenceLine)this.getWidget(i);
                p.iReason.resizeNotes();
            }
        }

        class PreferenceLine
        extends P
        implements HasChangeHandlers,
        TakesValue<InstructorSurveyInterface.Selection> {
            ListBox iList;
            List<RadioButton> iRadios;
            Image iButton;
            boolean iButtonAdd;
            List<InstructorSurveyInterface.PrefLevel> iOptions;
            Collection<InstructorSurveyInterface.IdLabel> iItems;
            P iDescription;
            Note iReason;

            PreferenceLine(Collection<InstructorSurveyInterface.IdLabel> items, final InstructorSurveyInterface.InstructorSurveyData survey) {
                super("preference-line");
                this.iButtonAdd = false;
                P line1 = new P("first-line");
                P line2 = new P("second-line");
                this.add((Widget)line1);
                this.add((Widget)line2);
                this.iOptions = survey.getPrefLevels();
                this.iItems = items;
                this.iList = new ListBox();
                this.iList.addItem("-", "");
                for (InstructorSurveyInterface.IdLabel item : items) {
                    this.iList.addItem(item.getLabel(), item.getId().toString());
                }
                this.iList.addStyleName("preference-cell");
                this.iList.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        PreferenceLine.this.fixOptions();
                        PreferenceLine.this.fireEvent((GwtEvent)event);
                    }
                });
                line1.add((Widget)this.iList);
                this.iRadios = new ArrayList<RadioButton>();
                for (InstructorSurveyInterface.PrefLevel option : survey.getPrefLevels()) {
                    RadioButton opt = new RadioButton("pref" + lastId, option.getLabel());
                    opt.setTitle(option.getTitle());
                    opt.getElement().getStyle().setColor(option.getColor());
                    opt.addStyleName("preference-cell");
                    this.iRadios.add(opt);
                    line1.add((Widget)opt);
                    opt.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                        public void onValueChange(ValueChangeEvent<Boolean> event) {
                            ChangeEvent.fireNativeEvent((NativeEvent)Document.get().createChangeEvent(), (HasHandlers)PreferenceLine.this);
                            InstructorSurveyInterface.PrefLevel level = PreferenceLine.this.getSelection();
                            PreferenceLine.this.iReason.setVisible(level != null && level.isHard());
                            if (PreferenceLine.this.iReason.isVisible()) {
                                PreferenceLine.this.iDescription.removeStyleName("wide-description");
                                PreferenceLine.this.iReason.setHint(MESSAGES.hintProvideReasonFor(level.getTitle(), PreferenceLine.this.iList.getSelectedItemText()));
                            } else {
                                PreferenceLine.this.iDescription.addStyleName("wide-description");
                            }
                        }
                    });
                }
                this.iButton = new Image(RESOURCES.delete());
                this.iButton.setTitle(MESSAGES.titleDeleteRow());
                this.iButton.addStyleName("preference-cell");
                this.iButton.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                this.iButton.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (PreferenceLine.this.iButtonAdd) {
                            PreferencesTable.this.add((Widget)new PreferenceLine(PreferenceLine.this.iItems, survey));
                        } else {
                            PreferencesTable.this.remove((Widget)PreferenceLine.this);
                        }
                        PreferencesTable.this.fixButtons();
                    }
                });
                line1.add((Widget)this.iButton);
                this.iDescription = new P("description", "wide-description");
                this.iDescription.setVisible(false);
                line2.add((Widget)this.iDescription);
                this.iReason = new Note();
                this.iReason.addStyleName("reason");
                this.iReason.setCharacterWidth(49);
                this.iReason.setVisible(false);
                line2.add((Widget)this.iReason);
                this.fixOptions();
                ++lastId;
            }

            protected InstructorSurveyInterface.IdLabel getItem() {
                String id = this.iList.getSelectedValue();
                if (id == null || id.isEmpty()) {
                    return null;
                }
                for (InstructorSurveyInterface.IdLabel item : this.iItems) {
                    if (!item.getId().toString().equals(id)) continue;
                    return item;
                }
                return null;
            }

            protected void fixOptions() {
                InstructorSurveyInterface.IdLabel item = this.getItem();
                if (item != null && item.hasDescription()) {
                    this.iDescription.setVisible(true);
                    this.iDescription.setHTML(item.getDescription());
                    this.iReason.setCharacterWidth(49);
                } else {
                    this.iDescription.setVisible(false);
                    this.iReason.setCharacterWidth(95);
                }
                int nbrVisible = 0;
                RadioButton lastVisible = null;
                InstructorSurveyInterface.PrefLevel level = null;
                for (int i = 0; i < this.iOptions.size(); ++i) {
                    RadioButton opt = this.iRadios.get(i);
                    InstructorSurveyInterface.PrefLevel option = this.iOptions.get(i);
                    if (item == null || !item.isAllowedPref(option.getId())) {
                        opt.setEnabled(false);
                        opt.setVisible(false);
                        opt.setValue(null);
                        continue;
                    }
                    opt.setEnabled(true);
                    opt.setVisible(true);
                    lastVisible = opt;
                    ++nbrVisible;
                    if (!Boolean.TRUE.equals(opt.getValue())) continue;
                    level = option;
                }
                if (nbrVisible == 1) {
                    lastVisible.setValue(Boolean.valueOf(true));
                }
                this.iReason.setVisible(level != null && level.isHard());
                if (this.iReason.isVisible()) {
                    this.iDescription.removeStyleName("wide-description");
                    this.iReason.setHint(MESSAGES.hintProvideReasonFor(level.getTitle(), this.iList.getSelectedItemText()));
                } else {
                    this.iDescription.addStyleName("wide-description");
                }
            }

            public InstructorSurveyInterface.PrefLevel getSelection() {
                for (int i = 0; i < this.iOptions.size(); ++i) {
                    RadioButton opt = this.iRadios.get(i);
                    if (!Boolean.TRUE.equals(opt.getValue())) continue;
                    return this.iOptions.get(i);
                }
                return null;
            }

            public Long getId() {
                String id = this.iList.getSelectedValue();
                if (id == null || id.isEmpty()) {
                    return null;
                }
                if (this.getSelection() == null) {
                    return null;
                }
                return Long.valueOf(id);
            }

            public void setId(Long id) {
                if (id == null) {
                    this.iList.setSelectedIndex(0);
                } else {
                    for (int i = 1; i < this.iList.getItemCount(); ++i) {
                        if (!this.iList.getValue(i).equals(id.toString())) continue;
                        this.iList.setSelectedIndex(i);
                        break;
                    }
                }
            }

            public HandlerRegistration addChangeHandler(ChangeHandler handler) {
                return this.addDomHandler((EventHandler)handler, ChangeEvent.getType());
            }

            public void setButtonAdd(boolean add) {
                this.iButtonAdd = add;
                if (add) {
                    this.iButton.setResource(RESOURCES.add());
                    this.iButton.setTitle(MESSAGES.titleAddRow());
                } else {
                    this.iButton.setResource(RESOURCES.delete());
                    this.iButton.setTitle(MESSAGES.titleDeleteRow());
                }
            }

            public void setValue(InstructorSurveyInterface.Selection value) {
                if (value == null) {
                    this.iList.setSelectedIndex(0);
                    for (RadioButton b : this.iRadios) {
                        b.setValue(Boolean.valueOf(false));
                    }
                    this.iReason.setText("");
                } else {
                    int i;
                    for (i = 0; i < this.iList.getItemCount(); ++i) {
                        if (!value.getItem().toString().equals(this.iList.getValue(i))) continue;
                        this.iList.setSelectedIndex(i);
                        break;
                    }
                    for (i = 0; i < this.iOptions.size(); ++i) {
                        RadioButton opt = this.iRadios.get(i);
                        opt.setValue(Boolean.valueOf(this.iOptions.get(i).getId().equals(value.getLevel())));
                    }
                    this.iReason.setText(value.getNote() == null ? "" : value.getNote());
                }
                this.fixOptions();
                this.iReason.setVisible(this.getSelection() != null && this.getSelection().isHard());
                this.iReason.resizeNotes();
            }

            public InstructorSurveyInterface.Selection getValue() {
                InstructorSurveyInterface.IdLabel item = this.getItem();
                InstructorSurveyInterface.PrefLevel pref = this.getSelection();
                if (item != null && pref != null) {
                    return new InstructorSurveyInterface.Selection(item.getId(), pref.getId(), this.iReason.getText());
                }
                return null;
            }
        }
    }

    static class PreferencesReadOnlyTable
    extends P {
        PreferencesReadOnlyTable(InstructorSurveyInterface.Preferences preferences, List<InstructorSurveyInterface.PrefLevel> options) {
            super("preference-table");
            if (preferences.hasSelections()) {
                block0: for (InstructorSurveyInterface.Selection selection : preferences.getSelections()) {
                    InstructorSurveyInterface.IdLabel item = preferences.getItem(selection.getItem());
                    for (InstructorSurveyInterface.PrefLevel prefLevel : options) {
                        if (!prefLevel.getId().equals(selection.getLevel())) continue;
                        this.add((Widget)new PreferenceLine(item, prefLevel, selection));
                        continue block0;
                    }
                }
            }
        }

        class PreferenceLine
        extends P {
            P iItem;
            P iPreference;
            P iDescription;
            P iReason;
            List<InstructorSurveyInterface.PrefLevel> iOptions;
            Collection<InstructorSurveyInterface.IdLabel> iItems;

            PreferenceLine(InstructorSurveyInterface.IdLabel item, InstructorSurveyInterface.PrefLevel preference, InstructorSurveyInterface.Selection selection) {
                P line2;
                super("preference-line", "preference-line-readonly");
                P line1 = new P("first-line");
                this.add((Widget)line1);
                this.iPreference = new P("preference-cell");
                this.iPreference.setText(preference.getTitle());
                this.iPreference.getElement().getStyle().setColor(preference.getColor());
                line1.add((Widget)this.iPreference);
                this.iItem = new P("preference-cell");
                this.iItem.setText(item.getLabel());
                this.iItem.getElement().getStyle().setColor(preference.getColor());
                line1.add((Widget)this.iItem);
                if (item.hasDescription()) {
                    this.iDescription = new P("description");
                    this.iDescription.setVisible(true);
                    this.iDescription.setHTML(item.getDescription());
                    line2 = new P("second-line");
                    line2.add((Widget)this.iDescription);
                    this.add((Widget)line2);
                }
                if (preference.isHard() && selection.hasNote()) {
                    this.iReason = new P("reason");
                    this.iReason.setVisible(false);
                    this.iReason.setVisible(true);
                    this.iReason.setText(selection.getNote());
                    line2 = new P("second-line");
                    line2.add((Widget)this.iReason);
                    this.add((Widget)line2);
                }
            }
        }
    }
}

