/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Date;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.hibernate.CacheMode;
import org.unitime.timetable.api.AbstractApiHelper;
import org.unitime.timetable.security.SessionContext;

public class XmlApiHelper
extends AbstractApiHelper {
    public XmlApiHelper(HttpServletRequest request, HttpServletResponse response, SessionContext context, CacheMode cacheMode) {
        super(request, response, context, cacheMode);
    }

    public Document getRequest(Type requestType) throws IOException {
        try (BufferedReader reader = this.iRequest.getReader();){
            Document document = new SAXReader().read((Reader)reader);
            return document;
        }
    }

    @Override
    public <R> void setResponse(R response) throws IOException {
        this.iResponse.setContentType("application/xml");
        this.iResponse.setCharacterEncoding("UTF-8");
        this.iResponse.setHeader("Pragma", "no-cache");
        this.iResponse.addHeader("Cache-Control", "must-revalidate");
        this.iResponse.addHeader("Cache-Control", "no-cache");
        this.iResponse.addHeader("Cache-Control", "no-store");
        this.iResponse.setDateHeader("Date", new Date().getTime());
        this.iResponse.setDateHeader("Expires", 0L);
        this.iResponse.setHeader("Content-Disposition", "attachment; filename=\"response.xml\"");
        PrintWriter writer = this.iResponse.getWriter();
        try {
            new XMLWriter((Writer)writer, OutputFormat.createPrettyPrint()).write(response);
        }
        finally {
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
    }
}

