/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import jakarta.persistence.TemporalType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalJavaType;
import org.hibernate.type.descriptor.java.CalendarJavaType;
import org.hibernate.type.descriptor.java.ClockHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaType;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaType;
import org.hibernate.type.descriptor.java.VersionJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class DateJavaType
extends AbstractTemporalJavaType<java.util.Date>
implements VersionJavaType<java.util.Date> {
    public static final DateJavaType INSTANCE = new DateJavaType();

    public DateJavaType() {
        super(java.util.Date.class, DateMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return dialect.getDefaultTimestampPrecision();
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getJdbcType(93);
    }

    @Override
    protected <X> TemporalJavaType<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return JdbcDateJavaType.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaType<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return JdbcTimestampJavaType.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaType<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return JdbcTimeJavaType.INSTANCE;
    }

    @Override
    public String toString(java.util.Date value) {
        return JdbcTimestampJavaType.LITERAL_FORMATTER.format(value.toInstant());
    }

    @Override
    public java.util.Date fromString(CharSequence string) {
        try {
            TemporalAccessor accessor = JdbcTimestampJavaType.LITERAL_FORMATTER.parse(string);
            return new java.util.Date(accessor.getLong(ChronoField.INSTANT_SECONDS) * 1000L + (long)(accessor.get(ChronoField.NANO_OF_SECOND) / 1000000));
        }
        catch (DateTimeParseException pe) {
            throw new HibernateException("could not parse timestamp string" + String.valueOf(string), pe);
        }
    }

    @Override
    public boolean areEqual(java.util.Date one, java.util.Date another) {
        if (one == another) {
            return true;
        }
        return one != null && another != null && one.getTime() == another.getTime();
    }

    @Override
    public int extractHashCode(java.util.Date value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        return CalendarJavaType.INSTANCE.extractHashCode(calendar);
    }

    @Override
    public <X> X unwrap(java.util.Date value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(type)) {
            Date rtn = value instanceof Date ? (Date)value : new Date(value.getTime());
            return (X)rtn;
        }
        if (Time.class.isAssignableFrom(type)) {
            Time rtn = value instanceof Time ? (Time)value : new Time(value.getTime() % 86400000L);
            return (X)rtn;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            Timestamp rtn = value instanceof Timestamp ? (Timestamp)value : new Timestamp(value.getTime());
            return (X)rtn;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(value.getTime());
            return (X)cal;
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.getTime());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> java.util.Date wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof Long) {
            return new java.util.Date((Long)value);
        }
        if (value instanceof Calendar) {
            return new java.util.Date(((Calendar)value).getTimeInMillis());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        switch (javaType.getTypeName()) {
            case "java.sql.Date": 
            case "java.sql.Timestamp": 
            case "java.util.Calendar": {
                return true;
            }
        }
        return false;
    }

    @Override
    public java.util.Date next(java.util.Date current, Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return this.seed(length, precision, scale, session);
    }

    @Override
    public java.util.Date seed(Long length, Integer precision, Integer scale, SharedSessionContractImplementor session) {
        return Timestamp.from(ClockHelper.forPrecision(precision, session).instant());
    }

    public static class DateMutabilityPlan
    extends MutableMutabilityPlan<java.util.Date> {
        public static final DateMutabilityPlan INSTANCE = new DateMutabilityPlan();

        @Override
        public java.util.Date deepCopyNotNull(java.util.Date value) {
            return new java.util.Date(value.getTime());
        }
    }
}

