/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.constraint.DepartmentSpreadConstraint;
import org.cpsolver.coursett.criteria.SameSubpartBalancingPenalty;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class DepartmentBalancingPenalty
extends SameSubpartBalancingPenalty {
    @Override
    public double getWeightDefault(DataProperties config) {
        return 12.0 * config.getPropertyDouble("Comparator.DeptSpreadPenaltyWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.DeptSpreadPenaltyWeight";
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        return (((Lecture)value.variable()).getDeptSpreadConstraint() == null ? 0.0 : (double)((Lecture)value.variable()).getDeptSpreadConstraint().getPenalty(assignment, value)) / 12.0;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double ret = 0.0;
        HashSet<DepartmentSpreadConstraint> constraints = new HashSet<DepartmentSpreadConstraint>();
        for (Lecture lect : variables) {
            if (lect.getDeptSpreadConstraint() == null || !constraints.add(lect.getDeptSpreadConstraint())) continue;
            ret += (double)lect.getDeptSpreadConstraint().getPenalty(assignment);
        }
        return ret / 12.0;
    }
}

