/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.animation.client;

import com.google.gwt.animation.client.AnimationScheduler;
import com.google.gwt.core.client.Duration;
import com.google.gwt.dom.client.Element;

public abstract class Animation {
    private final AnimationScheduler.AnimationCallback callback = new AnimationScheduler.AnimationCallback(){

        @Override
        public void execute(double timestamp) {
            if (Animation.this.update(timestamp)) {
                Animation.this.requestHandle = Animation.this.scheduler.requestAnimationFrame(Animation.this.callback, Animation.this.element);
            } else {
                Animation.this.requestHandle = null;
            }
        }
    };
    private int duration = -1;
    private Element element;
    private boolean isRunning = false;
    private boolean isStarted = false;
    private AnimationScheduler.AnimationHandle requestHandle;
    private int runId = -1;
    private final AnimationScheduler scheduler;
    private double startTime = -1.0;
    private boolean wasStarted = false;

    public Animation() {
        this(AnimationScheduler.get());
    }

    protected Animation(AnimationScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void cancel() {
        if (!this.isRunning) {
            return;
        }
        this.wasStarted = this.isStarted;
        this.element = null;
        this.isRunning = false;
        this.isStarted = false;
        if (this.requestHandle != null) {
            this.requestHandle.cancel();
            this.requestHandle = null;
        }
        this.onCancel();
    }

    public void run(int duration) {
        this.run(duration, null);
    }

    public void run(int duration, Element element) {
        this.run(duration, Duration.currentTimeMillis(), element);
    }

    public void run(int duration, double startTime) {
        this.run(duration, startTime, null);
    }

    public void run(int duration, double startTime, Element element) {
        this.cancel();
        this.isRunning = true;
        this.isStarted = false;
        this.duration = duration;
        this.startTime = startTime;
        this.element = element;
        ++this.runId;
        this.callback.execute(Duration.currentTimeMillis());
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    protected double interpolate(double progress) {
        return (1.0 + Math.cos(Math.PI + progress * Math.PI)) / 2.0;
    }

    protected void onCancel() {
        if (this.wasStarted) {
            this.onComplete();
        }
    }

    protected void onComplete() {
        this.onUpdate(this.interpolate(1.0));
    }

    protected void onStart() {
        this.onUpdate(this.interpolate(0.0));
    }

    protected abstract void onUpdate(double var1);

    private boolean isRunning(int curRunId) {
        return this.isRunning && this.runId == curRunId;
    }

    private boolean update(double curTime) {
        boolean finished;
        int curRunId = this.runId;
        boolean bl = finished = curTime >= this.startTime + (double)this.duration;
        if (this.isStarted && !finished) {
            double progress = (curTime - this.startTime) / (double)this.duration;
            this.onUpdate(this.interpolate(progress));
            return this.isRunning(curRunId);
        }
        if (!this.isStarted && curTime >= this.startTime) {
            this.isStarted = true;
            this.onStart();
            if (!this.isRunning(curRunId)) {
                return false;
            }
        }
        if (finished) {
            this.isRunning = false;
            this.isStarted = false;
            this.onComplete();
            return false;
        }
        return true;
    }
}

