/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.QueryHint;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.SqlResultSetMappings;
import jakarta.persistence.StoredProcedureParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Remove;
import org.hibernate.annotations.CacheModeType;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.HQLSelect;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.SQLSelect;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.boot.internal.NamedHqlQueryDefinitionImpl;
import org.hibernate.boot.internal.NamedProcedureCallDefinitionImpl;
import org.hibernate.boot.model.internal.QueryHintDefinition;
import org.hibernate.boot.model.internal.ResultSetMappingSecondPass;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinitionBuilder;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.query.SqlResultSetMappingDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.sql.internal.ParameterParser;
import org.hibernate.query.sql.spi.ParameterRecognizer;
import org.hibernate.type.BasicType;
import org.jboss.logging.Logger;

public abstract class QueryBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)QueryBinder.class.getName());

    public static void bindQuery(NamedQuery namedQuery, MetadataBuildingContext context, boolean isDefault) {
        if (namedQuery == null) {
            return;
        }
        String queryName = namedQuery.name();
        String queryString = namedQuery.query();
        if (queryName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedQuery' annotation must specify a 'name'");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", queryName, queryString);
        }
        QueryHintDefinition hints = new QueryHintDefinition(queryName, namedQuery.hints());
        NamedHqlQueryDefinitionImpl queryMapping = ((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(queryName).setHqlString(queryString).setCacheable(hints.getCacheability())).setCacheMode(hints.getCacheMode())).setCacheRegion(hints.getString("org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout())).setFetchSize(hints.getInteger("org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode())).setReadOnly(hints.getBooleanWrapper("org.hibernate.readOnly"))).setLockOptions(hints.determineLockOptions(namedQuery))).setComment(hints.getString("org.hibernate.comment"))).build();
        if (isDefault) {
            context.getMetadataCollector().addDefaultQuery(queryMapping);
        } else {
            context.getMetadataCollector().addNamedQuery(queryMapping);
        }
    }

    public static void bindNativeQuery(jakarta.persistence.NamedNativeQuery namedNativeQuery, MetadataBuildingContext context, boolean isDefault) {
        if (namedNativeQuery == null) {
            return;
        }
        String registrationName = namedNativeQuery.name();
        String queryString = namedNativeQuery.query();
        if (registrationName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedNativeQuery' annotation must specify a 'name'");
        }
        QueryHintDefinition hints = new QueryHintDefinition(registrationName, namedNativeQuery.hints());
        String resultSetMappingName = namedNativeQuery.resultSetMapping();
        String resultSetMappingClassName = Void.TYPE.equals(namedNativeQuery.resultClass()) ? null : namedNativeQuery.resultClass().getName();
        NamedNativeQueryDefinitionBuilder builder = (NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)new NamedNativeQueryDefinitionBuilder(registrationName).setSqlString(queryString).setResultSetMappingName(resultSetMappingName).setResultSetMappingClassName(resultSetMappingClassName).setQuerySpaces(null).setCacheable(hints.getCacheability())).setCacheMode(hints.getCacheMode())).setCacheRegion(hints.getString("org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout())).setFetchSize(hints.getInteger("org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode())).setReadOnly(hints.getBooleanWrapper("org.hibernate.readOnly"))).setComment(hints.getString("org.hibernate.comment"))).addHints(hints.getHintsMap());
        NamedNativeQueryDefinition queryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
        }
        if (isDefault) {
            context.getMetadataCollector().addDefaultNamedNativeQuery(queryDefinition);
        } else {
            context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
        }
    }

    public static void bindNativeQuery(String name, SQLSelect sqlSelect, XClass annotatedClass, MetadataBuildingContext context) {
        SqlResultSetMapping resultSetMapping;
        NamedNativeQueryDefinitionBuilder builder = ((NamedNativeQueryDefinitionBuilder)new NamedNativeQueryDefinitionBuilder(name).setFlushMode(FlushMode.MANUAL)).setSqlString(sqlSelect.sql()).setQuerySpaces(CollectionHelper.setOf(sqlSelect.querySpaces()));
        if (annotatedClass != null) {
            builder.setResultSetMappingClassName(annotatedClass.getName());
        }
        if ((resultSetMapping = sqlSelect.resultSetMapping()).columns().length != 0 || resultSetMapping.entities().length != 0 || resultSetMapping.classes().length != 0) {
            context.getMetadataCollector().addResultSetMapping(SqlResultSetMappingDescriptor.from(resultSetMapping, name));
            builder.setResultSetMappingName(name);
        }
        context.getMetadataCollector().addNamedNativeQuery(builder.build());
    }

    public static void bindNativeQuery(NamedNativeQuery namedNativeQuery, MetadataBuildingContext context) {
        if (namedNativeQuery == null) {
            return;
        }
        String registrationName = namedNativeQuery.name();
        if (registrationName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedNativeQuery' annotation must specify a 'name'");
        }
        String resultSetMappingName = namedNativeQuery.resultSetMapping();
        String resultSetMappingClassName = Void.TYPE.equals(namedNativeQuery.resultClass()) ? null : namedNativeQuery.resultClass().getName();
        NamedNativeQueryDefinitionBuilder builder = (NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)((NamedNativeQueryDefinitionBuilder)new NamedNativeQueryDefinitionBuilder(registrationName).setSqlString(namedNativeQuery.query()).setResultSetMappingName(resultSetMappingName).setResultSetMappingClassName(resultSetMappingClassName).setCacheable(namedNativeQuery.cacheable())).setCacheRegion(StringHelper.nullIfEmpty(namedNativeQuery.cacheRegion()))).setCacheMode(QueryBinder.getCacheMode(namedNativeQuery))).setTimeout(namedNativeQuery.timeout() < 0 ? null : Integer.valueOf(namedNativeQuery.timeout()))).setFetchSize(namedNativeQuery.fetchSize() < 0 ? null : Integer.valueOf(namedNativeQuery.fetchSize()))).setFlushMode(QueryBinder.getFlushMode(namedNativeQuery.flushMode()))).setReadOnly(namedNativeQuery.readOnly())).setQuerySpaces(CollectionHelper.setOf(namedNativeQuery.querySpaces())).setComment(StringHelper.nullIfEmpty(namedNativeQuery.comment()));
        if (namedNativeQuery.callable()) {
            NamedProcedureCallDefinition definition = QueryBinder.createStoredProcedure(builder, context, () -> QueryBinder.illegalCallSyntax(namedNativeQuery));
            context.getMetadataCollector().addNamedProcedureCallDefinition(definition);
            DeprecationLogger.DEPRECATION_LOGGER.warn("Marking named native queries as callable is no longer supported; use '@jakarta.persistence.NamedStoredProcedureQuery' instead. Ignoring.");
        } else {
            NamedNativeQueryDefinition queryDefinition = builder.build();
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
            }
            context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
        }
    }

    public static NamedProcedureCallDefinition createStoredProcedure(NamedNativeQueryDefinitionBuilder builder, MetadataBuildingContext context, Supplier<RuntimeException> exceptionProducer) {
        ArrayList<StoredProcedureParameter> storedProcedureParameters = new ArrayList<StoredProcedureParameter>();
        ArrayList<QueryHint> queryHints = new ArrayList<QueryHint>();
        String sqlString = builder.getSqlString().trim();
        if (!sqlString.startsWith("{") || !sqlString.endsWith("}")) {
            throw exceptionProducer.get();
        }
        JdbcCall jdbcCall = QueryBinder.parseJdbcCall(sqlString, exceptionProducer);
        AnnotationDescriptor descriptor = new AnnotationDescriptor(NamedStoredProcedureQuery.class);
        descriptor.setValue("name", (Object)builder.getName());
        descriptor.setValue("procedureName", (Object)jdbcCall.callableName);
        for (String parameterName : jdbcCall.parameters) {
            AnnotationDescriptor parameterDescriptor = new AnnotationDescriptor(StoredProcedureParameter.class);
            parameterDescriptor.setValue("name", (Object)parameterName);
            parameterDescriptor.setValue("mode", (Object)ParameterMode.IN);
            String typeName = builder.getParameterTypes().get(parameterName);
            if (typeName == null) {
                parameterDescriptor.setValue("type", Object.class);
            } else {
                BasicType registeredType = context.getBootstrapContext().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(typeName);
                parameterDescriptor.setValue("type", (Object)registeredType.getJavaType());
            }
            storedProcedureParameters.add((StoredProcedureParameter)AnnotationFactory.create((AnnotationDescriptor)parameterDescriptor));
        }
        descriptor.setValue("parameters", (Object)storedProcedureParameters.toArray(new StoredProcedureParameter[storedProcedureParameters.size()]));
        if (builder.getResultSetMappingName() != null) {
            descriptor.setValue("resultSetMappings", (Object)new String[]{builder.getResultSetMappingName()});
        } else {
            descriptor.setValue("resultSetMappings", (Object)new String[0]);
        }
        if (builder.getResultSetMappingClassName() != null) {
            descriptor.setValue("resultClasses", (Object)new Class[]{context.getBootstrapContext().getClassLoaderAccess().classForName(builder.getResultSetMappingClassName())});
        } else {
            descriptor.setValue("resultClasses", (Object)new Class[0]);
        }
        if (builder.getQuerySpaces() != null) {
            AnnotationDescriptor hintDescriptor = new AnnotationDescriptor(QueryHint.class);
            hintDescriptor.setValue("name", (Object)"org.hibernate.query.native.spaces");
            hintDescriptor.setValue("value", (Object)String.join((CharSequence)" ", builder.getQuerySpaces()));
            queryHints.add((QueryHint)AnnotationFactory.create((AnnotationDescriptor)hintDescriptor));
        }
        if (jdbcCall.resultParameter) {
            AnnotationDescriptor hintDescriptor2 = new AnnotationDescriptor(QueryHint.class);
            hintDescriptor2.setValue("name", (Object)"org.hibernate.callableFunction");
            hintDescriptor2.setValue("value", (Object)"true");
            queryHints.add((QueryHint)AnnotationFactory.create((AnnotationDescriptor)hintDescriptor2));
        }
        descriptor.setValue("hints", (Object)queryHints.toArray(new QueryHint[queryHints.size()]));
        return new NamedProcedureCallDefinitionImpl((NamedStoredProcedureQuery)AnnotationFactory.create((AnnotationDescriptor)descriptor));
    }

    public static void bindQueries(jakarta.persistence.NamedQueries namedQueries, MetadataBuildingContext context, boolean isDefault) {
        if (namedQueries != null) {
            for (NamedQuery namedQuery : namedQueries.value()) {
                QueryBinder.bindQuery(namedQuery, context, isDefault);
            }
        }
    }

    public static void bindNativeQueries(jakarta.persistence.NamedNativeQueries namedNativeQueries, MetadataBuildingContext context, boolean isDefault) {
        if (namedNativeQueries != null) {
            for (jakarta.persistence.NamedNativeQuery namedNativeQuery : namedNativeQueries.value()) {
                QueryBinder.bindNativeQuery(namedNativeQuery, context, isDefault);
            }
        }
    }

    public static void bindNativeQueries(NamedNativeQueries namedNativeQueries, MetadataBuildingContext context) {
        if (namedNativeQueries != null) {
            for (NamedNativeQuery namedNativeQuery : namedNativeQueries.value()) {
                QueryBinder.bindNativeQuery(namedNativeQuery, context);
            }
        }
    }

    public static void bindQuery(String name, HQLSelect hqlSelect, MetadataBuildingContext context) {
        NamedHqlQueryDefinitionImpl hqlQueryDefinition = ((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(name).setFlushMode(FlushMode.MANUAL)).setHqlString(hqlSelect.query()).build();
        context.getMetadataCollector().addNamedQuery(hqlQueryDefinition);
    }

    public static void bindQuery(org.hibernate.annotations.NamedQuery namedQuery, MetadataBuildingContext context) {
        if (namedQuery == null) {
            return;
        }
        String registrationName = namedQuery.name();
        if (registrationName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedQuery' annotation must specify a 'name'");
        }
        NamedHqlQueryDefinition.Builder builder = (NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(registrationName).setHqlString(namedQuery.query()).setCacheable(namedQuery.cacheable())).setCacheRegion(StringHelper.nullIfEmpty(namedQuery.cacheRegion()))).setCacheMode(QueryBinder.getCacheMode(namedQuery))).setTimeout(namedQuery.timeout() < 0 ? null : Integer.valueOf(namedQuery.timeout()))).setFetchSize(namedQuery.fetchSize() < 0 ? null : Integer.valueOf(namedQuery.fetchSize()))).setFlushMode(QueryBinder.getFlushMode(namedQuery.flushMode()))).setReadOnly(namedQuery.readOnly())).setComment(StringHelper.nullIfEmpty(namedQuery.comment()));
        NamedHqlQueryDefinitionImpl hqlQueryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", hqlQueryDefinition.getRegistrationName(), hqlQueryDefinition.getHqlString());
        }
        context.getMetadataCollector().addNamedQuery(hqlQueryDefinition);
    }

    private static CacheMode getCacheMode(org.hibernate.annotations.NamedQuery namedQuery) {
        CacheMode cacheMode = CacheMode.fromJpaModes(namedQuery.cacheRetrieveMode(), namedQuery.cacheStoreMode());
        return cacheMode == null || cacheMode == CacheMode.NORMAL ? QueryBinder.getCacheMode(namedQuery.cacheMode()) : cacheMode;
    }

    private static CacheMode getCacheMode(NamedNativeQuery namedNativeQuery) {
        CacheMode cacheMode = CacheMode.fromJpaModes(namedNativeQuery.cacheRetrieveMode(), namedNativeQuery.cacheStoreMode());
        return cacheMode == null || cacheMode == CacheMode.NORMAL ? QueryBinder.getCacheMode(namedNativeQuery.cacheMode()) : cacheMode;
    }

    private static FlushMode getFlushMode(FlushModeType flushModeType) {
        switch (flushModeType) {
            case ALWAYS: {
                return FlushMode.ALWAYS;
            }
            case AUTO: {
                return FlushMode.AUTO;
            }
            case COMMIT: {
                return FlushMode.COMMIT;
            }
            case MANUAL: {
                return FlushMode.MANUAL;
            }
            case PERSISTENCE_CONTEXT: {
                return null;
            }
        }
        throw new AssertionFailure("Unknown FlushModeType: " + String.valueOf((Object)flushModeType));
    }

    private static CacheMode getCacheMode(CacheModeType cacheModeType) {
        switch (cacheModeType) {
            case GET: {
                return CacheMode.GET;
            }
            case IGNORE: {
                return CacheMode.IGNORE;
            }
            case NORMAL: {
                return CacheMode.NORMAL;
            }
            case PUT: {
                return CacheMode.PUT;
            }
            case REFRESH: {
                return CacheMode.REFRESH;
            }
        }
        throw new AssertionFailure("Unknown cacheModeType: " + String.valueOf((Object)cacheModeType));
    }

    public static void bindQueries(NamedQueries namedQueries, MetadataBuildingContext context) {
        if (namedQueries != null) {
            for (org.hibernate.annotations.NamedQuery namedQuery : namedQueries.value()) {
                QueryBinder.bindQuery(namedQuery, context);
            }
        }
    }

    public static void bindNamedStoredProcedureQuery(NamedStoredProcedureQuery namedStoredProcedureQuery, MetadataBuildingContext context, boolean isDefault) {
        if (namedStoredProcedureQuery != null) {
            if (namedStoredProcedureQuery.name().isEmpty()) {
                throw new AnnotationException("Class or package level '@NamedStoredProcedureQuery' annotation must specify a 'name'");
            }
            NamedProcedureCallDefinitionImpl definition = new NamedProcedureCallDefinitionImpl(namedStoredProcedureQuery);
            if (isDefault) {
                context.getMetadataCollector().addDefaultNamedProcedureCall(definition);
            } else {
                context.getMetadataCollector().addNamedProcedureCallDefinition(definition);
            }
            LOG.debugf("Bound named stored procedure query : %s => %s", definition.getRegistrationName(), definition.getProcedureName());
        }
    }

    public static void bindSqlResultSetMappings(SqlResultSetMappings resultSetMappings, MetadataBuildingContext context, boolean isDefault) {
        if (resultSetMappings != null) {
            for (SqlResultSetMapping resultSetMapping : resultSetMappings.value()) {
                QueryBinder.bindSqlResultSetMapping(resultSetMapping, context, isDefault);
            }
        }
    }

    public static void bindSqlResultSetMapping(SqlResultSetMapping resultSetMapping, MetadataBuildingContext context, boolean isDefault) {
        context.getMetadataCollector().addSecondPass(new ResultSetMappingSecondPass(resultSetMapping, context, isDefault));
    }

    private static JdbcCall parseJdbcCall(String sqlString, Supplier<RuntimeException> exceptionProducer) {
        String callableName = null;
        boolean resultParameter = false;
        int index = QueryBinder.skipWhitespace(sqlString, 1);
        if (sqlString.charAt(index) == '?') {
            resultParameter = true;
            ++index;
            if (sqlString.charAt(index = QueryBinder.skipWhitespace(sqlString, index)) != '=') {
                throw exceptionProducer.get();
            }
            ++index;
            index = QueryBinder.skipWhitespace(sqlString, index);
        }
        if (!sqlString.regionMatches(true, index, "call", 0, 4)) {
            throw exceptionProducer.get();
        }
        index += 4;
        int procedureStart = index = QueryBinder.skipWhitespace(sqlString, index);
        while (index < sqlString.length()) {
            char c = sqlString.charAt(index);
            if (c == '(' || Character.isWhitespace(c)) {
                callableName = sqlString.substring(procedureStart, index);
                break;
            }
            ++index;
        }
        index = QueryBinder.skipWhitespace(sqlString, index);
        final ArrayList<String> parameters = new ArrayList<String>();
        ParameterParser.parse(sqlString.substring(index, sqlString.length() - 1), new ParameterRecognizer(){

            @Override
            public void ordinalParameter(int sourcePosition) {
                parameters.add("");
            }

            @Override
            public void namedParameter(String name, int sourcePosition) {
                parameters.add(name);
            }

            @Override
            public void jpaPositionalParameter(int label, int sourcePosition) {
                parameters.add("");
            }

            @Override
            public void other(char character) {
            }
        });
        return new JdbcCall(callableName, resultParameter, parameters);
    }

    @Remove
    @Deprecated(since="6.2")
    public static String parseJdbcCall(String sqlString, final List<String> parameterNames, Supplier<RuntimeException> exceptionProducer) {
        String procedureName = null;
        int index = QueryBinder.skipWhitespace(sqlString, 1);
        if (sqlString.charAt(index) == '?') {
            ++index;
            if (sqlString.charAt(index = QueryBinder.skipWhitespace(sqlString, index)) != '=') {
                throw exceptionProducer.get();
            }
            ++index;
            index = QueryBinder.skipWhitespace(sqlString, index);
        }
        if (!sqlString.regionMatches(true, index, "call", 0, 4)) {
            throw exceptionProducer.get();
        }
        index += 4;
        int procedureStart = index = QueryBinder.skipWhitespace(sqlString, index);
        while (index < sqlString.length()) {
            char c = sqlString.charAt(index);
            if (c == '(' || Character.isWhitespace(c)) {
                procedureName = sqlString.substring(procedureStart, index);
                break;
            }
            ++index;
        }
        index = QueryBinder.skipWhitespace(sqlString, index);
        ParameterParser.parse(sqlString.substring(index, sqlString.length() - 1), new ParameterRecognizer(){

            @Override
            public void ordinalParameter(int sourcePosition) {
                parameterNames.add("");
            }

            @Override
            public void namedParameter(String name, int sourcePosition) {
                parameterNames.add(name);
            }

            @Override
            public void jpaPositionalParameter(int label, int sourcePosition) {
                parameterNames.add("");
            }

            @Override
            public void other(char character) {
            }
        });
        return procedureName;
    }

    private static int skipWhitespace(String sqlString, int i) {
        while (i < sqlString.length() && Character.isWhitespace(sqlString.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static AnnotationException illegalCallSyntax(NamedNativeQuery queryAnn) {
        return new AnnotationException("Callable 'NamedNativeQuery' named '" + queryAnn.name() + "' does not use the JDBC call syntax");
    }

    private static class JdbcCall {
        private final String callableName;
        private final boolean resultParameter;
        private final ArrayList<String> parameters;

        public JdbcCall(String callableName, boolean resultParameter, ArrayList<String> parameters) {
            this.callableName = callableName;
            this.resultParameter = resultParameter;
            this.parameters = parameters;
        }
    }
}

