/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class DepartmentInterface
implements IsSerializable,
Comparable<DepartmentInterface>,
GwtRpcResponse {
    private Long iUniqueId = null;
    private Long iSessionId = null;
    private String iAcademicSessionName = null;
    private String iName = null;
    private String iDeptCode = null;
    private String iStatusType = null;
    private String iStatusTypeCode = null;
    private String iAbbreviation = null;
    private String iExternalId = null;
    private Integer iDistributionPrefPriority = 0;
    private String iExternalMgrLabel;
    private String iExternalMgrAbbv;
    private Integer iTimetableManagerCount;
    private String iLastChangeStr;
    private Boolean iExternalManager = false;
    private Boolean iAllowEvents = false;
    private Boolean iAllowStudentScheduling = false;
    private Boolean iInheritInstructorPreferences = false;
    private Boolean iAllowReqTime = false;
    private Boolean iAllowReqRoom = false;
    private Boolean iAllowReqDistribution = false;
    private Boolean iExternalFundingDept = false;
    private String iExternalStatusTypesStr;
    private ArrayList<String> iDependentStatusesStr;
    private Integer iSubjectAreaCount;
    private Integer iRoomDeptsCount;
    public ArrayList<String> iDependentStatuses;
    public ArrayList<String> iDependentDepartments;

    public String allowReq(GwtMessages msg) {
        Object allowReq = "";
        int allowReqOrd = 0;
        if (this.isAllowReqRoom() != null && this.isAllowReqRoom().booleanValue()) {
            if (!((String)allowReq).isEmpty()) {
                allowReq = (String)allowReq + ", ";
            }
            allowReq = (String)allowReq + msg.colRoom();
            ++allowReqOrd;
        }
        if (this.isAllowReqTime() != null && this.isAllowReqTime().booleanValue()) {
            if (!((String)allowReq).isEmpty()) {
                allowReq = (String)allowReq + ", ";
            }
            allowReq = (String)allowReq + msg.colTime();
            allowReqOrd += 2;
        }
        if (this.isAllowReqDistribution() != null && this.isAllowReqDistribution().booleanValue()) {
            if (!((String)allowReq).isEmpty()) {
                allowReq = (String)allowReq + ", ";
            }
            allowReq = (String)allowReq + msg.colDistribution();
            allowReqOrd += 4;
        }
        if (allowReqOrd == 7) {
            allowReq = msg.colAll();
        }
        if (allowReqOrd == 0) {
            allowReq = "";
        }
        return allowReq;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public Long getId() {
        return this.iUniqueId;
    }

    public void setId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public void setSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public String getAcademicSessionName() {
        return this.iAcademicSessionName;
    }

    public void setAcademicSessionName(String academicSessionName) {
        this.iAcademicSessionName = academicSessionName;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getDeptCode() {
        return this.iDeptCode;
    }

    public void setDeptCode(String deptCode) {
        this.iDeptCode = deptCode;
    }

    public String getStatusTypeCode() {
        return this.iStatusTypeCode;
    }

    public void setStatusTypeCode(String statusType) {
        this.iStatusTypeCode = statusType;
    }

    public String getStatusTypeStr() {
        return this.iStatusType;
    }

    public void setStatusTypeStr(String statusType) {
        this.iStatusType = statusType;
    }

    public String getAbbreviation() {
        return this.iAbbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.iAbbreviation = abbreviation;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(String externalId) {
        this.iExternalId = externalId;
    }

    public Integer getDistributionPrefPriority() {
        return this.iDistributionPrefPriority;
    }

    public void setDistributionPrefPriority(Integer distributionPrefPriority) {
        this.iDistributionPrefPriority = distributionPrefPriority;
    }

    public String effectiveStatusType() {
        String t = this.getStatusTypeStr();
        if (t != null) {
            return t;
        }
        return t;
    }

    public String getExternalMgrLabel() {
        return this.iExternalMgrLabel;
    }

    public void setExternalMgrLabel(String externalMgrLabel) {
        this.iExternalMgrLabel = externalMgrLabel;
    }

    public String getExternalMgrAbbv() {
        return this.iExternalMgrAbbv;
    }

    public void setExternalMgrAbbv(String externalMgrAbbv) {
        this.iExternalMgrAbbv = externalMgrAbbv;
    }

    public Integer getTimetableManagersCount() {
        return this.iTimetableManagerCount;
    }

    public void setTimetableManagersCount(Integer timetableManagerCount) {
        this.iTimetableManagerCount = timetableManagerCount;
    }

    public String getLastChangeStr() {
        return this.iLastChangeStr;
    }

    public void setLastChangeStr(String lastChangeStr) {
        this.iLastChangeStr = lastChangeStr;
    }

    public Boolean isExternalManager() {
        return this.iExternalManager;
    }

    public Boolean getExternalManager() {
        return this.iExternalManager;
    }

    public void setExternalManager(Boolean externalManager) {
        this.iExternalManager = externalManager;
    }

    public String getExternalStatusTypes() {
        return this.iExternalStatusTypesStr;
    }

    public void setExternalStatusTypes(String externalStatusTypes) {
        this.iExternalStatusTypesStr = externalStatusTypes;
    }

    public ArrayList<String> getDependentStatuses() {
        return this.iDependentStatuses;
    }

    public void setDependentStatuses(ArrayList<String> dependentStatuses) {
        this.iDependentStatuses = dependentStatuses;
    }

    public ArrayList<String> getDependentDepartments() {
        return this.iDependentDepartments;
    }

    public void setDependentDepartments(ArrayList<String> dependentDepartmentIds) {
        this.iDependentDepartments = dependentDepartmentIds;
    }

    public Boolean isAllowEvents() {
        return this.iAllowEvents;
    }

    public Boolean getAllowEvents() {
        return this.iAllowEvents;
    }

    public void setAllowEvents(Boolean allowEvents) {
        this.iAllowEvents = allowEvents;
    }

    public Boolean isAllowStudentScheduling() {
        return this.iAllowStudentScheduling;
    }

    public Boolean getAllowStudentScheduling() {
        return this.iAllowStudentScheduling;
    }

    public void setAllowStudentScheduling(Boolean allowStudentScheduling) {
        this.iAllowStudentScheduling = allowStudentScheduling;
    }

    public Boolean isInheritInstructorPreferences() {
        return this.iInheritInstructorPreferences;
    }

    public Boolean getInheritInstructorPreferences() {
        return this.iInheritInstructorPreferences;
    }

    public void setInheritInstructorPreferences(Boolean inheritInstructorPreferences) {
        this.iInheritInstructorPreferences = inheritInstructorPreferences;
    }

    public Boolean isAllowReqTime() {
        return this.iAllowReqTime;
    }

    public Boolean getAllowReqTime() {
        return this.iAllowReqTime;
    }

    public void setAllowReqTime(Boolean allowReqTime) {
        this.iAllowReqTime = allowReqTime;
    }

    public Boolean isAllowReqRoom() {
        return this.iAllowReqRoom;
    }

    public Boolean getAllowReqRoom() {
        return this.iAllowReqRoom;
    }

    public void setAllowReqRoom(Boolean allowReqRoom) {
        this.iAllowReqRoom = allowReqRoom;
    }

    public Boolean isAllowReqDistribution() {
        return this.iAllowReqDistribution;
    }

    public Boolean getAllowReqDistribution() {
        return this.iAllowReqDistribution;
    }

    public void setAllowReqDistribution(Boolean allowReqDistribution) {
        this.iAllowReqDistribution = allowReqDistribution;
    }

    public Boolean isExternalFundingDept() {
        return this.iExternalFundingDept;
    }

    public Boolean getExternalFundingDept() {
        return this.iExternalFundingDept;
    }

    public void setExternalFundingDept(Boolean externalFundingDept) {
        this.iExternalFundingDept = externalFundingDept;
    }

    public ArrayList<String> getDependentStatusesStr() {
        return this.iDependentStatusesStr;
    }

    public void setDependentStatusesStr(ArrayList<String> dependentStatuses) {
        this.iDependentStatusesStr = dependentStatuses;
    }

    public Integer getSubjectAreaCount() {
        return this.iSubjectAreaCount;
    }

    public void setSubjectAreaCount(Integer subjectAreas) {
        this.iSubjectAreaCount = subjectAreas;
    }

    public Integer getRoomDeptCount() {
        return this.iRoomDeptsCount;
    }

    public void setRoomDeptCount(Integer roomDepts) {
        this.iRoomDeptsCount = roomDepts;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public int compareTo(DepartmentInterface d) {
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(d.getUniqueId() == null ? -1L : d.getUniqueId());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DepartmentInterface)) {
            return false;
        }
        return this.getId().equals(((DepartmentInterface)object).getId());
    }

    public static class DepartmentsDataResponse
    implements GwtRpcResponse {
        private List<DepartmentInterface> iDepartments;
        private boolean iCanAdd;
        private boolean iFundingDeptEnabled;
        private boolean iCanExportPdf = true;

        public boolean isCanAdd() {
            return this.iCanAdd;
        }

        public void setCanAdd(boolean canAdd) {
            this.iCanAdd = canAdd;
        }

        public boolean isFundingDeptEnabled() {
            return this.iFundingDeptEnabled;
        }

        public void setFundingDeptEnabled(boolean fundingDepartmentsEnabled) {
            this.iFundingDeptEnabled = fundingDepartmentsEnabled;
        }

        public void addDepartment(DepartmentInterface department) {
            if (this.iDepartments == null) {
                this.iDepartments = new ArrayList<DepartmentInterface>();
            }
            this.iDepartments.add(department);
        }

        public boolean isCanExportPdf() {
            return this.iCanExportPdf;
        }

        public void setCanExportPdf(boolean canExportPdf) {
            this.iCanExportPdf = canExportPdf;
        }

        public List<DepartmentInterface> getDepartments() {
            return this.iDepartments;
        }

        public boolean hasDepartments() {
            return this.iDepartments != null && !this.iDepartments.isEmpty();
        }
    }

    public static class GetDepartmentsRequest
    implements GwtRpcRequest<DepartmentsDataResponse> {
    }

    public static class DepartmentOption
    implements IsSerializable {
        private Long iId;
        private String iLabel;

        public DepartmentOption() {
        }

        public DepartmentOption(Long id, String label) {
            this.iId = id;
            this.iLabel = label;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }
    }

    public static class StatusOption
    implements IsSerializable {
        private Long iId;
        private String iReference;
        private String iLabel;

        public StatusOption() {
        }

        public StatusOption(Long id, String ref, String label) {
            this.iId = id;
            this.iReference = ref;
            this.iLabel = label;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getReference() {
            return this.iReference;
        }

        public void setReference(String ref) {
            this.iReference = ref;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }
    }

    public static class DepartmentPropertiesInterface
    implements GwtRpcResponse {
        private boolean iCanExportPdf = true;
        private boolean iCoursesFundingDepartmentsEnabled = false;
        private String iAcademicSessionName = null;
        private List<StatusOption> iStatuses;
        private List<DepartmentOption> iExtDepartments;
        private Boolean iCanEdit = false;
        private Boolean iCanDelete = false;
        private Boolean iCanChangeExtManager = true;

        public boolean isCanExportPdf() {
            return this.iCanExportPdf;
        }

        public void setCanExportPdf(boolean canExportPdf) {
            this.iCanExportPdf = canExportPdf;
        }

        public boolean isCoursesFundingDepartmentsEnabled() {
            return this.iCoursesFundingDepartmentsEnabled;
        }

        public void setCoursesFundingDepartmentsEnabled(boolean coursesFundingDepartmentsEnabled) {
            this.iCoursesFundingDepartmentsEnabled = coursesFundingDepartmentsEnabled;
        }

        public String getAcademicSessionName() {
            return this.iAcademicSessionName;
        }

        public void setAcademicSessionName(String academicSessionName) {
            this.iAcademicSessionName = academicSessionName;
        }

        public List<StatusOption> getStatusOptions() {
            return this.iStatuses;
        }

        public void setStatusOptions(List<StatusOption> statuses) {
            this.iStatuses = statuses;
        }

        public void addStatusOption(StatusOption option) {
            if (this.iStatuses == null) {
                this.iStatuses = new ArrayList<StatusOption>();
            }
            this.iStatuses.add(option);
        }

        public List<DepartmentOption> getExtDepartmentOptions() {
            return this.iExtDepartments;
        }

        public void setExtDepartmentOptions(List<DepartmentOption> departments) {
            this.iExtDepartments = departments;
        }

        public void addExtDepartmentOption(DepartmentOption department) {
            if (this.iExtDepartments == null) {
                this.iExtDepartments = new ArrayList<DepartmentOption>();
            }
            this.iExtDepartments.add(department);
        }

        public boolean getCanEdit() {
            return this.iCanEdit;
        }

        public void setCanEdit(boolean canEdit) {
            this.iCanEdit = canEdit;
        }

        public boolean getCanDelete() {
            return this.iCanDelete;
        }

        public void setCanDelete(boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public boolean isCanChangeExtManager() {
            return this.iCanChangeExtManager;
        }

        public void setCanChangeExtManager(boolean canChangeExtManager) {
            this.iCanChangeExtManager = canChangeExtManager;
        }
    }

    public static class DepartmentPropertiesRequest
    implements GwtRpcRequest<DepartmentPropertiesInterface> {
        private Long iDepartmentId;

        protected DepartmentPropertiesRequest() {
        }

        public DepartmentPropertiesRequest(Long departmentId) {
            this.setDepartmentId(departmentId);
        }

        public Long getDepartmentId() {
            return this.iDepartmentId;
        }

        public void setDepartmentId(Long departmentId) {
            this.iDepartmentId = departmentId;
        }
    }

    public static enum UpdateDepartmentAction {
        CREATE,
        UPDATE,
        DELETE;

    }

    public static enum DepartmentsColumn {
        CODE,
        ABBV,
        NAME,
        EXTERNAL_MANAGER,
        SUBJECTS,
        ROOMS,
        STATUS,
        DIST_PREF_PRIORITY,
        ALLOW_REQUIRED,
        INSTRUCTOR_PREF,
        EVENTS,
        STUDENT_SCHEDULING,
        EXT_FUNDING_DEPT,
        LAST_CHANGE;

    }
}

