/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaHiddenLabel;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTabBar;
import org.unitime.timetable.gwt.client.widgets.CourseFinder;
import org.unitime.timetable.gwt.client.widgets.CourseFinderClasses;
import org.unitime.timetable.gwt.client.widgets.CourseFinderFilter;
import org.unitime.timetable.gwt.client.widgets.DataProvider;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class CourseFinderMultipleCourses
extends P
implements CourseFinder.CourseFinderTab<Collection<ClassAssignmentInterface.CourseAssignment>> {
    protected static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>> iDataProvider = null;
    private UniTimeTable<ClassAssignmentInterface.CourseAssignment> iCourses;
    private ScrollPanel iCoursesPanel;
    private Label iCoursesTip;
    private AriaTabBar iCourseDetailsTabBar;
    private ScrollPanel iCourseDetailsPanel;
    private Map<Character, Integer> iTabAccessKeys = new HashMap<Character, Integer>();
    private CourseFinder.CourseFinderCourseDetails[] iDetails = null;
    private String iLastQuery = null;
    private P iInstructionalMethodsPanel = null;
    private Map<CourseRequestInterface.Preference, CheckBox> iInstructionalMethods = new HashMap<CourseRequestInterface.Preference, CheckBox>();
    private Set<CourseRequestInterface.Preference> iSelectedMethods = new HashSet<CourseRequestInterface.Preference>();
    private CheckBox iRequired = null;
    private SpecialRegistrationInterface.SpecialRegistrationContext iSpecReg;
    private List<CourseRequestInterface.RequestedCourse> iCheckedCourses = new ArrayList<CourseRequestInterface.RequestedCourse>();
    private ClassAssignmentInterface.CourseAssignment iLastDetails = null;
    private boolean iAllowMultiSelection = true;
    private CourseFinderFilter iFilter;
    private boolean iShowCourseTitles = false;
    private boolean iShowDefaultSuggestions = false;
    private boolean iShowWaitLists = true;

    public CourseFinderMultipleCourses(OnlineSectioningInterface.StudentSectioningContext context) {
        this(context, false, false, false, null, true);
    }

    public CourseFinderMultipleCourses(OnlineSectioningInterface.StudentSectioningContext context, boolean showCourseTitles, boolean showDefaultSuggestions, boolean showRequired, SpecialRegistrationInterface.SpecialRegistrationContext specReg, boolean showWaitLists) {
        super("courses");
        this.iShowCourseTitles = showCourseTitles;
        this.iShowDefaultSuggestions = showDefaultSuggestions;
        this.iSpecReg = specReg;
        this.iShowWaitLists = showWaitLists;
        this.iCourses = new UniTimeTable();
        this.iCourses.setAllowMultiSelect(false);
        this.iCourses.setAllowSelection(true);
        ArrayList<UniTimeTableHeader> head = new ArrayList<UniTimeTableHeader>();
        head.add(new UniTimeTableHeader(""));
        head.add(new UniTimeTableHeader(MESSAGES.colSubject()));
        head.add(new UniTimeTableHeader(MESSAGES.colCourse()));
        head.add(new UniTimeTableHeader(MESSAGES.colLimit()));
        head.add(new UniTimeTableHeader(MESSAGES.colTitle()));
        head.add(new UniTimeTableHeader(MESSAGES.colCredit()));
        head.add(new UniTimeTableHeader(MESSAGES.colNote()));
        head.add(new UniTimeTableHeader(this.iShowWaitLists ? MESSAGES.colWaitListAndAllowedOverrides() : MESSAGES.colAllowedOverrides()));
        this.iCourses.addRow(null, head);
        this.iCourses.setColumnVisible(0, this.iAllowMultiSelection);
        this.iCourses.addMouseDoubleClickListener(new UniTimeTable.MouseDoubleClickListener<ClassAssignmentInterface.CourseAssignment>(){

            @Override
            public void onMouseDoubleClick(UniTimeTable.TableEvent<ClassAssignmentInterface.CourseAssignment> event) {
                CourseFinderMultipleCourses.this.updateCourseDetails();
                if (CourseFinderMultipleCourses.this.isEnabled()) {
                    SelectionEvent.fire((HasSelectionHandlers)CourseFinderMultipleCourses.this, (Object)CourseFinderMultipleCourses.this.getValue());
                }
            }
        });
        this.iCourses.addMouseClickListener(new UniTimeTable.MouseClickListener<ClassAssignmentInterface.CourseAssignment>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<ClassAssignmentInterface.CourseAssignment> event) {
                CourseFinderMultipleCourses.this.updateCourseDetails();
            }
        });
        this.iCoursesPanel = new ScrollPanel(this.iCourses);
        this.iCoursesPanel.setStyleName("unitime-ScrollPanel");
        this.iCoursesPanel.addStyleName("course-table");
        this.iCoursesTip = new Label(CONSTANTS.courseTips()[(int)(Math.random() * (double)CONSTANTS.courseTips().length)]);
        this.iCoursesTip.setStyleName("unitime-Hint");
        this.iCoursesTip.addStyleName("course-tip");
        ToolBox.disableTextSelectInternal((Element)this.iCoursesTip.getElement());
        this.iCoursesTip.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String oldText = CourseFinderMultipleCourses.this.iCoursesTip.getText();
                do {
                    CourseFinderMultipleCourses.this.iCoursesTip.setText(CONSTANTS.courseTips()[(int)(Math.random() * (double)CONSTANTS.courseTips().length)]);
                } while (oldText.equals(CourseFinderMultipleCourses.this.iCoursesTip.getText()));
            }
        });
        this.iCourseDetailsTabBar = new AriaTabBar();
        this.iCourseDetailsTabBar.addStyleName("course-details-tabs");
        this.iCourseDetailsPanel = new ScrollPanel();
        this.iCourseDetailsPanel.addStyleName("course-details");
        this.iCourseDetailsTabBar.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                ToolBox.setSessionCookie("UniTime:CourseFinderCourses", String.valueOf(event.getSelectedItem()));
                CourseFinderMultipleCourses.this.iCourseDetailsPanel.setWidget((IsWidget)CourseFinderMultipleCourses.this.iDetails[(Integer)event.getSelectedItem()]);
            }
        });
        this.iInstructionalMethodsPanel = new P("instructional-methods");
        this.iCourseDetailsTabBar.setRestWidget((Widget)this.iInstructionalMethodsPanel);
        if (showRequired) {
            this.iRequired = new CheckBox(MESSAGES.checkPreferencesAreRequired());
            this.iRequired.addStyleName("required-check");
            this.iRequired.setEnabled(this.isEnabled());
            this.iRequired.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> event) {
                    for (CourseRequestInterface.Preference p : CourseFinderMultipleCourses.this.iInstructionalMethods.keySet()) {
                        p.setRequired((Boolean)event.getValue());
                    }
                    for (CourseRequestInterface.Preference p : CourseFinderMultipleCourses.this.iSelectedMethods) {
                        p.setRequired((Boolean)event.getValue());
                    }
                }
            });
        }
        this.iFilter = new CourseFinderFilter(context);
        this.iFilter.addValueChangeHandler(new ValueChangeHandler<CourseRequestInterface.Filter>(){

            public void onValueChange(ValueChangeEvent<CourseRequestInterface.Filter> event) {
                if (CourseFinderMultipleCourses.this.iLastQuery != null) {
                    CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                    rc.setCourseName(CourseFinderMultipleCourses.this.iLastQuery);
                    CourseFinderMultipleCourses.this.reload(rc);
                }
            }
        });
        this.add((Widget)this.iFilter);
        this.add((Widget)this.iCoursesPanel);
        this.add((Widget)this.iCourseDetailsTabBar);
        this.add((Widget)this.iCourseDetailsPanel);
        this.add((Widget)this.iCoursesTip);
    }

    public void setShowWaitLists(boolean showWaitLists) {
        this.iShowWaitLists = showWaitLists;
        ((UniTimeTableHeader)this.iCourses.getWidget(0, 7)).setText(this.iShowWaitLists ? MESSAGES.colWaitListAndAllowedOverrides() : MESSAGES.colAllowedOverrides());
    }

    @Override
    public void setDataProvider(DataProvider<String, Collection<ClassAssignmentInterface.CourseAssignment>> provider) {
        this.iDataProvider = provider;
    }

    @Override
    public String getName() {
        return MESSAGES.courseSelectionCourses();
    }

    public Widget asWidget() {
        return this;
    }

    public void setValue(CourseRequestInterface.RequestedCourse value) {
        this.setValue(value, false);
    }

    public CourseRequestInterface.RequestedCourse getValue() {
        int row = this.iCourses.getSelectedRow();
        if (this.iCourses.getSelectedRow() < 0) {
            return null;
        }
        ClassAssignmentInterface.CourseAssignment record = this.iCourses.getData(row);
        if (record == null) {
            return null;
        }
        CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
        rc.setCourseId(record.getCourseId());
        rc.setCourseName(MESSAGES.courseName(record.getSubject(), record.getCourseNbr()));
        if (record.hasTitle() && (!record.hasUniqueName() || this.iShowCourseTitles)) {
            rc.setCourseName(MESSAGES.courseNameWithTitle(record.getSubject(), record.getCourseNbr(), record.getTitle()));
        }
        rc.setCourseTitle(record.getTitle());
        rc.setCredit(record.guessCreditRange());
        rc.setCanWaitList(record.isCanWaitList());
        rc.setParentCourseId(record.getParentCourseId());
        for (Map.Entry<CourseRequestInterface.Preference, CheckBox> e : this.iInstructionalMethods.entrySet()) {
            if (!e.getValue().isEnabled() || !e.getValue().getValue().booleanValue()) continue;
            rc.setSelectedIntructionalMethod(e.getKey(), true);
        }
        if (this.iDetails != null) {
            for (CourseFinder.CourseFinderCourseDetails d : this.iDetails) {
                d.onGetValue(rc);
            }
        }
        if (this.iCheckedCourses.contains(rc)) {
            this.iCheckedCourses.set(this.iCheckedCourses.indexOf(rc), rc);
        }
        return rc;
    }

    protected boolean isSelectedMethodRequired(Long id) {
        for (CourseRequestInterface.Preference p : this.iSelectedMethods) {
            if (!p.getId().equals(id)) continue;
            return p.isRequired();
        }
        return this.iRequired != null && this.iRequired.isEnabled() && this.iRequired.getValue() != false;
    }

    protected boolean isSelectedMethod(Long id) {
        for (CourseRequestInterface.Preference p : this.iSelectedMethods) {
            if (!p.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public void setValue(CourseRequestInterface.RequestedCourse value, boolean fireEvents) {
        this.setValue(value, fireEvents, false);
    }

    public void setValue(CourseRequestInterface.RequestedCourse value, final boolean fireEvents, boolean reload) {
        this.iCheckedCourses.clear();
        for (int r = 0; r < this.iCourses.getRowCount(); ++r) {
            ClassAssignmentInterface.CourseAssignment ca = this.iCourses.getData(r);
            if (!(this.iCourses.getWidget(r, 0) instanceof CheckBox) || ca == null) continue;
            CheckBox c = (CheckBox)this.iCourses.getWidget(r, 0);
            c.setValue(Boolean.valueOf(false));
            c.setText("");
        }
        String query = value == null || !value.isCourse() ? "" : value.getCourseName();
        this.iSelectedMethods.clear();
        if (this.iRequired != null) {
            this.iRequired.setValue(Boolean.valueOf(false));
        }
        for (CheckBox ch : this.iInstructionalMethods.values()) {
            if (!ch.isEnabled()) continue;
            ch.setValue(Boolean.valueOf(false));
        }
        if (value != null && value.hasSelectedIntructionalMethods()) {
            for (CourseRequestInterface.Preference id : value.getSelectedIntructionalMethods()) {
                CheckBox ch;
                this.iSelectedMethods.add(id);
                if (id.isRequired() && this.iRequired != null) {
                    this.iRequired.setValue(Boolean.valueOf(true));
                }
                if ((ch = this.iInstructionalMethods.get(id)) == null || !ch.isEnabled()) continue;
                ch.setValue(Boolean.valueOf(true));
            }
        }
        if (this.iDetails != null) {
            for (CourseFinder.CourseFinderCourseDetails d : this.iDetails) {
                d.onSetValue(value);
            }
        }
        if (query.isEmpty() && !this.iShowDefaultSuggestions) {
            this.iLastQuery = null;
            this.iCourses.clearTable(1);
            this.iCourses.setEmptyMessage(MESSAGES.courseSelectionNoCourseFilter());
            this.updateCourseDetails();
        } else if (!query.equals(this.iLastQuery) || reload) {
            this.iLastQuery = query;
            this.iDataProvider.getData(query, new AsyncCallback<Collection<ClassAssignmentInterface.CourseAssignment>>(){

                public void onFailure(Throwable caught) {
                    CourseFinderMultipleCourses.this.iCourses.clearTable(1);
                    CourseFinderMultipleCourses.this.iCourses.setEmptyMessage(caught.getMessage());
                    if (CourseFinderMultipleCourses.this.isVisible()) {
                        AriaStatus.getInstance().setText(caught.getMessage());
                    }
                    CourseFinderMultipleCourses.this.updateCourseDetails();
                    CourseFinder.ResponseEvent.fire(CourseFinderMultipleCourses.this, false);
                }

                public void onSuccess(Collection<ClassAssignmentInterface.CourseAssignment> result) {
                    CourseFinderMultipleCourses.this.iCourses.clearTable(1);
                    boolean hasCredit = false;
                    boolean hasNote = false;
                    boolean hasWaitList = false;
                    for (final ClassAssignmentInterface.CourseAssignment record : result) {
                        ArrayList<Object> line = new ArrayList<Object>();
                        final CheckBox ch = new CheckBox(){

                            protected void onAttach() {
                                super.onAttach();
                                this.setTabIndex(-1);
                            }
                        };
                        ch.setValue(Boolean.valueOf(CourseFinderMultipleCourses.this.iCheckedCourses.contains(new CourseRequestInterface.RequestedCourse(record, CONSTANTS.showCourseTitle()))));
                        ch.setText(ch.getValue() != false ? String.valueOf(CourseFinderMultipleCourses.this.iCheckedCourses.indexOf(new CourseRequestInterface.RequestedCourse(record, CONSTANTS.showCourseTitle())) + 1) : "");
                        ch.addFocusHandler(new FocusHandler(){

                            public void onFocus(FocusEvent event) {
                                int row = CourseFinderMultipleCourses.this.iCourses.getRowForWidget((Widget)ch);
                                if (row >= 1) {
                                    CourseFinderMultipleCourses.this.iCourses.setSelected(row, true);
                                }
                            }
                        });
                        ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                            public void onValueChange(ValueChangeEvent<Boolean> event) {
                                CourseRequestInterface.RequestedCourse rc = new CourseRequestInterface.RequestedCourse();
                                rc.setCourseId(record.getCourseId());
                                rc.setCourseName(MESSAGES.courseName(record.getSubject(), record.getCourseNbr()));
                                if (record.hasTitle() && (!record.hasUniqueName() || CourseFinderMultipleCourses.this.iShowCourseTitles)) {
                                    rc.setCourseName(MESSAGES.courseNameWithTitle(record.getSubject(), record.getCourseNbr(), record.getTitle()));
                                }
                                rc.setCourseTitle(record.getTitle());
                                rc.setCredit(record.guessCreditRange());
                                rc.setCanWaitList(record.isCanWaitList());
                                rc.setParentCourseId(record.getParentCourseId());
                                if (((Boolean)event.getValue()).booleanValue()) {
                                    CourseFinderMultipleCourses.this.iCheckedCourses.add(rc);
                                } else {
                                    CourseFinderMultipleCourses.this.iCheckedCourses.remove(rc);
                                }
                                for (int r = 0; r < CourseFinderMultipleCourses.this.iCourses.getRowCount(); ++r) {
                                    CheckBox c;
                                    ClassAssignmentInterface.CourseAssignment ca = CourseFinderMultipleCourses.this.iCourses.getData(r);
                                    if (!(CourseFinderMultipleCourses.this.iCourses.getWidget(r, 0) instanceof CheckBox) || ca == null) continue;
                                    c.setText((c = (CheckBox)CourseFinderMultipleCourses.this.iCourses.getWidget(r, 0)).getValue() != false ? String.valueOf(CourseFinderMultipleCourses.this.iCheckedCourses.indexOf(new CourseRequestInterface.RequestedCourse(ca, CONSTANTS.showCourseTitle())) + 1) : "");
                                }
                            }
                        });
                        line.add(ch);
                        line.add(new Label(record.getSubject(), false));
                        line.add(new Label(record.getCourseNbr(), false));
                        line.add(new HTML((String)(record.getLimit() == null || record.getLimit() == 0 || record.getEnrollment() == null ? "" : (record.getLimit() < 0 ? "&infin;" : record.getLimit() - record.getEnrollment() + " / " + record.getLimit())), false));
                        line.add(new Label(record.getTitle() == null ? "" : record.getTitle(), false));
                        if (record.hasCredit()) {
                            Label credit = new Label(record.getCreditAbbv(), false);
                            if (record.hasCredit()) {
                                credit.setTitle(record.getCreditText());
                            }
                            line.add(credit);
                            hasCredit = true;
                        } else {
                            line.add(new Label());
                        }
                        line.add(new Label(record.getNote() == null ? "" : record.getNote()));
                        if (record.hasNote()) {
                            hasNote = true;
                        }
                        P wl = new P("courses-wl");
                        if (record.isCanWaitList() && CourseFinderMultipleCourses.this.iShowWaitLists) {
                            Label l = new Label(MESSAGES.courseAllowsForWaitListing());
                            l.setTitle(MESSAGES.courseAllowsForWaitListingTitle(record.getCourseName()));
                            wl.add((Widget)l);
                            hasWaitList = true;
                        }
                        if (record.hasOverrides()) {
                            for (ClassAssignmentInterface.CodeLabel override : record.getOverrides()) {
                                Label l = new Label(override.getCode());
                                l.setTitle(override.getLabel());
                                wl.add((Widget)l);
                                hasWaitList = true;
                            }
                        }
                        line.add((Object)wl);
                        if (record.hasTitle()) {
                            if (record.hasNote()) {
                                line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourseWithTitleAndNote(record.getSubject(), record.getCourseNbr(), record.getTitle(), record.getNote())));
                            } else {
                                line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourseWithTitle(record.getSubject(), record.getCourseNbr(), record.getTitle())));
                            }
                        } else if (record.hasNote()) {
                            line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourseWithNote(record.getSubject(), record.getCourseNbr(), record.getNote())));
                        } else {
                            line.add((Object)new AriaHiddenLabel(ARIA.courseFinderCourse(record.getSubject(), record.getCourseNbr())));
                        }
                        int row = CourseFinderMultipleCourses.this.iCourses.addRow(record, line);
                        if (!CourseFinderMultipleCourses.this.iLastQuery.equalsIgnoreCase(MESSAGES.courseName(record.getSubject(), record.getCourseNbr())) && (record.getTitle() == null || !CourseFinderMultipleCourses.this.iLastQuery.equalsIgnoreCase(MESSAGES.courseNameWithTitle(record.getSubject(), record.getCourseNbr(), record.getTitle())))) continue;
                        CourseFinderMultipleCourses.this.iCourses.setSelected(row, true);
                    }
                    CourseFinderMultipleCourses.this.iCourses.setColumnVisible(5, hasCredit);
                    CourseFinderMultipleCourses.this.iCourses.setColumnVisible(6, hasNote);
                    CourseFinderMultipleCourses.this.iCourses.setColumnVisible(7, hasWaitList);
                    if (result.size() == 1) {
                        CourseFinderMultipleCourses.this.iCourses.setSelected(1, true);
                    }
                    if (CourseFinderMultipleCourses.this.iCourses.getSelectedRow() >= 0) {
                        CourseFinderMultipleCourses.this.scrollToSelectedRow();
                        if (fireEvents) {
                            ValueChangeEvent.fire((HasValueChangeHandlers)CourseFinderMultipleCourses.this, (Object)CourseFinderMultipleCourses.this.getValue());
                        }
                    }
                    CourseFinderMultipleCourses.this.updateCourseDetails();
                    CourseFinder.ResponseEvent.fire(CourseFinderMultipleCourses.this, !result.isEmpty());
                }
            });
        }
        if (this.iRequired != null) {
            this.iRequired.setEnabled(this.isEnabled() && (this.iSpecReg == null || this.iSpecReg.isCanRequire()));
            this.iRequired.setVisible(this.iSpecReg == null || this.iSpecReg.isCanRequire());
        }
    }

    public void scrollToSelectedRow() {
        int row = this.iCourses.getSelectedRow();
        if (row >= 0) {
            this.iCourses.getCellFormatter().getElement(row, 0).scrollIntoView();
        }
    }

    protected void updateCourseDetails() {
        ClassAssignmentInterface.CourseAssignment record;
        if (this.iLastDetails != null) {
            for (CourseRequestInterface.RequestedCourse rc : this.iCheckedCourses) {
                if (!rc.equals(this.iLastDetails)) continue;
                rc.clearSelection();
                for (Map.Entry entry : this.iInstructionalMethods.entrySet()) {
                    if (!((CheckBox)entry.getValue()).isEnabled() || !((CheckBox)entry.getValue()).getValue().booleanValue()) continue;
                    rc.setSelectedIntructionalMethod((CourseRequestInterface.Preference)entry.getKey(), true);
                }
                if (this.iDetails == null) continue;
                for (CourseFinder.CourseFinderCourseDetails courseFinderCourseDetails : this.iDetails) {
                    courseFinderCourseDetails.onGetValue(rc);
                }
            }
        }
        int row = this.iCourses.getSelectedRow();
        this.iLastDetails = record = this.iCourses.getData(row);
        if (record == null) {
            if (this.iDetails != null) {
                for (CourseFinder.CourseFinderCourseDetails courseFinderCourseDetails : this.iDetails) {
                    courseFinderCourseDetails.setValue(null);
                }
            }
            if (this.isVisible() && this.isAttached()) {
                AriaStatus.getInstance().setHTML(ARIA.courseFinderNoCourse());
            }
            this.iInstructionalMethodsPanel.clear();
            this.iInstructionalMethods.clear();
        } else {
            for (CourseFinder.CourseFinderCourseDetails courseFinderCourseDetails : this.iDetails) {
                courseFinderCourseDetails.setValue(record);
            }
            if (record.hasTitle()) {
                if (record.hasNote()) {
                    AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithTitleAndNote(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr(), record.getTitle(), record.getNote()));
                } else {
                    AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithTitle(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr(), record.getTitle()));
                }
            } else if (record.hasNote()) {
                AriaStatus.getInstance().setHTML(ARIA.courseFinderSelectedWithNote(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr(), record.getNote()));
            } else {
                AriaStatus.getInstance().setHTML(ARIA.courseFinderSelected(this.iCourses.getSelectedRow(), this.iCourses.getRowCount() - 1, record.getSubject(), record.getCourseNbr()));
            }
            this.iInstructionalMethodsPanel.clear();
            this.iInstructionalMethods.clear();
            if (record.hasInstructionalMethodSelection()) {
                imp = new P("preference-label");
                imp.setText(MESSAGES.labelInstructionalMethodPreference());
                this.iInstructionalMethodsPanel.add((Widget)imp);
                for (ClassAssignmentInterface.IdValue m : record.getInstructionalMethods()) {
                    CheckBox checkBox = new CheckBox(m.getValue());
                    checkBox.setValue(Boolean.valueOf(this.isSelectedMethod(m.getId())));
                    checkBox.setEnabled(this.isEnabled());
                    final CourseRequestInterface.Preference p = new CourseRequestInterface.Preference(m.getId(), m.getValue(), this.isSelectedMethodRequired(m.getId()));
                    checkBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                        public void onValueChange(ValueChangeEvent<Boolean> event) {
                            if (((Boolean)event.getValue()).booleanValue()) {
                                CourseFinderMultipleCourses.this.iSelectedMethods.add(p);
                            } else {
                                CourseFinderMultipleCourses.this.iSelectedMethods.remove(p);
                            }
                        }
                    });
                    checkBox.addStyleName("instructional-method");
                    this.iInstructionalMethods.put(p, checkBox);
                    this.iInstructionalMethodsPanel.add((Widget)checkBox);
                }
            } else if (record.hasInstructionalMethods()) {
                imp = new P("preference-label");
                imp.setText(MESSAGES.labelInstructionalMethodPreference());
                this.iInstructionalMethodsPanel.add((Widget)imp);
                for (ClassAssignmentInterface.IdValue m : record.getInstructionalMethods()) {
                    CheckBox checkBox = new CheckBox(m.getValue());
                    checkBox.addStyleName("instructional-method");
                    checkBox.setValue(Boolean.valueOf(true));
                    checkBox.setEnabled(false);
                    this.iInstructionalMethods.put(new CourseRequestInterface.Preference(m.getId(), m.getValue(), this.isSelectedMethodRequired(m.getId())), checkBox);
                    this.iInstructionalMethodsPanel.add((Widget)checkBox);
                }
            }
            if (this.iRequired != null) {
                this.iInstructionalMethodsPanel.add((Widget)this.iRequired);
            }
        }
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<CourseRequestInterface.RequestedCourse> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface.RequestedCourse> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    @Override
    public boolean isCourseSelection() {
        return true;
    }

    @Override
    public void setCourseDetails(CourseFinder.CourseFinderCourseDetails ... details) {
        this.iDetails = details;
        int tabIndex = 0;
        for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
            ScrollPanel panel = new ScrollPanel(detail.asWidget());
            panel.setStyleName("unitime-ScrollPanel-inner");
            panel.addStyleName("course-info");
            this.iCourseDetailsTabBar.addTab(detail.getName(), true);
            Character ch = UniTimeHeaderPanel.guessAccessKey(detail.getName());
            if (ch != null) {
                this.iTabAccessKeys.put(ch, tabIndex);
            }
            ++tabIndex;
        }
        this.selectLastTab();
    }

    @Override
    public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        if (event.getNativeEvent().getCtrlKey() || event.getNativeEvent().getAltKey()) {
            for (Map.Entry<Character, Integer> entry : this.iTabAccessKeys.entrySet()) {
                if (event.getNativeEvent().getKeyCode() != Character.toLowerCase(entry.getKey().charValue()) && event.getNativeEvent().getKeyCode() != Character.toUpperCase(entry.getKey().charValue())) continue;
                this.iCourseDetailsTabBar.selectTab(entry.getValue(), true);
                event.cancel();
            }
        }
        if (event.getTypeInt() == 128) {
            if (this.iCourses.getRowCount() < 2 || this.iCourses.getData(1) == null) {
                return;
            }
            int row = this.iCourses.getSelectedRow();
            if (event.getNativeEvent().getKeyCode() == 40 && this.isEnabled() && !this.iFilter.isPopupShowing()) {
                if (row < 0 || this.iCourses.getSelectedRow() + 1 >= this.iCourses.getRowCount()) {
                    this.iCourses.setSelected(1, true);
                } else {
                    this.iCourses.setSelected(row + 1, true);
                }
                this.scrollToSelectedRow();
                this.updateCourseDetails();
                event.cancel();
            } else if (event.getNativeEvent().getKeyCode() == 38 && this.isEnabled() && !this.iFilter.isPopupShowing()) {
                if (row - 1 < 1) {
                    this.iCourses.setSelected(this.iCourses.getRowCount() - 1, true);
                } else {
                    this.iCourses.setSelected(row - 1, true);
                }
                this.scrollToSelectedRow();
                this.updateCourseDetails();
                event.cancel();
            } else if (event.getNativeEvent().getKeyCode() == 32 && this.isEnabled() && row >= 1) {
                CheckBox c;
                InputElement input;
                if (InputElement.is((JavaScriptObject)event.getNativeEvent().getEventTarget()) && "checkbox".equals((input = (InputElement)InputElement.as((JavaScriptObject)event.getNativeEvent().getEventTarget())).getType())) {
                    return;
                }
                if (ImageElement.is((JavaScriptObject)event.getNativeEvent().getEventTarget())) {
                    return;
                }
                c.setValue(Boolean.valueOf((c = (CheckBox)this.iCourses.getWidget(row, 0)).getValue() == false), true);
                this.updateCourseDetails();
                event.cancel();
            }
        }
    }

    @Override
    public HandlerRegistration addResponseHandler(CourseFinder.ResponseHandler handler) {
        return this.addHandler(handler, CourseFinder.ResponseEvent.getType());
    }

    private void selectLastTab() {
        try {
            int tab = Integer.valueOf(ToolBox.getSessionCookie("UniTime:CourseFinderCourses"));
            if (tab >= 0 || tab < this.iCourseDetailsTabBar.getTabCount() && tab != this.iCourseDetailsTabBar.getSelectedTab()) {
                this.iCourseDetailsTabBar.selectTab(tab, true);
            } else {
                this.iCourseDetailsTabBar.selectTab(0, true);
            }
        }
        catch (Exception e) {
            this.iCourseDetailsTabBar.selectTab(0, true);
        }
    }

    @Override
    public void changeTip() {
        this.iCoursesTip.setText(CONSTANTS.courseTips()[(int)(Math.random() * (double)CONSTANTS.courseTips().length)]);
        this.selectLastTab();
    }

    public boolean isEnabled() {
        return this.iCourses.isEnabled();
    }

    public List<ClassAssignmentInterface.CourseAssignment> getCourses() {
        return this.iCourses.getData();
    }

    public void setEnabled(boolean enabled) {
        this.iCourses.setEnabled(enabled);
        if (this.iDetails != null) {
            for (CourseFinder.CourseFinderCourseDetails details : this.iDetails) {
                details.setEnabled(enabled);
            }
        }
        if (this.iRequired != null) {
            this.iRequired.setEnabled(enabled && (this.iSpecReg == null || this.iSpecReg.isCanRequire()));
            this.iRequired.setVisible(this.iSpecReg == null || this.iSpecReg.isCanRequire());
        }
    }

    @Override
    public CheckBox getRequiredCheckbox() {
        return this.iRequired;
    }

    public List<CourseRequestInterface.RequestedCourse> getCheckedCourses() {
        return this.iCheckedCourses;
    }

    public boolean setCheckedCourses(List<CourseRequestInterface.RequestedCourse> checkedCourses) {
        this.iLastDetails = null;
        this.iCheckedCourses = checkedCourses;
        this.iSelectedMethods.clear();
        if (this.iRequired != null) {
            this.iRequired.setValue(Boolean.valueOf(false));
        }
        if (this.iDetails != null) {
            for (CourseFinder.CourseFinderCourseDetails detail : this.iDetails) {
                detail.setValue(null);
            }
        }
        if (this.iCourses.getSelectedRow() >= 0) {
            this.iCourses.setSelected(this.iCourses.getSelectedRow(), false);
        }
        if (!this.iCheckedCourses.isEmpty()) {
            CourseRequestInterface.RequestedCourse value = this.iCheckedCourses.get(0);
            if (value != null && value.hasSelectedIntructionalMethods()) {
                for (CourseRequestInterface.Preference id : this.iCheckedCourses.get(0).getSelectedIntructionalMethods()) {
                    this.iSelectedMethods.add(id);
                    if (!id.isRequired() || this.iRequired == null) continue;
                    this.iRequired.setValue(Boolean.valueOf(true));
                }
            }
            if (value != null && value.hasSelectedClasses()) {
                for (CourseRequestInterface.Preference p : value.getSelectedClasses()) {
                    if (!p.isRequired() || this.iRequired == null) continue;
                    this.iRequired.setValue(Boolean.valueOf(true));
                }
            }
            if (this.iDetails != null) {
                for (CourseFinder.CourseFinderCourseDetails d : this.iDetails) {
                    if (!(d instanceof CourseFinderClasses)) continue;
                    Set<CourseRequestInterface.Preference> classes = ((CourseFinderClasses)d).getAllSelectedClasses();
                    classes.clear();
                    for (CourseRequestInterface.RequestedCourse rc : this.iCheckedCourses) {
                        if (!rc.hasSelectedClasses()) continue;
                        classes.addAll(rc.getSelectedClasses());
                    }
                }
            }
        }
        int checked = 0;
        for (int r = 0; r < this.iCourses.getRowCount(); ++r) {
            ClassAssignmentInterface.CourseAssignment ca = this.iCourses.getData(r);
            if (!(this.iCourses.getWidget(r, 0) instanceof CheckBox) || ca == null) continue;
            CheckBox c = (CheckBox)this.iCourses.getWidget(r, 0);
            int idx = this.iCheckedCourses.indexOf(new CourseRequestInterface.RequestedCourse(ca, CONSTANTS.showCourseTitle()));
            c.setValue(Boolean.valueOf(idx >= 0));
            c.setText(idx >= 0 ? String.valueOf(idx + 1) : "");
            if (idx >= 0) {
                ++checked;
            }
            if (this.iCheckedCourses.isEmpty() || !this.iCheckedCourses.get(0).equals(ca)) continue;
            this.iCourses.setSelected(r, true);
        }
        this.scrollToSelectedRow();
        this.updateCourseDetails();
        return checked == checkedCourses.size();
    }

    public boolean selectCourse(ClassAssignmentInterface.CourseAssignment course) {
        for (int r = 0; r < this.iCourses.getRowCount(); ++r) {
            ClassAssignmentInterface.CourseAssignment ca = this.iCourses.getData(r);
            if (!(this.iCourses.getWidget(r, 0) instanceof CheckBox) || ca == null || !course.equals(ca)) continue;
            CheckBox c = (CheckBox)this.iCourses.getWidget(r, 0);
            boolean changed = false;
            if (!c.getValue().booleanValue()) {
                c.setValue(Boolean.valueOf(true), true);
                changed = true;
            }
            if (this.iCourses.getSelectedRow() < 0) {
                this.iCourses.setSelected(r, true);
                this.updateCourseDetails();
            }
            return changed;
        }
        return false;
    }

    public boolean isAllowMultiSelection() {
        return this.iAllowMultiSelection;
    }

    public void setAllowMultiSelection(boolean multi) {
        this.iAllowMultiSelection = multi;
        this.iCourses.setColumnVisible(0, this.iAllowMultiSelection);
    }

    public String getLastQuery() {
        return this.iLastQuery;
    }

    @Override
    public void reload(CourseRequestInterface.RequestedCourse value) {
        this.setValue(value, false, true);
    }

    public CourseRequestInterface.Filter getFilter() {
        return this.iFilter.getValue();
    }

    public void setFilter(CourseRequestInterface.Filter filter) {
        this.iFilter.setValue(filter);
    }

    @Override
    public void onBeforeShow() {
        this.iFilter.init();
    }

    @Override
    public boolean isCanSubmit(Event.NativePreviewEvent event) {
        return this.iFilter.isCanSubmit(event);
    }

    @Override
    public void reset() {
        this.iLastQuery = null;
        this.iCourses.clearTable(1);
        this.iCourses.setEmptyMessage(MESSAGES.courseSelectionNoCourseFilter());
        this.updateCourseDetails();
        this.iFilter.setValue(null);
    }
}

