/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe;

import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.RawComponent;
import biweekly.io.scribe.component.DaylightSavingsTimeScribe;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.component.ICalendarScribe;
import biweekly.io.scribe.component.RawComponentScribe;
import biweekly.io.scribe.component.StandardTimeScribe;
import biweekly.io.scribe.component.VAlarmScribe;
import biweekly.io.scribe.component.VEventScribe;
import biweekly.io.scribe.component.VFreeBusyScribe;
import biweekly.io.scribe.component.VJournalScribe;
import biweekly.io.scribe.component.VTimezoneScribe;
import biweekly.io.scribe.component.VTodoScribe;
import biweekly.io.scribe.property.ActionScribe;
import biweekly.io.scribe.property.AttachmentScribe;
import biweekly.io.scribe.property.AttendeeScribe;
import biweekly.io.scribe.property.AudioAlarmScribe;
import biweekly.io.scribe.property.CalendarScaleScribe;
import biweekly.io.scribe.property.CategoriesScribe;
import biweekly.io.scribe.property.ClassificationScribe;
import biweekly.io.scribe.property.ColorScribe;
import biweekly.io.scribe.property.CommentScribe;
import biweekly.io.scribe.property.CompletedScribe;
import biweekly.io.scribe.property.ConferenceScribe;
import biweekly.io.scribe.property.ContactScribe;
import biweekly.io.scribe.property.CreatedScribe;
import biweekly.io.scribe.property.DateDueScribe;
import biweekly.io.scribe.property.DateEndScribe;
import biweekly.io.scribe.property.DateStartScribe;
import biweekly.io.scribe.property.DateTimeStampScribe;
import biweekly.io.scribe.property.DaylightScribe;
import biweekly.io.scribe.property.DescriptionScribe;
import biweekly.io.scribe.property.DisplayAlarmScribe;
import biweekly.io.scribe.property.DurationPropertyScribe;
import biweekly.io.scribe.property.EmailAlarmScribe;
import biweekly.io.scribe.property.ExceptionDatesScribe;
import biweekly.io.scribe.property.ExceptionRuleScribe;
import biweekly.io.scribe.property.FreeBusyScribe;
import biweekly.io.scribe.property.GeoScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.scribe.property.ImageScribe;
import biweekly.io.scribe.property.LastModifiedScribe;
import biweekly.io.scribe.property.LocationScribe;
import biweekly.io.scribe.property.MethodScribe;
import biweekly.io.scribe.property.NameScribe;
import biweekly.io.scribe.property.OrganizerScribe;
import biweekly.io.scribe.property.PercentCompleteScribe;
import biweekly.io.scribe.property.PriorityScribe;
import biweekly.io.scribe.property.ProcedureAlarmScribe;
import biweekly.io.scribe.property.ProductIdScribe;
import biweekly.io.scribe.property.RawPropertyScribe;
import biweekly.io.scribe.property.RecurrenceDatesScribe;
import biweekly.io.scribe.property.RecurrenceIdScribe;
import biweekly.io.scribe.property.RecurrenceRuleScribe;
import biweekly.io.scribe.property.RefreshIntervalScribe;
import biweekly.io.scribe.property.RelatedToScribe;
import biweekly.io.scribe.property.RepeatScribe;
import biweekly.io.scribe.property.RequestStatusScribe;
import biweekly.io.scribe.property.ResourcesScribe;
import biweekly.io.scribe.property.SequenceScribe;
import biweekly.io.scribe.property.SourceScribe;
import biweekly.io.scribe.property.StatusScribe;
import biweekly.io.scribe.property.SummaryScribe;
import biweekly.io.scribe.property.TimezoneIdScribe;
import biweekly.io.scribe.property.TimezoneNameScribe;
import biweekly.io.scribe.property.TimezoneOffsetFromScribe;
import biweekly.io.scribe.property.TimezoneOffsetToScribe;
import biweekly.io.scribe.property.TimezoneScribe;
import biweekly.io.scribe.property.TimezoneUrlScribe;
import biweekly.io.scribe.property.TransparencyScribe;
import biweekly.io.scribe.property.TriggerScribe;
import biweekly.io.scribe.property.UidScribe;
import biweekly.io.scribe.property.UrlScribe;
import biweekly.io.scribe.property.VersionScribe;
import biweekly.io.scribe.property.XmlScribe;
import biweekly.property.ICalProperty;
import biweekly.property.RawProperty;
import biweekly.property.Xml;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class ScribeIndex {
    private static final Map<String, ICalComponentScribe<? extends ICalComponent>> standardCompByName = new HashMap<String, ICalComponentScribe<? extends ICalComponent>>();
    private static final Map<Class<? extends ICalComponent>, ICalComponentScribe<? extends ICalComponent>> standardCompByClass = new HashMap<Class<? extends ICalComponent>, ICalComponentScribe<? extends ICalComponent>>();
    private static final Map<String, ICalPropertyScribe<? extends ICalProperty>> standardPropByName;
    private static final Map<Class<? extends ICalProperty>, ICalPropertyScribe<? extends ICalProperty>> standardPropByClass;
    private static final Map<QName, ICalPropertyScribe<? extends ICalProperty>> standardPropByQName;
    private final Map<String, ICalComponentScribe<? extends ICalComponent>> experimentalCompByName = new HashMap<String, ICalComponentScribe<? extends ICalComponent>>(0);
    private final Map<Class<? extends ICalComponent>, ICalComponentScribe<? extends ICalComponent>> experimentalCompByClass = new HashMap<Class<? extends ICalComponent>, ICalComponentScribe<? extends ICalComponent>>(0);
    private final Map<String, ICalPropertyScribe<? extends ICalProperty>> experimentalPropByName = new HashMap<String, ICalPropertyScribe<? extends ICalProperty>>(0);
    private final Map<Class<? extends ICalProperty>, ICalPropertyScribe<? extends ICalProperty>> experimentalPropByClass = new HashMap<Class<? extends ICalProperty>, ICalPropertyScribe<? extends ICalProperty>>(0);
    private final Map<QName, ICalPropertyScribe<? extends ICalProperty>> experimentalPropByQName = new HashMap<QName, ICalPropertyScribe<? extends ICalProperty>>(0);

    public ICalComponentScribe<? extends ICalComponent> getComponentScribe(String componentName, ICalVersion version) {
        ICalComponentScribe<? extends ICalComponent> scribe = this.experimentalCompByName.get(componentName = componentName.toUpperCase());
        if (scribe == null) {
            scribe = standardCompByName.get(componentName);
        }
        if (scribe == null) {
            return new RawComponentScribe(componentName);
        }
        if (version != null && !scribe.getSupportedVersions().contains((Object)version)) {
            return new RawComponentScribe(componentName);
        }
        return scribe;
    }

    public ICalPropertyScribe<? extends ICalProperty> getPropertyScribe(String propertyName, ICalVersion version) {
        String key = ScribeIndex.propertyNameKey(propertyName = propertyName.toUpperCase(), version);
        ICalPropertyScribe<? extends ICalProperty> scribe = this.experimentalPropByName.get(key);
        if (scribe == null) {
            scribe = standardPropByName.get(key);
        }
        if (scribe == null) {
            return new RawPropertyScribe(propertyName);
        }
        if (version != null && !scribe.getSupportedVersions().contains((Object)version)) {
            return new RawPropertyScribe(propertyName);
        }
        return scribe;
    }

    public ICalComponentScribe<? extends ICalComponent> getComponentScribe(Class<? extends ICalComponent> clazz) {
        ICalComponentScribe<? extends ICalComponent> scribe = this.experimentalCompByClass.get(clazz);
        if (scribe != null) {
            return scribe;
        }
        return standardCompByClass.get(clazz);
    }

    public ICalPropertyScribe<? extends ICalProperty> getPropertyScribe(Class<? extends ICalProperty> clazz) {
        ICalPropertyScribe<? extends ICalProperty> scribe = this.experimentalPropByClass.get(clazz);
        if (scribe != null) {
            return scribe;
        }
        return standardPropByClass.get(clazz);
    }

    public ICalComponentScribe<? extends ICalComponent> getComponentScribe(ICalComponent component) {
        if (component instanceof RawComponent) {
            RawComponent raw = (RawComponent)component;
            return new RawComponentScribe(raw.getName());
        }
        return this.getComponentScribe(component.getClass());
    }

    public ICalPropertyScribe<? extends ICalProperty> getPropertyScribe(ICalProperty property) {
        if (property instanceof RawProperty) {
            RawProperty raw = (RawProperty)property;
            return new RawPropertyScribe(raw.getName());
        }
        return this.getPropertyScribe(property.getClass());
    }

    public ICalPropertyScribe<? extends ICalProperty> getPropertyScribe(QName qname) {
        ICalPropertyScribe<? extends ICalProperty> scribe = this.experimentalPropByQName.get(qname);
        if (scribe == null) {
            scribe = standardPropByQName.get(qname);
        }
        if (scribe == null || !scribe.getSupportedVersions().contains((Object)ICalVersion.V2_0)) {
            if ("urn:ietf:params:xml:ns:icalendar-2.0".equals(qname.getNamespaceURI())) {
                return new RawPropertyScribe(qname.getLocalPart().toUpperCase());
            }
            return this.getPropertyScribe(Xml.class);
        }
        return scribe;
    }

    public void register(ICalComponentScribe<? extends ICalComponent> scribe) {
        this.experimentalCompByName.put(scribe.getComponentName().toUpperCase(), scribe);
        this.experimentalCompByClass.put(scribe.getComponentClass(), scribe);
    }

    public void register(ICalPropertyScribe<? extends ICalProperty> scribe) {
        for (ICalVersion version : ICalVersion.values()) {
            this.experimentalPropByName.put(ScribeIndex.propertyNameKey(scribe, version), scribe);
        }
        this.experimentalPropByClass.put(scribe.getPropertyClass(), scribe);
        this.experimentalPropByQName.put(scribe.getQName(), scribe);
    }

    public void unregister(ICalComponentScribe<? extends ICalComponent> scribe) {
        this.experimentalCompByName.remove(scribe.getComponentName().toUpperCase());
        this.experimentalCompByClass.remove(scribe.getComponentClass());
    }

    public void unregister(ICalPropertyScribe<? extends ICalProperty> scribe) {
        for (ICalVersion version : ICalVersion.values()) {
            this.experimentalPropByName.remove(ScribeIndex.propertyNameKey(scribe, version));
        }
        this.experimentalPropByClass.remove(scribe.getPropertyClass());
        this.experimentalPropByQName.remove(scribe.getQName());
    }

    public static ICalendarScribe getICalendarScribe() {
        return (ICalendarScribe)standardCompByClass.get(ICalendar.class);
    }

    private static void registerStandard(ICalComponentScribe<? extends ICalComponent> scribe) {
        standardCompByName.put(scribe.getComponentName().toUpperCase(), scribe);
        standardCompByClass.put(scribe.getComponentClass(), scribe);
    }

    private static void registerStandard(ICalPropertyScribe<? extends ICalProperty> scribe) {
        for (ICalVersion version : ICalVersion.values()) {
            standardPropByName.put(ScribeIndex.propertyNameKey(scribe, version), scribe);
        }
        standardPropByClass.put(scribe.getPropertyClass(), scribe);
        standardPropByQName.put(scribe.getQName(), scribe);
    }

    private static String propertyNameKey(ICalPropertyScribe<? extends ICalProperty> scribe, ICalVersion version) {
        return ScribeIndex.propertyNameKey(scribe.getPropertyName(version), version);
    }

    private static String propertyNameKey(String propertyName, ICalVersion version) {
        return version.ordinal() + propertyName.toUpperCase();
    }

    static {
        ScribeIndex.registerStandard(new ICalendarScribe());
        ScribeIndex.registerStandard(new VAlarmScribe());
        ScribeIndex.registerStandard(new VEventScribe());
        ScribeIndex.registerStandard(new VFreeBusyScribe());
        ScribeIndex.registerStandard(new VJournalScribe());
        ScribeIndex.registerStandard(new VTodoScribe());
        ScribeIndex.registerStandard(new VTimezoneScribe());
        ScribeIndex.registerStandard(new StandardTimeScribe());
        ScribeIndex.registerStandard(new DaylightSavingsTimeScribe());
        standardPropByName = new HashMap<String, ICalPropertyScribe<? extends ICalProperty>>();
        standardPropByClass = new HashMap<Class<? extends ICalProperty>, ICalPropertyScribe<? extends ICalProperty>>();
        standardPropByQName = new HashMap<QName, ICalPropertyScribe<? extends ICalProperty>>();
        ScribeIndex.registerStandard(new ActionScribe());
        ScribeIndex.registerStandard(new AttachmentScribe());
        ScribeIndex.registerStandard(new AttendeeScribe());
        ScribeIndex.registerStandard(new CalendarScaleScribe());
        ScribeIndex.registerStandard(new CategoriesScribe());
        ScribeIndex.registerStandard(new ClassificationScribe());
        ScribeIndex.registerStandard(new CommentScribe());
        ScribeIndex.registerStandard(new CompletedScribe());
        ScribeIndex.registerStandard(new ContactScribe());
        ScribeIndex.registerStandard(new CreatedScribe());
        ScribeIndex.registerStandard(new DateDueScribe());
        ScribeIndex.registerStandard(new DateEndScribe());
        ScribeIndex.registerStandard(new DateStartScribe());
        ScribeIndex.registerStandard(new DateTimeStampScribe());
        ScribeIndex.registerStandard(new DescriptionScribe());
        ScribeIndex.registerStandard(new DurationPropertyScribe());
        ScribeIndex.registerStandard(new ExceptionDatesScribe());
        ScribeIndex.registerStandard(new FreeBusyScribe());
        ScribeIndex.registerStandard(new GeoScribe());
        ScribeIndex.registerStandard(new LastModifiedScribe());
        ScribeIndex.registerStandard(new LocationScribe());
        ScribeIndex.registerStandard(new MethodScribe());
        ScribeIndex.registerStandard(new OrganizerScribe());
        ScribeIndex.registerStandard(new PercentCompleteScribe());
        ScribeIndex.registerStandard(new PriorityScribe());
        ScribeIndex.registerStandard(new ProductIdScribe());
        ScribeIndex.registerStandard(new RecurrenceDatesScribe());
        ScribeIndex.registerStandard(new RecurrenceIdScribe());
        ScribeIndex.registerStandard(new RecurrenceRuleScribe());
        ScribeIndex.registerStandard(new RelatedToScribe());
        ScribeIndex.registerStandard(new RepeatScribe());
        ScribeIndex.registerStandard(new RequestStatusScribe());
        ScribeIndex.registerStandard(new ResourcesScribe());
        ScribeIndex.registerStandard(new SequenceScribe());
        ScribeIndex.registerStandard(new StatusScribe());
        ScribeIndex.registerStandard(new SummaryScribe());
        ScribeIndex.registerStandard(new TimezoneIdScribe());
        ScribeIndex.registerStandard(new TimezoneNameScribe());
        ScribeIndex.registerStandard(new TimezoneOffsetFromScribe());
        ScribeIndex.registerStandard(new TimezoneOffsetToScribe());
        ScribeIndex.registerStandard(new TimezoneUrlScribe());
        ScribeIndex.registerStandard(new TransparencyScribe());
        ScribeIndex.registerStandard(new TriggerScribe());
        ScribeIndex.registerStandard(new UidScribe());
        ScribeIndex.registerStandard(new UrlScribe());
        ScribeIndex.registerStandard(new VersionScribe());
        ScribeIndex.registerStandard(new XmlScribe());
        ScribeIndex.registerStandard(new ExceptionRuleScribe());
        ScribeIndex.registerStandard(new AudioAlarmScribe());
        ScribeIndex.registerStandard(new DaylightScribe());
        ScribeIndex.registerStandard(new DisplayAlarmScribe());
        ScribeIndex.registerStandard(new EmailAlarmScribe());
        ScribeIndex.registerStandard(new ProcedureAlarmScribe());
        ScribeIndex.registerStandard(new TimezoneScribe());
        ScribeIndex.registerStandard(new ColorScribe());
        ScribeIndex.registerStandard(new ConferenceScribe());
        ScribeIndex.registerStandard(new ImageScribe());
        ScribeIndex.registerStandard(new NameScribe());
        ScribeIndex.registerStandard(new SourceScribe());
        ScribeIndex.registerStandard(new RefreshIntervalScribe());
    }
}

