/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.client.page.UniTimeNavigation;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.client.tables.TableWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class SubpartDetailPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel = new SimpleForm(2);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private OfferingsInterface.SubpartDetailReponse iResponse;

    public SubpartDetailPage() {
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-SubpartDetailPage");
        this.initWidget((Widget)this.iRootPanel);
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        String id = Window.Location.getParameter((String)"id");
        if (id == null) {
            id = Window.Location.getParameter((String)"ssuid");
        }
        if (id == null || id.isEmpty()) {
            LoadingWidget.getInstance().hide();
            this.iHeader.setErrorMessage(COURSE.errorNoSubpartId());
        } else {
            this.load(Long.valueOf(id), null);
        }
        this.iHeader.addButton("edit", COURSE.actionEditSubpart(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "schedulingSubpartEdit.action?ssuid=" + SubpartDetailPage.this.iResponse.getSubpartgId());
            }
        });
        this.iHeader.setEnabled("edit", false);
        this.iHeader.getButton("edit").setAccessKey(COURSE.accessEditSubpart().charAt(0));
        this.iHeader.getButton("edit").setTitle(COURSE.titleEditSubpart(COURSE.accessEditSubpart()));
        this.iHeader.addButton("previous", COURSE.actionPreviousSubpart(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "subpart?id=" + SubpartDetailPage.this.iResponse.getPreviousId());
            }
        });
        this.iHeader.setEnabled("previous", false);
        this.iHeader.getButton("previous").setAccessKey(COURSE.accessPreviousSubpart().charAt(0));
        this.iHeader.getButton("previous").setTitle(COURSE.titlePreviousSubpart(COURSE.accessPreviousSubpart()));
        this.iHeader.addButton("next", COURSE.actionNextSubpart(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "subpart?id=" + SubpartDetailPage.this.iResponse.getNextId());
            }
        });
        this.iHeader.setEnabled("next", false);
        this.iHeader.getButton("next").setAccessKey(COURSE.accessNextSubpart().charAt(0));
        this.iHeader.getButton("next").setTitle(COURSE.titleNextSubpart(COURSE.accessNextSubpart()));
        this.iHeader.addButton("back", COURSE.actionBackSubpartDetail(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "back.action?uri=" + URL.encodeQueryString((String)SubpartDetailPage.this.iResponse.getBackUrl()) + "&backId=" + SubpartDetailPage.this.iResponse.getSubpartgId() + "&backType=PreferenceGroup");
            }
        });
        this.iHeader.setEnabled("back", false);
        this.iHeader.getButton("back").setAccessKey(COURSE.accessBackSubpartDetail().charAt(0));
        this.iFooter = this.iHeader.clonePanel();
    }

    protected void load(Long subpartId, OfferingsInterface.SubpartDetailRequest.Action action) {
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        OfferingsInterface.SubpartDetailRequest req = new OfferingsInterface.SubpartDetailRequest();
        req.setSubpartId(subpartId);
        req.setAction(action);
        RPC.execute(req, new AsyncCallback<OfferingsInterface.SubpartDetailReponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                SubpartDetailPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(final OfferingsInterface.SubpartDetailReponse response) {
                UniTimeHeaderPanel hp;
                SubpartDetailPage.this.iResponse = response;
                if (response.hasUrl()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + response.getUrl());
                    return;
                }
                LoadingWidget.getInstance().hide();
                SubpartDetailPage.this.iPanel.clear();
                SubpartDetailPage.this.iPanel.addHeaderRow((Widget)SubpartDetailPage.this.iHeader);
                SubpartDetailPage.this.iHeader.getHeaderTitlePanel().clear();
                Anchor anchor = new Anchor(response.getCourseName());
                anchor.setHref("offering?io=" + response.getOfferingId());
                anchor.setAccessKey(COURSE.accessInstructionalOfferingDetail().charAt(0));
                anchor.setTitle(COURSE.titleInstructionalOfferingDetail(COURSE.accessInstructionalOfferingDetail()));
                anchor.setStyleName("l8");
                SubpartDetailPage.this.iHeader.getHeaderTitlePanel().add((Widget)anchor);
                P suffix = new P((Element)DOM.createSpan(), new String[0]);
                suffix.setText(" : " + response.getSubparName());
                SubpartDetailPage.this.iHeader.getHeaderTitlePanel().add((Widget)suffix);
                for (TableInterface.PropertyInterface property : response.getProperties().getProperties()) {
                    SubpartDetailPage.this.iPanel.addRow(property.getName(), (Widget)new TableWidget.CellWidget(property.getCell(), true));
                }
                if (response.hasPreferences()) {
                    hp = new UniTimeHeaderPanel(COURSE.sectionTitlePreferences());
                    SubpartDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    SubpartDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getPreferences()));
                }
                if (response.hasDistributions()) {
                    hp = new UniTimeHeaderPanel(response.getDistributions().getName());
                    SubpartDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    SubpartDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getDistributions()));
                    if (response.hasOperation("add-distribution")) {
                        hp.addButton("add-distribution", COURSE.actionAddDistributionPreference(), new ClickHandler(){

                            public void onClick(ClickEvent evt) {
                                ToolBox.open(GWT.getHostPageBaseURL() + "distributionAdd?subpartId=" + SubpartDetailPage.this.iResponse.getSubpartgId());
                            }
                        });
                        hp.getButton("add-distribution").setAccessKey(COURSE.accessAddDistributionPreference().charAt(0));
                        hp.getButton("add-distribution").setTitle(COURSE.titleAddDatePatternPreference(COURSE.accessAddDistributionPreference()));
                    }
                    if (response.hasOperation("add-distribution-legacy")) {
                        hp.addButton("add-distribution-legacy", COURSE.actionAddDistributionPreference(), new ClickHandler(){

                            public void onClick(ClickEvent evt) {
                                ToolBox.open(GWT.getHostPageBaseURL() + "distributionPrefs.action?op=" + URL.encodeQueryString((String)COURSE.actionAddDistributionPreference()) + "&subpartId=" + SubpartDetailPage.this.iResponse.getSubpartgId());
                            }
                        });
                        hp.getButton("add-distribution-legacy").setAccessKey(COURSE.accessAddDistributionPreference().charAt(0));
                        hp.getButton("add-distribution-legacy").setTitle(COURSE.titleAddDatePatternPreference(COURSE.accessAddDistributionPreference()));
                    }
                }
                if (response.hasClasses()) {
                    hp = new UniTimeHeaderPanel(COURSE.sectionTitleClasses());
                    SubpartDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    SubpartDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getClasses()));
                    if (response.hasOperation("clear-prefs")) {
                        hp.addButton("clear", COURSE.actionClearClassPreferences(), new ClickHandler(){

                            public void onClick(ClickEvent evt) {
                                if (SubpartDetailPage.this.iResponse.isConfirms()) {
                                    UniTimeConfirmationDialog.confirm(COURSE.confirmClearAllClassPreferences(), new Command(){

                                        public void execute() {
                                            SubpartDetailPage.this.load(SubpartDetailPage.this.iResponse.getSubpartgId(), OfferingsInterface.SubpartDetailRequest.Action.ClearPrefs);
                                        }
                                    });
                                } else {
                                    SubpartDetailPage.this.load(SubpartDetailPage.this.iResponse.getSubpartgId(), OfferingsInterface.SubpartDetailRequest.Action.ClearPrefs);
                                }
                            }
                        });
                        hp.getButton("clear").setAccessKey(COURSE.accessClearClassPreferences().charAt(0));
                        hp.getButton("clear").setTitle(COURSE.titleClearClassPreferences(COURSE.accessClearClassPreferences()));
                    }
                }
                if (response.hasExaminations()) {
                    hp = new UniTimeHeaderPanel(response.getExaminations().getName());
                    SubpartDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    SubpartDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getExaminations()));
                    if (response.hasOperation("add-exam")) {
                        hp.addButton("add-exam", COURSE.actionAddExamination(), new ClickHandler(){

                            public void onClick(ClickEvent evt) {
                                ToolBox.open(GWT.getHostPageBaseURL() + "examEdit.action?firstType=InstructionalOffering&firstId=" + response.getOfferingId());
                            }
                        });
                        hp.getButton("add-exam").setAccessKey(COURSE.accessAddExamination().charAt(0));
                        hp.getButton("add-exam").setTitle(COURSE.titleAddExamination(COURSE.accessAddExamination()));
                    }
                }
                SubpartDetailPage.this.iPanel.addBottomRow((Widget)SubpartDetailPage.this.iFooter);
                for (String op : SubpartDetailPage.this.iHeader.getOperations()) {
                    SubpartDetailPage.this.iHeader.setEnabled(op, response.hasOperation(op));
                }
                if (response.hasBackTitle()) {
                    SubpartDetailPage.this.iHeader.getButton("back").setTitle(COURSE.navigationBackTitle(response.getBackTitle()));
                    SubpartDetailPage.this.iFooter.getButton("back").setTitle(COURSE.navigationBackTitle(response.getBackTitle()));
                }
                UniTimeNavigation.getInstance().refresh();
            }
        });
    }
}

