/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.ExamReportForm;
import org.unitime.timetable.security.SessionContext;

public class RoomAvailabilityForm
extends ExamReportForm {
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    private static final long serialVersionUID = -7604226806875981047L;
    private String iFilter = null;
    private boolean iIncludeExams = false;
    private boolean iCompare = false;

    @Override
    public void validate(UniTimeAction action) {
        if (this.getExamType() < 0L) {
            action.addFieldError("examType", MSG.errorExamTypeIsRequired());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.iIncludeExams = false;
        this.iFilter = null;
        this.iCompare = false;
        this.setExamType(null);
    }

    public String getFilter() {
        return this.iFilter;
    }

    public void setFilter(String filter) {
        this.iFilter = filter;
    }

    public boolean getIncludeExams() {
        return this.iIncludeExams;
    }

    public void setIncludeExams(boolean exams) {
        this.iIncludeExams = exams;
    }

    public boolean getCompare() {
        return this.iCompare;
    }

    public void setCompare(boolean compare) {
        this.iCompare = compare;
    }

    @Override
    public void load(SessionContext session) {
        super.load(session);
        this.setFilter((String)session.getAttribute("RoomAvailability.Filter"));
        this.setIncludeExams(Boolean.TRUE.equals(session.getAttribute("RoomAvailability.Exams")));
        this.setCompare(Boolean.TRUE.equals(session.getAttribute("RoomAvailability.Compare")));
    }

    @Override
    public void save(SessionContext session) {
        super.save(session);
        if (this.getFilter() == null) {
            session.removeAttribute("RoomAvailability.Filter");
        } else {
            session.setAttribute("RoomAvailability.Filter", (Object)this.getFilter());
        }
        session.setAttribute("RoomAvailability.Exams", (Object)this.getIncludeExams());
        session.setAttribute("RoomAvailability.Compare", (Object)this.getCompare());
    }
}

