/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.export.ExportServletHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;

public class ExportServlet
extends HttpServlet {
    private static Log sLog = LogFactory.getLog(ExportServlet.class);
    private static final long serialVersionUID = 1L;

    protected SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.getServletContext());
    }

    protected Exporter getExporter(String reference) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        return (Exporter)applicationContext.getBean("org.unitime.timetable.export.Exporter:" + reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ExportServletHelper helper = null;
        String ref = null;
        try {
            helper = new ExportServletHelper(request, response, this.getSessionContext());
            ref = helper.getParameter("output");
            if (ref == null) {
                sLog.info((Object)"No exporter provided.");
                response.sendError(400, "No exporter provided, please set the output parameter.");
                return;
            }
            this.getExporter(ref).export(helper);
        }
        catch (NoSuchBeanDefinitionException e) {
            sLog.info((Object)("Exporter " + ref + " not known."));
            response.sendError(400, "Exporter " + ref + " not known, please check the output parameter.");
        }
        catch (IllegalArgumentException e) {
            sLog.info((Object)e.getMessage());
            response.sendError(400, e.getMessage());
        }
        catch (PageAccessException e) {
            sLog.info((Object)e.getMessage());
            response.sendError(403, e.getMessage());
        }
        catch (Exception e) {
            sLog.warn((Object)e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
        finally {
            if (helper != null) {
                if (helper.hasOutputStream()) {
                    helper.getOutputStream().flush();
                    helper.getOutputStream().close();
                }
                if (helper.hasWriter()) {
                    helper.getWriter().flush();
                    helper.getWriter().close();
                }
            }
        }
    }
}

