/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import org.unitime.commons.Email;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@GwtRpcImplements(value=EventInterface.SendStudentEmailsRpcRequest.class)
public class EventSendStudentEmailsBackend
implements GwtRpcImplementation<EventInterface.SendStudentEmailsRpcRequest, GwtRpcResponseNull> {
    @Override
    public GwtRpcResponseNull execute(EventInterface.SendStudentEmailsRpcRequest request, SessionContext context) {
        context.checkPermission(Right.EventDetailEmailStudents);
        context.checkPermission(request.getEventId(), "Event", Right.EventDetail);
        String nameFormat = UserProperty.NameFormat.get(context.getUser());
        try {
            Email email = Email.createEmail();
            if (request.hasCC()) {
                email.addRecipientCC(request.getCC(), null);
            }
            email.setSubject(request.getSubject());
            email.setText(request.getMessage());
            for (Long studentId : request.getStudentIds()) {
                Student student = (Student)StudentDAO.getInstance().get(studentId);
                if (student == null || student.getEmail() == null || student.getEmail().isEmpty()) continue;
                email.addRecipientBCC(student.getEmail(), student.getName(nameFormat));
            }
            if (context != null && context.isAuthenticated() && context.getUser().getEmail() != null) {
                email.setReplyTo(context.getUser().getEmail(), context.getUser().getName());
            } else if (request.hasCC()) {
                email.setReplyTo(request.getCC(), null);
            }
            email.send();
        }
        catch (Exception e) {
            throw new GwtRpcException(e.getMessage(), e);
        }
        return null;
    }
}

