/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.Debug;
import org.unitime.timetable.action.PreferencesAction2;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.SchedulingSubpartEditForm;
import org.unitime.timetable.interfaces.ExternalSchedulingSubpartEditAction;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.ItypeDescDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ComboBoxLookup;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;

@Action(value="schedulingSubpartEdit", results={@Result(name={"editSchedulingSubpart"}, type="tiles", location="schedulingSubpartEdit.tiles"), @Result(name={"instructionalOfferingSearch"}, type="redirect", location="/instructionalOfferingSearch.action"), @Result(name={"addDistributionPrefs"}, type="redirect", location="/distributionPrefs.action", params={"subpartId", "${form.schedulingSubpartId}", "op", "${op}"}), @Result(name={"displaySubpartDetail"}, type="redirect", location="/schedulingSubpartDetail.action", params={"ssuid", "${form.schedulingSubpartId}"})})
@TilesDefinition(name="schedulingSubpartEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Scheduling Subpart"), @TilesPutAttribute(name="body", value="/user/schedulingSubpartEdit.jsp"), @TilesPutAttribute(name="showNavigation", value="true")})
public class SchedulingSubpartEditAction
extends PreferencesAction2<SchedulingSubpartEditForm> {
    private static final long serialVersionUID = -271792073108532899L;
    protected String subpartId = null;
    protected String op2 = null;

    public String getSsuid() {
        return this.subpartId;
    }

    public void setSsuid(String subpartId) {
        this.subpartId = subpartId;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    @Override
    public String execute() throws Exception {
        DatePattern selectedDatePattern;
        if (ApplicationProperty.LegacySubpartEdit.isFalse()) {
            Object url = "subpartEdit";
            boolean first = true;
            Enumeration e = this.getRequest().getParameterNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                url = (String)url + (first ? "?" : "&") + param + "=" + URLEncoder.encode(this.getRequest().getParameter(param), "utf-8");
                first = false;
            }
            this.response.sendRedirect((String)url);
            return null;
        }
        if (this.form == null) {
            this.form = new SchedulingSubpartEditForm();
            ((SchedulingSubpartEditForm)this.form).reset();
        }
        super.execute();
        if (this.subpartId == null && this.request.getAttribute("ssuid") != null) {
            this.subpartId = (String)this.request.getAttribute("ssuid");
        }
        if (this.op == null) {
            this.op = ((SchedulingSubpartEditForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (MSG.actionAddTimePreference().equals(this.op) || MSG.actionAddRoomPreference().equals(this.op) || MSG.actionAddBuildingPreference().equals(this.op) || MSG.actionAddRoomFeaturePreference().equals(this.op) || MSG.actionAddDistributionPreference().equals(this.op) || MSG.actionAddRoomGroupPreference().equals(this.op) || MSG.actionUpdatePreferences().equals(this.op) || MSG.actionAddDatePatternPreference().equals(this.op) || MSG.actionAddAttributePreference().equals(this.op) || MSG.actionAddInstructorPreference().equals(this.op) || MSG.actionClearSubpartPreferences().equals(this.op) || MSG.actionRemoveBuildingPreference().equals(this.op) || MSG.actionRemoveDistributionPreference().equals(this.op) || MSG.actionRemoveRoomFeaturePreference().equals(this.op) || MSG.actionRemoveRoomGroupPreference().equals(this.op) || MSG.actionRemoveRoomPreference().equals(this.op) || MSG.actionRemoveTimePattern().equals(this.op) || MSG.actionRemoveAttributePreference().equals(this.op) || MSG.actionRemoveInstructorPreference().equals(this.op) || MSG.actionBackToDetail().equals(this.op) || MSG.actionNextSubpart().equals(this.op) || MSG.actionPreviousSubpart().equals(this.op) || "updateDatePattern".equals(this.op)) {
            this.subpartId = ((SchedulingSubpartEditForm)this.form).getSchedulingSubpartId();
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            this.op = "init";
        }
        this.sessionContext.checkPermission((Serializable)((Object)this.subpartId), "SchedulingSubpart", Right.SchedulingSubpartEdit);
        boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
        Debug.debug("op: " + this.op);
        Debug.debug("subpart: " + this.subpartId);
        if (this.subpartId == null || this.subpartId.trim().isEmpty()) {
            throw new Exception(MSG.errorSubpartInfoNotSupplied());
        }
        SchedulingSubpartDAO sdao = SchedulingSubpartDAO.getInstance();
        SchedulingSubpart ss = (SchedulingSubpart)sdao.get(Long.valueOf(this.subpartId));
        if (MSG.actionBackToDetail().equals(this.op)) {
            return "displaySubpartDetail";
        }
        if (MSG.actionClearSubpartPreferences().equals(this.op)) {
            this.sessionContext.checkPermission(ss, Right.SchedulingSubpartEditClearPreferences);
            Set<Preference> s = ss.getPreferences();
            super.doClear(s, Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DATE);
            ss.setPreferences(s);
            sdao.getSession().merge((Object)ss);
            ChangeLog.addChange(null, this.sessionContext, ss, ChangeLog.Source.SCHEDULING_SUBPART_EDIT, ChangeLog.Operation.CLEAR_PREF, ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), ss.getManagingDept());
            sdao.getSession().flush();
            return "displaySubpartDetail";
        }
        if ("init".equals(this.op)) {
            ((SchedulingSubpartEditForm)this.form).reset();
            ((SchedulingSubpartEditForm)this.form).setAutoSpreadInTime(ss.isAutoSpreadInTime());
            ((SchedulingSubpartEditForm)this.form).setStudentAllowOverlap(ss.isStudentAllowOverlap());
        }
        this.doLoad(ss, this.subpartId);
        if ("init".equals(this.op)) {
            ((SchedulingSubpartEditForm)this.form).setDatePattern(ss.getDatePattern() == null ? Long.valueOf(-1L) : ss.getDatePattern().getUniqueId());
        }
        if (MSG.actionUpdatePreferences().equals(this.op) || MSG.actionNextSubpart().equals(this.op) || MSG.actionPreviousSubpart().equals(this.op)) {
            ((SchedulingSubpartEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.doUpdate(ss, sdao, timeVertical);
                if (MSG.actionNextSubpart().equals(this.op)) {
                    this.response.sendRedirect(this.response.encodeURL("schedulingSubpartEdit.action?ssuid=" + ((SchedulingSubpartEditForm)this.form).getNextId()));
                    return null;
                }
                if (MSG.actionPreviousSubpart().equals(this.op)) {
                    this.response.sendRedirect(this.response.encodeURL("schedulingSubpartEdit.action?ssuid=" + ((SchedulingSubpartEditForm)this.form).getPreviousId()));
                    return null;
                }
                return "displaySubpartDetail";
            }
        }
        Set<TimePattern> timePatterns = null;
        ((SchedulingSubpartEditForm)this.form).setAvailableTimePatterns(TimePattern.findApplicable(this.sessionContext.getUser(), ss.getMinutesPerWk(), ((SchedulingSubpartEditForm)this.form).getDatePattern() < 0L ? (ss.canInheritParentPreferences() ? ss.getParentSubpart().effectiveDatePattern() : ss.getSession().getDefaultDatePatternNotNull()) : (DatePattern)DatePatternDAO.getInstance().get(((SchedulingSubpartEditForm)this.form).getDatePattern()), ss.getInstrOfferingConfig().getDurationModel(), false, ss.getManagingDept()));
        if ("init".equals(this.op)) {
            this.initPrefs(ss, null, true);
            timePatterns = ss.getTimePatterns();
            selectedDatePattern = ss.effectiveDatePattern();
            if (selectedDatePattern != null) {
                for (DatePattern dp : selectedDatePattern.findChildren()) {
                    if (((SchedulingSubpartEditForm)this.form).getDatePatternPrefs().contains(dp.getUniqueId().toString())) continue;
                    ((SchedulingSubpartEditForm)this.form).addToDatePatternPrefs(dp.getUniqueId().toString(), PreferenceLevel.PREF_LEVEL_NEUTRAL);
                }
            }
        }
        if ("updateDatePattern".equals(this.op)) {
            this.initPrefs(ss, null, true);
            timePatterns = ss.getTimePatterns();
            ((SchedulingSubpartEditForm)this.form).getDatePatternPrefs().clear();
            ((SchedulingSubpartEditForm)this.form).getDatePatternPrefLevels().clear();
            DatePattern datePattern = ((SchedulingSubpartEditForm)this.form).getDatePattern() < 0L ? (ss.canInheritParentPreferences() ? ss.getParentSubpart().effectiveDatePattern() : ss.getSession().getDefaultDatePatternNotNull()) : (selectedDatePattern = (DatePattern)DatePatternDAO.getInstance().get(((SchedulingSubpartEditForm)this.form).getDatePattern()));
            if (selectedDatePattern != null) {
                for (DatePattern dp : selectedDatePattern.findChildren()) {
                    boolean found = false;
                    for (DatePatternPref dpp : ss.getPreferences(DatePatternPref.class)) {
                        if (!dp.equals(dpp.getDatePattern())) continue;
                        ((SchedulingSubpartEditForm)this.form).addToDatePatternPrefs(dp.getUniqueId().toString(), dpp.getPrefLevel().getUniqueId().toString());
                        found = true;
                    }
                    if (found) continue;
                    ((SchedulingSubpartEditForm)this.form).addToDatePatternPrefs(dp.getUniqueId().toString(), PreferenceLevel.PREF_LEVEL_NEUTRAL);
                }
            }
        }
        this.processPrefAction();
        super.generateTimePatternGrids(ss, ss.getMinutesPerWk(), ss.getInstrOfferingConfig().getDurationModel(), ((SchedulingSubpartEditForm)this.form).getDatePattern() < 0L ? (ss.canInheritParentPreferences() ? ss.getParentSubpart().effectiveDatePattern() : ss.getSession().getDefaultDatePatternNotNull()) : (DatePattern)DatePatternDAO.getInstance().get(((SchedulingSubpartEditForm)this.form).getDatePattern()), timePatterns, this.op, timeVertical, true, null);
        this.setupChildren(ss);
        LookupTables.setupDatePatterns(this.request, this.sessionContext.getUser(), MSG.dropDefaultDatePattern(), ss.canInheritParentPreferences() ? ss.getParentSubpart().effectiveDatePattern() : ss.getSession().getDefaultDatePatternNotNull(), ss.getManagingDept(), ss.effectiveDatePattern());
        LookupTables.setupRooms(this.request, ss);
        LookupTables.setupBldgs(this.request, ss);
        LookupTables.setupRoomFeatures(this.request, ss);
        LookupTables.setupRoomGroups(this.request, ss);
        LookupTables.setupInstructorAttributes(this.request, ss);
        LookupTables.setupCourseCreditFormats(this.request);
        LookupTables.setupCourseCreditTypes(this.request);
        LookupTables.setupCourseCreditUnitTypes(this.request);
        LookupTables.setupInstructors(this.request, this.sessionContext, ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getSubjectArea().getDepartment().getUniqueId());
        ((SchedulingSubpartEditForm)this.form).setAllowHardPrefs(this.sessionContext.hasPermission(ss, Right.CanUseHardRoomPrefs));
        BackTracker.markForBack(this.request, "schedulingSubpartDetail.action?ssuid=" + ((SchedulingSubpartEditForm)this.form).getSchedulingSubpartId(), MSG.backSubpart(ss.getSchedulingSubpartLabel()), true, false);
        return "editSchedulingSubpart";
    }

    private void doLoad(SchedulingSubpart ss, String subpartId) {
        SchedulingSubpart parentSS;
        CourseOffering co = ss.getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
        InstrOfferingConfig ioc = ss.getInstrOfferingConfig();
        InstructionalOffering io = ioc.getInstructionalOffering();
        ((SchedulingSubpartEditForm)this.form).setInstrOfferingId(io.getUniqueId().toString());
        ((SchedulingSubpartEditForm)this.form).setSchedulingSubpartId(subpartId);
        if (((SchedulingSubpartEditForm)this.form).getInstructionalType() == null) {
            ((SchedulingSubpartEditForm)this.form).setInstructionalType(ss.getItype().getItype().toString());
        }
        Object label = ss.getItype().getAbbv();
        if (io.hasMultipleConfigurations()) {
            label = (String)label + " [" + ioc.getName() + "]";
        }
        ((SchedulingSubpartEditForm)this.form).setInstructionalTypeLabel((String)label);
        ((SchedulingSubpartEditForm)this.form).setUnlimitedEnroll(ioc.isUnlimitedEnrollment());
        ((SchedulingSubpartEditForm)this.form).setItypeBasic(ss.getItype() == null || ss.getItype().getBasic() != false);
        ArrayList<ComboBoxLookup> itypes = new ArrayList<ComboBoxLookup>();
        for (ItypeDesc itype : ItypeDesc.findAll(((SchedulingSubpartEditForm)this.form).getItypeBasic())) {
            itypes.add(new ComboBoxLookup(itype.getDesc(), itype.getItype().toString()));
        }
        if (((SchedulingSubpartEditForm)this.form).getItypeBasic()) {
            itypes.add(new ComboBoxLookup(MSG.selectMoreOptions(), "more"));
        } else {
            itypes.add(new ComboBoxLookup(MSG.selectLessOptions(), "less"));
        }
        this.request.setAttribute("itypes", itypes);
        ((SchedulingSubpartEditForm)this.form).setSubjectArea(co.getSubjectAreaAbbv());
        ((SchedulingSubpartEditForm)this.form).setSubjectAreaId(co.getSubjectArea().getUniqueId().toString());
        ((SchedulingSubpartEditForm)this.form).setCourseNbr(co.getCourseNbr());
        ((SchedulingSubpartEditForm)this.form).setCourseTitle(co.getTitle());
        if (ss.getParentSubpart() != null && ss.getItype().equals(ss.getParentSubpart().getItype())) {
            ((SchedulingSubpartEditForm)this.form).setSameItypeAsParent(true);
        } else {
            ((SchedulingSubpartEditForm)this.form).setSameItypeAsParent(false);
        }
        if (((SchedulingSubpartEditForm)this.form).getCreditFormat() == null && ss.getCredit() != null) {
            CourseCreditUnitConfig credit = ss.getCredit();
            ((SchedulingSubpartEditForm)this.form).setCreditText(credit.creditText());
            ((SchedulingSubpartEditForm)this.form).setCreditFormat(credit.getCreditFormat());
            ((SchedulingSubpartEditForm)this.form).setCreditType(credit.getCreditType().getUniqueId());
            ((SchedulingSubpartEditForm)this.form).setCreditUnitType(credit.getCreditUnitType().getUniqueId());
            if (credit instanceof FixedCreditUnitConfig) {
                ((SchedulingSubpartEditForm)this.form).setUnits(SchedulingSubpartEditAction.float2string(((FixedCreditUnitConfig)credit).getFixedUnits()));
            } else if (credit instanceof VariableFixedCreditUnitConfig) {
                ((SchedulingSubpartEditForm)this.form).setUnits(SchedulingSubpartEditAction.float2string(((VariableFixedCreditUnitConfig)credit).getMinUnits()));
                ((SchedulingSubpartEditForm)this.form).setMaxUnits(SchedulingSubpartEditAction.float2string(((VariableFixedCreditUnitConfig)credit).getMaxUnits()));
                if (credit instanceof VariableRangeCreditUnitConfig) {
                    ((SchedulingSubpartEditForm)this.form).setFractionalIncrementsAllowed(((VariableRangeCreditUnitConfig)credit).isFractionalIncrementsAllowed());
                }
            }
        }
        SchedulingSubpart next = ss.getNextSchedulingSubpart(this.sessionContext, Right.SchedulingSubpartEdit);
        ((SchedulingSubpartEditForm)this.form).setNextId(next == null ? null : next.getUniqueId().toString());
        SchedulingSubpart previous = ss.getPreviousSchedulingSubpart(this.sessionContext, Right.SchedulingSubpartEdit);
        ((SchedulingSubpartEditForm)this.form).setPreviousId(previous == null ? null : previous.getUniqueId().toString());
        Object parentSubpart = "";
        ((SchedulingSubpartEditForm)this.form).setParentSubpartId(parentSS == null ? null : parentSS.getUniqueId().toString());
        ((SchedulingSubpartEditForm)this.form).setParentSubpartLabel(parentSS == null ? null : parentSS.getSchedulingSubpartLabel());
        for (parentSS = ss.getParentSubpart(); parentSS != null; parentSS = parentSS.getParentSubpart()) {
            parentSubpart = parentSS.getItype().getAbbv() + " - " + (String)parentSubpart;
        }
        ((SchedulingSubpartEditForm)this.form).setParentSubpart((String)parentSubpart);
        ((SchedulingSubpartEditForm)this.form).setManagingDeptName(ss.getManagingDept() == null ? null : ss.getManagingDept().getManagingDeptLabel());
        ((SchedulingSubpartEditForm)this.form).setControllingDept(ss.getControllingDept().getUniqueId());
        ((SchedulingSubpartEditForm)this.form).setDatePatternEditable(ApplicationProperty.WaitListCanChangeDatePattern.isTrue() || ss.getInstrOfferingConfig().getEnrollment() == 0 || !ss.getInstrOfferingConfig().getInstructionalOffering().effectiveReScheduleNow());
    }

    private void doUpdate(SchedulingSubpart ss, SchedulingSubpartDAO sdao, boolean timeVertical) throws Exception {
        ItypeDesc newItype;
        Set<Preference> s = ss.getPreferences();
        super.doClear(s, Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DATE);
        super.doUpdate(ss, s, timeVertical, Preference.Type.TIME, Preference.Type.ROOM, Preference.Type.ROOM_FEATURE, Preference.Type.ROOM_GROUP, Preference.Type.BUILDING, Preference.Type.DATE);
        ss.setAutoSpreadInTime(((SchedulingSubpartEditForm)this.form).getAutoSpreadInTime());
        ss.setStudentAllowOverlap(((SchedulingSubpartEditForm)this.form).getStudentAllowOverlap());
        if (((SchedulingSubpartEditForm)this.form).getDatePattern() == null || ((SchedulingSubpartEditForm)this.form).getDatePattern().intValue() < 0) {
            ss.setDatePattern(null);
        } else {
            ss.setDatePattern((DatePattern)DatePatternDAO.getInstance().get(((SchedulingSubpartEditForm)this.form).getDatePattern()));
        }
        if (((SchedulingSubpartEditForm)this.form).getInstructionalType() != null && ((SchedulingSubpartEditForm)this.form).getInstructionalType().length() != 0 && (newItype = (ItypeDesc)ItypeDescDAO.getInstance().get(Integer.valueOf(((SchedulingSubpartEditForm)this.form).getInstructionalType()))) != null) {
            ss.setItype(newItype);
        }
        if (((SchedulingSubpartEditForm)this.form).getCreditFormat() == null || ((SchedulingSubpartEditForm)this.form).getCreditFormat().length() == 0 || ((SchedulingSubpartEditForm)this.form).getCreditFormat().equals(Constants.BLANK_OPTION_VALUE)) {
            CourseCreditUnitConfig origConfig = ss.getCredit();
            if (origConfig != null) {
                ss.setCredit(null);
                sdao.getSession().remove((Object)origConfig);
            }
        } else if (ss.getCredit() != null) {
            CourseCreditUnitConfig ccuc = ss.getCredit();
            if (ccuc.getCreditFormat().equals(((SchedulingSubpartEditForm)this.form).getCreditFormat())) {
                boolean changed = false;
                if (!ccuc.getCreditType().getUniqueId().equals(((SchedulingSubpartEditForm)this.form).getCreditType())) {
                    changed = true;
                }
                if (!ccuc.getCreditUnitType().getUniqueId().equals(((SchedulingSubpartEditForm)this.form).getCreditUnitType())) {
                    changed = true;
                }
                if (ccuc instanceof FixedCreditUnitConfig) {
                    FixedCreditUnitConfig fcuc = (FixedCreditUnitConfig)ccuc;
                    if (!fcuc.getFixedUnits().equals(((SchedulingSubpartEditForm)this.form).getUnits())) {
                        changed = true;
                    }
                } else if (ccuc instanceof VariableFixedCreditUnitConfig) {
                    VariableRangeCreditUnitConfig vrcuc;
                    VariableFixedCreditUnitConfig vfcuc = (VariableFixedCreditUnitConfig)ccuc;
                    if (!vfcuc.getMinUnits().equals(((SchedulingSubpartEditForm)this.form).getUnits())) {
                        changed = true;
                    }
                    if (!vfcuc.getMaxUnits().equals(((SchedulingSubpartEditForm)this.form).getMaxUnits())) {
                        changed = true;
                    }
                    if (vfcuc instanceof VariableRangeCreditUnitConfig && !(vrcuc = (VariableRangeCreditUnitConfig)vfcuc).isFractionalIncrementsAllowed().equals(((SchedulingSubpartEditForm)this.form).getFractionalIncrementsAllowed())) {
                        changed = true;
                    }
                }
                if (changed) {
                    CourseCreditUnitConfig origConfig = ss.getCredit();
                    ss.setCredit(null);
                    sdao.getSession().remove((Object)origConfig);
                    ss.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(((SchedulingSubpartEditForm)this.form).getCreditFormat(), ((SchedulingSubpartEditForm)this.form).getCreditType(), ((SchedulingSubpartEditForm)this.form).getCreditUnitType(), SchedulingSubpartEditAction.string2float(((SchedulingSubpartEditForm)this.form).getUnits()), SchedulingSubpartEditAction.string2float(((SchedulingSubpartEditForm)this.form).getMaxUnits()), ((SchedulingSubpartEditForm)this.form).getFractionalIncrementsAllowed(), (Boolean)false));
                    ss.getCredit().setOwner(ss);
                }
            } else {
                CourseCreditUnitConfig origConfig = ss.getCredit();
                ss.setCredit(null);
                sdao.getSession().remove((Object)origConfig);
                ss.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(((SchedulingSubpartEditForm)this.form).getCreditFormat(), ((SchedulingSubpartEditForm)this.form).getCreditType(), ((SchedulingSubpartEditForm)this.form).getCreditUnitType(), SchedulingSubpartEditAction.string2float(((SchedulingSubpartEditForm)this.form).getUnits()), SchedulingSubpartEditAction.string2float(((SchedulingSubpartEditForm)this.form).getMaxUnits()), ((SchedulingSubpartEditForm)this.form).getFractionalIncrementsAllowed(), (Boolean)false));
                ss.getCredit().setOwner(ss);
            }
        } else {
            ss.setCredit(CourseCreditUnitConfig.createCreditUnitConfigOfFormat(((SchedulingSubpartEditForm)this.form).getCreditFormat(), ((SchedulingSubpartEditForm)this.form).getCreditType(), ((SchedulingSubpartEditForm)this.form).getCreditUnitType(), SchedulingSubpartEditAction.string2float(((SchedulingSubpartEditForm)this.form).getUnits()), SchedulingSubpartEditAction.string2float(((SchedulingSubpartEditForm)this.form).getMaxUnits()), ((SchedulingSubpartEditForm)this.form).getFractionalIncrementsAllowed(), (Boolean)false));
            ss.getCredit().setOwner(ss);
        }
        if (ss.getCredit() != null) {
            if (ss.getCredit().getUniqueId() == null) {
                sdao.getSession().persist((Object)ss.getCredit());
            } else {
                sdao.getSession().merge((Object)ss.getCredit());
            }
        }
        sdao.getSession().merge((Object)ss);
        String className = ApplicationProperty.ExternalActionSchedulingSubpartEdit.value();
        if (className != null && className.trim().length() > 0) {
            ExternalSchedulingSubpartEditAction editAction = (ExternalSchedulingSubpartEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            editAction.performExternalSchedulingSubpartEditAction(ss, sdao.getSession());
        }
        ChangeLog.addChange(null, this.sessionContext, ss, ChangeLog.Source.SCHEDULING_SUBPART_EDIT, ChangeLog.Operation.UPDATE, ss.getInstrOfferingConfig().getControllingCourseOffering().getSubjectArea(), ss.getManagingDept());
        sdao.getSession().flush();
    }

    protected static Float string2float(String value) {
        try {
            return Float.valueOf(value);
        }
        catch (Exception e) {
            return Float.valueOf(0.0f);
        }
    }

    protected static String float2string(Float value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    protected void setupChildren(SchedulingSubpart ss) {
        DatePattern selectedDatePattern = ((SchedulingSubpartEditForm)this.form).getDatePattern() < 0L ? (ss.canInheritParentPreferences() ? ss.getParentSubpart().effectiveDatePattern() : ss.getSession().getDefaultDatePatternNotNull()) : (DatePattern)DatePatternDAO.getInstance().get(((SchedulingSubpartEditForm)this.form).getDatePattern());
        try {
            if (selectedDatePattern != null) {
                List<DatePattern> v = selectedDatePattern.findChildren();
                this.request.setAttribute(DatePattern.DATE_PATTERN_CHILDREN_LIST_ATTR, v);
                ((SchedulingSubpartEditForm)this.form).sortDatePatternPrefs(((SchedulingSubpartEditForm)this.form).getDatePatternPrefs(), ((SchedulingSubpartEditForm)this.form).getDatePatternPrefLevels(), v);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

