/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;

public class ConcurrentLinkedBlockingQueue<T>
extends ConcurrentLinkedQueue<T>
implements BlockingQueue<T> {
    protected final int capacity;
    protected final AtomicInteger size = new AtomicInteger(0);
    protected final boolean block_on_empty;
    protected final boolean block_on_full;
    protected final Lock lock = new ReentrantLock();
    protected final Condition not_empty = this.lock.newCondition();
    protected final Condition not_full = this.lock.newCondition();
    protected final IntUnaryOperator INCR;

    public ConcurrentLinkedBlockingQueue(int capacity, boolean block_on_empty, boolean block_on_full) {
        this.capacity = capacity;
        this.block_on_empty = block_on_empty;
        this.block_on_full = block_on_full;
        if (capacity <= 0) {
            throw new IllegalArgumentException(String.format("Capacity (%d) needs to be positive", capacity));
        }
        this.INCR = x -> x >= capacity ? x : x + 1;
    }

    @Override
    public void put(T t) throws InterruptedException {
        Objects.requireNonNull(t);
        if (!this.block_on_full) {
            throw new IllegalStateException(String.format("put() must not be called when block_on_full=%b", this.block_on_full));
        }
        boolean rc;
        block3: while (!(rc = this.offer(t))) {
            this.lock.lockInterruptibly();
            try {
                while (true) {
                    if (this.size.get() < this.capacity) continue block3;
                    this.not_full.await();
                }
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    @Override
    public boolean add(T t) {
        boolean rc = this.offer(t);
        if (rc) {
            return rc;
        }
        throw new IllegalStateException(String.format("no space available: capacity=%d, size=%d", this.capacity, this.size.get()));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(T t) {
        int old_size = this.size.getAndUpdate(this.INCR);
        if (old_size < this.capacity) {
            boolean rc = super.offer(t);
            if (rc && old_size == 0 && this.block_on_empty) {
                this.signalNotEmpty();
            }
            return rc;
        }
        return false;
    }

    @Override
    public boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        super.clear();
        this.size.set(super.size());
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public T poll() {
        Object retval = super.poll();
        if (retval != null) {
            int old_size = this.size.getAndDecrement();
            if (this.block_on_full && old_size >= this.capacity) {
                this.signalNotFull();
            }
        }
        return (T)retval;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T take() throws InterruptedException {
        if (!this.block_on_empty) {
            throw new IllegalStateException(String.format("take() must not be called when block_on_empty=%b", this.block_on_empty));
        }
        T retval;
        block3: while ((retval = this.poll()) == null) {
            this.lock.lockInterruptibly();
            try {
                while (true) {
                    if (this.size.get() != 0) continue block3;
                    this.not_empty.await();
                }
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return retval;
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super T> c, int max) {
        int drained;
        Objects.requireNonNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (max <= 0) {
            return 0;
        }
        for (drained = 0; drained < max; ++drained) {
            T el = this.poll();
            if (el == null) {
                return drained;
            }
            c.add(el);
        }
        return drained;
    }

    @Override
    public T remove() {
        T el = this.poll();
        if (el != null) {
            return el;
        }
        throw new NoSuchElementException("queue is empty");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.size.get();
    }

    protected void signalNotEmpty() {
        this.lock.lock();
        try {
            this.not_empty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void signalNotFull() {
        this.lock.lock();
        try {
            this.not_full.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

