/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.studentsct;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.HardDistanceConflicts;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;
import org.cpsolver.studentsct.reservation.CourseReservation;
import org.cpsolver.studentsct.reservation.CurriculumReservation;
import org.cpsolver.studentsct.reservation.DummyReservation;
import org.cpsolver.studentsct.reservation.GroupReservation;
import org.cpsolver.studentsct.reservation.IndividualReservation;
import org.cpsolver.studentsct.reservation.LearningCommunityReservation;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.ReservationOverride;
import org.cpsolver.studentsct.reservation.UniversalOverride;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;

public class UnusedReservations
extends AbstractStudentSectioningReport {
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);

    public UnusedReservations(StudentSectioningModel model) {
        super(model);
    }

    protected String type(Reservation reservation) {
        if (reservation instanceof LearningCommunityReservation) {
            return "lc";
        }
        if (reservation instanceof GroupReservation) {
            return "group";
        }
        if (reservation instanceof ReservationOverride) {
            return "override";
        }
        if (reservation instanceof IndividualReservation) {
            return "individual";
        }
        if (reservation instanceof CurriculumReservation) {
            return "curriculum";
        }
        if (reservation instanceof CourseReservation) {
            return "course";
        }
        if (reservation instanceof DummyReservation) {
            return "dummy";
        }
        if (reservation instanceof UniversalOverride) {
            return "universal";
        }
        return "other";
    }

    protected String name(Reservation reservation) {
        if (reservation instanceof LearningCommunityReservation) {
            return MSG.reservationLearningCommunity();
        }
        if (reservation instanceof GroupReservation) {
            return MSG.reservationGroup();
        }
        if (reservation instanceof ReservationOverride) {
            return MSG.reservationOverride();
        }
        if (reservation instanceof IndividualReservation) {
            return MSG.reservationIndividual();
        }
        if (reservation instanceof CurriculumReservation) {
            return MSG.reservationCurriculum();
        }
        if (reservation instanceof CourseReservation) {
            return MSG.reservationCourse();
        }
        if (reservation instanceof DummyReservation) {
            return MSG.reservationDummy();
        }
        if (reservation instanceof UniversalOverride) {
            return MSG.reservationUniversal();
        }
        return MSG.reservationOther();
    }

    protected String curriculum(Student student) {
        Object curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = (String)curriculum + (((String)curriculum).isEmpty() ? "" : ", ") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        Object group = "";
        for (StudentGroup aac : student.getGroups()) {
            group = (String)group + (((String)group).isEmpty() ? "" : ", ") + aac.getReference();
        }
        return group;
    }

    protected String advisor(Student student) {
        Object advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = (String)advisors + (((String)advisors).isEmpty() ? "" : ", ") + instructor.getName();
        }
        return advisors;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        HashSet<String> types = new HashSet<String>();
        for (String type : properties.getProperty("type", "group").split("\\,")) {
            types.add(type);
        }
        HashMap<Long, ArrayList<Reservation>> unused = new HashMap<Long, ArrayList<Reservation>>();
        for (Offering offering : this.getModel().getOfferings()) {
            if (offering.isDummy()) continue;
            for (Reservation reservation : offering.getReservations()) {
                if (!types.contains(this.type(reservation))) continue;
                HashSet<Long> studentIds = null;
                if (reservation instanceof IndividualReservation) {
                    studentIds = new HashSet<Long>(((IndividualReservation)reservation).getStudentIds());
                } else if (reservation instanceof CourseReservation) {
                    studentIds = new HashSet();
                    for (CourseRequest cr : ((CourseReservation)reservation).getCourse().getRequests()) {
                        if (!this.matches((Request)cr) || !this.matches(offering.getCourse(cr.getStudent()))) continue;
                        studentIds.add(cr.getStudent().getId());
                    }
                } else {
                    studentIds = new HashSet();
                    for (Course course : reservation.getOffering().getCourses()) {
                        for (CourseRequest cr : course.getRequests()) {
                            if (!reservation.isApplicable(cr.getStudent()) || !this.matches((Request)cr) || !this.matches(offering.getCourse(cr.getStudent()))) continue;
                            studentIds.add(cr.getStudent().getId());
                        }
                    }
                }
                if (studentIds == null || studentIds.isEmpty()) continue;
                for (Enrollment e : reservation.getEnrollments(assignment)) {
                    studentIds.remove(e.getStudent().getId());
                }
                for (Long studentId : studentIds) {
                    ArrayList<Reservation> studentReservations = (ArrayList<Reservation>)unused.get(studentId);
                    if (studentReservations == null) {
                        studentReservations = new ArrayList<Reservation>();
                        unused.put(studentId, studentReservations);
                    }
                    studentReservations.add(reservation);
                }
            }
        }
        CSVFile csv = new CSVFile();
        if (types.contains("universal")) {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportRequestedCourse()), new CSVFile.CSVField((Object)MSG.reportCourseRequestPriority()), new CSVFile.CSVField((Object)MSG.reportAssignmentConflict()), new CSVFile.CSVField((Object)MSG.reportUniversalReservationStudentFilter())});
        } else {
            csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"__Student"), new CSVFile.CSVField((Object)MSG.reportStudentId()), new CSVFile.CSVField((Object)MSG.reportStudentName()), new CSVFile.CSVField((Object)MSG.reportStudentEmail()), new CSVFile.CSVField((Object)MSG.reportStudentPriority()), new CSVFile.CSVField((Object)MSG.reportStudentCurriculum()), new CSVFile.CSVField((Object)MSG.reportStudentGroup()), new CSVFile.CSVField((Object)MSG.reportStudentAdvisor()), new CSVFile.CSVField((Object)MSG.reportRequestedCourse()), new CSVFile.CSVField((Object)MSG.reportCourseRequestPriority()), new CSVFile.CSVField((Object)MSG.reportAssignmentConflict())});
        }
        if (unused.isEmpty()) {
            return csv;
        }
        for (Student student : this.getModel().getStudents()) {
            List studentReservations = (List)unused.get(student.getId());
            if (studentReservations == null || studentReservations.isEmpty()) continue;
            for (Reservation reservation : studentReservations) {
                if (!this.matches(student)) continue;
                ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
                line.add(new CSVFile.CSVField(student.getId()));
                line.add(new CSVFile.CSVField((Object)student.getExternalId()));
                line.add(new CSVFile.CSVField((Object)student.getName()));
                org.unitime.timetable.model.Student dbStudent = (org.unitime.timetable.model.Student)StudentDAO.getInstance().get(student.getId());
                if (dbStudent != null) {
                    line.add(new CSVFile.CSVField((Object)dbStudent.getEmail()));
                } else {
                    line.add(new CSVFile.CSVField((Object)""));
                }
                line.add(new CSVFile.CSVField((Object)(student.getPriority() == null ? "" : student.getPriority().name())));
                line.add(new CSVFile.CSVField((Object)this.curriculum(student)));
                line.add(new CSVFile.CSVField((Object)this.group(student)));
                line.add(new CSVFile.CSVField((Object)this.advisor(student)));
                CourseRequest courseRequest = null;
                Course course = null;
                block10: for (Request r : student.getRequests()) {
                    if (!(r instanceof CourseRequest)) continue;
                    CourseRequest cr = (CourseRequest)r;
                    for (Course c : cr.getCourses()) {
                        if (!reservation.getOffering().equals((Object)c.getOffering())) continue;
                        courseRequest = cr;
                        course = c;
                        break block10;
                    }
                }
                if (course == null) {
                    Course c = reservation instanceof CourseReservation ? ((CourseReservation)reservation).getCourse() : (Course)reservation.getOffering().getCourses().get(0);
                    if (!this.matches(c)) continue;
                    line.add(new CSVFile.CSVField((Object)(reservation instanceof CourseReservation ? ((CourseReservation)reservation).getCourse().getName() : reservation.getOffering().getName())));
                    line.add(new CSVFile.CSVField((Object)""));
                    line.add(new CSVFile.CSVField((Object)MSG.courseNotRequested()));
                } else {
                    if (!this.matches((Request)courseRequest)) continue;
                    line.add(new CSVFile.CSVField((Object)course.getName()));
                    line.add(new CSVFile.CSVField((Object)(courseRequest.getRequestPriority() == null ? "" : courseRequest.getRequestPriority().name())));
                    Enrollment enrollment = (Enrollment)courseRequest.getAssignment(assignment);
                    if (enrollment != null && reservation.isIncluded(enrollment)) continue;
                    TreeSet<Enrollment> overlaps = new TreeSet<Enrollment>(new Comparator<Enrollment>(){

                        @Override
                        public int compare(Enrollment o1, Enrollment o2) {
                            return o1.getRequest().compareTo(o2.getRequest());
                        }
                    });
                    TreeSet<CallSite> other = new TreeSet<CallSite>();
                    Hashtable<CourseRequest, TreeSet<Section>> overlapingSections = new Hashtable<CourseRequest, TreeSet<Section>>();
                    List av = courseRequest.getAvaiableEnrollmentsSkipSameTime(assignment);
                    if (enrollment != null) {
                        if (enrollment.getOffering().equals((Object)reservation.getOffering())) {
                            line.add(new CSVFile.CSVField((Object)MSG.reservationNotUsed()));
                        } else {
                            line.add(new CSVFile.CSVField((Object)MSG.enrolledInAlt(enrollment.getCourse().getName())));
                        }
                    } else if (av.isEmpty() || av.size() == 1 && ((Enrollment)av.get(0)).equals((Object)courseRequest.getInitialAssignment()) && this.getModel().inConflict(assignment, (Value)((Enrollment)av.get(0)))) {
                        if (((Course)courseRequest.getCourses().get(0)).getLimit() >= 0) {
                            line.add(new CSVFile.CSVField((Object)MSG.courseIsFull()));
                        } else if (SectioningRequest.hasInconsistentRequirements(courseRequest, null)) {
                            line.add(new CSVFile.CSVField((Object)MSG.classNotAvailableDueToStudentPrefs()));
                        } else {
                            line.add(new CSVFile.CSVField((Object)MSG.classNotAvailable()));
                        }
                    } else {
                        Object x;
                        for (Enrollment enrl : av) {
                            for (Request q : enrl.getStudent().getRequests()) {
                                if (q.equals((Object)courseRequest) || (x = (Enrollment)assignment.getValue((Variable)q)) == null || x.getAssignments() == null || x.getAssignments().isEmpty()) continue;
                                for (SctAssignment a : x.getAssignments()) {
                                    if (!a.isOverlapping(enrl.getAssignments()) && !HardDistanceConflicts.inConflict((StudentQuality)this.getModel().getStudentQuality(), (SctAssignment)a, (Enrollment)enrl)) continue;
                                    overlaps.add((Enrollment)x);
                                    if (!(x.getRequest() instanceof CourseRequest)) continue;
                                    CourseRequest cr = (CourseRequest)x.getRequest();
                                    TreeSet<Section> ss = (TreeSet<Section>)overlapingSections.get(cr);
                                    if (ss == null) {
                                        ss = new TreeSet<Section>((Comparator<Section>)new AssignmentComparator(assignment));
                                        overlapingSections.put(cr, ss);
                                    }
                                    ss.add((Section)a);
                                }
                                block15: for (Unavailability unavailability2 : student.getUnavailabilities()) {
                                    for (SctAssignment section : enrl.getAssignments()) {
                                        if (!HardDistanceConflicts.inConflict((StudentQuality)this.getModel().getStudentQuality(), (Section)((Section)section), (Unavailability)unavailability2)) continue;
                                        other.add((CallSite)((Object)(unavailability2.getCourseName() + " " + unavailability2.getSectionName())));
                                        continue block15;
                                    }
                                }
                            }
                        }
                        block17: for (Object unavailability : student.getUnavailabilities()) {
                            for (Config config : course.getOffering().getConfigs()) {
                                x = config.getSubparts().iterator();
                                while (x.hasNext()) {
                                    Unavailability unavailability2;
                                    Subpart subpart = (Subpart)x.next();
                                    unavailability2 = subpart.getSections().iterator();
                                    while (unavailability2.hasNext()) {
                                        Section section = (Section)unavailability2.next();
                                        if (section.getLimit() <= 0 || !unavailability.isOverlapping((SctAssignment)section)) continue;
                                        other.add((CallSite)((Object)(unavailability.getCourseName() + " " + unavailability.getSectionName())));
                                        continue block17;
                                    }
                                }
                            }
                        }
                        if (!overlaps.isEmpty() || !other.isEmpty()) {
                            Object unavailability;
                            TreeSet<String> ts = new TreeSet<String>((SortedSet<String>)other);
                            unavailability = overlaps.iterator();
                            while (unavailability.hasNext()) {
                                Enrollment q = (Enrollment)unavailability.next();
                                if (q.getRequest() instanceof FreeTimeRequest) {
                                    ts.add(OnlineSectioningHelper.toString((FreeTimeRequest)q.getRequest()));
                                    continue;
                                }
                                CourseRequest cr = (CourseRequest)q.getRequest();
                                Course o = q.getCourse();
                                Object ov = MSG.course(o.getSubjectArea(), o.getCourseNumber());
                                if (((TreeSet)overlapingSections.get(cr)).size() == 1) {
                                    Iterator i = ((TreeSet)overlapingSections.get(cr)).iterator();
                                    while (i.hasNext()) {
                                        Section s = (Section)i.next();
                                        ov = (String)ov + " " + s.getSubpart().getName();
                                        if (!i.hasNext()) continue;
                                        ov = (String)ov + ",";
                                    }
                                }
                                ts.add((String)ov);
                            }
                            Object message = "";
                            Iterator i = ts.iterator();
                            while (i.hasNext()) {
                                String x2 = (String)i.next();
                                if (((String)message).isEmpty()) {
                                    message = (String)message + MSG.conflictWithFirst(x2);
                                    continue;
                                }
                                if (!i.hasNext()) {
                                    message = (String)message + MSG.conflictWithLast(x2);
                                    continue;
                                }
                                message = (String)message + MSG.conflictWithMiddle(x2);
                            }
                            line.add(new CSVFile.CSVField(message));
                        } else {
                            line.add(new CSVFile.CSVField((Object)MSG.courseNotAssigned()));
                        }
                    }
                }
                if (reservation instanceof UniversalOverride) {
                    line.add(new CSVFile.CSVField((Object)((UniversalOverride)reservation).getFilter()));
                }
                csv.addLine(line);
            }
        }
        return csv;
    }
}

