/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.events.SessionDatesSelector;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.offerings.PreferenceEditWidget;
import org.unitime.timetable.gwt.client.page.UniTimeNavigation;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.client.tables.TableWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SearchableListBox;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class ClassEditPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel = new SimpleForm(2);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private PrefGroupEditInterface.ClassEditResponse iData;
    private UniTimeTable<PrefGroupEditInterface.ClassInstr> iInstructors;
    private ListBox iDatePattern;
    private PreferenceEditWidget iPreferences;

    public ClassEditPage() {
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-ClassEditPage");
        this.initWidget((Widget)this.iRootPanel);
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        String id = Window.Location.getParameter((String)"id");
        if (id == null) {
            id = Window.Location.getParameter((String)"cid");
        }
        if (id == null || id.isEmpty()) {
            LoadingWidget.getInstance().hide();
            this.iHeader.setErrorMessage(COURSE.errorNoClassId());
        } else {
            this.load(Long.valueOf(id), PrefGroupEditInterface.Operation.GET, true, null);
        }
        this.iHeader.addButton("update", COURSE.actionUpdatePreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ClassEditPage.this.iPreferences.update();
                if (ClassEditPage.this.iInstructors != null) {
                    ClassEditPage.this.iData.setClassInstructors(ClassEditPage.this.iInstructors.getData());
                }
                if (ClassEditPage.this.validate()) {
                    ClassEditPage.this.load(ClassEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.UPDATE, true, null);
                }
            }
        });
        this.iHeader.getButton("update").setTitle(COURSE.titleUpdatePreferences(COURSE.accessUpdatePreferences()));
        this.iHeader.getButton("update").setAccessKey(COURSE.accessUpdatePreferences().charAt(0));
        this.iHeader.setEnabled("update", false);
        this.iHeader.addButton("clear", COURSE.actionClearClassPreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ClassEditPage.this.iPreferences.update();
                if (ClassEditPage.this.iInstructors != null) {
                    ClassEditPage.this.iData.setClassInstructors(ClassEditPage.this.iInstructors.getData());
                }
                ClassEditPage.this.load(ClassEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.CLEAR_CLASS_PREFS, true, null);
            }
        });
        this.iHeader.getButton("clear").setTitle(COURSE.titleClearClassPreferences(COURSE.accessClearClassPreferences()));
        this.iHeader.getButton("clear").setAccessKey(COURSE.accessClearClassPreferences().charAt(0));
        this.iHeader.setEnabled("clear", false);
        this.iHeader.addButton("previous", COURSE.actionPreviousClass(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ClassEditPage.this.iPreferences.update();
                if (ClassEditPage.this.iInstructors != null) {
                    ClassEditPage.this.iData.setClassInstructors(ClassEditPage.this.iInstructors.getData());
                }
                if (ClassEditPage.this.validate()) {
                    ClassEditPage.this.load(ClassEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.PREVIOUS, true, null);
                }
            }
        });
        this.iHeader.getButton("previous").setTitle(COURSE.titlePreviousClassWithUpdate(COURSE.accessPreviousClass()));
        this.iHeader.getButton("previous").setAccessKey(COURSE.accessPreviousClass().charAt(0));
        this.iHeader.setEnabled("previous", false);
        this.iHeader.addButton("next", COURSE.actionNextClass(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ClassEditPage.this.iPreferences.update();
                if (ClassEditPage.this.iInstructors != null) {
                    ClassEditPage.this.iData.setClassInstructors(ClassEditPage.this.iInstructors.getData());
                }
                if (ClassEditPage.this.validate()) {
                    ClassEditPage.this.load(ClassEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.NEXT, true, null);
                }
            }
        });
        this.iHeader.getButton("next").setTitle(COURSE.titleNextClassWithUpdate(COURSE.accessNextClass()));
        this.iHeader.getButton("next").setAccessKey(COURSE.accessNextClass().charAt(0));
        this.iHeader.setEnabled("next", false);
        this.iHeader.addButton("back", COURSE.actionBackToDetail(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ToolBox.open(GWT.getHostPageBaseURL() + "clazz?id=" + ClassEditPage.this.iData.getId());
            }
        });
        this.iHeader.getButton("back").setTitle(COURSE.titleBackToDetail(COURSE.accessBackToDetail()));
        this.iHeader.getButton("back").setAccessKey(COURSE.accessBackToDetail().charAt(0));
        this.iFooter = this.iHeader.clonePanel();
    }

    protected void load(final Long classId, final PrefGroupEditInterface.Operation op, final boolean showLoading, final Command command) {
        if (showLoading) {
            LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        }
        PrefGroupEditInterface.ClassEditRequest req = new PrefGroupEditInterface.ClassEditRequest();
        req.setOperation(op);
        if (op != null && this.iData != null) {
            this.iPreferences.update();
            if (this.iInstructors != null) {
                this.iData.setClassInstructors(this.iInstructors.getData());
            }
            req.setPayLoad(this.iData);
        }
        req.setId(classId);
        RPC.execute(req, new AsyncCallback<PrefGroupEditInterface.ClassEditResponse>(){

            public void onFailure(Throwable caught) {
                if (showLoading) {
                    LoadingWidget.getInstance().hide();
                }
                ClassEditPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(final PrefGroupEditInterface.ClassEditResponse response) {
                ClassEditPage.this.iData = response;
                if (response.hasUrl()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + response.getUrl());
                    return;
                }
                if (showLoading) {
                    LoadingWidget.getInstance().hide();
                }
                if (op == PrefGroupEditInterface.Operation.DATE_PATTERN || op == PrefGroupEditInterface.Operation.INSTRUCTORS) {
                    ClassEditPage.this.iPreferences.setValue(response);
                    return;
                }
                ClassEditPage.this.iPanel.clear();
                ClassEditPage.this.iHeader.setHeaderTitle(response.getName());
                ClassEditPage.this.iPanel.addHeaderRow((Widget)ClassEditPage.this.iHeader);
                for (TableInterface.PropertyInterface property : response.getProperties().getProperties()) {
                    ClassEditPage.this.iPanel.addRow(property.getName(), (Widget)new TableWidget.CellWidget(property.getCell(), true));
                }
                if (response.hasDatePatterms()) {
                    ClassEditPage.this.iDatePattern = new ListBox();
                    for (PrefGroupEditInterface.IdLabel dp : response.getDatePatterns()) {
                        ClassEditPage.this.iDatePattern.addItem(dp.getLabel(), dp.getId().toString());
                        if (!dp.getId().equals(response.getDatePatternId())) continue;
                        ClassEditPage.this.iDatePattern.setSelectedIndex(ClassEditPage.this.iDatePattern.getItemCount() - 1);
                    }
                    P datePatternPanel = new P("date-pattern");
                    if (response.isSearchableDatePattern()) {
                        datePatternPanel.add((Widget)new SearchableListBox(ClassEditPage.this.iDatePattern));
                    } else {
                        datePatternPanel.add((Widget)ClassEditPage.this.iDatePattern);
                    }
                    final ImageButton cal = new ImageButton(RESOURCES.datepattern());
                    ClassEditPage.this.iDatePattern.addChangeHandler(new ChangeHandler(){

                        public void onChange(ChangeEvent event) {
                            Long id = Long.valueOf(ClassEditPage.this.iDatePattern.getSelectedValue());
                            ClassEditPage.this.iData.setDatePatternId(id);
                            PrefGroupEditInterface.IdLabel dp = response.getDatePattern(id);
                            cal.setVisible(dp != null && dp.getDescription() != null);
                            ClassEditPage.this.load(classId, PrefGroupEditInterface.Operation.DATE_PATTERN, false, null);
                        }
                    });
                    cal.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            Long id = Long.valueOf(ClassEditPage.this.iDatePattern.getSelectedValue());
                            PrefGroupEditInterface.IdLabel dp = response.getDatePattern(id);
                            if (dp != null && dp.getDescription() != null) {
                                final UniTimeDialogBox box = new UniTimeDialogBox(true, true);
                                SessionDatesSelector w = new SessionDatesSelector().forDatePattern(response.getDatePattern(id).getDescription(), new Command(){

                                    public void execute() {
                                        box.center();
                                    }
                                });
                                w.getElement().getStyle().setProperty("width", "80vw");
                                box.setWidget((Widget)w);
                                box.setText(COURSE.sectPreviewOfDatePattern(ClassEditPage.this.iDatePattern.getSelectedItemText()));
                            }
                        }
                    });
                    datePatternPanel.add((Widget)cal);
                    ClassEditPage.this.iPanel.addRow(COURSE.propertyDatePattern(), (Widget)datePatternPanel);
                }
                CheckBox displayInstructor = new CheckBox();
                displayInstructor.setValue(Boolean.valueOf(response.isDisplayInstructors()));
                ClassEditPage.this.iPanel.addRow(COURSE.propertyDisplayInstructors(), (Widget)displayInstructor);
                displayInstructor.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        ClassEditPage.this.iData.setDisplayInstructors((Boolean)event.getValue());
                    }
                });
                CheckBox studentScheduling = new CheckBox();
                studentScheduling.setValue(Boolean.valueOf(response.isStudentScheduling()));
                ClassEditPage.this.iPanel.addRow(COURSE.propertyEnabledForStudentScheduling(), (Widget)studentScheduling);
                studentScheduling.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        ClassEditPage.this.iData.setStudentScheduling((Boolean)event.getValue());
                    }
                });
                TextArea scheduleNote = new TextArea();
                scheduleNote.setHeight("66px");
                scheduleNote.setWidth("100%");
                if (response.hasScheduleNote()) {
                    scheduleNote.setText(response.getScheduleNote());
                }
                ClassEditPage.this.iPanel.addRow(COURSE.propertyStudentScheduleNote(), (Widget)scheduleNote);
                scheduleNote.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        ClassEditPage.this.iData.setScheduleNote((String)event.getValue());
                    }
                });
                if (response.hasTimetable()) {
                    UniTimeHeaderPanel hp = new UniTimeHeaderPanel(response.getTimetable().getName());
                    ClassEditPage.this.iPanel.addHeaderRow((Widget)hp);
                    ClassEditPage.this.iPanel.addRow((Widget)new TableWidget(response.getTimetable()));
                }
                UniTimeHeaderPanel notesPanel = new UniTimeHeaderPanel(COURSE.sectionTitleNotesToScheduleManager());
                ClassEditPage.this.iPanel.addHeaderRow((Widget)notesPanel);
                TextArea reqestNotes = new TextArea();
                reqestNotes.setHeight("66px");
                reqestNotes.setWidth("100%");
                if (response.hasRequestNote()) {
                    reqestNotes.setText(response.getRequestNote());
                }
                ClassEditPage.this.iPanel.addRow((Widget)reqestNotes);
                reqestNotes.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                    public void onValueChange(ValueChangeEvent<String> event) {
                        ClassEditPage.this.iData.setRequestNote((String)event.getValue());
                    }
                });
                ClassEditPage.this.iInstructors = new UniTimeTable();
                if (response.hasInstructors()) {
                    UniTimeHeaderPanel instrPanel = new UniTimeHeaderPanel(COURSE.sectionTitleInstructors());
                    ClassEditPage.this.iPanel.addHeaderRow((Widget)instrPanel);
                    ClassEditPage.this.iPanel.addRow((Widget)ClassEditPage.this.iInstructors);
                    instrPanel.addButton("add-instructor", COURSE.actionAddInstructor(), new ClickHandler(){

                        public void onClick(ClickEvent evt) {
                            PrefGroupEditInterface.ClassInstr ci = new PrefGroupEditInterface.ClassInstr();
                            int percent = 0;
                            for (int r = 1; r < ClassEditPage.this.iInstructors.getRowCount(); ++r) {
                                percent += ClassEditPage.this.iInstructors.getData(r).getPercentShare();
                            }
                            ci.setPercentShare(Math.max(0, 100 - percent));
                            ClassEditPage.this.iInstructors.addRow(ci, ClassEditPage.this.toLine(ci));
                        }
                    });
                    ArrayList<UniTimeTableHeader> instrHeader = new ArrayList<UniTimeTableHeader>();
                    instrHeader.add(new UniTimeTableHeader(COURSE.columnInstructorName()));
                    if (response.hasResponsibilities()) {
                        instrHeader.add(new UniTimeTableHeader(COURSE.columnTeachingResponsibility()));
                    }
                    UniTimeTableHeader hShare = new UniTimeTableHeader(COURSE.columnInstructorShare());
                    hShare.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                    instrHeader.add(hShare);
                    UniTimeTableHeader hConf = new UniTimeTableHeader(COURSE.columnInstructorCheckConflicts());
                    hConf.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                    instrHeader.add(hConf);
                    instrHeader.add(new UniTimeTableHeader(""));
                    ClassEditPage.this.iInstructors.addRow(null, instrHeader);
                    if (response.hasClassInstructors()) {
                        for (PrefGroupEditInterface.ClassInstr ci : response.getClassInstructors()) {
                            ClassEditPage.this.iInstructors.addRow(ci, ClassEditPage.this.toLine(ci));
                        }
                    }
                    if (ClassEditPage.this.iInstructors.getRowCount() <= 1) {
                        PrefGroupEditInterface.ClassInstr ci = new PrefGroupEditInterface.ClassInstr();
                        ci.setPercentShare(100);
                        ClassEditPage.this.iInstructors.addRow(ci, ClassEditPage.this.toLine(ci));
                    }
                }
                ClassEditPage.this.iPreferences = new PreferenceEditWidget();
                ClassEditPage.this.iPreferences.setValue(response);
                ClassEditPage.this.iPanel.addRow((Widget)ClassEditPage.this.iPreferences);
                ClassEditPage.this.iPanel.addBottomRow((Widget)ClassEditPage.this.iFooter);
                UniTimeNavigation.getInstance().refresh();
                ClassEditPage.this.iHeader.setEnabled("update", true);
                ClassEditPage.this.iHeader.setEnabled("previous", response.getPreviousId() != null);
                ClassEditPage.this.iHeader.setEnabled("next", response.getNextId() != null);
                ClassEditPage.this.iHeader.setEnabled("clear", response.canClearPrefs());
                if (command != null) {
                    command.execute();
                }
            }
        });
    }

    protected void instructorsChanged(Long instructorId, Long oldId, final Focusable widget) {
        PrefGroupEditInterface.IdLabel instructor;
        if (this.iData.getInheritInstructorPrefs() == PrefGroupEditInterface.InheritInstructorPrefs.NEVER) {
            return;
        }
        boolean hasPrefs = false;
        if (instructorId != null && (instructor = this.iData.getInstructor(instructorId)) != null && "1".equals(instructor.getDescription())) {
            hasPrefs = true;
        }
        if (oldId != null && (instructor = this.iData.getInstructor(oldId)) != null && "1".equals(instructor.getDescription())) {
            hasPrefs = true;
        }
        if (!hasPrefs) {
            return;
        }
        if (this.iData.getInheritInstructorPrefs() == PrefGroupEditInterface.InheritInstructorPrefs.ALWAYS) {
            this.load(this.iData.getId(), PrefGroupEditInterface.Operation.INSTRUCTORS, false, null);
        } else if (this.iData.getInheritInstructorPrefs() == PrefGroupEditInterface.InheritInstructorPrefs.ASK) {
            UniTimeConfirmationDialog.confirm(instructorId == null ? COURSE.confirmRemoveInstructorPreferencesFromClass() : COURSE.confirmApplyInstructorPreferencesToClass(), new Command(){

                public void execute() {
                    ClassEditPage.this.load(ClassEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.INSTRUCTORS, false, new Command(){

                        public void execute() {
                            if (widget != null) {
                                widget.setFocus(true);
                            }
                        }
                    });
                }
            });
        }
    }

    protected List<Widget> toLine(final PrefGroupEditInterface.ClassInstr ci) {
        ArrayList<Widget> ret = new ArrayList<Widget>();
        final ListBox instructor = new ListBox();
        final CoflictBox conflict = new CoflictBox();
        instructor.addItem("-", "");
        for (PrefGroupEditInterface.IdLabel idLabel : this.iData.getInstructors()) {
            instructor.addItem(idLabel.getLabel(), idLabel.getId().toString());
            if (!idLabel.getId().equals(ci.getInstructorId())) continue;
            instructor.setSelectedIndex(instructor.getItemCount() - 1);
        }
        instructor.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent ce) {
                String id = instructor.getSelectedValue();
                Long oldId = ci.getInstructorId();
                if (id.isEmpty()) {
                    ci.setInstructorId(null);
                    if (oldId != null && conflict.getValue().booleanValue()) {
                        ClassEditPage.this.instructorsChanged(null, oldId, (Focusable)instructor);
                    }
                    conflict.setValue(Boolean.valueOf(false), false);
                    ci.setCheckConflicts(false);
                    conflict.setEnabled(false);
                } else {
                    ci.setInstructorId(Long.valueOf(id));
                    conflict.setEnabled(true);
                    if (oldId == null) {
                        conflict.setValue(Boolean.valueOf(true), false);
                        ci.setCheckConflicts(true);
                    }
                    if (!ci.getInstructorId().equals(oldId) && conflict.getValue().booleanValue()) {
                        ClassEditPage.this.instructorsChanged(ci.getInstructorId(), oldId, (Focusable)instructor);
                    }
                }
            }
        });
        ret.add((Widget)instructor);
        if (this.iData.hasResponsibilities()) {
            final ListBox responsibility = new ListBox();
            if (this.iData.getDefaultResponsibilityId() == null) {
                responsibility.addItem("-", "");
            }
            for (PrefGroupEditInterface.IdLabel i : this.iData.getResponsibilities()) {
                responsibility.addItem(i.getLabel(), i.getId().toString());
                if (!i.getId().equals(ci.getResponsibilityId()) && (ci.getResponsibilityId() != null || !i.getId().equals(this.iData.getDefaultResponsibilityId()))) continue;
                responsibility.setSelectedIndex(responsibility.getItemCount() - 1);
            }
            ret.add((Widget)responsibility);
            responsibility.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent ce) {
                    String id = responsibility.getSelectedValue();
                    if (id.isEmpty()) {
                        ci.setResponsibilityId(null);
                    } else {
                        ci.setResponsibilityId(Long.valueOf(id));
                    }
                }
            });
        }
        PercentBox percent = new PercentBox();
        percent.setValue(ci.getPercentShare());
        percent.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                try {
                    ci.setPercentShare(Integer.valueOf((String)event.getValue()));
                }
                catch (Exception e) {
                    ci.setPercentShare(0);
                }
            }
        });
        ret.add((Widget)percent);
        conflict.setValue(ci.getInstructorId() != null && ci.isCheckConflicts());
        conflict.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                ci.setCheckConflicts((Boolean)event.getValue());
                ClassEditPage.this.instructorsChanged(ci.getInstructorId(), null, (Focusable)conflict);
            }
        });
        ret.add((Widget)conflict);
        conflict.setEnabled(ci.getInstructorId() != null);
        final ImageButton imageButton = new ImageButton(RESOURCES.delete());
        imageButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                int row = ClassEditPage.this.iInstructors.getRowForWidget((Widget)imageButton);
                if (row >= 0) {
                    ClassEditPage.this.iInstructors.removeRow(row);
                }
                if (conflict.getValue().booleanValue()) {
                    ClassEditPage.this.instructorsChanged(null, ci.getInstructorId(), null);
                }
            }
        });
        ret.add((Widget)imageButton);
        return ret;
    }

    public boolean validate() {
        String error;
        this.iHeader.clearMessage();
        if (this.iData.hasRequestNote() && this.iData.getRequestNote().length() > 999) {
            this.iHeader.setErrorMessage(COURSE.errorNotesLongerThan999());
            return false;
        }
        if (this.iData.hasScheduleNote() && this.iData.getScheduleNote().length() > 1999) {
            this.iHeader.setErrorMessage(COURSE.errorSchedulePrintNoteLongerThan1999());
            return false;
        }
        if (this.iInstructors != null) {
            HashSet<PrefGroupEditInterface.ClassInstr> instructors = new HashSet<PrefGroupEditInterface.ClassInstr>();
            for (PrefGroupEditInterface.ClassInstr ci : this.iInstructors.getData()) {
                if (ci.getInstructorId() == null || instructors.add(ci)) continue;
                this.iHeader.setErrorMessage(COURSE.errorInvalidInstructors());
                return false;
            }
        }
        if ((error = this.iPreferences.validate()) != null) {
            this.iHeader.setErrorMessage(error);
            return false;
        }
        return true;
    }

    private static class CoflictBox
    extends CheckBox
    implements UniTimeTable.HasCellAlignment {
        private CoflictBox() {
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_CENTER;
        }
    }

    private static class PercentBox
    extends NumberBox
    implements UniTimeTable.HasCellAlignment {
        public PercentBox() {
            this.setDecimal(false);
            this.setNegative(false);
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }
}

