/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.defaults;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;

public enum ApplicationProperty {
    DatabaseDialect("hibernate.dialect"),
    ConnectionUrl("connection.url"),
    ConnectionUser("connection.username"),
    ConnectionPassword("connection.password"),
    ConnectionDriver("connection.driver_class"),
    ConnectionLogging("connection.logging"),
    DatabaseSchema("hibernate.default_schema"),
    DatabaseUniqueIdGenerator("tmtbl.uniqueid.generator"),
    DatabaseVersion("tmtbl.db.version"),
    DatabaseUpdateFile("tmtbl.db.update"),
    Locale("unitime.locale"),
    DataDir("unitime.data.dir"),
    CustomProperties("tmtbl.custom.properties"),
    LoginPage("tmtbl.login_url"),
    LoginMethod("tmtbl.login_method"),
    LoginPageHeader("tmtbl.header.external"),
    LoginPageFooter("tmtbl.footer.external"),
    SystemMessage("tmtbl.system_message"),
    GlobalInfoMessage("tmtbl.global.info"),
    GlobalWarningMessage("tmtbl.global.warn"),
    GlobalErrorMessage("tmtbl.global.error"),
    DisclaimerMessage("tmtbl.page.disclaimer"),
    CustomStyleSheet("tmtbl.custom.css"),
    MenuStyle("unitime.menu.style"),
    LoginFailedLockout("tmtbl.login.failed.lockout.minutes"),
    LoginMaxFailedAttempts("tmtbl.login.max.failed.attempts"),
    LoginFailedAttemptDelay("tmtbl.login.failed.delay.milliseconds"),
    AccessLevel("tmtbl.access_level"),
    ApplicationPropertiesDynamicReload("tmtbl.properties.dynamic_reload"),
    ApplicationPropertiesDynamicReloadInterval("tmtbl.properties.dynamic_reload_interval"),
    PasswordReset("unitime.password.reset"),
    RegistrationPopupObtrusiveness("unitime.registration.obtrusiveness"),
    UrlEncoderSecret("unitime.encode.secret"),
    UrlEncoderSecretAlgorithm("unitime.encode.algorithm"),
    UrlEncoderSecretIterationCount("unitime.encode.iterationCount"),
    UrlEncoderSecretKeyLength("unitime.encode.keyLength"),
    UrlEncoderCipher("unitime.encode.cipher"),
    UrlEncoderCipherIV("unitime.encode.cipher.iv"),
    UrlEncoderHashQueryWhenAsked("unitime.encode.hash"),
    AuthenticationModules("tmtbl.authenticate.modules"),
    AuthenticationLdapUrl("unitime.authentication.ldap.url"),
    AuthenticationLdapAuthenticate("unitime.authentication.ldap.user-dn-pattern"),
    AuthenticationLdapAuthorize("unitime.authentication.ldap.group-search-base"),
    AuthenitcationLdapFilter("unitime.authentication.ldap.group-search-filter"),
    AuthorizationLdapUpCase("unitime.authentication.ldap.group-convert-to-uppercase"),
    AuthenticationLdapIdTranslate("unitime.authentication.ldap.id-translate"),
    AuthenticationLdapIdTrimLeadingZeros("unitime.authentication.ldap.id-trim"),
    AuthenticationLdapIdentify("unitime.authentication.ldap.identify"),
    AuthenticationLdapIdAttribute("unitime.authentication.ldap.group-role-attribute"),
    AuthenticationLdapLogin2UserId("unitime.authentication.ldap.uid2ext"),
    AuthenticationLdapUserId2Login("unitime.authentication.ldap.ext2uid"),
    MenuFile("unitime.menu"),
    CustomMenuFile("unitime.menu.custom"),
    PageHelpEnabled("tmtbl.wiki.help"),
    PageHelpUrl("tmtbl.wiki.url"),
    PageWarning("tmtbl.page.warn.%"),
    PageInfo("tmtbl.page.info.%"),
    PageError("tmtbl.page.error.%"),
    UniTimeUrl("unitime.url"),
    MaxUploadSize("unitime.upload.max_size_in_bytes"),
    KeepLastUsedAcademicSession("tmtbl.keeplastused.session"),
    DistanceEllipsoid("unitime.distance.ellipsoid"),
    EventDistanceSpeed("tmtbl.events.distanceSpeed"),
    EventNearByDistance("tmtbl.events.nearByDistance"),
    RoomDefaultBreakTime("unitime.events.breakTime.%"),
    SolverLocalEnabled("tmtbl.solver.local.enabled"),
    SolverMemoryLimit("tmtbl.solver.mem_limit"),
    SolverBaseUsage("tmtbl.solver.base_usage"),
    SolverLogLevel("unitime.solver.log.level.%"),
    RoomAreaUnitsFormat("unitime.room.area.units.format"),
    RoomAreaUnitsMetric("unitime.room.area.units.metric"),
    ClassAssignmentChangePastMeetings("tmtbl.classAssign.changePastMeetings"),
    ClassAssignmentIgnorePastMeetings("tmtbl.classAssign.ignorePastMeetings"),
    ClassAssignmentShowStudentConflicts("tmtbl.classAssign.showStudentConflicts"),
    ClassAssignmentAllowUnassignments("tmtbl.classAssign.allowUnassignment"),
    ClassAssignmentPrefetchConflicts("tmtbl.classAssign.prefetchConflicts"),
    ClassAssignmentStudentConflictsType("tmtbl.classAssign.studentConflicts"),
    ClassSetupShowExternalIds("tmtbl.class_setup.show_display_external_ids"),
    ClassSetupEditExternalIds("tmtbl.class_setup.edit_external_ids"),
    ClassSetupEditSnapshotLimits("tmtbl.class_setup.edit_snapshot_limits"),
    ClassSetupDisplayInstructorFlags("tmtbl.class_setup.show_display_instructor_flags"),
    ClassSetupEnabledForStudentScheduling("tmtbl.class_setup.show_enabled_for_student_scheduling"),
    CourseOfferingShowExternalIds("unitime.course.showExternalIds"),
    CourseOfferingEditExternalIds("unitime.course.editExternalIds"),
    CourseOfferingNumberMustBeUnique("tmtbl.courseNumber.unique"),
    CourseOfferingNumberUpperCase("tmtbl.courseNumber.upperCase"),
    CourseOfferingTitleSearch("tmtbl.courseNumber.searchTitle"),
    CourseOfferingNumberPattern("tmtbl.courseNumber.pattern"),
    CourseOfferingNumberPatternInfo("tmtbl.courseNumber.patternInfo"),
    NonUniversityLocationPattern("tmtbl.nonUniversityLocation.pattern"),
    NonUniversityLocationPatternInfo("tmtbl.nonUniversityLocation.patternInfo"),
    DataExchangeTrimLeadingZerosFromExternalIds("tmtbl.data.exchange.trim.externalId"),
    DataExchangeIncludeDefaultDatePattern("tmtbl.export.defaultDatePattern"),
    DataExchangeIncludeMeetings("tmtbl.export.classMeetings"),
    DataExchangeIncludeStudentGroups("tmtbl.export.studentGroups"),
    DataExchangeXmlManager("unitime.xml.manager"),
    DataExchangeUpdateStudentConflictsFinal("tmtbl.data.import.studentEnrl.finalExam.updateConflicts"),
    DataExchangeUpdateStudentConflictsMidterm("tmtbl.data.import.studentEnrl.midtermExam.updateConflicts"),
    TimePatternEditableDuringInitialDataLoad("tmtbl.time_pattern.initial_data_load.editable"),
    BuildingsExternalUpdateExistingRooms("unitime.external.room.update.existing"),
    BuildingsExternalUpdateExistingRoomFeatures("unitime.external.room.update.existing.features"),
    BuildingsExternalUpdateExistingRoomDepartments("unitime.external.room.update.existing.departments"),
    BuildingsExternalUpdateClassification("unitime.external.room.update.classifications"),
    RoomSharingMode("unitime.room.sharingMode%"),
    OnlineSchedulingCheckDeadlines("unitime.enrollment.deadline"),
    OnlineSchedulingStudentNameFormat("unitime.enrollment.student.name"),
    OnlineSchedulingInstructorNameFormat("unitime.enrollment.instructor.name"),
    OnlineSchedulingStudentIdPattern("unitime.enrollment.student.externalIdPattern"),
    OnlineSchedulingDashboardSuggestionsOperationPattern("unitime.enrollment.suggestions.operationPattern"),
    OnlineSchedulingDashboardSuggestionsLogDays("unitime.enrollment.suggestions.sectioningLogDays"),
    OnlineSchedulingDashboardCreditFilterUseDatabase("unitime.enrollment.suggestions.creditFilterUseDatabase"),
    OnlineSchedulingEmailConfirmation("unitime.enrollment.email"),
    OnlineSchedulingEmailConfirmationWhenFailed("unitime.enrollment.email.failedWaitList"),
    OnlineSchedulingEmailConfirmationOverride("unitime.enrollment.email.%"),
    OnlineSchedulingEmailCCAdvisors("unitime.enrollment.email.%.ccAdvisors"),
    OnlineSchedulingEmailSkipOnErrorCodes("unitime.enrollment.email.skipOnErrorCodes"),
    OnlineSchedulingEmailSkipOnErrorMessage("unitime.enrollment.email.skipOnErrorMessage"),
    OnlineSchedulingGradableIType("unitime.enrollment.gradableITypes"),
    OnlineSchedulingAllowOverExpected("unitime.sectioning.allowOverExpected"),
    OnlineSchedulingLoggingEnabled("unitime.sectioning.log"),
    OnlineSchedulingLogLimit("unitime.sectioning.log.limit"),
    OnlineSchedulingLogFile("unitime.sectioning.log.file"),
    OnlineSchedulingLogOperation("unitime.sectioning.log.enabled.%"),
    OnlineSchedulingParameter("unitime.sectioning.config.%"),
    StudentSchedulingAlternativeCourse("unitime.sectioning.alternativeCourse"),
    OnlineSchedulingPublishHost("unitime.enrollment.publish.host"),
    RoomAvailabilityImplementation("tmtbl.room.availability.class"),
    RoomAvailabilityClassBreakTimeStart("tmtbl.room.availability.class.breakTime.start"),
    RoomAvailabilityClassBreakTimeStop("tmtbl.room.availability.class.breakTime.stop"),
    RoomAvailabilityMidtermExamType("tmtbl.room.availability.eventType.midtermExam"),
    RoomAvailabilityFinalExamType("tmtbl.room.availability.eventType.finalExam"),
    RoomAvailabilityClassType("tmtbl.room.availability.eventType.class"),
    RoomAvailabilityIncludeOtherTerms("tmtbl.room.availability.includeOtherTerms"),
    BlobRoomAvailabilityRequestSQL("tmtbl.room.availability.request"),
    BlobRoomAvailabilityResponseSQL("tmtbl.room.availability.response"),
    RoomAvailabilityIncludeInstructors("unitime.events.instructorUnavailability"),
    RoomAvailabilitySolverWaitForSync("tmtbl.room.availability.solver.waitForSync"),
    ClassNamingHelper("tmtbl.class.naming.helper"),
    MakeNotOfferedStaysOnDetail("unitime.offering.makeNotOfferedStaysOnDetail"),
    ConfigEditCheckLimits("unitime.instrOfferingConfig.checkConfigLimit"),
    ConfigEditDeleteTimePrefs("unitime.instrOfferingConfig.deleteIncompatibleTimePrefs"),
    SubpartCreditEditable("tmtbl.subpart.credit.editable"),
    InstructorExternalIdLookup("tmtbl.instructor.external_id.lookup.enabled"),
    InstructorExternalIdLookupClass("tmtbl.instructor.external_id.lookup.class"),
    ManagerExternalIdLookup("tmtbl.manager.external_id.lookup.enabled"),
    ManagerExternalIdLookupClass("tmtbl.manager.external_id.lookup.class"),
    ExternalActionClassEdit("tmtbl.external.class.edit_action.class"),
    ExternalActionInstrOfferingConfigAssignInstructors("tmtbl.external.instr_offr_config.assign_instructors_action.class"),
    ExternalActionCourseOfferingEdit("tmtbl.external.course_offering.edit_action.class"),
    ExternalActionInstructionalOfferingAdd("tmtbl.external.instr_offr.add_action.class"),
    ExternalActionCourseOfferingRemove("tmtbl.external.course_offering.remove_action.class"),
    ExternalActionInstructionalOfferingInCrosslistAdd("tmtbl.external.instr_offr_in_crosslist.add_action.class"),
    ExternalActionCourseCrosslist("tmtbl.external.instr_offr.crosslist_action.class"),
    ExternalActionInstrOffrConfigChange("tmtbl.external.instr_offr_config.change_action.class"),
    ExternalActionInstructionalOfferingDelete("tmtbl.external.instr_offr.delete_action.class"),
    ExternalActionInstructionalOfferingNotOffered("tmtbl.external.instr_offr.not_offered_action.class"),
    ExternalActionInstructionalOfferingOffered("tmtbl.external.instr_offr.offered_action.class"),
    ExternalActionSolutionCommit("tmtbl.external.solution.commit_action.class"),
    ExternalActionSchedulingSubpartEdit("tmtbl.external.sched_subpart.edit_action.class"),
    ExternalActionCourseOfferingReservationEdit("tmtbl.external.reservation.edit_action.class"),
    ExternalActionSectionMonitoredUpdateMessage("unitime.external.section_monitored_update_message.class"),
    ExternalVariableTitleDataLookup("unitime.external.variable_title_data_lookup.class"),
    ExternalCourseDepartmentCodeLookupSQL("unitime.external.course.department_code_lookup_sql"),
    ExternalUserIdTranslation("tmtbl.externalUid.translation"),
    CustomSQLUidToExternalTranslation("unitime.custom.sql.uid2ext"),
    CustomSQLExternalToUidTranslation("unitime.custom.sql.ext2uid"),
    DatabaseUpdateAddonClass("tmtbl.db.addon.update.class"),
    ExaminationReportsClassSufix("tmtbl.exam.report.suffix"),
    ExaminationsNoRoomText("tmtbl.exam.report.noroom"),
    ExaminationRoomCode("tmtbl.exam.report.roomcode"),
    ExaminationReportsExternalId("tmtbl.exam.report.external"),
    ExaminationReportsExternalIdName("tmtbl.exam.report.external.name"),
    ExaminationReportsShowInstructionalType("tmtbl.exam.report.itype"),
    ExaminationReportsStudentBackToBacks("tmtbl.exams.reports.student.btb"),
    ExaminationReportsInstructorBackToBacks("tmtbl.exams.reports.instructor.btb"),
    ExaminationPdfReportsCanUseSolution("tmtbl.exam.pdfReports.canUseSolution"),
    ExaminationPdfReportsPreloadCrosslistedExams("tmtbl.exam.pdfReports.useSolution.preloadCrosslistedExams"),
    ExaminationPdfReportsSkipSuffixSubpart("tmtbl.exam.report.verification.skipSuffixSubparts"),
    ExaminationPdfReportTitle("tmtbl.exam.report.%"),
    ExaminationPdfReportsIncludeClassSchedule("tmtbl.exam.report.cschedule"),
    ExaminationPdfReportsFullTermCheckDatePattern("tmtbl.exam.report.fullterm.checkdp"),
    ExaminationPdfReportsUseEventsForMeetingTimes("tmtbl.exam.report.meeting_time.use_events"),
    ExaminationReportsIncludeDifferentSubject("tmtbl.exam.report.differentSubjectSections"),
    ExaminationPeriodDefaultStartOffset("tmtbl.exam.defaultStartOffset.%"),
    ExaminationPeriodDefaultStopOffset("tmtbl.exam.defaultStopOffset.%"),
    ExaminationCacheConflicts("tmtbl.exams.conflicts.cache"),
    ExaminationTravelTimeClass("tmtbl.exam.eventConflicts.travelTime.classEvent"),
    ExaminationTravelTimeCourse("tmtbl.exam.eventConflicts.travelTime.courseEvent"),
    ExaminationSizeUseLimitInsteadOfEnrollment("tmtbl.exam.useLimit.%"),
    ExaminationConsiderEventConflicts("tmtbl.exam.eventConflicts.%"),
    ExaminationCreateSameRoomConstraints("tmtbl.exam.sameRoom.%"),
    ExaminationNameExpandCrossListedOfferingsToCourses("tmtbl.exam.name.expandCrosslistedOfferingToCourses"),
    ExamNameMaxLength("tmtbl.exam.name.maxLength"),
    ExamNameType("tmtbl.exam.name.type.%"),
    ExamNameSuffix("tmtbl.exam.name.suffix"),
    ExamNameSeparator("tmtbl.exam.name.diffSubject.separator"),
    ExamNameCourse("tmtbl.exam.name.Course"),
    ExamNameOffering("tmtbl.exam.name.Offering"),
    ExamNameConfig("tmtbl.exam.name.Config"),
    ExamNameClass("tmtbl.exam.name.Class"),
    ExamNameSameSubjectCourse("tmtbl.exam.name.sameSubject.Course"),
    ExamNameSameSubjectOffering("tmtbl.exam.name.sameSubject.Offering"),
    ExamNameSameSubjectConfig("tmtbl.exam.name.sameSubject.Config"),
    ExamNameSameSubjectClass("tmtbl.exam.name.sameSubject.Class"),
    ExamNameSameCourseConfig("tmtbl.exam.name.sameCourse.Config"),
    ExamNameSameCourseClass("tmtbl.exam.name.sameCourse.Class"),
    ExamNameSameSubpartClass("tmtbl.exam.name.sameSubpart.Class"),
    ExamDefaultsEveningClassPreference("tmtbl.exam.defaultPrefs.%.eveningClasses.pref"),
    ExamDefaultsEveningClassStart("tmtbl.exam.defaultPrefs.%.eveningClasses.firstEveningPeriod"),
    ExamDefaultsOriginalRoomPreference("tmtbl.exam.defaultPrefs.%.originalRoom.pref"),
    ExamDefaultsOriginalBuildingPreference("tmtbl.exam.defaultPrefs.%.originalBuilding.pref"),
    ExamDefaultsOriginalBuildingOnlyForExamRooms("tmtbl.exam.defaultPrefs.%.originalBuilding.onlyForExaminationRooms"),
    CustomizationCourseDetails("unitime.custom.CourseDetailsProvider"),
    CustomizationCourseLink("unitime.custom.CourseUrlProvider"),
    CustomizationStudentEnrollments("unitime.custom.StudentEnrollmentProvider"),
    CustomizationCourseRequests("unitime.custom.CourseRequestsProvider"),
    CustomizationCriticalCourses("unitime.custom.CriticalCoursesProvider"),
    CustomizationCourseLookup("unitime.custom.CustomCourseLookup"),
    CustomizationCourseRequestsValidation("unitime.custom.CourseRequestsValidationProvider"),
    CustomizationAdvisorsCourseRequestsValidation("unitime.custom.AdvisorCourseRequestsValidationProvider"),
    CustomizationDegreePlans("unitime.custom.DegreePlansProvider"),
    CustomizationSpecialRegistration("unitime.custom.SpecialRegistrationProvider"),
    CustomizationSpecialRegistrationDashboardUrl("unitime.custom.SpecialRegistrationDashboardUrlProvider"),
    CustomizationOnlineSectioningActionFactory("unitime.custom.OnlineSectioningActionFactory"),
    CustomOnlineSchedulingAction("unitime.custom.action.%"),
    CustomizationExternalTerm("unitime.custom.ExternalTermProvider"),
    CustomizationExternalClassLookup("unitime.custom.ExternalClassLookup"),
    CustomizationVariableTitleCourseProvider("unitime.custom.VariableTitleCourseProvider"),
    CustomizationWaitListValidationProvider("unitime.custom.WaitListValidationProvider"),
    CustomizationWaitListComparatorProvider("unitime.custom.WaitListComparatorProvider"),
    CourseCatalogLinkProvider("tmtbl.catalogLink.lookup.class"),
    CustomizationStudentEmail("unitime.custom.StudentEmailProvider"),
    CustomizationCustomClassAttendance("unitime.custom.CustomClassAttendanceProvider"),
    CustomizationStudentHoldsCheck("unitime.custom.StudentHoldsCheckProvider"),
    CurriculumConvertNamesToInitialCase("tmtbl.toInitialCase.curriculum"),
    CurriculumLastLikeDemandsTotalShareLimit("tmtbl.curriculum.lldemands.totalShareLimit"),
    CurriculumLastLikeDemandsShareLimit("tmtbl.curriculum.lldemands.shareLimit"),
    CurriculumLastLikeDemandsEnrollmentLimit("tmtbl.curriculum.lldemands.enrlLimit"),
    EventTooEarlySlot("unitime.event.tooEarly"),
    EventExpirationServiceUpdateInterval("unitime.events.expiration.updateIntervalInMinutes"),
    EventFilterSkipConflictCounts("unitime.events.eventFilter.skipConflictCounts"),
    EventFilterSkipMostCounts("unitime.events.eventFilter.skipCounts"),
    RoomFilterFasterCounts("unitime.events.roomFilter.fasterCounts"),
    EventRoomTimetableAllRooms("unitime.event_timetable.event_rooms_only"),
    EventGridDisplayTitle("unitime.events.grid_display_title"),
    EventGridStartDay("unitime.events.gridStartDay"),
    EventCalendarDisplayInstructorsInDescription("unitime.events.ics_instructors_in_description"),
    EventCalendarDisplayNoteInDescription("unitime.events.ics_note_in_description"),
    EventCalendarSetOrganizer("unitime.events.ics_set_organizer"),
    EventHasRoleCheckReportStatus("unitime.events.hasRole.checkSessionStatusForClasses"),
    EventExamsConsiderClassInstructorAssignments("unitime.events.exams.considerClassInstructors"),
    EventGridShowRoomNote("unitime.events.roomGrid.showRoomNote"),
    EventCourseEventsDefaultStudentAttendance("unitime.events.courseEventDefaultStudentAttendance"),
    EventExpectedAttendanceRequired("unitime.events.expectedAttendanceRequired"),
    EventSponsoringOrgRequired("unitime.events.sponsoringOrgRequired"),
    EventPersonalConsiderAdditionalEmails("unitime.events.personal.considerAdditionalEmails"),
    EmailProvider("unitime.email.class"),
    EmailSmtpHost("mail.smtp.host"),
    EmailSmtpPort("mail.smtp.port"),
    EmailSmtpUser("mail.smtp.user"),
    EmailSmtpPassword("mail.smtp.password"),
    EmailSmtpSSL("mail.smtp.ssl.enable"),
    EmailSenderAddress("unitime.email.sender"),
    EmailSenderName("unitime.email.sender.name"),
    EmailReplyToAddress("unitime.email.replyto"),
    EmailReplyToName("unitime.email.replyto.name"),
    EmailNotificationAddress("unitime.email.notif"),
    EmailNotificationAddressName("unitime.email.notif.name"),
    EmailNotificationSolutionCommits("unitime.email.notif.commit"),
    EmailNotificationErrorReports("unitime.email.notif.error"),
    EmailNotificationDataExchange("unitime.email.notif.data"),
    EmailInquiryAddress("unitime.email.inquiry"),
    EmailInquiryAddressName("unitime.email.inquiry.name"),
    EmailInquiryAddressSuffix("unitime.email.inquiry.suffix"),
    EmailInquiryAutoreply("unitime.email.inquiry.autoreply"),
    EmailConfirmationEvents("unitime.email.confirm.event"),
    EmailConfirmationEventsDefault("unitime.email.confirm.default"),
    EmailConfirmationEventInstructors("unitime.email.event.instructor"),
    EmailConfirmationEventCoordinators("unitime.email.event.coordinator"),
    EmailConfirmationEventManagers("unitime.email.event.managers"),
    EmailDefaultAddressSuffix("unitime.email.event.suffix"),
    EmailConfirmationIncludeCalendar("unitime.email.event.calendar"),
    InboundEmailsEnabled("unitime.email.inbound.enabled"),
    InboundEmailsAddress("unitime.email.inbound.uri"),
    InboundEmailsReplyToAddress("unitime.email.inbound.address"),
    InboundEmailsReplyToAddressName("unitime.email.inbound.name"),
    JGroupsBindAddress("jgroups.bind_addr"),
    HibernateClusterEnabled("unitime.hibernate.cluster"),
    HibernateCacheConfiguration("unitime.hibernate.cache.config"),
    HibernateClusterConfiguration("unitime.hibernate.jgroups.config"),
    HibernateClusterPort("unitime.hibernate.port"),
    HibernateClusterInitialHosts("unitime.hibernate.initial_hosts"),
    OnlineSchedulingClusterForkChannel("unitime.enrollment.jgroups.fork_channel"),
    OnlineSchedulingClusterConfiguration("unitime.enrollment.jgroups.config"),
    OnlineSchedulingClusterPort("unitime.enrollment.port"),
    OnlineSchedulingClusterInitialHosts("unitime.enrollment.initial_hosts"),
    SolverClusterEnabled("unitime.solver.cluster"),
    SolverClusterConfiguration("unitime.solver.jgroups.config"),
    SolverClusterPort("unitime.solver.port"),
    SolverClusterInitialHosts("unitime.solver.initial_hosts"),
    SolverClusterTimeout("unitime.solver.timeout"),
    TestHQLMaxLines("tmtbl.test_hql.max_line"),
    QueryLogLimit("unitime.query.log.limit"),
    QueryLogJSON("unitime.query.log.json"),
    PreferencesHierarchicalInheritance("unitime.preferences.hierarchicalInheritance"),
    PreferencesHighlighClassPreferences("unitime.preferences.highlightClassPrefs"),
    SessionNrExcessDays("unitime.session.nrExcessDays"),
    SessionDefaultShiftDays("unitime.session.defaultSessionShiftDays"),
    DatePatternNrExessMonth("unitime.pattern.nrExcessMoths"),
    DatePatternFormatUseDates("unitime.pattern.format.useDates"),
    DatePatternShowMakeDefault("unitime.pattern.showMakeDefault"),
    PeopleLookupLimit("tmtbl.lookup.limit"),
    PeopleLookupLdapUrl("tmtbl.lookup.ldap"),
    PeopleLookupLdapBase("tmtbl.lookup.ldap.name"),
    PeopleLookupLdapUser("tmtbl.lookup.ldap.user"),
    PeopleLookupLdapPassword("tmtbl.lookup.ldap.password"),
    PeopleLookupLdapReferral("tmtbl.lookup.ldap.referral"),
    PeopleLookupLdapLimit("tmtbl.lookup.ldap.countLimit"),
    PeopleLookupLdapSearchSubtree("tmtbl.lookup.ldap.searchSubtree"),
    PeopleLookupLdapQuery("tmtbl.lookup.ldap.query"),
    PeopleLookupLdapUidAttribute("tmtbl.lookup.ldap.uid"),
    PeopleLookupLdapCnAttribute("tmtbl.lookup.ldap.cn"),
    PeopleLookupLdapSnAttribute("tmtbl.lookup.ldap.sn"),
    PeopleLookupLdapGivenNameAttribute("tmtbl.lookup.ldap.givenName"),
    PeopleLookupLdapEmailAttribute("tmtbl.lookup.ldap.email"),
    PeopleLookupLdapSkipWithoutEmail("tmtbl.lookup.ldap.skipWhenNoEmail"),
    PeopleLookupLdapPhoneAttribute("tmtbl.lookup.ldap.phone"),
    PeopleLookupLdapDepartmentAttribute("tmtbl.lookup.ldap.department"),
    PeopleLookupLdapPositionAttribute("tmtbl.lookup.ldap.position"),
    PeopleLookupLdapAcademicTitleAttribute("tmtbl.lookup.ldap.title"),
    PeopleLookupDefaultSources("unitime.lookup.source.defaults"),
    PeopleLookupInstructorsPreferStaffDept("unitime.lookup.instructors.checkStaffDept"),
    PeopleLookupShowEmail("unitime.lookup.showEmail.%"),
    ReservationExpirationDateGlobal("unitime.reservations.expiration_date"),
    ReservationExpirationDate("unitime.reservations.%.expiration_date"),
    ReservationExpirationInDaysGlobal("unitime.reservations.expires_in_days"),
    ReservationExpirationInDays("unitime.reservations.%.expires_in_days"),
    ReservationStartDateGlobal("unitime.reservations.start_date"),
    ReservationStartDate("unitime.reservations.%.start_date"),
    ReservationStartInDaysGlobal("unitime.reservations.expires_in_days"),
    ReservationStartInDays("unitime.reservations.%.expires_in_days"),
    RoomMapStatic("unitime.minimap.url"),
    RoomHintMinimapUrl("unitime.minimap.hint"),
    RoomMapStaticApiKey("unitime.minimap.apikey"),
    RoomMapStaticSecret("unitime.minimap.secret"),
    RoomUseGoogleMap("unitime.coordinates.googlemap"),
    GoogleMapsApiKey("unitime.coordinates.googlemap.apikey"),
    RoomUseLeafletMap("unitime.coordinates.leafletmap"),
    RoomCacheLeafletMapTiles("unitime.coordinates.leafletmap.cacheTiles"),
    RoomUseLeafletMapTiles("unitime.coordinates.leafletmap.tilesUrl"),
    RoomUseLeafletMapAttribution("unitime.coordinates.leafletmap.tilesAttribution"),
    RoomGeocodeSearch("unitime.coordinates.geocode.search"),
    RoomGeocodeReverse("unitime.coordinates.geocode.reverse"),
    RoomHintShowBreakTime("unitime.roomHint.showBreakTime"),
    LastChangesLimit("unitime.changelog.limit"),
    SolverXMLExportNames("unitime.solution.export.names"),
    SolverXMLExportConvertIds("unitime.solution.export.id-conv"),
    SolverXMLExportConfiguration("unitime.solution.export.configuration"),
    SolverPasivationTime("unitime.solver.passivation.time"),
    OnlineSchedulingQueueLoadInterval("unitime.sectioning.queue.loadInterval"),
    OnlineSchedulingQueueUpdateInterval("unitime.sectioning.queue.updateInterval"),
    OnlineSchedulingAcademicYear("unitime.enrollment.year"),
    OnlineSchedulingAcademicTerm("unitime.enrollment.term"),
    OnlineSchedulingAcademicCampus("unitime.enrollment.campus"),
    OnlineSchedulingServerClass("unitime.enrollment.server.class"),
    OnlineSchedulingServerAsyncPoolSize("unitime.enrollment.server.asyncPoolSize"),
    LogCleanupChangeLog("unitime.cleanup.changeLog"),
    LogCleanupQueryLog("unitime.cleanup.queryLog"),
    LogCleanupOnlineSchedulingLog("unitime.cleanup.sectioningLog"),
    LogCleanupMessageLog("unitime.message.log.cleanup.days"),
    LogCleanupOnlineSchedulingQueue("unitime.cleanup.sectioningQueue"),
    LogCleanupHashedQueries("unitime.cleanup.hashedQueries"),
    LogCleanupSectioningSolutionLog("unitime.cleanup.publishedSolutions"),
    MessageLogLevel("unitime.message.log.level"),
    MessageLogLimit("unitime.message.log.limit"),
    MessageLogCleanupInterval("unitime.message.log.cleanup.interval"),
    PdfFontNormal("unitime.pdf.font"),
    PdfFontItalic("unitime.pdf.font.italic"),
    PdfFontBold("unitime.pdf.font.bold"),
    PdfFontBoldItalic("unitime.pdf.font.bolditalic"),
    PdfFontFixed("unitime.pdf.font.fixed"),
    PdfFontSizeSmall("unitime.pdf.fontsize.small"),
    PdfFontSizeNormal("unitime.pdf.fontsize.normal"),
    PdfFontSizeFixed("unitime.pdf.fontsize.fixed"),
    PdfFontSizeBig("unitime.pdf.fontsize.big"),
    PdfFontSizeExams("unitime.pdf.fontsize.exams"),
    PdfFontCache("unitime.pdf.fontcache"),
    WorksheetPdfEnabled("tmtbl.pdf.worksheet"),
    WorksheetPdfUseCommittedAssignments("tmtbl.pdf.worksheet.useCommitedAssignments"),
    WorksheetPdfAuthor("tmtbl.pdf.worksheet.author"),
    WorksheetPdfTitle("tmtbl.pdf.worksheet.title"),
    TimetableGridSlotsPerPeriod("tmtbl.timeGrid.slotsPerPeriod"),
    TimetableGridFirstDaySlot("tmtbl.timeGrid.firstDaySlot"),
    TimetableGridLastDaySlot("tmtbl.timeGrid.lastDaySlot"),
    TimetableGridLastEveningSlot("tmtbl.timeGrid.lastEveningSlot"),
    TimetableGridMaxCellWidth("tmtbl.timeGrid.maxCellWidth"),
    TimetableGridMaxCellWidthVertical("tmtbl.timeGrid.maxCellWidthVertical"),
    TimetableGridUseClassInstructors("tmtbl.timeGrid.useClassInstructors"),
    TimetableGridUseClassInstructorsCheckClassDisplayInstructors("tmtbl.timeGrid.useClassInstructors.checkDisplayInstructor"),
    TimetableGridUseClassInstructorsCheckLead("tmtbl.timeGrid.useClassInstructors.checkConflicts"),
    TimetableGridUseClassInstructorsHideAuxiliary("tmtbl.timeGrid.useClassInstructors.hideAuxiliary"),
    TimetableGridUtilizationSkipHolidays("tmtbl.timeGrid.utilizationSkipHolidays"),
    ContactUsAddress("tmtbl.contact.address"),
    ContactUsPhone("tmtbl.contact.phone"),
    ContactUsOfficeHours("tmtbl.contact.office_hours"),
    ContactUsEmail("tmtbl.contact.email"),
    ContactUsMailTo("tmtbl.contact.email_mailto"),
    ApplicationConfigPattern("tmtbl.appConfig.pattern"),
    EventAllowEditPast("tmtbl.event.allowEditPast"),
    ExamsLoginMessage("tmtbl.exams.login.message"),
    HelpFAQ("tmtbl.help.faq"),
    ManualEvents("tmtbl.help.manual.events"),
    ManualEventsAdmin("tmtbl.help.manual.events_admin"),
    ManualCourseDataEntry("tmtbl.help.manual.input_data"),
    ManualCourseSolver("tmtbl.help.manual.solver"),
    ManualInstructorScheduling("tmtbl.help.manual.instructorScheduling"),
    ManualAdministration("tmtbl.help.manual.administration"),
    ManualOtherDocumentation("tmtbl.help.manual.other"),
    ManualSchedulingAssistant("tmtbl.help.manual.schedulingAssistant"),
    ManualCourseRequests("tmtbl.help.manual.courseRequests"),
    ManualSchedulinDashboard("tmtbl.help.manual.schedulingDashboard"),
    ManualExaminationTimetabling("tmtbl.help.manual.exams"),
    ManualStudentScheduling("tmtbl.help.manual.students"),
    HelpReleaseNotes("tmtbl.help.release_notes"),
    HelpMain("tmtbl.help.root"),
    HelpTricks("tmtbl.help.tricks"),
    RollForwardAllowClassPreferences("unitime.rollforward.allowClassPrefs"),
    RollForwardResetClassSuffix("unitime.rollforward.resetClassSufix"),
    ChromeFrameWarning("unitime.warn.chromeframe"),
    LoggingLevel("log4j.logger.%"),
    InstructorAllowEditExternalId("tmtbl.instructor.allowExternalIdEdit"),
    SessionBackupInterface("unitime.session_backup.class"),
    SessionBackupAvoid("unitime.session_backup.avoid"),
    SessionBackupDisallowed("unitime.session_backup.disallowed"),
    SessionRestoreInterface("unitime.session_restore.class"),
    CustomizationDefaultCourseUrl("unitime.custom.default.course_url"),
    CustomizationDefaultCourseDetailsDownload("unitime.custom.default.course_download"),
    CustomizationDefaultCourseDetailsContent("unitime.custom.default.course_regexp"),
    CustomizationDefaultCourseDetailsModifiers("unitime.custom.default.course_modifiers"),
    SchedulingSubpartAutoSpreadInTimeDefault("unitime.defaults.subpartSpreadInTime"),
    SchedulingSubpartStudentOverlapsDefault("unitime.defaults.subpartStudentOverlaps"),
    ReservationPriorityIndividual("unitime.reservation.priority.individual"),
    ReservationPriorityGroup("unitime.reservation.priority.group"),
    ReservationPriorityLearningCommunity("unitime.reservation.priority.learningCommunity"),
    ReservationPriorityOverride("unitime.reservation.priority.override"),
    ReservationPriorityCourse("unitime.reservation.priority.course"),
    ReservationPriorityCurriculum("unitime.reservation.priority.curriculum"),
    ReservationPriorityDummy("unitime.reservation.priority.dummy"),
    ReservationMustBeUsedIndividual("unitime.reservation.mustBeUsed.individual"),
    ReservationMustBeUsedGroup("unitime.reservation.mustBeUsed.group"),
    ReservationMustBeUsedLearningCommunity("unitime.reservation.mustBeUsed.learningCommunity"),
    ReservationMustBeUsedCourse("unitime.reservation.mustBeUsed.course"),
    ReservationMustBeUsedCurriculum("unitime.reservation.mustBeUsed.curriculum"),
    ReservationCanOverLimitIndividual("unitime.reservation.canOverLimit.individual"),
    ReservationCanOverLimitGroup("unitime.reservation.canOverLimit.group"),
    ReservationCanOverLimitLearningCommunity("unitime.reservation.canOverLimit.learningCommunity"),
    ReservationCanOverLimitCourse("unitime.reservation.canOverLimit.course"),
    ReservationCanOverLimitCurriculum("unitime.reservation.canOverLimit.curriculum"),
    ReservationAllowOverlapIndividual("unitime.reservation.allowOverlap.individual"),
    ReservationAllowOverlapGroup("unitime.reservation.allowOverlap.group"),
    ReservationAllowOverlapLearningCommunity("unitime.reservation.allowOverlap.learningCommunity"),
    ReservationAllowOverlapCourse("unitime.reservation.allowOverlap.course"),
    ReservationAllowOverlapCurriculum("unitime.reservation.allowOverlap.curriculum"),
    AuthenticationCasIdAttribute("unitime.authentication.cas.id-attribute"),
    AuthenticationCasIdAlwaysTranslate("unitime.authentication.cas.id-translate"),
    AuthenticationCasIdTrimLeadingZerosFrom("unitime.authentication.cas.id-trim"),
    AuthenticationCasNameAttribute("unitime.authentication.cas.name-attribute"),
    ConflictStatisticsSaveToFile("unitime.cbs.saveToFile"),
    CustomizationCourseMatcher("unitime.custom.CourseMatcherProvider"),
    OnlineSchedulingCustomEligibilityRecheck("unitime.enrollment.recheckCustomEligibility"),
    OnlineSchedulingEmailTemplate("unitime.enrollment.email.teplate"),
    OnlineSchedulingEmailPlainTextTemplate("unitime.enrollment.email.plainTextTemplate"),
    OnlineSchedulingEmailPlainText("unitime.enrollment.email.plainText"),
    OnlineSchedulingEmailICalendar("unitime.enrollment.email.ics"),
    OnlineSchedulingEmailIncludeImage("unitime.enrollment.email.grid"),
    OnlineSchedulingEmailIncludeMessage("unitime.enrollment.email.message"),
    OnlineSchedulingEmailCarbonCopy("unitime.enrollment.email.cc"),
    OnlineSchedulingAllowScheduleReset("unitime.enrollment.allowScheduleReset"),
    OnlineSchedulingAllowScheduleResetIfAdmin("unitime.enrollment.allowScheduleReset.manager"),
    OnlineSchedulingConfirmCourseDrop("unitime.enrollment.confirmCourseDrop"),
    OnlineSchedulingMakeAssignedRequestReadOnly("unitime.enrollment.disableAssignedRequests"),
    OnlineSchedulingMakeAssignedRequestReadOnlyIfAdmin("unitime.enrollment.disableAssignedRequests.manager"),
    OnlineSchedulingMakeReservedRequestReadOnly("unitime.enrollment.disableReservedRequests"),
    OnlineSchedulingMakeReservedRequestReadOnlyIfAdmin("unitime.enrollment.disableReservedRequests.manager"),
    OnlineSchedulingReservedRequestNoAlternativeChanges("unitime.enrollment.disableReservedRequests.noAlternativeChanges"),
    OnlineSchedulingAssignedRequestNoAlternativeChanges("unitime.enrollment.disableAssignedRequests.noAlternativeChanges"),
    OnlineSchedulingReservedRequestNoPriorityChanges("unitime.enrollment.disableReservedRequests.noPriorityChanges"),
    OnlineSchedulingAssignedRequestNoPriorityChanges("unitime.enrollment.disableAssignedRequests.noPriorityChanges"),
    OnlineSchedulingMakeUnassignedRequestsInactive("unitime.enrollment.inactiveUnassignedRequests"),
    OnlineSchedulingMakeUnassignedRequestsInactiveIfAdmin("unitime.enrollment.inactiveUnassignedRequests.manager"),
    OnlineSchedulingQuickAddDrop("unitime.enrollment.quickAddDrop"),
    OnlineSchedulingAlternativesDrop("unitime.enrollment.alternativesDrop"),
    OnlineSchedulingGWTConfirmations("unitime.enrollment.gwtConfirmations"),
    OnlineSchedulingNoRequestArrows("unitime.enrollment.hideCourseRequestArrows"),
    OnlineSchedulingStudentPreferencesEnabled("unitime.enrollment.studentPrefs.enabled"),
    OnlineSchedulingStudentPreferencesDatesAllowed("unitime.enrollment.studentPrefs.datesAllowed"),
    OnlineSchedulingStudentPreferencesNote("unitime.enrollment.studentPrefs.customNote"),
    OnlineSchedulingStudentPreferencesReqOnlineAllowed("unitime.enrollment.studentPrefs.reqOnlineAllowed"),
    SolverDashboardAllowScheduleReset("unitime.solverDashboard.allowScheduleReset"),
    DistributionsShowClassSufix("unitime.distributions.showClassSuffixes"),
    ReservationsShowClassSufix("unitime.reservations.showClassSuffixes"),
    InstructorShowClassSufix("unitime.instructor.showClassSuffixes"),
    ReservationsAreInclusive("unitime.reservations.restrictionsInclusive"),
    SolverShowClassSufix("unitime.solver.showClassSuffixes"),
    SolverShowConfiguratioName("unitime.solver.showConfigurationNames"),
    ApiCanUseAPIToken("unitime.api.canUseToken"),
    ApiCacheMode("unitime.api.%.cacheMode"),
    ApiTrimLeadingZerosFromUserExternalIds("unitime.api.user.id-trim"),
    StudentGroupsTimetableMinimalEnrollment("unitime.events.group.minimalEnrollment"),
    StudentGroupsTimetableGroupEnrollments("unitime.events.group.showGroupEnrollment"),
    LegacyPeriodPreferences("unitime.legacy.periodPrefs"),
    SubpartMaxNumClasses("unitime.subpart.max_num_classes"),
    ChameleonAllowLookup("unitime.chameleon.lookup"),
    StandardClassMeetingLengthInMinutes("unitime.pointInTimeData.standardClassMeetingLengthInMinutes"),
    StandardMinutesInReportingHour("unitime.pointInTimeData.standardMinutesInReportingHour"),
    StandardWeeksInReportingTerm("unitime.pointInTimeData.standardWeeksInReportingTerm"),
    ReportsStartOnTheHalfHour("unitime.pointInTimeData.hourlyReportsStartOnTheHalfHour"),
    OfferingShowClassNotes("unitime.offering.showClassNotes"),
    TimeGridDays("unitime.timeGrid.days%"),
    TimeGridTimes("unitime.timeGrid.times%"),
    TimeGridShowCrosslists("unitime.timeGrid.crossList"),
    TimeGridFixInstructors("unitime.timeGrid.fixInstructors"),
    TimeGridFirstDayOfWeek("unitime.timeGrid.startDay"),
    TimeGridShowNameInTwoLines("unitime.timeGrid.classNameTwoLines"),
    TimeGridShowAllCommitted("unitime.timeGrid.showAllCommitted"),
    TimeGridShowClassesAcrossPartitions("unitime.timeGrid.classesAcrossPartitions"),
    TimeGridClassFilter("unitime.timeGrid.classFilter"),
    TimeGridRoomFilter("unitime.timeGrid.roomFilter"),
    ListSessionsReverse("unitime.events.listSessionsLatestFirst"),
    SessionBackupPointInTime("unitime.session_backup.pointInTimeData"),
    MaxSubjectsToSearchAutomatically("unitime.auto_search.maxSubjects"),
    TimePatternFirstDayOfWeek("unitime.timePattern.firstDayOfWeek"),
    ClassSuffixDivSecFormat("unitime.class.classSuffix.divSecDivider"),
    AuthorizationAdvisorMustHaveStudents("unitime.authorization.advisor.mustHaveStudents"),
    ModifyCrossListKeepCourseRequests("unitime.crossList.keepCourseRequests"),
    ModifyCrossListSingleCourseLimit("unitime.crossList.singleCourseLimit"),
    CourseRequestsShowNotOffered("unitime.courseRequests.showNotOffered"),
    CalendarVTimeZoneID("unitime.calendar.timezone.%"),
    CalendarVTimeZone("unitime.calendar.timezone"),
    TimeGridXLSRowHeight("unitime.timeGrid.xls.rowHeight"),
    TimeGridXLSHeaderWidth("unitime.timeGrid.xls.headerWidth"),
    TimeGridXLSCellWidth("unitime.timeGrid.xls.horizontalCellWidth"),
    TimeGridXLSCellWidthVertical("unitime.timeGrid.xls.verticalCellWidth"),
    TimeGridXLSFontSize("unitime.timeGrid.xls.fontSize"),
    TimeGridXLSFontName("unitime.timeGrid.xls.fontName"),
    TaskSchedulerCheckIntervalInMinutes("unitime.taskScheduler.checkIntervalInMinutes"),
    TaskSchedulerEnabled("unitime.taskScheduler.enabled"),
    ReservationLockCheckWaitList("unitime.reservation.lockingCheckWaitList"),
    ListCourseOfferingsSelectionMode("unitime.enrollment.listOfferings.selectionMode"),
    ListCourseOfferingsSelectionRandomize("unitime.enrollment.listOfferings.rouletteWheel"),
    ListCourseOfferingsSelectionLimit("unitime.enrollment.listOfferings.limit"),
    ListCourseOfferingsMatchingCampusFirst("unitime.enrollment.listOfferings.campusFirst"),
    StudentStatusEffectivePeriodMessage("unitime.enrollment.studentStatus.timeWindowMessage"),
    StudentSchedulingUseDefaultSession("unitime.studentScheduling.useDefaultSession"),
    StudentSchedulingPreferCourseRequests("unitime.studentScheduling.preferCourseRequests"),
    EnrollmentCheckCritical("unitime.enrollment.checkCritical"),
    AdvisorCourseRequestsPDFLogo("unitime.acrf.pdflogo"),
    AdvisorCourseRequestsPDFDisclaimer("unitime.acrf.pdfdisclaimer"),
    AdvisorCourseRequestsDefaultNote("unitime.acrf.note"),
    AdvisorCourseRequestsLastNotes("unitime.acrf.lastNotes"),
    AdvisorCourseRequestsPrepopulateCourseRequests("unitime.acrf.prepopulate.courseRequests"),
    AdvisorCourseRequestsPrepopulateSchedulingAssistant("unitime.acrf.prepopulate.schedulingAssistant"),
    AdvisorCourseRequestsRestrictedStatusChange("unitime.acrf.restrictedStatusChange"),
    PopupMessageCourseRequestsPrepopulatedWithAdvisorRecommendations("unitime.acrf.showingRecommendationsPopup"),
    AdvisorCourseRequestsAllowCritical("unitime.acrf.setCriticalCourses"),
    InstructorUnavailbeDays("tmtbl.instructor.unavaibleDates"),
    AdminStudentGroupsLazyStudents("unitime.admin.studentGroups.lazyLoad"),
    AdvisorRecommendationsWaitListMode("unitime.acr.waitlist"),
    ExamEventAllocatedTimeBasedExamLength("unitime.examEvent.allocatesTimeBasedExamLength.%"),
    AcademicSessionLookupImplementation("unitime.session.lookup.class"),
    VariableTitleConfigName("unitime.variableTitle.configName"),
    VariableTitleInstructionalType("unitime.variableTitle.instructionalType"),
    VariableTitleDatePatternPrefix("unitime.variableTitle.datePatternPrefix"),
    VariableTitleDefaultConsentType("unitime.variableTitle.defaultConsentType"),
    VariableTitleDefaultCourseCreditType("unitime.variableTitle.defaultCourseCreditType"),
    VariableTitleDefaultCourseCreditUnitType("unitime.variableTitle.defaultCourseCreditUnitType"),
    VariableTitleDefaultLimit("unitime.variableTitle.defaultLimit"),
    VariableTitleCourseSuffixDefaultStartCharacter("unitime.variableTitle.courseSuffixDefaultStartCharacter"),
    VariableTitleExternalSystemWaitTime("unitime.variableTitle.defaultExternalSystemWaitTime"),
    VariableTitleInstructorIdRequired("unitime.variableTitle.instructorIdRequired"),
    VariableTitleTitleFirstCharsOfWordsUpperCase("unitime.variableTitle.title.firstUpperCase"),
    CourseTimetablingCommitSkipChecking("unitime.commit.skipConflictChecking"),
    OfferingWaitListDefault("unitime.offering.waitListDefault"),
    OfferingWaitListProhibitedOverride("unitime.offering.waitList.prohibitedOverride"),
    OfferingWaitListShowFilter("unitime.offering.waitListFilter"),
    OnlineSchedulingShowWaitListPosition("unitime.enrollment.waitList.showWaitListPosition"),
    FailedWaitListDelayInSeconds("unitime.enrollment.waitList.failedWaitListsDelay"),
    OnlineSchedulingReloadAfterMerge("unitime.sectioning.reloadAfterMerge"),
    WaitListLogging("unitime.enrollment.waitList.logging"),
    WaitListCanChangeInstructionalMethod("unitime.offering.waitList.canChangeInstructionalMethod"),
    WaitListCanChangeDatePattern("unitime.offering.waitList.canChangeDatePattern"),
    PermissionCourseOfferingAllowsExternalEdit("unitime.permissions.courseOfferingAllowExternalEdits"),
    CoursesFundingDepartmentsEnabled("unitime.courses.funding_departments_enabled"),
    LegacyCourseAssignInstructors("unitime.legacy.course.assign_instructors"),
    LegacyCourseEdit("unitime.legacy.course_edit"),
    LegacyClassSetup("unitime.legacy.course.multiple_class_setup"),
    LegacyInstrOfferingConfig("unitime.legacy.course.instr_offering_config"),
    ClearPreferencesWhenManagingDepartmentIsChanged("unitime.legacy.course.clear_preferences"),
    LegacyDepartments("unitime.legacy.admin.departments"),
    LegacySubjectAreas("unitime.legacy.admin.subjectAreas"),
    ManageSolversComputeMemoryUses("unitime.solvers.memory"),
    DegreePlanForStudents("unitime.degreePlan.students"),
    DegreePlanForAdvisors("unitime.degreePlan.advisors"),
    InstructorsDropdownFollowNameFormatting("unitime.instructors.useNameFormatInDropdowns"),
    InstructorSurveyTimePreferences("unitime.instructorSurvey.timePrefs"),
    InstructorSurveyRoomPreferences("unitime.instructorSurvey.roomPrefs"),
    InstructorSurveyBuildingPreferences("unitime.instructorSurvey.buildingPrefs"),
    InstructorSurveyRoomFeaturePreferences("unitime.instructorSurvey.roomFeaturePrefs"),
    InstructorSurveyRoomGroupPreferences("unitime.instructorSurvey.roomGroupPrefs"),
    InstructorSurveyTimePreferencesDept("unitime.instructorSurvey.timePrefs.%"),
    InstructorSurveyRoomPreferencesDept("unitime.instructorSurvey.roomPrefs.%"),
    InstructorSurveyBuildingPreferencesDept("unitime.instructorSurvey.buildingPrefs.%"),
    InstructorSurveyRoomFeaturePreferencesDept("unitime.instructorSurvey.roomFeaturePrefs.%"),
    InstructorSurveyRoomGroupPreferencesDept("unitime.instructorSurvey.roomGroupPrefs.%"),
    InstructorSurveyTimePreferencesHard("unitime.instructorSurvey.timePrefsHard"),
    InstructorSurveyRoomPreferencesHard("unitime.instructorSurvey.roomPrefsHard"),
    InstructorSurveyBuildingPreferencesHard("unitime.instructorSurvey.buildingPrefsHard"),
    InstructorSurveyRoomFeaturePreferencesHard("unitime.instructorSurvey.roomFeaturePrefsHard"),
    InstructorSurveyRoomGroupPreferencesHard("unitime.instructorSurvey.roomGroupPrefsHard"),
    InstructorSurveyTimePreferencesDeptHard("unitime.instructorSurvey.timePrefsHard.%"),
    InstructorSurveyRoomPreferencesDeptHard("unitime.instructorSurvey.roomPrefsHard.%"),
    InstructorSurveyBuildingPreferencesDeptHard("unitime.instructorSurvey.buildingPrefsHard.%"),
    InstructorSurveyRoomFeaturePreferencesDeptHard("unitime.instructorSurvey.roomFeaturePrefsHard.%"),
    InstructorSurveyRoomGroupPreferencesDeptHard("unitime.instructorSurvey.roomGroupPrefsHard.%"),
    InstructorSurveyDistributionPreferences("unitime.instructorSurvey.distPrefs"),
    InstructorSurveyDistributionPreferencesDept("unitime.instructorSurvey.distPrefs.%"),
    InstructorSurveyDistributionPreferencesHard("unitime.instructorSurvey.distPrefsHard"),
    InstructorSurveyDistributionPreferencesDeptHard("unitime.instructorSurvey.distPrefsHard.%"),
    InstructorSurveyEmailConfirmation("unitime.instructorSurvey.emailConfirmation"),
    InstructorSurveyExcludeAuxiliaryAssignments("unitime.instructorSurvey.excludeAuxiliaryAssignments"),
    InstructorSurveyExcludeCourseTypes("unitime.instructorSurvey.excludeCourseTypes"),
    InstructorSurveyManagersCanDelete("unitime.instructorSurvey.managersCanDelete"),
    InstructorsCopyToSubSubparts("unitime.instructors.copyToSubSubparts"),
    NotificationsInstructorChanges("unitime.notifications.instructorChanges.enabled"),
    NotificationsInstructorChangesCheckShare("unitime.notifications.instructorChanges.checkShare"),
    NotificationsInstructorChangesCheckAssignment("unitime.notifications.instructorChanges.checkAssignment"),
    NotificationsInstructorChangesCheckCancellations("unitime.notifications.instructorChanges.checkCancellations"),
    NotificationsInstructorChangesCheckTime("unitime.notifications.instructorChanges.checkTime"),
    NotificationsInstructorChangesCheckRoom("unitime.notifications.instructorChanges.checkRoom"),
    NotificationsInstructorChangesIncludeSchedule("unitime.notifications.instructorChanges.includeSchedule"),
    NotificationsInstructorChangeEmailTemplate("unitime.notifications.instructorEmail.template"),
    NotificationsInstructorChangesCheckDates("unitime.notifications.instructorChanges.checkNotificationDates"),
    OnlineSchedulingEmailCheckDates("unitime.enrollment.email.checkNotificationDates"),
    OnlineSchedulingEmailCheckDatesOverride("unitime.enrollment.email.%.checkNotificationDates"),
    OnlineSchedulingEmailIncludeLink("unitime.enrollment.email.link"),
    NotificationsInstructorChangesIncludeLink("unitime.notifications.instructorChanges.includeLink"),
    SolverConfigDefaultInteractive("unitime.solverConfig.defaultInteractive"),
    SolverConfigDefaultCourse("unitime.solverConfig.defaultCourse"),
    SolverConfigDefaultExam("unitime.solverConfig.defaultExam"),
    SolverConfigDefaultStudentSct("unitime.solverConfig.defaultStudentSct"),
    SolverConfigDefaultInstrSchd("unitime.solverConfig.defaultInstrSchd"),
    AccessControlActiveMaxActiveUsersSectioning("unitime.accessControl.sectioning.maxActiveUsers"),
    AccessControlLimitInSecondsSectioning("unitime.accessControl.sectioning.activeLimitInMinutes"),
    AccessControlActiveMaxActiveUsersRequests("unitime.accessControl.requests.maxActiveUsers"),
    AccessControlLimitInSecondsRequests("unitime.accessControl.requests.activeLimitInMinutes"),
    AccessControlMaxActiveUsers("unitime.accessControl.%.maxActiveUsers"),
    AccessControlActiveLimitInMinutes("unitime.accessControl.%.activeLimitInMinutes"),
    LogCleanupAccessStatistics("unitime.cleanup.accessControlStatistics"),
    AuthenticationOAuht2IdAttribute("unitime.authentication.oauth2.id-attribute"),
    AuthenticationOAuht2IdAlwaysTranslate("unitime.authentication.oauth2.id-translate"),
    AuthenticationOAuht2IdTrimLeadingZerosFrom("unitime.authentication.oauth2.id-trim"),
    AuthenticationOAuht2NameAttribute("unitime.authentication.oauth2.name-attribute"),
    AuthenticationOAuht2Provider("unitime.authentication.oauth2.provider"),
    AuthenticationOAuht2ClientId("unitime.authentication.oauth2.client-id"),
    AuthenticationOAuht2ClientSecret("unitime.authentication.oauth2.client-secret"),
    AuthenticationOAuht2Scope("unitime.authentication.oauth2.scope"),
    AuthenticationOAuht2LoginMessage("unitime.authentication.oauth2.login-message"),
    AuthenticationOAuht2TenantId("unitime.authentication.oauth2.tenant-id"),
    AuthenticationOAuht2AdditionalAttributes("unitime.authentication.oauth2.queryAttributes"),
    RoomEditPrefetchRelations("unitime.rooms.prefetchRelations"),
    CustomRoomUrlProvider("unitime.rooms.url.provider"),
    DefaultRoomUrlRoom("unitime.rooms.url.room"),
    DefaultRoomUrlLoncation("unitime.rooms.url.location"),
    ClassEditSearcheableDatePattern("unitime.classEdit.searchableDatePattern"),
    StudentSchedulingFilterSkipAdvisedCounts("unitime.enrollment.studentFiler.skipAdvisedCounts"),
    StudentSchedulingPreferStudentCampus("unitime.studentScheduling.preferSessionsWithMatchingCampus"),
    StudentSchedulingPreferredCampus("unitime.studentScheduling.preferredStudentCampus"),
    OnlineSchedulingConfirmLongTravel("unitime.enrollment.confirmLongTravel"),
    EventsPersonalScheduleSkipSessionRestriction("unitime.events.personal.allSessions.skipSessionCheck"),
    CustomizationStudentPinsProvider("unitime.custom.StudentPinsProvider"),
    ManagerShortNameFormat("unitime.managers.shortNameFormat"),
    AuthorizationUseStudentName("unitime.authorization.preferStudentName"),
    AuthorizationUserNameFormat("unitime.authorization.userNameFormat"),
    CurriculaCourseWidth("unitime.curricula.courseWidth"),
    LegacyInstructionalOfferings("unitime.legacy.course.offerings"),
    LegacyClasses("unitime.legacy.course.classes"),
    LegacyClassAssignments("unitime.legacy.course.assignments"),
    LegacyOfferingDetail("unitime.legacy.offeringDetail"),
    LegacySubpartDetail("unitime.legacy.subpartDetail"),
    LegacyClassDetail("unitime.legacy.classDetail"),
    LegacyClassEdit("unitime.legacy.classEdit"),
    LegacySubpartEdit("unitime.legacy.subpartEdit"),
    LegacyInstructors("unitime.legacy.instructors"),
    LegacyCrossList("unitime.legacy.crosslist"),
    LegacyDistributions("unitime.legacy.distributions"),
    LegacyClassAssignment("unitime.legacy.classAssignment"),
    LegacyExaminations("unitime.legacy.examinations"),
    LegacyExaminationDetail("unitime.legacy.examinationDetail"),
    LegacyExaminationEdit("unitime.legacy.examinationEdit"),
    LegacyExamDistributions("unitime.legacy.examDistributions"),
    StudentSchedulingParentCourse("unitime.sectioning.parentCourse"),
    OnlineSchedulingFullCanRequestOverride("unitime.enrollment.fullCourseCanRequestOverride"),
    DataExchangeExportTypeGzip("unitime.export.%.xml.gz"),
    ClassAssignmentRefreshClass("tmtbl.classAssign.refreshClass");

    String iKey;

    private ApplicationProperty(String key) {
        this.iKey = key;
    }

    public String key() {
        return this.iKey;
    }

    public String key(String reference) {
        return reference == null ? this.iKey : this.iKey.replace("%", reference);
    }

    public String defaultValue() {
        try {
            DefaultValue defaultValue = ApplicationProperty.class.getField(this.name()).getAnnotation(DefaultValue.class);
            return defaultValue == null ? null : defaultValue.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public String description() {
        try {
            Description description = ApplicationProperty.class.getField(this.name()).getAnnotation(Description.class);
            return description == null ? null : description.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public Class type() {
        try {
            Type type = ApplicationProperty.class.getField(this.name()).getAnnotation(Type.class);
            return type == null ? String.class : type.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public Class implementation() {
        try {
            Implements impl = ApplicationProperty.class.getField(this.name()).getAnnotation(Implements.class);
            return impl == null ? null : impl.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public String[] availableValues() {
        try {
            Values type = ApplicationProperty.class.getField(this.name()).getAnnotation(Values.class);
            return type == null ? null : type.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public Double since() {
        try {
            Since since = ApplicationProperty.class.getField(this.name()).getAnnotation(Since.class);
            return since == null ? null : Double.valueOf(since.value());
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public String value() {
        return this.value(null, null);
    }

    public String value(AcademicSessionInfo session) {
        return this.valueOfSession(session == null ? null : session.getUniqueId());
    }

    public String value(Session session) {
        return this.valueOfSession(session == null ? null : session.getUniqueId());
    }

    public String value(String reference) {
        return this.value(reference, null);
    }

    public String value(String reference, String defaultValueOverride) {
        String value = ApplicationProperties.getProperty(this.key(reference));
        if (value != null) {
            return value;
        }
        String[] oldKeys = this.replaces();
        if (oldKeys != null) {
            for (String key : oldKeys) {
                value = ApplicationProperties.getProperty(reference == null ? key : key.replace("%", reference));
                if (value == null) continue;
                return value;
            }
        }
        return defaultValueOverride != null ? defaultValueOverride : this.defaultValue();
    }

    public String valueOfSession(Long sessionId) {
        return this.valueOfSession(sessionId, null, null);
    }

    public String valueOfSession(Long sessionId, String reference) {
        return this.valueOfSession(sessionId, reference, null);
    }

    public String valueOfSession(Long sessionId, String reference, String defaultValueOverride) {
        String value = ApplicationProperties.getProperty(sessionId, this.key(reference));
        if (value != null) {
            return value;
        }
        String[] oldKeys = this.replaces();
        if (oldKeys != null) {
            for (String key : oldKeys) {
                value = ApplicationProperties.getProperty(sessionId, reference == null ? key : key.replace("%", reference));
                if (value == null) continue;
                return value;
            }
        }
        return defaultValueOverride != null ? defaultValueOverride : this.defaultValue();
    }

    public boolean isTrue() {
        return "true".equalsIgnoreCase(this.value());
    }

    public boolean isTrue(String reference) {
        return "true".equalsIgnoreCase(this.value(reference));
    }

    public boolean isTrue(String reference, boolean defaultValueOverride) {
        return "true".equalsIgnoreCase(this.value(reference, defaultValueOverride ? "true" : "false"));
    }

    public boolean isFalse() {
        return !this.isTrue();
    }

    public Integer intValue() {
        try {
            return Integer.valueOf(this.value());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer intValue(String reference) {
        try {
            return Integer.valueOf(this.value(reference));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Float floatValue() {
        try {
            return Float.valueOf(this.value());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Double doubleValue() {
        try {
            return Double.valueOf(this.value());
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] replaces() {
        try {
            Replaces replaces = ApplicationProperty.class.getField(this.name()).getAnnotation(Replaces.class);
            return replaces == null ? null : replaces.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public boolean matches(String key) {
        if (key.matches(this.key().replace(".", "\\.").replace("%", "(.+)"))) {
            return true;
        }
        String[] oldKeys = this.replaces();
        if (oldKeys != null) {
            for (String old : oldKeys) {
                if (!key.matches(old.replace(".", "\\.").replace("%", "(.+)"))) continue;
                return true;
            }
        }
        return false;
    }

    public String reference() {
        try {
            Parameter reference = ApplicationProperty.class.getField(this.name()).getAnnotation(Parameter.class);
            return reference == null ? null : reference.value();
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public String reference(String key) {
        Matcher m = Pattern.compile(this.key().replace(".", "\\.").replace("%", "(.+)")).matcher(key);
        if (m.matches() && m.groupCount() > 0) {
            return m.group(1);
        }
        String[] oldKeys = this.replaces();
        if (oldKeys != null) {
            for (String old : oldKeys) {
                m = Pattern.compile(old.replace(".", "\\.").replace("%", "(.+)")).matcher(key);
                if (!m.matches() || m.groupCount() <= 0) continue;
                return m.group(1);
            }
        }
        return null;
    }

    public static ApplicationProperty fromKey(String key) {
        for (ApplicationProperty property : ApplicationProperty.values()) {
            if (!property.key().equals(key)) continue;
            return property;
        }
        for (ApplicationProperty property : ApplicationProperty.values()) {
            if (!property.matches(key)) continue;
            return property;
        }
        return null;
    }

    public static String getDescription(String key) {
        ApplicationProperty property = ApplicationProperty.fromKey(key);
        if (property != null) {
            String reference = property.reference(key);
            String description = property.description();
            if (reference != null) {
                return description.replace("%", reference);
            }
            return description;
        }
        return null;
    }

    public boolean isDeprecated() {
        try {
            return ApplicationProperty.class.getField(this.name()).getAnnotation(Deprecated.class) != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public boolean isSecret() {
        try {
            return ApplicationProperty.class.getField(this.name()).getAnnotation(Secret.class) != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public boolean isReadOnly() {
        try {
            return ApplicationProperty.class.getField(this.name()).getAnnotation(ReadOnly.class) != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public String toString() {
        String description = this.description();
        String defaultValue = this.defaultValue();
        return (String)(description == null ? "" : "# " + description + "\n") + this.key() + "=" + (defaultValue == null ? "" : defaultValue);
    }

    public static void main(String[] args) {
        for (ApplicationProperty p : ApplicationProperty.values()) {
            System.out.println();
            if (p.description() != null) {
                System.out.println("# " + p.description());
            }
            if (p.implementation() != null) {
                System.out.println("# Implements: " + p.implementation().getName());
            } else if (p.type() != null && !p.type().equals(String.class)) {
                System.out.println("# Type: " + p.type().getSimpleName().toLowerCase());
            }
            if (p.reference() != null) {
                System.out.println("# Parameter: " + p.reference());
            }
            if (p.replaces() != null) {
                for (String r : p.replaces()) {
                    System.out.println("# Replaces: " + r);
                }
            }
            if (p.since() != null) {
                System.out.println("# Since " + p.since());
            }
            if (p.isDeprecated()) {
                System.out.println("# Deprecated");
            }
            String value = p.value();
            if (p.defaultValue() != null && !p.isSecret() && !p.defaultValue().equals(value)) {
                System.out.println("# Default: " + p.defaultValue());
            }
            if (value == null) {
                System.out.println("#" + p.key() + "=" + (p.isSecret() ? "****" : ""));
                continue;
            }
            System.out.println(p.key() + "=" + (p.isSecret() ? "****" : value));
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface DefaultValue {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Description {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Type {
        public Class value() default String.class;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Implements {
        public Class value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Values {
        public String[] value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Since {
        public double value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Replaces {
        public String[] value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    static @interface Parameter {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Secret {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ReadOnly {
    }
}

