/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.springframework.stereotype.Service;
import org.springframework.web.util.HtmlUtils;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.webutil.PdfWebTable;

@Service(value="/subjectList")
@Action(value="subjectList", results={@Result(name={"showSubjectList"}, type="tiles", location="subjectList.tiles"), @Result(name={"add"}, type="redirect", location="/subjectAreaEdit.action", params={"op", "${op}"})})
@TilesDefinition(name="subjectList.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Subject Areas"), @TilesPutAttribute(name="body", value="/admin/subjectList.jsp")})
public class SubjectListAction
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = -7091704122522332475L;
    protected static final GwtMessages MSG = Localization.create(GwtMessages.class);
    protected static final CourseMessages CMSG = Localization.create(CourseMessages.class);

    public String execute() throws Exception {
        this.sessionContext.checkPermission(Right.SubjectAreas);
        if (SubjectListAction.stripAccessKey(MSG.buttonAddSubjectArea()).equals(this.op)) {
            return "add";
        }
        if (SubjectListAction.stripAccessKey(MSG.buttonExportPDF()).equals(this.op)) {
            String[] stringArray;
            boolean dispLastChanges = this.isDisplayLastChanges();
            List<SubjectArea> subjects = SubjectArea.getSubjectAreaList(this.sessionContext.getUser().getCurrentAcademicSessionId());
            int n = dispLastChanges ? 5 : 4;
            String string = MSG.sectSujectAreas(this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel());
            if (dispLastChanges) {
                String[] stringArray2 = new String[5];
                stringArray2[0] = MSG.fieldAbbv();
                stringArray2[1] = MSG.fieldTitle();
                stringArray2[2] = MSG.fieldDepartment();
                stringArray2[3] = MSG.fieldManagers();
                stringArray = stringArray2;
                stringArray2[4] = MSG.fieldLastChange();
            } else {
                String[] stringArray3 = new String[4];
                stringArray3[0] = MSG.fieldAbbv();
                stringArray3[1] = MSG.fieldTitle();
                stringArray3[2] = MSG.fieldDepartment();
                stringArray = stringArray3;
                stringArray3[3] = MSG.fieldManagers();
            }
            PdfWebTable webTable = new PdfWebTable(n, string, "subjectList.action?ord=%%", stringArray, new String[]{"left", "left", "left", "left", "right"}, new boolean[]{true, true, true, true, false});
            for (SubjectArea s : subjects) {
                Department d = s.getDepartment();
                Object sdName = "";
                for (TimetableManager mgr : s.getManagers()) {
                    if (((String)sdName).length() > 0) {
                        sdName = (String)sdName + "\n";
                    }
                    sdName = (String)sdName + mgr.getFirstName() + " " + mgr.getLastName();
                }
                String lastChangeStr = null;
                Long lastChangeCmp = null;
                if (dispLastChanges) {
                    List<ChangeLog> changes = ChangeLog.findLastNChanges(d.getSession().getUniqueId(), null, null, d.getUniqueId(), 1);
                    ChangeLog lastChange = changes == null || changes.isEmpty() ? null : changes.get(0);
                    lastChangeStr = lastChange == null ? "" : MSG.lastChange(ChangeLog.sDFdate.format(lastChange.getTimeStamp()), lastChange.getManager().getShortName());
                    lastChangeCmp = lastChange == null ? 0L : lastChange.getTimeStamp().getTime();
                }
                webTable.addLine(null, new String[]{s.getSubjectAreaAbbreviation(), s.getTitle(), d == null ? "" : d.getDeptCode() + (String)(d.getAbbreviation() == null ? "" : ": " + d.getAbbreviation().trim()), sdName == null || ((String)sdName).trim().length() == 0 ? "" : sdName, lastChangeStr}, new Comparable[]{s.getSubjectAreaAbbreviation(), s.getTitle(), d == null ? "" : d.getDeptCode(), sdName, lastChangeCmp});
            }
            ExportUtils.exportPDF(webTable, WebTable.getOrder(this.sessionContext, "SubjectList.ord"), this.response, "subjects");
            return null;
        }
        return "showSubjectList";
    }

    public String getTable() {
        String[] stringArray;
        boolean dispLastChanges = this.isDisplayLastChanges();
        List<SubjectArea> subjects = SubjectArea.getSubjectAreaList(this.sessionContext.getUser().getCurrentAcademicSessionId());
        int n = dispLastChanges ? 5 : 4;
        if (dispLastChanges) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = MSG.fieldAbbv();
            stringArray2[1] = MSG.fieldTitle();
            stringArray2[2] = MSG.fieldDepartment();
            stringArray2[3] = MSG.fieldManagers();
            stringArray = stringArray2;
            stringArray2[4] = MSG.fieldLastChange();
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = MSG.fieldAbbv();
            stringArray3[1] = MSG.fieldTitle();
            stringArray3[2] = MSG.fieldDepartment();
            stringArray = stringArray3;
            stringArray3[3] = MSG.fieldManagers();
        }
        WebTable webTable = new WebTable(n, "", "subjectList.action?ord=%%", stringArray, new String[]{"left", "left", "left", "left", "right"}, new boolean[]{true, true, true, true, false});
        webTable.enableHR("#9CB0CE");
        webTable.setRowStyle("white-space: nowrap");
        WebTable.setOrder(this.sessionContext, "SubjectList.ord", this.request.getParameter("ord"), 1);
        for (SubjectArea s : subjects) {
            Department d = s.getDepartment();
            Object sdName = "";
            for (TimetableManager mgr : s.getManagers()) {
                if (((String)sdName).length() > 0) {
                    sdName = (String)sdName + "<BR>";
                }
                sdName = (String)sdName + mgr.getFirstName() + " " + mgr.getLastName();
            }
            String lastChangeStr = null;
            Long lastChangeCmp = null;
            if (dispLastChanges) {
                List<ChangeLog> changes = ChangeLog.findLastNChanges(d.getSession().getUniqueId(), null, null, d.getUniqueId(), 1);
                ChangeLog lastChange = changes == null || changes.isEmpty() ? null : changes.get(0);
                lastChangeStr = lastChange == null ? "&nbsp;" : "<span title='" + HtmlUtils.htmlEscape((String)lastChange.getLabel()) + "'>" + MSG.lastChange(ChangeLog.sDFdate.format(lastChange.getTimeStamp()), lastChange.getManager().getShortName()) + "</span>";
                lastChangeCmp = lastChange == null ? 0L : lastChange.getTimeStamp().getTime();
            }
            WebTable.WebTableLine line = webTable.addLine("onClick=\"document.location.href='subjectAreaEdit.action?op=edit&id=" + s.getUniqueId() + "'\"", new String[]{s.getSubjectAreaAbbreviation(), s.getTitle(), d == null ? "&nbsp;" : "<span title='" + d.getHtmlTitle() + "'>" + d.getDeptCode() + (String)(d.getAbbreviation() == null ? "" : ": " + d.getAbbreviation().trim()) + "</span>", sdName == null || ((String)sdName).trim().length() == 0 ? "&nbsp;" : sdName, lastChangeStr}, new Comparable[]{s.getSubjectAreaAbbreviation(), s.getTitle(), d == null ? "" : d.getDeptCode(), sdName, lastChangeCmp});
            line.setUniqueId(s.getUniqueId().toString());
        }
        return webTable.printTable(WebTable.getOrder(this.sessionContext, "SubjectList.ord"));
    }

    public boolean isDisplayLastChanges() {
        return CommonValues.Yes.eq(UserProperty.DisplayLastChanges.get(this.sessionContext.getUser()));
    }

    public String getTitle() {
        return MSG.sectSujectAreas(this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel());
    }
}

