/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.StudentSectioningPref;

@MappedSuperclass
public abstract class BaseStudentSectioningPref
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iLabel;
    private Boolean iRequired;
    private CourseRequest iCourseRequest;

    public BaseStudentSectioningPref() {
    }

    public BaseStudentSectioningPref(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="label", nullable=true, length=60)
    public String getLabel() {
        return this.iLabel;
    }

    public void setLabel(String label) {
        this.iLabel = label;
    }

    @Column(name="required", nullable=false)
    public Boolean isRequired() {
        return this.iRequired;
    }

    @Transient
    public Boolean getRequired() {
        return this.iRequired;
    }

    public void setRequired(Boolean required) {
        this.iRequired = required;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="request_id", nullable=false)
    public CourseRequest getCourseRequest() {
        return this.iCourseRequest;
    }

    public void setCourseRequest(CourseRequest courseRequest) {
        this.iCourseRequest = courseRequest;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StudentSectioningPref)) {
            return false;
        }
        if (this.getUniqueId() == null || ((StudentSectioningPref)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((StudentSectioningPref)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "StudentSectioningPref[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    public String toDebugString() {
        return "StudentSectioningPref[\n\tCourseRequest: " + String.valueOf(this.getCourseRequest()) + "\n\tLabel: " + this.getLabel() + "\n\tRequired: " + this.getRequired() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

