/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolutionInfo;
import org.unitime.timetable.model.SolverInfo;

@MappedSuperclass
public abstract class BaseSolutionInfo
extends SolverInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Solution iSolution;

    public BaseSolutionInfo() {
    }

    public BaseSolutionInfo(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="solution_id", nullable=false)
    public Solution getSolution() {
        return this.iSolution;
    }

    public void setSolution(Solution solution) {
        this.iSolution = solution;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof SolutionInfo)) {
            return false;
        }
        if (this.getUniqueId() == null || ((SolutionInfo)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((SolutionInfo)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "SolutionInfo[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "SolutionInfo[\n\tData: " + String.valueOf(this.getData()) + "\n\tDefinition: " + String.valueOf(this.getDefinition()) + "\n\tOpt: " + this.getOpt() + "\n\tSolution: " + String.valueOf(this.getSolution()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

