/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.Session;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.base.BaseClassDurationType;
import org.unitime.timetable.model.dao.ClassDurationTypeDAO;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.util.duration.MinutesPerWeek;

@Entity
@Table(name="duration_type")
public class ClassDurationType
extends BaseClassDurationType
implements Comparable<ClassDurationType> {
    private static final long serialVersionUID = 1L;

    @Transient
    public DurationModel getModel() {
        try {
            return (DurationModel)Class.forName(this.getImplementation()).getConstructor(String.class).newInstance(this.getParameter());
        }
        catch (Exception e) {
            Debug.error("Failed to create duration model: " + e.getMessage(), e);
            return new MinutesPerWeek(null);
        }
    }

    public static List<ClassDurationType> findAll() {
        return ClassDurationTypeDAO.getInstance().getSession().createQuery("from ClassDurationType order by label", ClassDurationType.class).setCacheable(true).list();
    }

    public static ClassDurationType findByReference(String reference, Session hibSession) {
        return (ClassDurationType)(hibSession == null ? ClassDurationTypeDAO.getInstance().getSession() : hibSession).createQuery("from ClassDurationType where reference = :reference", ClassDurationType.class).setParameter("reference", (Object)reference).setCacheable(true).uniqueResult();
    }

    public static ClassDurationType findDefaultType(Long sessionId, Session hibSession) {
        return (ClassDurationType)(hibSession == null ? ClassDurationTypeDAO.getInstance().getSession() : hibSession).createQuery("select t from Session s inner join s.defaultClassDurationType t where s.uniqueId = :sessionId", ClassDurationType.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).uniqueResult();
    }

    public static Set<ClassDurationType> findAllVisible(ClassDurationType include) {
        TreeSet<ClassDurationType> ret = new TreeSet<ClassDurationType>(ClassDurationTypeDAO.getInstance().getSession().createQuery("from ClassDurationType where visible = true order by label", ClassDurationType.class).setCacheable(true).list());
        if (include != null && !ret.contains(include)) {
            ret.add(include);
        }
        return ret;
    }

    @Override
    public int compareTo(ClassDurationType t) {
        int cmp = this.getLabel().compareTo(t.getLabel());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(0L) : this.getUniqueId()).compareTo(t.getUniqueId() == null ? 0L : t.getUniqueId());
    }
}

