/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Objects;
import java.util.logging.Level;
import org.restlet.Context;

public final class Tag {
    public static final Tag ALL = Tag.parse("*");
    private volatile String name;
    private final boolean weak;

    public static Tag parse(String httpTag) {
        Tag result = null;
        boolean weak = false;
        String httpTagCopy = httpTag;
        if (httpTagCopy.startsWith("W/")) {
            weak = true;
            httpTagCopy = httpTagCopy.substring(2);
        }
        if (httpTagCopy.startsWith("\"") && httpTagCopy.endsWith("\"")) {
            result = new Tag(httpTagCopy.substring(1, httpTagCopy.length() - 1), weak);
        } else if (httpTagCopy.equals("*")) {
            result = new Tag("*", weak);
        } else {
            Context.getCurrentLogger().log(Level.WARNING, "Invalid tag format detected: " + httpTagCopy);
        }
        return result;
    }

    public Tag() {
        this(null, true);
    }

    public Tag(String opaqueTag) {
        this(opaqueTag, true);
    }

    public Tag(String opaqueTag, boolean weak) {
        this.name = opaqueTag;
        this.weak = weak;
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean checkWeakness) {
        if (!(object instanceof Tag)) {
            return false;
        }
        Tag that = (Tag)object;
        if (checkWeakness && that.isWeak() != this.isWeak()) {
            return false;
        }
        return Objects.equals(this.getName(), that.getName());
    }

    public String format() {
        if ("*".equals(this.getName())) {
            return "*";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isWeak()) {
            sb.append("W/");
        }
        return sb.append('\"').append(this.getName()).append('\"').toString();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.format().hashCode();
    }

    public boolean isWeak() {
        return this.weak;
    }

    public String toString() {
        return this.getName();
    }
}

