/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.constraints;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.Pattern;

public class PatternValidator
implements ConstraintValidator<Pattern, String> {
    private RegExp pattern;

    public final void initialize(Pattern annotation) {
        Pattern.Flag[] flags = annotation.flags();
        String flagString = "";
        for (Pattern.Flag flag : flags) {
            flagString = flagString + this.toString(flag);
        }
        this.pattern = RegExp.compile(annotation.regexp(), flagString);
    }

    public final boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        MatchResult match = this.pattern.exec(value);
        if (match == null) {
            return false;
        }
        return match.getGroup(0).length() == value.length();
    }

    private final String toString(Pattern.Flag flag) {
        String value;
        switch (flag) {
            case CASE_INSENSITIVE: 
            case UNICODE_CASE: {
                value = "i";
                break;
            }
            case MULTILINE: {
                value = "m";
                break;
            }
            default: {
                throw new IllegalArgumentException(flag + " is not a suppoted gwt Pattern (RegExp) flag");
            }
        }
        return value;
    }
}

