/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jgroups.util.Average;
import org.jgroups.util.Bits;
import org.jgroups.util.Util;

public class AverageMinMax
extends Average {
    protected long min = Long.MAX_VALUE;
    protected long max = 0L;
    protected List<Long> values;
    protected volatile boolean sorted;

    public AverageMinMax() {
    }

    public AverageMinMax(int capacity) {
        super(capacity);
    }

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }

    public boolean usePercentiles() {
        return this.values != null;
    }

    public AverageMinMax usePercentiles(int cap) {
        this.values = cap > 0 ? new ArrayList(cap) : null;
        return this;
    }

    public List<Long> values() {
        return this.values;
    }

    @Override
    public <T extends Average> T add(long num) {
        if (num < 0L) {
            return (T)this;
        }
        super.add(num);
        this.min = Math.min(this.min, num);
        this.max = Math.max(this.max, num);
        if (this.values != null) {
            this.values.add(num);
            this.sorted = false;
        }
        return (T)this;
    }

    @Override
    public <T extends Average> T merge(T other) {
        if (other.count() == 0) {
            return (T)this;
        }
        super.merge(other);
        if (other instanceof AverageMinMax) {
            AverageMinMax o = (AverageMinMax)other;
            this.min = Math.min(this.min, o.min());
            this.max = Math.max(this.max, o.max());
            if (this.values != null) {
                this.values.addAll(o.values);
                this.sorted = false;
            }
        }
        return (T)this;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.values != null) {
            this.values.clear();
        }
        this.min = Long.MAX_VALUE;
        this.max = 0L;
    }

    public String percentiles() {
        if (this.values == null) {
            return "n/a";
        }
        this.sort();
        double stddev = this.stddev();
        return String.format("stddev: %s, 50: %s, 90: %s, 99: %s, 99.9: %s, 99.99: %s, 99.999: %s, 100: %s\n", Util.printTime(stddev, this.unit), Util.printTime(this.p(50.0), this.unit), Util.printTime(this.p(90.0), this.unit), Util.printTime(this.p(99.0), this.unit), Util.printTime(this.p(99.9), this.unit), Util.printTime(this.p(99.99), this.unit), Util.printTime(this.p(99.999), this.unit), Util.printTime(this.p(100.0), this.unit));
    }

    @Override
    public String toString() {
        return this.count() == 0 ? "n/a" : (this.unit != null ? this.toString(this.unit) : String.format("min/avg/max=%.2f/%.2f/%.2f%s", this.min, this.average(), (double)this.max, this.unit == null ? "" : " " + Util.suffix(this.unit)));
    }

    @Override
    public String toString(TimeUnit u) {
        if (this.count() == 0) {
            return "n/a";
        }
        return String.format("%s/%s/%s", Util.printTime(this.min, u), Util.printTime(this.average(), u), Util.printTime(this.max, u));
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bits.writeLongCompressed(this.min, out);
        Bits.writeLongCompressed(this.max, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.min = Bits.readLongCompressed(in);
        this.max = Bits.readLongCompressed(in);
    }

    public double percentile(double percentile) {
        return this.p(percentile);
    }

    public double p(double percentile) {
        if (this.values == null) {
            return -1.0;
        }
        this.sort();
        int size = this.values.size();
        if (size == 0) {
            return -1.0;
        }
        int idx = size == 1 ? 1 : (int)((double)size * (percentile / 100.0));
        return this.values.get(idx - 1).longValue();
    }

    public double stddev() {
        if (this.values == null) {
            return -1.0;
        }
        this.sort();
        double av = this.average();
        int size = this.values.size();
        double variance = this.values.stream().map(v -> ((double)v.longValue() - av) * ((double)v.longValue() - av)).reduce(0.0, Double::sum) / (double)size;
        return Math.sqrt(variance);
    }

    public AverageMinMax sort() {
        if (this.values != null && !this.sorted) {
            Collections.sort(this.values);
            this.sorted = true;
        }
        return this;
    }
}

