/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.expectations;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;

public class PenaltyNotNegative
implements OverExpectedCriterion {
    public PenaltyNotNegative(DataProperties config) {
    }

    @Override
    public double getOverExpected(Assignment<Request, Enrollment> assignment, Section section, Request request) {
        if (section.getPenalty() < 0.0 || (double)section.getLimit() <= 0.0) {
            return 0.0;
        }
        int subparts = section.getSubpart().getConfig().getSubparts().size();
        return 1.0 / (double)subparts;
    }

    public String toString() {
        return "not-negative";
    }

    @Override
    public Integer getExpected(int sectionLimit, double expectedSpace) {
        if ((double)sectionLimit <= 0.0) {
            return null;
        }
        int expected = (int)Math.round(expectedSpace);
        if (expected > 0) {
            return expected;
        }
        return null;
    }
}

