/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import org.hibernate.Session;
import org.unitime.timetable.interfaces.ExternalClassNameHelperInterface;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;

public class DefaultExternalClassNameHelper
implements ExternalClassNameHelperInterface,
ExternalClassNameHelperInterface.HasGradableSubpart {
    @Override
    public String getClassLabel(Class_ clazz, CourseOffering courseOffering) {
        return courseOffering.getCourseName() + " " + clazz.getItypeDesc().trim() + " " + clazz.getSectionNumberString();
    }

    @Override
    public String getClassSuffix(Class_ clazz, CourseOffering courseOffering) {
        return clazz.getClassSuffix();
    }

    @Override
    public String getClassLabelWithTitle(Class_ clazz, CourseOffering courseOffering) {
        return courseOffering.getCourseNameWithTitle() + " " + clazz.getItypeDesc().trim() + " " + clazz.getSectionNumberString();
    }

    @Override
    public String getExternalId(Class_ clazz, CourseOffering courseOffering) {
        return clazz.getExternalUniqueId();
    }

    @Override
    public Float getClassCredit(Class_ clazz, CourseOffering courseOffering) {
        return null;
    }

    @Override
    public boolean isGradableSubpart(SchedulingSubpart subpart, CourseOffering courseOffering, Session hibSession) {
        if (subpart.getInstrOfferingConfig().getSchedulingSubparts().size() == 1) {
            return true;
        }
        if (subpart.getParentSubpart() != null) {
            return false;
        }
        SchedulingSubpartComparator cmp = new SchedulingSubpartComparator();
        for (SchedulingSubpart s : subpart.getInstrOfferingConfig().getSchedulingSubparts()) {
            if (cmp.compare(s, subpart) >= 0) continue;
            return false;
        }
        return true;
    }
}

